/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.ErrorResultSetFuture;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.google.common.util.concurrent.ExecutionList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;

public class LastResultSequentialSetFuture
extends DefaultResultSetFuture {
    private final Iterator<StatementImpl<?, ?, ?>> statements;
    private final ExecutionList executionList = new ExecutionList();
    private final StatementManagerImpl mgr;
    private ResultSetFuture future = null;
    private StatementImpl<?, ?, ?> statement = null;
    private boolean cancelled = false;
    private final Runnable listener = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean execute;
            block18: {
                execute = false;
                Iterator iterator = LastResultSequentialSetFuture.this.statements;
                // MONITORENTER : iterator
                if (!LastResultSequentialSetFuture.this.future.isCancelled()) break block18;
                execute = true;
                // MONITOREXIT : iterator
                if (!execute) return;
                LastResultSequentialSetFuture.this.executionList.execute();
                return;
            }
            if (!LastResultSequentialSetFuture.this.future.isDone()) {
                // MONITOREXIT : iterator
                if (!execute) return;
                LastResultSequentialSetFuture.this.executionList.execute();
                return;
            }
            try {
                try {
                    LastResultSequentialSetFuture.this.future.get();
                }
                catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                    execute = true;
                    throw e;
                }
                catch (Error | Exception e) {
                    execute = true;
                }
                if (LastResultSequentialSetFuture.this.statements.hasNext()) {
                    try {
                        LastResultSequentialSetFuture.this.statement = (StatementImpl)LastResultSequentialSetFuture.this.statements.next();
                        LastResultSequentialSetFuture.this.future = LastResultSequentialSetFuture.this.statement.executeAsyncRaw();
                        LastResultSequentialSetFuture.this.future.addListener(LastResultSequentialSetFuture.this.listener, (Executor)LastResultSequentialSetFuture.this.mgr.getPoolExecutor());
                        return;
                    }
                    catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                        LastResultSequentialSetFuture.this.future = (ResultSetFuture)new ErrorResultSetFuture(LastResultSequentialSetFuture.this.mgr, (Throwable)e);
                        execute = true;
                        throw e;
                    }
                    catch (Error e) {
                        LastResultSequentialSetFuture.this.future = (ResultSetFuture)new ErrorResultSetFuture(LastResultSequentialSetFuture.this.mgr, e);
                        execute = true;
                        return;
                    }
                    catch (Exception e) {
                        LastResultSequentialSetFuture.this.future = (ResultSetFuture)new ErrorResultSetFuture(LastResultSequentialSetFuture.this.mgr, new ExecutionException(e));
                        execute = true;
                        return;
                    }
                }
                execute = true;
                // MONITOREXIT : iterator
                return;
            }
            finally {
                if (execute) {
                    LastResultSequentialSetFuture.this.executionList.execute();
                }
            }
        }
    };

    public LastResultSequentialSetFuture(List<StatementImpl<?, ?, ?>> statements, StatementManagerImpl mgr) {
        super(null, mgr.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion(), null);
        Validate.notNull(statements, (String)"invalid null statements", (Object[])new Object[0]);
        this.mgr = mgr;
        ArrayList ss = new ArrayList(statements.size());
        for (StatementImpl<?, ?, ?> s : statements) {
            Validate.notNull(s, (String)"invalid null statement", (Object[])new Object[0]);
            ss.add(s);
        }
        this.statements = ss.iterator();
        if (this.statements.hasNext()) {
            this.statement = this.statements.next();
            this.future = this.statement.executeAsyncRaw();
            this.future.addListener(this.listener, (Executor)mgr.getPoolExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Iterator<StatementImpl<?, ?, ?>> iterator = this.statements;
        synchronized (iterator) {
            return this.future.isDone() && !this.statements.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Iterator<StatementImpl<?, ?, ?>> iterator = this.statements;
        synchronized (iterator) {
            return this.cancelled || this.future.isCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean bl;
        boolean execute;
        block12: {
            execute = false;
            Iterator<StatementImpl<?, ?, ?>> iterator = this.statements;
            // MONITORENTER : iterator
            if (!this.cancelled) break block12;
            boolean bl2 = false;
            // MONITOREXIT : iterator
            if (!execute) return bl2;
            this.executionList.execute();
            return bl2;
        }
        execute = true;
        this.cancelled = true;
        try {
            boolean bl3 = bl = this.future.cancel(mayInterruptIfRunning) || this.statements.hasNext();
        }
        catch (Throwable throwable) {
            try {
                while (this.statements.hasNext()) {
                    this.statements.next();
                }
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (!execute) throw throwable2;
                this.executionList.execute();
                throw throwable2;
            }
        }
        while (true) {
            if (!this.statements.hasNext()) {
                // MONITOREXIT : iterator
                if (!execute) return bl;
                this.executionList.execute();
                return bl;
            }
            this.statements.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        ResultSetFuture future;
        long end = System.nanoTime() + unit.toNanos(timeout);
        while (true) {
            Iterator<StatementImpl<?, ?, ?>> iterator = this.statements;
            synchronized (iterator) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                future = this.future;
                if (!this.statements.hasNext()) {
                    break;
                }
            }
            future.get(end - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        return (ResultSet)future.get(end - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet get() throws InterruptedException, ExecutionException {
        ResultSetFuture future;
        while (true) {
            Iterator<StatementImpl<?, ?, ?>> iterator = this.statements;
            synchronized (iterator) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                future = this.future;
                if (!this.statements.hasNext()) {
                    break;
                }
            }
            future.get();
        }
        return (ResultSet)future.get();
    }

    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }
}

