/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeClassNameParser;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import java.util.List;
import java.util.stream.Collectors;
import org.helenus.driver.impl.DataTypeImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Ordering;

public class DataTypeParser
extends DataTypeClassNameParser {
    private static CQLDataType toCQL(final StatementManagerImpl mgr, DataType t, boolean isFrozen) {
        if (t instanceof UserType) {
            final UserType ut = (UserType)t;
            return new CQLDataType(){

                public String name() {
                    return ut.getTypeName();
                }

                public boolean isFrozen() {
                    return true;
                }

                public boolean isCollection() {
                    return false;
                }

                public boolean isTuple() {
                    return false;
                }

                public boolean isUserDefined() {
                    return true;
                }

                public DataType getDataType() {
                    return ut;
                }

                public CQLDataType getMainType() {
                    return this;
                }

                public CQLDataType getElementType() {
                    return null;
                }

                public List<CQLDataType> getArgumentTypes() {
                    return null;
                }

                public CQLDataType getFirstArgumentType() {
                    return null;
                }

                public boolean isAlterableTo(CQLDataType to) {
                    return false;
                }

                public String toCQL() {
                    return "frozen<" + this.name() + '>';
                }
            };
        }
        if (t instanceof TupleType) {
            final TupleType tt = (TupleType)t;
            return new CQLDataType(){

                public String name() {
                    return "tuple";
                }

                public boolean isFrozen() {
                    return true;
                }

                public boolean isCollection() {
                    return false;
                }

                public boolean isTuple() {
                    return true;
                }

                public boolean isUserDefined() {
                    return false;
                }

                public DataType getDataType() {
                    return tt;
                }

                public CQLDataType getMainType() {
                    return this;
                }

                public CQLDataType getElementType() {
                    return null;
                }

                public List<CQLDataType> getArgumentTypes() {
                    return null;
                }

                public CQLDataType getFirstArgumentType() {
                    return null;
                }

                public boolean isAlterableTo(CQLDataType to) {
                    return false;
                }

                public String toCQL() {
                    return tt.getComponentTypes().stream().map(ct -> DataTypeParser.toCQL(mgr, ct, true).toCQL()).collect(Collectors.joining(",", "frozen<tuple<", ">>"));
                }
            };
        }
        return new DataTypeImpl.Definition(mgr, org.helenus.driver.persistence.DataType.valueOf((String)t.getName().name()), t.getTypeArguments().stream().map(ta -> DataTypeParser.toCQL(mgr, ta, true)).collect(Collectors.toList()), isFrozen);
    }

    public static CQLDataType validatorToCQL(StatementManagerImpl mgr, String validator) {
        return DataTypeParser.toCQL(mgr, DataTypeClassNameParser.parseOne((String)validator, (ProtocolVersion)mgr.getProtocolVersion(), (CodecRegistry)mgr.getCodecRegistry()), DataTypeClassNameParser.isFrozen((String)validator));
    }

    public static CQLDataType typeToCQL(StatementManagerImpl mgr, String type) {
        boolean isFrozen;
        if (type.startsWith("org.apache.cassandra.db.marshal.FrozenType(")) {
            type = type.substring(43, type.length() - 1);
            isFrozen = true;
        } else {
            isFrozen = false;
        }
        return DataTypeParser.toCQL(mgr, DataTypeClassNameParser.parseOne((String)type, (ProtocolVersion)mgr.getProtocolVersion(), (CodecRegistry)mgr.getCodecRegistry()), isFrozen);
    }

    public static boolean isReversed(String validator) {
        return DataTypeClassNameParser.isReversed((String)validator);
    }

    public static Ordering getOrderingFrom(String validator) {
        return DataTypeClassNameParser.isReversed((String)validator) ? Ordering.DESCENDING : Ordering.ASCENDING;
    }

    public static boolean isUserType(String validator) {
        return DataTypeClassNameParser.isUserType((String)validator);
    }

    public static boolean isTupleType(String validator) {
        return DataTypeClassNameParser.isTupleType((String)validator);
    }

    private DataTypeParser() {
    }
}

