/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaChangeListenerBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UserType;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.helenus.commons.collections.iterators.SnapshotIterator;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.AlterSchema;
import org.helenus.driver.AlterSchemas;
import org.helenus.driver.Assignment;
import org.helenus.driver.Batch;
import org.helenus.driver.BatchableStatement;
import org.helenus.driver.BindMarker;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateIndex;
import org.helenus.driver.CreateKeyspace;
import org.helenus.driver.CreateSchema;
import org.helenus.driver.CreateSchemas;
import org.helenus.driver.CreateTable;
import org.helenus.driver.CreateType;
import org.helenus.driver.Delete;
import org.helenus.driver.Group;
import org.helenus.driver.GroupableStatement;
import org.helenus.driver.Insert;
import org.helenus.driver.Ordering;
import org.helenus.driver.Recorder;
import org.helenus.driver.RegularStatement;
import org.helenus.driver.Select;
import org.helenus.driver.Sequence;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.StatementManager;
import org.helenus.driver.Truncate;
import org.helenus.driver.Update;
import org.helenus.driver.Using;
import org.helenus.driver.WithOptions;
import org.helenus.driver.impl.AlterSchemaImpl;
import org.helenus.driver.impl.AlterSchemasImpl;
import org.helenus.driver.impl.AssignmentImpl;
import org.helenus.driver.impl.BatchImpl;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.CreateIndexImpl;
import org.helenus.driver.impl.CreateKeyspaceImpl;
import org.helenus.driver.impl.CreateSchemaImpl;
import org.helenus.driver.impl.CreateSchemasImpl;
import org.helenus.driver.impl.CreateTableImpl;
import org.helenus.driver.impl.CreateTypeImpl;
import org.helenus.driver.impl.DataTypeImpl;
import org.helenus.driver.impl.DeleteImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.GroupImpl;
import org.helenus.driver.impl.InsertImpl;
import org.helenus.driver.impl.OrderingImpl;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.SelectImpl;
import org.helenus.driver.impl.SequenceImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.TruncateImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.impl.UDTActualClassInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.impl.UpdateImpl;
import org.helenus.driver.impl.UsingImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.impl.WithOptionsImpl;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.EntityFilter;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.Entity;
import org.helenus.driver.persistence.RootEntity;
import org.helenus.driver.persistence.TypeEntity;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;
import org.helenus.driver.persistence.UDTTypeEntity;

public class StatementManagerImpl
extends StatementManager {
    private static final Logger logger = LogManager.getFormatterLogger(StatementManagerImpl.class);
    private final StatementBridge bridge;
    private final Cluster cluster;
    private Session session;
    private int defaultReplicationFactor = 2;
    private Map<String, Integer> defaultDataCenters = null;
    private final Map<Class<?>, ClassInfoImpl<?>> classInfoCache = new ConcurrentHashMap(64);
    private final Map<String, UDTClassInfoImpl<?>> udts = new ConcurrentHashMap(64);
    private final List<EntityFilter> filters = new ArrayList<EntityFilter>(2);
    private final ExecutorService directExecutor = MoreExecutors.sameThreadExecutor();
    private final ExecutorService poolExecutor;
    private volatile boolean fullTraces = false;
    private volatile boolean allStatementTraces = false;

    public StatementManagerImpl(Cluster.Initializer initializer, boolean connect) {
        org.helenus.commons.lang3.Validate.notNull((Logger)logger, (Object)initializer, (String)"invalid null initializer", (Object[])new Object[0]);
        this.cluster = Cluster.buildFrom((Cluster.Initializer)initializer);
        this.session = connect ? this.cluster.connect() : null;
        this.bridge = StatementManagerImpl.setManager((StatementManager)this);
        this.poolExecutor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(64, 64, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
        this.cluster.register((SchemaChangeListener)new SchemaChangeListenerBase(){

            public void onUserTypeAdded(UserType type) {
                UDTClassInfoImpl ucinfo;
                if (type != null && (ucinfo = (UDTClassInfoImpl)StatementManagerImpl.this.udts.get(type.getName())) != null) {
                    ucinfo.register(type);
                }
            }

            public void onUserTypeRemoved(UserType type) {
                UDTClassInfoImpl ucinfo;
                if (type != null && (ucinfo = (UDTClassInfoImpl)StatementManagerImpl.this.udts.get(type.getName())) != null) {
                    ucinfo.deregister(type);
                }
            }

            public void onUserTypeChanged(UserType current, UserType previous) {
                this.onUserTypeAdded(current);
            }
        });
    }

    public StatementManagerImpl(Cluster.Initializer initializer, int defaultReplicationFactor, boolean connect) {
        this(initializer, connect);
        this.setDefaultReplicationFactor(defaultReplicationFactor);
    }

    public StatementManagerImpl(Cluster.Initializer initializer, int defaultReplicationFactor, boolean connect, EntityFilter ... filters) {
        this(initializer, connect, filters);
        this.setDefaultReplicationFactor(defaultReplicationFactor);
    }

    public StatementManagerImpl(Cluster.Initializer initializer, boolean connect, EntityFilter ... filters) {
        this(initializer, connect);
        if (filters != null) {
            for (EntityFilter filter : filters) {
                this.filters.add(filter);
            }
        }
    }

    public StatementManagerImpl(Cluster.Initializer initializer, boolean connect, String ... cnames) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this(initializer, connect);
        if (cnames != null) {
            for (String cname : cnames) {
                Class<?> clazz = DataTypeImpl.findClass(cname);
                Validate.isTrue((boolean)EntityFilter.class.isAssignableFrom(clazz), (String)"invalid entity filter class: %s", (Object[])new Object[]{cname});
                this.filters.add((EntityFilter)EntityFilter.class.cast(clazz.newInstance()));
            }
        }
    }

    protected <T> ClassInfo<T> getClassInfo(Class<T> clazz) {
        return this.getClassInfoImpl(clazz);
    }

    protected <T> ClassInfo<? super T> getRootClassInfo(Class<T> clazz) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        if (cinfo instanceof TypeClassInfoImpl) {
            return ((TypeClassInfoImpl)cinfo).getRoot();
        }
        if (cinfo instanceof UDTTypeClassInfoImpl) {
            return ((UDTTypeClassInfoImpl)cinfo).getRoot();
        }
        return cinfo;
    }

    protected <T> Select.Builder<T> select(Class<T> clazz, CharSequence ... columns) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a select statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new SelectImpl.BuilderImpl(cinfo.newContext(), Arrays.asList((Object[])columns), this, this.bridge);
    }

    protected <T> Select.Selection<T> select(Class<T> clazz) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a select statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new SelectImpl.SelectionImpl(cinfo.newContext(), this, this.bridge);
    }

    protected <T> Select<T> selectFrom(TableInfo<T> table, CharSequence ... columns) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(table.getObjectClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a select statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), table.getObjectClass().getSimpleName()});
        return new SelectImpl.BuilderImpl<T>(cinfo.newContext(), Arrays.asList((Object[])columns), this, this.bridge).from(table);
    }

    protected <T> Select.TableSelection<T> selectFrom(TableInfo<T> table) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(table.getObjectClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a select statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), table.getObjectClass().getSimpleName()});
        return new SelectImpl.TableSelectionImpl<T>(table, cinfo.newContext(), this, this.bridge);
    }

    protected <T> Insert.Builder<T> insert(T object) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        ClassInfoImpl<?> cinfo = this.getClassInfoImpl(object.getClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for an insert statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), object.getClass().getSimpleName()});
        return new InsertImpl.BuilderImpl(cinfo.newContext(object), this, this.bridge);
    }

    protected <T> Update<T> update(T object) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        ClassInfoImpl<?> cinfo = this.getClassInfoImpl(object.getClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for an update statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), object.getClass().getSimpleName()});
        return new UpdateImpl(cinfo.newContext(object), this, this.bridge);
    }

    protected <T> Update<T> update(T object, String ... tables) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        ClassInfoImpl<?> cinfo = this.getClassInfoImpl(object.getClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for an update statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), object.getClass().getSimpleName()});
        return new UpdateImpl(cinfo.newContext(object), tables, this, this.bridge);
    }

    protected <T> Delete.Builder<T> delete(T object, String ... columns) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        ClassInfoImpl<?> cinfo = this.getClassInfoImpl(object.getClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a delete statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), object.getClass().getSimpleName()});
        return new DeleteImpl.BuilderImpl(cinfo.newContext(object), Arrays.asList((Object[])columns), this, this.bridge);
    }

    protected <T> Delete.Selection<T> delete(T object) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        ClassInfoImpl<?> cinfo = this.getClassInfoImpl(object.getClass());
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a delete statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), object.getClass().getSimpleName()});
        return new DeleteImpl.SelectionImpl(cinfo.newContext(object), this, this.bridge);
    }

    protected <T> Delete.Builder<T> delete(Class<T> clazz, String ... columns) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a delete statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new DeleteImpl.BuilderImpl(cinfo.newContext(), Arrays.asList((Object[])columns), this, this.bridge);
    }

    protected <T> Delete.Selection<T> delete(Class<T> clazz) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a delete statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new DeleteImpl.SelectionImpl(cinfo.newContext(), this, this.bridge);
    }

    protected Batch batch(Optional<Recorder> recorder, BatchableStatement<?, ?> ... statements) {
        return new BatchImpl(recorder, statements, true, this, this.bridge);
    }

    protected Batch batch(Optional<Recorder> recorder, Iterable<BatchableStatement<?, ?>> statements) {
        return new BatchImpl(recorder, statements, true, this, this.bridge);
    }

    protected Batch unloggedBatch(Optional<Recorder> recorder, BatchableStatement<?, ?> ... statements) {
        return new BatchImpl(recorder, statements, false, this, this.bridge);
    }

    protected Batch unloggedBatch(Optional<Recorder> recorder, Iterable<BatchableStatement<?, ?>> statements) {
        return new BatchImpl(recorder, statements, false, this, this.bridge);
    }

    protected RegularStatement regular(com.datastax.driver.core.RegularStatement statement) {
        return new SimpleStatementImpl(statement, this, this.bridge);
    }

    protected <T> CreateKeyspace<T> createKeyspace(Class<T> clazz) {
        return new CreateKeyspaceImpl(this.getClassInfoImpl(clazz).newContext(), this, this.bridge);
    }

    protected <T> CreateType<T> createType(Class<T> clazz) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((!cinfo.supportsTablesAndIndexes() ? 1 : 0) != 0, (String)"unsupported %s POJO class '%s' for a create type statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new CreateTypeImpl(cinfo.newContext(), this, this.bridge);
    }

    protected <T> CreateTable<T> createTable(Class<T> clazz) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a create table statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new CreateTableImpl(cinfo.newContext(), this, this.bridge);
    }

    protected <T> CreateTable<T> createTable(Class<T> clazz, String ... tables) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a create table statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new CreateTableImpl(cinfo.newContext(), tables, this, this.bridge);
    }

    protected <T> CreateIndex.Builder<T> createIndex(Class<T> clazz) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a create index statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new CreateIndexImpl.BuilderImpl(cinfo.newContext(), this, this.bridge);
    }

    protected <T> CreateSchema<T> createSchema(Class<T> clazz) {
        return new CreateSchemaImpl(this.getClassInfoImpl(clazz).newContext(), this, this.bridge);
    }

    protected CreateSchemas createSchemas(String[] pkgs) {
        return new CreateSchemasImpl(pkgs, false, this, this.bridge);
    }

    protected CreateSchemas createMatchingSchemas(String[] pkgs) {
        return new CreateSchemasImpl(pkgs, true, this, this.bridge);
    }

    protected <T> AlterSchema<T> alterSchema(Class<T> clazz) {
        return new AlterSchemaImpl(this.getClassInfoImpl(clazz).newContext(), this, this.bridge);
    }

    protected AlterSchemas alterSchemas(String[] pkgs) {
        return new AlterSchemasImpl(pkgs, false, this, this.bridge);
    }

    protected AlterSchemas alterMatchingSchemas(String[] pkgs) {
        return new AlterSchemasImpl(pkgs, true, this, this.bridge);
    }

    protected <T> Truncate<T> truncate(Class<T> clazz) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a truncate statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new TruncateImpl(cinfo.newContext(), this, this.bridge);
    }

    protected <T> Truncate<T> truncate(Class<T> clazz, String ... tables) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        Validate.isTrue((boolean)cinfo.supportsTablesAndIndexes(), (String)"unsupported %s POJO class '%s' for a truncate statement", (Object[])new Object[]{cinfo.getEntityAnnotationClass().getSimpleName(), clazz.getSimpleName()});
        return new TruncateImpl(cinfo.newContext(), tables, this, this.bridge);
    }

    protected Sequence sequence(Optional<Recorder> recorder, SequenceableStatement<?, ?> ... statements) {
        return new SequenceImpl(recorder, statements, this, this.bridge);
    }

    protected Sequence sequence(Optional<Recorder> recorder, Iterable<SequenceableStatement<?, ?>> statements) {
        return new SequenceImpl(recorder, statements, this, this.bridge);
    }

    protected Group group(Optional<Recorder> recorder, GroupableStatement<?, ?> ... statements) {
        return new GroupImpl(recorder, statements, this, this.bridge);
    }

    protected Group group(Optional<Recorder> recorder, Iterable<GroupableStatement<?, ?>> statements) {
        return new GroupImpl(recorder, statements, this, this.bridge);
    }

    protected CharSequence quote(String name) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        return Metadata.quote((String)name);
    }

    protected CharSequence token(String name) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder(name.length() + 7);
        sb.append("token(");
        Utils.appendName(sb, name);
        sb.append(")");
        return new Utils.CNameSequence(sb.toString(), name);
    }

    protected CharSequence token(String ... names) {
        StringBuilder sb = new StringBuilder();
        sb.append("token(");
        Utils.joinAndAppendNames(null, null, this.getCodecRegistry(), sb, ",", Arrays.asList((Object[])names));
        sb.append(")");
        return new Utils.CNameSequence(sb.toString(), names);
    }

    protected Clause isKeyspacedLikeObject() {
        return new ClauseImpl.IsKeyspacedLikeObjectClauseImpl();
    }

    protected <T> Clause isKeyspacedLike(T object) {
        return new ClauseImpl.IsKeyspacedLikeClauseImpl(object);
    }

    protected Clause isPartitionedLikeObject() {
        return new ClauseImpl.IsPartitionedLikeObjectClauseImpl();
    }

    protected <T> Clause isPartitionedLike(T object) {
        return new ClauseImpl.IsPartitionedLikeClauseImpl(object);
    }

    protected Clause isObject() {
        return new ClauseImpl.IsObjectClauseImpl();
    }

    protected <T> Clause is(T object) {
        return new ClauseImpl.IsClauseImpl(object);
    }

    protected Clause.Equality eq(CharSequence name, Object value) {
        return new ClauseImpl.EqClauseImpl(name, value);
    }

    protected Clause.Equality eq(List<String> names, List<?> values) {
        return new ClauseImpl.CompoundEqClauseImpl(names, values);
    }

    protected Clause like(CharSequence name, Object value) {
        return new ClauseImpl.SimpleClauseImpl(name, " LIKE ", value);
    }

    protected Clause.In in(CharSequence name, Object ... values) {
        return new ClauseImpl.InClauseImpl(name, Arrays.asList(values));
    }

    protected Clause.In in(CharSequence name, Collection<?> values) {
        return new ClauseImpl.InClauseImpl(name, values);
    }

    protected Clause.In in(CharSequence name, Stream<?> values) {
        return new ClauseImpl.InClauseImpl(name, values.collect(Collectors.toList()));
    }

    protected Clause.In in(CharSequence name, int from, int to) {
        Validate.isTrue((to >= from ? 1 : 0) != 0, (String)"'to' value '%d' must be greater or equal to 'from' value '%d'", (Object[])new Object[]{to, from});
        ArrayList<Integer> values = new ArrayList<Integer>(to - from + 1);
        for (int i = from; i <= to; ++i) {
            values.add(i);
        }
        return new ClauseImpl.InClauseImpl(name, values);
    }

    protected Clause contains(CharSequence name, Object value) {
        return new ClauseImpl.ContainsClauseImpl(name, value);
    }

    protected Clause containsKey(CharSequence name, Object key) {
        return new ClauseImpl.ContainsKeyClauseImpl(name, key);
    }

    protected Clause lt(CharSequence name, Object value) {
        return new ClauseImpl.SimpleClauseImpl(name, "<", value);
    }

    protected Clause lt(List<String> names, List<?> values) {
        return new ClauseImpl.CompoundClauseImpl(names, "<", values);
    }

    protected Clause lte(CharSequence name, Object value) {
        return new ClauseImpl.SimpleClauseImpl(name, "<=", value);
    }

    protected Clause lte(List<String> names, List<?> values) {
        return new ClauseImpl.CompoundClauseImpl(names, "<=", values);
    }

    protected Clause gt(CharSequence name, Object value) {
        return new ClauseImpl.SimpleClauseImpl(name, ">", value);
    }

    protected Clause gt(List<String> names, List<?> values) {
        return new ClauseImpl.CompoundClauseImpl(names, ">", values);
    }

    protected Clause gte(CharSequence name, Object value) {
        return new ClauseImpl.SimpleClauseImpl(name, ">=", value);
    }

    protected Clause gte(List<String> names, List<?> values) {
        return new ClauseImpl.CompoundClauseImpl(names, ">=", values);
    }

    protected Ordering asc(CharSequence name) {
        return new OrderingImpl(name, false);
    }

    protected Ordering desc(CharSequence name) {
        return new OrderingImpl(name, true);
    }

    protected Using<Long> timestamp(long timestamp) {
        Validate.isTrue((timestamp >= 0L ? 1 : 0) != 0, (String)"invalid timestamp, must be positive: %s", (long)timestamp);
        return new UsingImpl<Long>("TIMESTAMP", timestamp);
    }

    protected Using<BindMarker> timestamp(BindMarker marker) {
        return new UsingImpl<BindMarker>("TIMESTAMP", marker);
    }

    protected Using<Integer> ttl(int ttl) {
        Validate.isTrue((ttl >= 0 ? 1 : 0) != 0, (String)"invalid ttl, must be positive: %s", (long)ttl);
        return new UsingImpl<Integer>("TTL", ttl);
    }

    protected Using<BindMarker> ttl(BindMarker marker) {
        return new UsingImpl<BindMarker>("TTL", marker);
    }

    protected StringBuilder appendName(String name, StringBuilder sb) {
        return Utils.appendName(sb, name);
    }

    protected Assignment setFromObject(CharSequence name) {
        return new AssignmentImpl.DelayedSetAssignmentImpl(name);
    }

    protected <T> Assignment setFrom(T object, CharSequence name) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        return new AssignmentImpl.DelayedSetAssignmentImpl(object, name);
    }

    protected Assignment set(CharSequence name, Object value) {
        return new AssignmentImpl.SetAssignmentImpl(name, value);
    }

    protected Assignment set(CharSequence name, Object value, Object old) {
        return new AssignmentImpl.ReplaceAssignmentImpl(name, value, old);
    }

    protected Assignment setAllFromObject() {
        return new AssignmentImpl.DelayedSetAllAssignmentImpl();
    }

    protected <T> Assignment setAllFrom(T object) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        return new AssignmentImpl.DelayedSetAllAssignmentImpl(object);
    }

    protected Assignment previous(CharSequence name, Object old) {
        return new AssignmentImpl.PreviousAssignmentImpl(name, old);
    }

    protected Assignment incr(CharSequence name, long value) {
        return new AssignmentImpl.CounterAssignmentImpl(name, value, true);
    }

    protected Assignment incr(CharSequence name, BindMarker marker) {
        return new AssignmentImpl.CounterAssignmentImpl(name, marker, true);
    }

    protected Assignment decr(CharSequence name, long value) {
        return new AssignmentImpl.CounterAssignmentImpl(name, value, false);
    }

    protected Assignment decr(CharSequence name, BindMarker marker) {
        return new AssignmentImpl.CounterAssignmentImpl(name, marker, false);
    }

    protected Assignment prepend(CharSequence name, Object value) {
        Validate.isTrue((boolean)Utils.isBindMarker(value), (String)"binding a value is not supported", (Object[])new Object[0]);
        return new AssignmentImpl.ListPrependAssignmentImpl(name, Collections.singletonList(value));
    }

    protected Assignment prependAll(CharSequence name, List<?> values) {
        return new AssignmentImpl.ListPrependAssignmentImpl(name, values);
    }

    protected Assignment prependAll(CharSequence name, BindMarker marker) {
        return new AssignmentImpl.ListPrependAssignmentImpl(name, marker);
    }

    protected Assignment append(CharSequence name, Object value) {
        Validate.isTrue((boolean)Utils.isBindMarker(value), (String)"binding a value is not supported", (Object[])new Object[0]);
        return this.appendAll(name, Collections.singletonList(value));
    }

    protected Assignment appendAll(CharSequence name, List<?> values) {
        return new AssignmentImpl.CollectionAssignmentImpl(DataType.LIST, name, values, true, false);
    }

    protected Assignment discard(CharSequence name, Object value) {
        return this.discardAll(name, Collections.singletonList(value));
    }

    protected Assignment discardAll(CharSequence name, List<?> values) {
        return new AssignmentImpl.CollectionAssignmentImpl(DataType.LIST, name, values, false);
    }

    protected Assignment setIdx(CharSequence name, int idx, Object value) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("invalid negative index: " + idx);
        }
        return new AssignmentImpl.ListSetIdxAssignmentImpl(name, idx, value);
    }

    protected Assignment add(CharSequence name, Object value) {
        return this.addAll(name, Collections.singleton(value));
    }

    protected Assignment addAll(CharSequence name, Set<?> values) {
        return new AssignmentImpl.CollectionAssignmentImpl(DataType.SET, name, values, true);
    }

    protected Assignment remove(CharSequence name, Object value) {
        return this.removeAll(name, Collections.singleton(value));
    }

    protected Assignment removeAll(CharSequence name, Set<?> values) {
        return new AssignmentImpl.CollectionAssignmentImpl(DataType.SET, name, values, false);
    }

    protected Assignment put(CharSequence name, Object key, Object value) {
        return new AssignmentImpl.MapPutAssignmentImpl(name, key, value);
    }

    protected Assignment putAll(CharSequence name, Map<?, ?> mappings) {
        return new AssignmentImpl.CollectionAssignmentImpl(DataType.MAP, name, mappings, true);
    }

    protected WithOptions options(JsonObject map) {
        return new WithOptionsImpl("OPTIONS", map);
    }

    protected WithOptions replication(JsonObject map) {
        return new WithOptionsImpl("REPLICATION", map);
    }

    protected WithOptions durableWrites(boolean value) {
        return new WithOptionsImpl("DURABLE_WRITES", value);
    }

    protected Object raw(String str) {
        return new Utils.RawString(str);
    }

    protected Object fcall(String name, Object ... parameters) {
        return new Utils.FCall(name, parameters);
    }

    protected Object cast(Object column, DataType dataType) {
        return new Utils.Cast(column, dataType);
    }

    protected Object now() {
        return new Utils.FCall("now", new Object[0]);
    }

    protected Object uuid() {
        return new Utils.FCall("uuid", new Object[0]);
    }

    protected Object column(String name) {
        return new Utils.CName(name);
    }

    protected <T> Set<String> getColumnNamesFor(Class<T> clazz, Field field) {
        ClassInfoImpl<T> cinfo = this.getClassInfoImpl(clazz);
        LinkedHashSet<String> names = new LinkedHashSet<String>(cinfo.getNumTables());
        for (TableInfoImpl<T> tinfo : cinfo.getTablesImpl()) {
            FieldInfoImpl<T> column = tinfo.getColumnByField(field);
            if (column == null) continue;
            names.add(column.getColumnName());
        }
        Validate.isTrue((!names.isEmpty() ? 1 : 0) != 0, (String)"field '%s.%s' is not annotated as a column", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
        return names;
    }

    protected void executing(StatementImpl<?, ?, ?> statement) {
    }

    protected ResultSetFuture sent(StatementImpl<?, ?, ?> statement, ResultSetFuture future) {
        return future;
    }

    protected <T> ClassInfoImpl<T> cacheClassInfoIfAbsent(ClassInfoImpl<T> cinfo) {
        ClassInfoImpl<T> old = this.classInfoCache.putIfAbsent(cinfo.getObjectClass(), cinfo);
        if (old != null) {
            return old;
        }
        if (cinfo instanceof UDTClassInfoImpl) {
            UDTClassInfoImpl ucinfo = (UDTClassInfoImpl)cinfo;
            this.udts.put(ucinfo.getName(), ucinfo);
        }
        return cinfo;
    }

    protected void clearCache() {
        this.classInfoCache.clear();
        this.udts.clear();
    }

    protected ClassInfoImpl<?> get(Class<?> clazz) {
        return this.classInfoCache.get(clazz);
    }

    public synchronized void connect() {
        if (this.session == null) {
            this.session = this.cluster.connect();
        }
    }

    public void filter(TableInfo<?> tinfo) {
        SnapshotIterator i = new SnapshotIterator(this.filters.iterator());
        while (i.hasNext()) {
            try {
                ((EntityFilter)i.next()).filter(tinfo);
            }
            catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                logger.log(Level.WARN, "entity filter error", t);
            }
        }
    }

    public Stream<ClassInfoImpl<?>> classInfoImpls() {
        return this.classInfoCache.values().stream();
    }

    public <T> ClassInfoImpl<T> findClassInfoImpl(Class<T> clazz) {
        return this.classInfoCache.get(clazz);
    }

    public <T> ClassInfoImpl<T> getClassInfoImpl(Class<T> clazz) {
        ClassInfoImpl classInfo = this.classInfoCache.get(clazz);
        if (classInfo == null) {
            Class rclazz = ReflectionUtils.findFirstClassAnnotatedWith(clazz, RootEntity.class);
            Class rudtclazz = ReflectionUtils.findFirstClassAnnotatedWith(clazz, UDTRootEntity.class);
            if (rclazz != null) {
                Validate.isTrue((rudtclazz == null ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @RootEntity and @UDTRootEntity", (Object[])new Object[]{clazz.getSimpleName()});
                Validate.isTrue((!clazz.isAnnotationPresent(Entity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @RootEntity and @Entity", (Object[])new Object[]{clazz.getSimpleName()});
                Validate.isTrue((!clazz.isAnnotationPresent(UDTEntity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @RootEntity and @UDTEntity", (Object[])new Object[]{clazz.getSimpleName()});
                Validate.isTrue((!clazz.isAnnotationPresent(UDTTypeEntity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @RootEntity and @UDTTypeEntity", (Object[])new Object[]{clazz.getSimpleName()});
                if (rclazz == clazz) {
                    Validate.isTrue((!clazz.isAnnotationPresent(TypeEntity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @RootEntity and @TypeEntity", (Object[])new Object[]{clazz.getSimpleName()});
                    classInfo = new RootClassInfoImpl<T>(this, clazz);
                } else if (clazz.isAnnotationPresent(TypeEntity.class)) {
                    RootClassInfoImpl rcinfo = (RootClassInfoImpl)this.getClassInfoImpl(rclazz);
                    classInfo = rcinfo.getType(clazz);
                    if (classInfo == null) {
                        classInfo = rcinfo.addType(this, clazz);
                    }
                } else {
                    RootClassInfoImpl rcinfo = (RootClassInfoImpl)this.getClassInfoImpl(rclazz);
                    classInfo = rcinfo.newSubClass(this, clazz);
                }
            } else if (rudtclazz != null) {
                Validate.isTrue((!clazz.isAnnotationPresent(UDTEntity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @UDTRootEntity and @UDTEntity", (Object[])new Object[]{clazz.getSimpleName()});
                if (rudtclazz == clazz) {
                    Validate.isTrue((!clazz.isAnnotationPresent(UDTTypeEntity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @UDTRootEntity and @UDTTypeEntity", (Object[])new Object[]{clazz.getSimpleName()});
                    classInfo = new UDTRootClassInfoImpl<T>(this, clazz);
                } else if (clazz.isAnnotationPresent(UDTTypeEntity.class)) {
                    UDTRootClassInfoImpl rcinfo = (UDTRootClassInfoImpl)this.getClassInfoImpl(rudtclazz);
                    classInfo = rcinfo.getType(clazz);
                    if (classInfo == null) {
                        classInfo = rcinfo.addType(this, clazz);
                    }
                } else {
                    UDTRootClassInfoImpl rcinfo = (UDTRootClassInfoImpl)this.getClassInfoImpl(rclazz);
                    classInfo = rcinfo.newSubClass(this, clazz);
                }
            } else if (clazz.isAnnotationPresent(UDTEntity.class)) {
                Validate.isTrue((!clazz.isAnnotationPresent(Entity.class) ? 1 : 0) != 0, (String)"class '%s' cannot be annotated with both @UDTEntity and @Entity", (Object[])new Object[]{clazz.getSimpleName()});
                classInfo = new UDTActualClassInfoImpl(this, clazz);
            } else if (clazz.isAnnotationPresent(Entity.class)) {
                classInfo = new ClassInfoImpl<T>(this, clazz);
            } else {
                throw new IllegalArgumentException("class '" + clazz.getSimpleName() + "' is not annotated with @Entity");
            }
            classInfo = this.cacheClassInfoIfAbsent(classInfo);
        }
        return classInfo;
    }

    public synchronized Session getSession() {
        return this.session;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public CodecRegistry getCodecRegistry() {
        return this.cluster.getConfiguration().getCodecRegistry();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    public int getMaximumKeyspaceReplicationFactor(String keyspace) {
        KeyspaceMetadata mdata = this.cluster.getMetadata().getKeyspace(keyspace);
        if (mdata == null) {
            return 0;
        }
        Map options = mdata.getReplication();
        String strategyClass = (String)options.get("class");
        if (strategyClass == null) {
            return 0;
        }
        try {
            if (strategyClass.contains("SimpleStrategy")) {
                String repFactorString = (String)options.get("replication_factor");
                return repFactorString == null ? 0 : Integer.parseInt(repFactorString);
            }
            if (strategyClass.contains("NetworkTopologyStrategy")) {
                int max_rfactor = 0;
                for (Map.Entry e : options.entrySet()) {
                    int rfactor;
                    if (((String)e.getKey()).equals("class") || max_rfactor >= (rfactor = Integer.parseInt((String)e.getValue()))) continue;
                    max_rfactor = rfactor;
                }
                return max_rfactor;
            }
            return 1;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public ExecutorService getPoolExecutor() {
        return this.poolExecutor;
    }

    public ExecutorService getDirectExecutor() {
        return this.directExecutor;
    }

    public int getDefaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public StatementManagerImpl setDefaultReplicationFactor(int defaultReplicationFactor) {
        Validate.isTrue((defaultReplicationFactor > 0 ? 1 : 0) != 0, (String)"invalid default replication factor: %d", (long)defaultReplicationFactor);
        this.defaultReplicationFactor = defaultReplicationFactor;
        return this;
    }

    public Map<String, Integer> getDefaultDataCenters() {
        return this.defaultDataCenters;
    }

    public StatementManagerImpl setDefaultDataCenters(Map<String, Integer> defaultDataCenters) {
        if (defaultDataCenters != null) {
            defaultDataCenters.entrySet().forEach(e -> Validate.isTrue((e.getValue() != null && (Integer)e.getValue() > 0 ? 1 : 0) != 0, (String)"invalid replication factor: %d for: %s", (Object[])new Object[]{e.getValue(), e.getKey()}));
        }
        this.defaultDataCenters = defaultDataCenters;
        return this;
    }

    public boolean isFullTracesEnabled() {
        return this.fullTraces;
    }

    public void enableFullTraces() {
        this.fullTraces = true;
    }

    public void disableFullTraces() {
        this.fullTraces = false;
    }

    public boolean areAllStatementsTracesEnabled() {
        return this.allStatementTraces;
    }

    public void enableAllStatementsTraces() {
        this.allStatementTraces = true;
    }

    public void disableAllStatementsTraces() {
        this.allStatementTraces = false;
    }

    public CloseFuture closeAsync() {
        CloseFuture future = this.cluster.closeAsync();
        future.addListener(new Runnable(){

            @Override
            public void run() {
                StatementManagerImpl.this.poolExecutor.shutdown();
            }
        }, (Executor)this.directExecutor);
        return future;
    }

    public void close() {
        this.cluster.close();
        this.poolExecutor.shutdown();
    }
}

