/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.codecs.LinkedHashSetCodec;
import org.helenus.driver.codecs.MandatoryCollectionCodec;
import org.helenus.driver.codecs.MandatoryMapCodec;
import org.helenus.driver.codecs.MandatoryPairCodec;
import org.helenus.driver.codecs.MandatoryTripleCodec;
import org.helenus.driver.codecs.PairCodec;
import org.helenus.driver.codecs.SortedMapCodec;
import org.helenus.driver.codecs.SortedSetCodec;
import org.helenus.driver.codecs.TripleCodec;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Column;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;

public class DataTypeImpl {
    public static Class<?> findClass(String name) throws ClassNotFoundException {
        ClassLoader otccl = Thread.currentThread().getContextClassLoader();
        return otccl != null ? Class.forName(name, true, otccl) : Class.forName(name);
    }

    public static Class<?> unwrapOptionalIfPresent(Class<?> clazz, Type type) {
        if (Optional.class.isAssignableFrom(clazz) && type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type atype = ptype.getActualTypeArguments()[0];
            return ReflectionUtils.getRawClass((Type)atype);
        }
        return clazz;
    }

    public static Type unwrapOptionalIfPresent(Type type) {
        if (Optional.class.isAssignableFrom(ReflectionUtils.getRawClass((Type)type)) && type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type atype = ptype.getActualTypeArguments()[0];
            return atype;
        }
        return type;
    }

    public static boolean anyArgumentsInferred(List<CQLDataType> args) {
        for (CQLDataType dt : args) {
            if (dt != DataType.INFERRED) continue;
            return true;
        }
        return false;
    }

    private static void inferDataTypeFrom(Field field, Class<?> clazz, List<CQLDataType> types, boolean isFrozen) {
        DataTypeImpl.inferDataTypeFrom("field: " + field.getDeclaringClass().getName() + "." + field.getName(), field.getGenericType(), clazz, types, isFrozen);
    }

    private static void inferDataTypeFrom(Class<?> clazz, List<CQLDataType> types, boolean isFrozen) {
        DataTypeImpl.inferDataTypeFrom("class: " + clazz.getName(), clazz.getGenericSuperclass(), clazz.getSuperclass(), types, isFrozen);
    }

    private static void inferDataTypeFrom(String trace, Type type, Class<?> clazz, List<CQLDataType> types, boolean isFrozen) {
        boolean isUDT;
        boolean bl = isUDT = clazz.getAnnotation(UDTEntity.class) != null || ReflectionUtils.findFirstClassAnnotatedWith(clazz, UDTRootEntity.class) != null;
        if (Optional.class.isAssignableFrom(clazz)) {
            Validate.isTrue((!isUDT && types.isEmpty() ? 1 : 0) != 0, (String)"collection of optionals is not supported in %s", (Object[])new Object[]{trace});
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type atype = ptype.getActualTypeArguments()[0];
                DataTypeImpl.inferDataTypeFrom(trace, atype, ReflectionUtils.getRawClass((Type)atype), types, true);
                return;
            }
        } else if (List.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types);
                return;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type atype = ptype.getActualTypeArguments()[0];
                types.add((CQLDataType)DataType.LIST);
                DataTypeImpl.inferDataTypeFrom(trace, atype, ReflectionUtils.getRawClass((Type)atype), types, true);
                return;
            }
        } else if (Set.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types);
                return;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type atype = ptype.getActualTypeArguments()[0];
                types.add((CQLDataType)(LinkedHashSet.class.isAssignableFrom(clazz) ? DataType.ORDERED_SET : DataType.SET));
                DataTypeImpl.inferDataTypeFrom(trace, atype, ReflectionUtils.getRawClass((Type)atype), types, true);
                return;
            }
        } else if (SortedMap.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types);
                return;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type ktype = ptype.getActualTypeArguments()[0];
                Type vtype = ptype.getActualTypeArguments()[1];
                types.add((CQLDataType)DataType.SORTED_MAP);
                DataTypeImpl.inferDataTypeFrom(trace, ktype, ReflectionUtils.getRawClass((Type)ktype), types, true);
                DataTypeImpl.inferDataTypeFrom(trace, vtype, ReflectionUtils.getRawClass((Type)vtype), types, true);
                return;
            }
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types);
                return;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type ktype = ptype.getActualTypeArguments()[0];
                Type vtype = ptype.getActualTypeArguments()[1];
                types.add((CQLDataType)DataType.MAP);
                DataTypeImpl.inferDataTypeFrom(trace, ktype, ReflectionUtils.getRawClass((Type)ktype), types, true);
                DataTypeImpl.inferDataTypeFrom(trace, vtype, ReflectionUtils.getRawClass((Type)vtype), types, true);
                return;
            }
        } else if (Pair.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type a1type = ptype.getActualTypeArguments()[0];
                Type a2type = ptype.getActualTypeArguments()[1];
                types.add((CQLDataType)DataType.TUPLE);
                DataTypeImpl.inferDataTypeFrom(trace, a1type, ReflectionUtils.getRawClass((Type)a1type), types, true);
                DataTypeImpl.inferDataTypeFrom(trace, a2type, ReflectionUtils.getRawClass((Type)a2type), types, true);
                return;
            }
        } else if (Triple.class.isAssignableFrom(clazz) && type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type a1type = ptype.getActualTypeArguments()[0];
            Type a2type = ptype.getActualTypeArguments()[1];
            Type a3type = ptype.getActualTypeArguments()[2];
            types.add((CQLDataType)DataType.TUPLE);
            DataTypeImpl.inferDataTypeFrom(trace, a1type, ReflectionUtils.getRawClass((Type)a1type), types, true);
            DataTypeImpl.inferDataTypeFrom(trace, a2type, ReflectionUtils.getRawClass((Type)a2type), types, true);
            DataTypeImpl.inferDataTypeFrom(trace, a3type, ReflectionUtils.getRawClass((Type)a3type), types, true);
            return;
        }
        DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types);
    }

    private static void inferBasicDataTypeFrom(String trace, Class<?> clazz, List<CQLDataType> types) {
        DataType dtype = DataType.valueOf(clazz);
        if (dtype != null) {
            types.add((CQLDataType)dtype);
        } else {
            try {
                ClassInfoImpl cinfo = (ClassInfoImpl)StatementBuilder.getClassInfo(clazz);
                Validate.isTrue((boolean)(cinfo instanceof UDTClassInfoImpl), (String)"unable to infer data type in %s", (Object[])new Object[]{trace});
                types.add((UDTClassInfoImpl)cinfo);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("unable to infer data type in " + trace, e);
            }
        }
    }

    public static Definition inferDataTypeFrom(StatementManagerImpl mgr, Field field, boolean isFrozen) {
        Validate.notNull((Object)field, (String)"invalid null field", (Object[])new Object[0]);
        Column.Data cdata = field.getAnnotation(Column.Data.class);
        if (cdata != null) {
            ArrayList<CQLDataType> itypes = new ArrayList<CQLDataType>(3);
            ArrayList<DataType> atypes = new ArrayList<DataType>(Arrays.asList(cdata.arguments()));
            DataType type = cdata.type();
            if (!atypes.isEmpty() && type == DataType.INFERRED) {
                DataTypeImpl.inferDataTypeFrom(field, field.getType(), itypes, isFrozen);
                Validate.isTrue((boolean)(itypes.get(0) instanceof DataType), (String)"missing data type value in field: %s.%s", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
                type = (DataType)itypes.get(0);
            }
            if (type != DataType.INFERRED) {
                if (type.NUM_ARGUMENTS == -1) {
                    Validate.isTrue((atypes.size() > 0 ? 1 : 0) != 0, (String)"missing argument data type(s) for '%s' in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                } else {
                    Validate.isTrue((atypes.size() >= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"missing argument data type(s) for '%s' in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                    Validate.isTrue((type.NUM_ARGUMENTS != 0 || atypes.size() == 0 ? 1 : 0) != 0, (String)"data type '%s' is not a collection in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                    Validate.isTrue((atypes.size() <= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"too many argument data type(s) for '%s' in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                }
                if (type.NUM_ARGUMENTS != 0 && DataTypeImpl.anyArgumentsInferred(atypes)) {
                    if (itypes.isEmpty()) {
                        DataTypeImpl.inferDataTypeFrom(field, field.getType(), itypes, isFrozen);
                    }
                    for (int i = 0; i < atypes.size(); ++i) {
                        if (atypes.get(i) != DataType.INFERRED) continue;
                        atypes.set(i, (DataType)itypes.get(i + 1));
                    }
                }
                return new Definition(mgr, type, atypes, isFrozen);
            }
            if (type == DataType.BLOB) {
                return new Definition(DataType.BLOB);
            }
            Validate.isTrue((type == DataType.INFERRED ? 1 : 0) != 0, (String)"unsupported data type '%s' in annotated field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
        }
        ArrayList<CQLDataType> types = new ArrayList<CQLDataType>(3);
        DataTypeImpl.inferDataTypeFrom(field, field.getType(), types, isFrozen);
        return new Definition(mgr, types, isFrozen);
    }

    public static Definition inferDataTypeFrom(StatementManagerImpl mgr, DataType type, boolean isFrozen, Class<?> clazz) {
        Validate.notNull((Object)type, (String)"invalid null type", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.isTrue((boolean)type.isCollection(), (String)"data type '%s' is not a collection in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
        UDTEntity.Data cdata = clazz.getAnnotation(UDTEntity.Data.class);
        if (cdata != null) {
            ArrayList<DataType> atypes = new ArrayList<DataType>(Arrays.asList(cdata.arguments()));
            if (type.NUM_ARGUMENTS == -1) {
                Validate.isTrue((atypes.size() > 0 ? 1 : 0) != 0, (String)"missing argument data type(s) for '%s' in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
            } else {
                Validate.isTrue((atypes.size() >= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"missing argument data type(s) for '%s' in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
                Validate.isTrue((atypes.size() <= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"too many argument data type(s) for '%s' in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
            }
            if (type.NUM_ARGUMENTS != 0 && DataTypeImpl.anyArgumentsInferred(atypes)) {
                ArrayList<CQLDataType> types = new ArrayList<CQLDataType>(3);
                DataTypeImpl.inferDataTypeFrom(clazz, types, isFrozen);
                for (int i = 0; i < atypes.size(); ++i) {
                    if (atypes.get(i) != DataType.INFERRED) continue;
                    atypes.set(i, (DataType)types.get(i + 1));
                }
            }
            return new Definition(mgr, type, atypes, isFrozen);
        }
        ArrayList<CQLDataType> types = new ArrayList<CQLDataType>(3);
        DataTypeImpl.inferDataTypeFrom(clazz, types, isFrozen);
        return new Definition(mgr, types, isFrozen);
    }

    public static class Definition
    implements CQLDataType {
        private final CQLDataType type;
        private final List<CQLDataType> arguments;
        public final com.datastax.driver.core.DataType dtype;
        public final boolean isFrozen;

        private static TypeCodec<?> getBasicCodec(String trace, String keyspace, CQLDataType dtype, Type type, boolean mandatory, CodecRegistry codecRegistry) {
            TypeToken token = TypeToken.of((Type)type);
            if (dtype instanceof UDTClassInfoImpl) {
                return ((UDTClassInfoImpl)dtype).getCodec(keyspace);
            }
            try {
                return codecRegistry.codecFor(dtype.getDataType(), token);
            }
            catch (CodecNotFoundException codecNotFoundException) {
                if (dtype instanceof DataType) {
                    try {
                        return ((DataType)dtype).codecFor(keyspace, ReflectionUtils.getRawClass((Type)type));
                    }
                    catch (CodecNotFoundException e) {
                        throw new IllegalArgumentException("unable to find a suitable codec to convert to: " + type.getTypeName() + " for " + trace, e);
                    }
                }
                throw new IllegalArgumentException("unsupported basic type to convert to: " + type.getTypeName() + " for " + trace);
            }
        }

        private static TypeCodec<?> getCodec(String trace, String keyspace, CQLDataType dtype, Type type, boolean mandatory, CodecRegistry codecRegistry) {
            if (dtype instanceof Definition) {
                return ((Definition)dtype).getCodec(trace, keyspace, type, mandatory, codecRegistry);
            }
            return Definition.getBasicCodec(trace, keyspace, dtype, type, mandatory, codecRegistry);
        }

        public Definition(DataType type) {
            this.type = type;
            this.arguments = Collections.emptyList();
            this.dtype = type.getDataType();
            this.isFrozen = false;
        }

        public Definition(StatementManagerImpl mgr, DataType type, List<CQLDataType> arguments, boolean isFrozen) {
            this.type = type;
            this.arguments = arguments;
            this.isFrozen = this.isCollection() ? isFrozen : false;
            this.dtype = this.resolveDataType(mgr);
        }

        public Definition(StatementManagerImpl mgr, List<CQLDataType> types, boolean isFrozen) {
            this.type = types.remove(0);
            this.arguments = Collections.unmodifiableList(types);
            this.isFrozen = this.isCollection() ? isFrozen : false;
            this.dtype = this.resolveDataType(mgr);
        }

        private com.datastax.driver.core.DataType resolveDataType(StatementManagerImpl mgr) {
            if (this.type.isCollection()) {
                switch (((DataType)this.type).NAME) {
                    case LIST: {
                        return com.datastax.driver.core.DataType.list((com.datastax.driver.core.DataType)this.arguments.get(0).getDataType(), (boolean)this.isFrozen());
                    }
                    case SET: {
                        return com.datastax.driver.core.DataType.set((com.datastax.driver.core.DataType)this.arguments.get(0).getDataType(), (boolean)this.isFrozen());
                    }
                    case MAP: {
                        return com.datastax.driver.core.DataType.map((com.datastax.driver.core.DataType)this.arguments.get(0).getDataType(), (com.datastax.driver.core.DataType)this.arguments.get(1).getDataType(), (boolean)this.isFrozen());
                    }
                }
            } else if (this.type.isTuple()) {
                return TupleType.of((ProtocolVersion)mgr.getProtocolVersion(), (CodecRegistry)mgr.getCodecRegistry(), (com.datastax.driver.core.DataType[])((com.datastax.driver.core.DataType[])this.arguments.stream().map(CQLDataType::getDataType).toArray(com.datastax.driver.core.DataType[]::new)));
            }
            return this.type.getDataType();
        }

        private TypeCodec<?> getCodec(String trace, String keyspace, Type type, boolean mandatory, CodecRegistry codecRegistry) {
            TypeToken token = TypeToken.of((Type)type);
            Class clazz = ReflectionUtils.getRawClass((Type)type);
            if (this.isCollection()) {
                if (List.class.isAssignableFrom(clazz)) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        TypeCodec<?> acodec = Definition.getCodec(trace, keyspace, this.arguments.get(0), atype, mandatory, codecRegistry);
                        TypeCodec codec = TypeCodec.list(acodec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryCollectionCodec(codec, () -> new ArrayList(8))), new TypeCodec[]{acodec});
                    }
                    throw new IllegalArgumentException("unable to determine element type for " + trace);
                }
                if (LinkedHashSet.class.isAssignableFrom(clazz) || Set.class.equals((Object)clazz) && this.type.getMainType() == DataType.ORDERED_SET) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        TypeCodec<?> acodec = Definition.getCodec(trace, keyspace, this.arguments.get(0), atype, mandatory, codecRegistry);
                        LinkedHashSetCodec codec = new LinkedHashSetCodec((DataType.CollectionType)this.dtype, token, acodec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryCollectionCodec((TypeCodec)codec, () -> new LinkedHashSet(8))), new TypeCodec[]{acodec});
                    }
                    throw new IllegalArgumentException("unable to determine element type for " + trace);
                }
                if (SortedSet.class.isAssignableFrom(clazz) || Set.class.equals((Object)clazz) && this.type.getMainType() == DataType.SORTED_SET) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        TypeCodec<?> acodec = Definition.getCodec(trace, keyspace, this.arguments.get(0), atype, mandatory, codecRegistry);
                        SortedSetCodec codec = new SortedSetCodec((DataType.CollectionType)this.dtype, token, acodec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryCollectionCodec((TypeCodec)codec, () -> new TreeSet())), new TypeCodec[]{acodec});
                    }
                    throw new IllegalArgumentException("unable to determine element type for " + trace);
                }
                if (Set.class.isAssignableFrom(clazz)) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        TypeCodec<?> acodec = Definition.getCodec(trace, keyspace, this.arguments.get(0), atype, mandatory, codecRegistry);
                        TypeCodec codec = TypeCodec.set(acodec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryCollectionCodec(codec, () -> new LinkedHashSet(8))), new TypeCodec[]{acodec});
                    }
                    throw new IllegalArgumentException("unable to determine element type for " + trace);
                }
                if (SortedMap.class.isAssignableFrom(clazz) || Map.class.equals((Object)clazz) && this.type.getMainType() == DataType.SORTED_MAP) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type ktype = ptype.getActualTypeArguments()[0];
                        TypeCodec<?> kcodec = Definition.getCodec(trace, keyspace, this.arguments.get(0), ktype, mandatory, codecRegistry);
                        Type vtype = ptype.getActualTypeArguments()[1];
                        TypeCodec<?> vcodec = Definition.getCodec(trace, keyspace, this.arguments.get(1), vtype, mandatory, codecRegistry);
                        SortedMapCodec codec = new SortedMapCodec((DataType.CollectionType)this.dtype, token, kcodec, vcodec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryMapCodec((TypeCodec)codec, () -> new TreeMap())), new TypeCodec[]{kcodec, vcodec});
                    }
                    throw new IllegalArgumentException("unable to determine key & value type for " + trace);
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type ktype = ptype.getActualTypeArguments()[0];
                        final Class kclazz = ReflectionUtils.getRawClass((Type)ktype);
                        TypeCodec<?> kcodec = Definition.getCodec(trace, keyspace, this.arguments.get(0), ktype, mandatory, codecRegistry);
                        Type vtype = ptype.getActualTypeArguments()[1];
                        TypeCodec<?> vcodec = Definition.getCodec(trace, keyspace, this.arguments.get(1), vtype, mandatory, codecRegistry);
                        if (kclazz.isEnum()) {
                            TypeCodec.AbstractMapCodec codec = new TypeCodec.AbstractMapCodec(kcodec, vcodec){

                                protected Map<?, ?> newInstance(int size) {
                                    return new EnumMap(kclazz);
                                }
                            };
                            return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryMapCodec((TypeCodec)codec, () -> new EnumMap(kclazz))), new TypeCodec[]{kcodec, vcodec});
                        }
                        TypeCodec codec = TypeCodec.map(kcodec, vcodec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryMapCodec(codec, () -> new HashMap(8))), new TypeCodec[]{kcodec, vcodec});
                    }
                    throw new IllegalArgumentException("unable to determine key & value type for " + trace);
                }
            } else if (this.isTuple()) {
                if (Pair.class.isAssignableFrom(clazz)) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type a1type = ptype.getActualTypeArguments()[0];
                        Type a2type = ptype.getActualTypeArguments()[1];
                        TypeCodec<?> a1codec = Definition.getCodec(trace, keyspace, this.arguments.get(0), a1type, mandatory, codecRegistry);
                        TypeCodec<?> a2codec = Definition.getCodec(trace, keyspace, this.arguments.get(1), a2type, mandatory, codecRegistry);
                        PairCodec codec = new PairCodec((TupleType)this.dtype, token, a1codec, a2codec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryPairCodec((TypeCodec)codec, () -> new MutablePair())), new TypeCodec[]{a1codec, a2codec});
                    }
                    throw new IllegalArgumentException("unable to determine element type for " + trace);
                }
                if (Triple.class.isAssignableFrom(clazz)) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type a1type = ptype.getActualTypeArguments()[0];
                        Type a2type = ptype.getActualTypeArguments()[1];
                        Type a3type = ptype.getActualTypeArguments()[2];
                        TypeCodec<?> a1codec = Definition.getCodec(trace, keyspace, this.arguments.get(0), a1type, mandatory, codecRegistry);
                        TypeCodec<?> a2codec = Definition.getCodec(trace, keyspace, this.arguments.get(1), a2type, mandatory, codecRegistry);
                        TypeCodec<?> a3codec = Definition.getCodec(trace, keyspace, this.arguments.get(2), a3type, mandatory, codecRegistry);
                        TripleCodec codec = new TripleCodec((TupleType)this.dtype, token, a1codec, a2codec, a3codec);
                        return new ArgumentsCodec((TypeCodec)(!mandatory ? codec : new MandatoryTripleCodec((TypeCodec)codec, () -> new MutableTriple())), new TypeCodec[]{a1codec, a2codec, a3codec});
                    }
                    throw new IllegalArgumentException("unable to determine element type for " + trace);
                }
            }
            return Definition.getBasicCodec(trace, keyspace, this.type, type, mandatory, codecRegistry);
        }

        public String name() {
            return this.type.name();
        }

        public boolean isFrozen() {
            return this.type.isFrozen() || this.isCollection() && this.isFrozen;
        }

        public boolean isCollection() {
            return this.type.isCollection();
        }

        public boolean isTuple() {
            return this.type.isTuple();
        }

        public boolean isUserDefined() {
            return this.type instanceof UDTClassInfoImpl;
        }

        public com.datastax.driver.core.DataType getDataType() {
            return this.dtype;
        }

        public CQLDataType getMainType() {
            return this.type;
        }

        public CQLDataType getElementType() {
            if (this.arguments.size() == 0) {
                return null;
            }
            return this.arguments.get(this.arguments.size() - 1);
        }

        public List<CQLDataType> getArgumentTypes() {
            return this.arguments;
        }

        public CQLDataType getFirstArgumentType() {
            return this.arguments.isEmpty() ? null : this.arguments.get(0);
        }

        public boolean isAlterableTo(CQLDataType to) {
            if (to instanceof Definition) {
                Definition tod = (Definition)to;
                if (!this.type.isAlterableTo(tod.type)) {
                    return false;
                }
                if (this.isCollection() || this.isTuple()) {
                    if (this.arguments.size() != tod.arguments.size()) {
                        return false;
                    }
                    for (int i = 0; i < this.arguments.size(); ++i) {
                        if (this.arguments.get(i).isAlterableTo(tod.arguments.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
            if (this.isCollection() || this.isUserDefined() || this.isTuple()) {
                return false;
            }
            return this.type.isAlterableTo(to);
        }

        public TypeCodec<?> getCodec(String keyspace, Field field, boolean mandatory, CodecRegistry codecRegistry) {
            Validate.notNull((Object)keyspace, (String)"invalid null keyspace", (Object[])new Object[0]);
            Validate.notNull((Object)field, (String)"invalid null field", (Object[])new Object[0]);
            return this.getCodec("field: " + field.getDeclaringClass().getName() + "." + field.getName(), keyspace, DataTypeImpl.unwrapOptionalIfPresent(field.getGenericType()), mandatory, codecRegistry);
        }

        public TypeCodec<?> getCodec(String keyspace, Class<?> clazz, CodecRegistry codecRegistry) {
            Validate.notNull((Object)keyspace, (String)"invalid null keyspace", (Object[])new Object[0]);
            Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
            Validate.validState((boolean)this.isCollection(), (String)"not a collection definition", (Object[])new Object[0]);
            return this.getCodec("class: " + clazz.getName(), keyspace, clazz.getGenericSuperclass(), true, codecRegistry);
        }

        public String toCQL() {
            if (this.isCollection() || this.isTuple()) {
                ArrayList<String> cqls = new ArrayList<String>(this.arguments.size());
                StringBuilder sb = new StringBuilder();
                for (CQLDataType atype : this.arguments) {
                    cqls.add(atype.toCQL());
                }
                if (this.isFrozen()) {
                    sb.append("frozen<");
                }
                sb.append(this.type.toCQL()).append('<').append(StringUtils.join(cqls, (char)',')).append('>');
                if (this.isFrozen()) {
                    sb.append('>');
                }
                return sb.toString();
            }
            return this.type.toCQL();
        }

        public Stream<UDTClassInfoImpl<?>> udts() {
            if (this.type instanceof UDTClassInfoImpl) {
                return Stream.of((UDTClassInfoImpl)this.type);
            }
            return this.arguments.stream().filter(t -> t instanceof UDTClassInfoImpl).map(t -> (UDTClassInfoImpl)t);
        }

        public String toString() {
            return this.toCQL();
        }
    }
}

