/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.CreateKeyspaceImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.impl.WithOptionsImpl;

public class AlterCreateKeyspaceImpl<T>
extends CreateKeyspaceImpl<T> {
    public AlterCreateKeyspaceImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(context, mgr, bridge);
        this.ifNotExists();
    }

    @Override
    protected StringBuilder buildQueryString() {
        Row row = this.mgr.getSession().executeAsync((Statement)new SimpleStatement("SELECT durable_writes,strategy_class,strategy_options FROM system.schema_keyspaces WHERE keyspace_name='" + this.getKeyspace() + "' LIMIT 1")).getUninterruptibly().one();
        if (row == null) {
            return super.buildQueryString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER KEYSPACE ");
        Utils.appendName(builder, this.getKeyspace());
        WithOptionsImpl.ReplicationWithImpl replication = this.with.replication;
        if (replication == null) {
            replication = new WithOptionsImpl.ReplicationWithImpl(this.getContext().getClassInfo(), this.mgr);
        }
        ArrayList<WithOptionsImpl> options = new ArrayList<WithOptionsImpl>(this.with.options.size() + 1);
        options.add(replication);
        options.addAll(this.with.options);
        builder.append(" WITH ");
        Utils.joinAndAppend(this.getKeyspace(), null, null, this.mgr.getCodecRegistry(), builder, " AND ", options, null);
        builder.append(" AND DURABLE_WRITES = ").append(this.getContext().getClassInfo().getKeyspace().durableWrites());
        return builder;
    }
}

