/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.tools;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.helenus.commons.cli.RunnableFirstOption;
import org.helenus.commons.cli.RunnableOption;
import org.helenus.commons.collections.DirectedGraph;
import org.helenus.commons.collections.GraphUtils;
import org.helenus.commons.collections.graph.ConcurrentHashDirectedGraph;
import org.helenus.commons.lang3.IllegalCycleException;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.AlterSchemas;
import org.helenus.driver.Batch;
import org.helenus.driver.BatchableStatement;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateSchemas;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.Group;
import org.helenus.driver.GroupableStatement;
import org.helenus.driver.ObjectClassStatement;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.Sequence;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.Truncate;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.persistence.InitialObjects;
import org.helenus.driver.persistence.ObjectCreator;
import org.helenus.jackson.jsonSchema.factories.JsonAnnotationSchemaFactoryWrapper;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

public class Tool {
    private static StatementManagerImpl mgr;
    private static boolean vflag;
    private static boolean fvflag;
    private static final RunnableOption schemas;
    private static final RunnableOption objects;
    private static final RunnableOption truncate;
    private static final RunnableOption jsons;
    private static final Option jsonview;
    private static final RunnableFirstOption deserialize;
    private static final RunnableOption help;
    private static final RunnableOption verbose;
    private static final RunnableOption full_verbose;
    private static final RunnableOption trace;
    private static final Option filters;
    private static final Option server;
    private static final Option port;
    private static final Option matches_only;
    private static final Option alter;
    private static final Option no_dependents;
    private static final Option replicationFactor;
    private static final Option dataCenters;
    private static final Option keyspaceKeys;
    private static final Option output;
    private static final Options options;

    private static String getViewName(Class<?> clazz) {
        String cname = clazz.getSimpleName();
        Class<?> pclazz = clazz.getDeclaringClass();
        if (pclazz != null) {
            return pclazz.getSimpleName() + "." + cname;
        }
        return cname;
    }

    private static <T> ObjectSet<T> executeCQL(ObjectClassStatement<T> s) {
        s.setConsistencyLevel(ConsistencyLevel.ONE);
        if (vflag) {
            System.out.println(Tool.class.getSimpleName() + ": CQL -> " + s.getQueryString());
        }
        return (ObjectSet)s.execute();
    }

    private static void executeCQL(GenericStatement<?, ?> s) {
        s.setConsistencyLevel(ConsistencyLevel.ONE);
        s.setSerialConsistencyLevel(ConsistencyLevel.SERIAL);
        if (vflag) {
            String query = s.getQueryString();
            if (query == null) {
                System.out.println(Tool.class.getSimpleName() + ": CQL -> null");
            } else if (fvflag || query.length() < 2048) {
                System.out.println(Tool.class.getSimpleName() + ": CQL -> " + query);
            } else if (s instanceof Batch) {
                System.out.println(Tool.class.getSimpleName() + ": CQL -> " + query.substring(0, 2032) + " ... APPLY BATCH;");
            } else if (s instanceof Sequence) {
                System.out.println(Tool.class.getSimpleName() + ": CQL -> " + query.substring(0, 2029) + " ... APPLY SEQUENCE;");
            } else if (s instanceof Group) {
                System.out.println(Tool.class.getSimpleName() + ": CQL -> " + query.substring(0, 2032) + " ... APPLY GROUP;");
            } else {
                System.out.println(Tool.class.getSimpleName() + ": CQL -> " + query.substring(0, 2044));
            }
        }
        s.execute();
    }

    private static void createSchemasFromPackagesOrClasses(String[] pkgs, Map<String, String> kkeys, boolean matching, boolean alter, Sequence s) {
        if (alter) {
            AlterSchemas cs = matching ? StatementBuilder.alterMatchingSchemas((String[])pkgs) : StatementBuilder.alterSchemas((String[])pkgs);
            for (Map.Entry<String, String> e : kkeys.entrySet()) {
                cs.where((Clause)StatementBuilder.eq((CharSequence)e.getKey(), (Object)e.getValue()));
            }
            cs.classInfos().forEachOrdered(cinfo -> System.out.println(Tool.class.getSimpleName() + ": altering schema for " + cinfo.getObjectClass().getName()));
            s.add((SequenceableStatement)cs);
        } else {
            CreateSchemas cs = matching ? StatementBuilder.createMatchingSchemas((String[])pkgs) : StatementBuilder.createSchemas((String[])pkgs);
            cs.ifNotExists();
            for (Map.Entry<String, String> e : kkeys.entrySet()) {
                cs.where((Clause)StatementBuilder.eq((CharSequence)e.getKey(), (Object)e.getValue()));
            }
            cs.classInfos().forEachOrdered(cinfo -> System.out.println(Tool.class.getSimpleName() + ": creating schema for " + cinfo.getObjectClass().getName()));
            s.add((SequenceableStatement)cs);
        }
    }

    private static void truncateSchemasFromPackagesOrClasses(String[] pkgs, Map<String, String> kkeys, boolean matching, Sequence s) {
        CreateSchemas cs = matching ? StatementBuilder.createMatchingSchemas((String[])pkgs) : StatementBuilder.createSchemas((String[])pkgs);
        for (Map.Entry<String, String> e : kkeys.entrySet()) {
            cs.where((Clause)StatementBuilder.eq((CharSequence)e.getKey(), (Object)e.getValue()));
        }
        cs.classInfos().forEachOrdered(cinfo -> {
            System.out.println(Tool.class.getSimpleName() + ": truncating schema for " + cinfo.getObjectClass().getName());
            Truncate t = StatementBuilder.truncate((Class)cinfo.getObjectClass());
            s.add((SequenceableStatement)t);
        });
    }

    private static void createSchemas(CommandLine line) throws Exception {
        Object[] opts = line.getOptionValues(schemas.getLongOpt());
        Properties kkeys = line.getOptionProperties(keyspaceKeys.getOpt());
        boolean matching = line.hasOption(matches_only.getLongOpt());
        boolean alter = line.hasOption(Tool.alter.getLongOpt());
        Sequence s = StatementBuilder.sequence((SequenceableStatement[])new SequenceableStatement[0]);
        System.out.print(Tool.class.getSimpleName() + ": searching for schema definitions in " + Arrays.toString(opts));
        if (!kkeys.isEmpty()) {
            System.out.print(" with " + (matching ? "matching " : "") + "keyspace keys " + kkeys);
        }
        System.out.println();
        Tool.createSchemasFromPackagesOrClasses((String[])opts, kkeys, matching, alter, s);
        if (s.isEmpty() || s.getQueryString() == null) {
            System.out.println(Tool.class.getSimpleName() + ": no schemas found matching the specified criteria");
        } else {
            Tool.executeCQL(s);
        }
    }

    private static void truncateSchemas(CommandLine line) throws Exception {
        Object[] opts = line.getOptionValues(truncate.getLongOpt());
        Properties kkeys = line.getOptionProperties(keyspaceKeys.getOpt());
        boolean matching = line.hasOption(matches_only.getLongOpt());
        Sequence s = StatementBuilder.sequence((SequenceableStatement[])new SequenceableStatement[0]);
        System.out.print(Tool.class.getSimpleName() + ": searching for schema definitions in " + Arrays.toString(opts));
        if (!kkeys.isEmpty()) {
            System.out.print(" with " + (matching ? "matching " : "") + "keyspace keys " + kkeys);
        }
        System.out.println();
        Tool.truncateSchemasFromPackagesOrClasses((String[])opts, kkeys, matching, s);
        if (s.isEmpty() || s.getQueryString() == null) {
            System.out.println(Tool.class.getSimpleName() + ": no schemas found matching the specified criteria");
        } else {
            Tool.executeCQL(s);
        }
    }

    private static void createJsonSchemasFromPackagesOrClasses(String[] pkgs, Map<String, String> kkeys, boolean matching, Map<Class<?>, JsonSchema> schemas, Class<?> view) throws IOException {
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : pkgs) {
            CreateSchemas cs = matching ? StatementBuilder.createMatchingSchemas((String[])new String[]{pkg}) : StatementBuilder.createSchemas((String[])new String[]{pkg});
            for (Map.Entry<String, String> e : kkeys.entrySet()) {
                cs.where((Clause)StatementBuilder.eq((CharSequence)e.getKey(), (Object)e.getValue()));
            }
            Set csclasses = cs.getObjectClasses();
            if (csclasses.isEmpty()) {
                Reflections reflections = new Reflections(new Object[]{pkgs, new SubTypesScanner(false)});
                try {
                    reflections.getAllTypes().stream().map(n -> {
                        try {
                            return Class.forName(n);
                        }
                        catch (ClassNotFoundException | LinkageError ee) {
                            return null;
                        }
                    }).filter(c -> c != null).forEach(c -> classes.add((Class<?>)c));
                }
                catch (ReflectionsException e) {
                    for (String c2 : pkgs) {
                        try {
                            classes.add(Class.forName(c2));
                        }
                        catch (ClassNotFoundException | LinkageError throwable) {
                            // empty catch block
                        }
                    }
                }
                classes.addAll(reflections.getSubTypesOf(Enum.class));
                continue;
            }
            classes.addAll(csclasses);
        }
        for (Class clazz : classes) {
            System.out.println(Tool.class.getSimpleName() + ": creating Json schema for " + clazz.getName() + (view != null ? " with view '" + Tool.getViewName(view) + "'" : ""));
            ObjectMapper m = new ObjectMapper();
            JsonAnnotationSchemaFactoryWrapper visitor = new JsonAnnotationSchemaFactoryWrapper();
            if (view != null) {
                m.setConfig(m.getSerializationConfig().withView(view));
            }
            m.registerModules(new Module[]{new Jdk8Module(), new JSR310Module()});
            m.enable(SerializationFeature.INDENT_OUTPUT);
            m.acceptJsonFormatVisitor(m.constructType((Type)clazz), (JsonFormatVisitorWrapper)visitor);
            schemas.put(clazz, visitor.finalSchemaWithTitle());
        }
    }

    private static void createJsonSchemas(CommandLine line) throws Exception {
        Object[] opts = line.getOptionValues(jsons.getLongOpt());
        Properties kkeys = line.getOptionProperties(keyspaceKeys.getOpt());
        boolean matching = line.hasOption(matches_only.getLongOpt());
        LinkedHashMap schemas = new LinkedHashMap();
        Class<?> view = line.hasOption(jsonview.getLongOpt()) ? Class.forName(line.getOptionValue(jsonview.getLongOpt())) : null;
        System.out.print(Tool.class.getSimpleName() + ": searching for Json schema definitions in " + Arrays.toString(opts));
        if (!kkeys.isEmpty()) {
            System.out.print(" with " + (matching ? "matching " : "") + "keyspace keys " + kkeys);
        }
        System.out.println();
        Tool.createJsonSchemasFromPackagesOrClasses((String[])opts, kkeys, matching, schemas, view);
        if (schemas.isEmpty()) {
            System.out.println(Tool.class.getSimpleName() + ": no Json schemas found matching the specified criteria");
        } else {
            String output = line.getOptionValue(Tool.output.getLongOpt(), ".");
            File dir = new File(output);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Validate.isTrue((boolean)dir.isDirectory(), (String)"not a directory: %s", (Object[])new Object[]{dir});
            ObjectMapper m = new ObjectMapper();
            m.enable(SerializationFeature.INDENT_OUTPUT);
            for (Map.Entry e : schemas.entrySet()) {
                m.writeValue(new File(dir, ((Class)e.getKey()).getName() + ".json"), e.getValue());
            }
        }
    }

    private static Collection<?> getInitialObjects(Method initial, Map<String, String> kkeys) {
        try {
            Object ret = initial.getParameterCount() == 0 ? initial.invoke(null, new Object[0]) : initial.invoke(null, kkeys);
            if (ret == null) {
                return Collections.emptyList();
            }
            Class<?> type = initial.getReturnType();
            if (type.isArray()) {
                int length = Array.getLength(ret);
                ArrayList<Object> objects = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    objects.add(Array.get(ret, i));
                }
                return objects;
            }
            if (ret instanceof Collection) {
                return (Collection)ret;
            }
            if (ret instanceof Stream) {
                return ((Stream)ret).collect(Collectors.toList());
            }
            if (ret instanceof Iterator) {
                ArrayList objects = new ArrayList(32);
                Iterator i = (Iterator)ret;
                while (i.hasNext()) {
                    objects.add(i.next());
                }
                return objects;
            }
            if (ret instanceof Enumeration) {
                ArrayList objects = new ArrayList(32);
                Enumeration e = (Enumeration)ret;
                while (e.hasMoreElements()) {
                    objects.add(e.nextElement());
                }
                return objects;
            }
            if (ret instanceof Iterable) {
                ArrayList objects = new ArrayList(32);
                Iterator i = ((Iterable)ret).iterator();
                while (i.hasNext()) {
                    objects.add(i.next());
                }
                return objects;
            }
            return Collections.singleton(ret);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(t);
        }
    }

    private static Map<Method, Class<?>[]> findInitials(Class<?> clazz) {
        return ReflectionUtils.getAllAnnotationsForMethodsAnnotatedWith(clazz, InitialObjects.class, (boolean)true).entrySet().stream().peek(e -> {
            Method m = (Method)e.getKey();
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new IllegalArgumentException("initial objects method '" + m.getName() + "' is not static in class: " + clazz.getSimpleName());
            }
            Class<?>[] cparms = m.getParameterTypes();
            if (cparms.length > 1) {
                throw new IllegalArgumentException("expecting only one parameter for initial objects method '" + m.getName() + "' to be of type Map<String, String> in class: " + clazz.getSimpleName());
            }
            if (cparms.length == 1) {
                if (!Map.class.isAssignableFrom(cparms[0])) {
                    throw new IllegalArgumentException("expecting parameter for initial objects method '" + m.getName() + "' to be of type Map<String, String> in class: " + clazz.getSimpleName());
                }
                Type[] tparms = m.getGenericParameterTypes();
                if (tparms.length != 1) {
                    throw new IllegalArgumentException("expecting parameter for initial objects method '" + m.getName() + "' to be of type Map<String, String> in class: " + clazz.getSimpleName());
                }
                if (tparms[0] instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)tparms[0];
                    for (Type atype : ptype.getActualTypeArguments()) {
                        Class aclazz = ReflectionUtils.getRawClass((Type)atype);
                        if (String.class == aclazz) continue;
                        throw new IllegalArgumentException("expecting parameter for initial objects method '" + m.getName() + "' to be of type Map<String, String> in class: " + clazz.getSimpleName());
                    }
                } else {
                    throw new IllegalArgumentException("expecting parameter for initial objects method '" + m.getName() + "' to be of type Map<String, String> in class: " + clazz.getSimpleName());
                }
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, e -> ((InitialObjects[])e.getValue())[0].dependsOn()));
    }

    private static void findCreatorsFromPackagesOrClasses(DirectedGraph<Class<?>> classes, String[] pkgs, boolean no_dependents) {
        for (String pkg : pkgs) {
            if (pkg == null) continue;
            for (Class clazz : new Reflections(pkg, new Scanner[0]).getTypesAnnotatedWith(ObjectCreator.class, true)) {
                Map<Method, Class<?>[]> initials = Tool.findInitials(clazz);
                if (initials.isEmpty()) {
                    System.out.println(Tool.class.getSimpleName() + ": no objects found using " + clazz.getName());
                    continue;
                }
                classes.add((Object)clazz);
                if (no_dependents) continue;
                DirectedGraph.Node node = classes.get((Object)clazz);
                initials.forEach((m, cs) -> {
                    for (Class c : cs) {
                        node.add((Object)c);
                    }
                });
            }
        }
    }

    private static void insertObjectsFromClasses(Collection<Class<?>> classes, Map<String, String> kkeys) {
        for (Class<?> clazz : classes) {
            Map<Method, Class<?>[]> initials = Tool.findInitials(clazz);
            if (initials.isEmpty()) {
                System.out.println(Tool.class.getSimpleName() + ": no objects found using " + clazz.getName());
                continue;
            }
            Group group = StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]);
            for (Map.Entry<Method, Class<?>[]> e : initials.entrySet()) {
                Method m = e.getKey();
                Collection<?> ios = Tool.getInitialObjects(m, kkeys);
                System.out.println(Tool.class.getSimpleName() + ": inserting " + ios.size() + " object" + (ios.size() == 1 ? "" : "s") + " using " + clazz.getName() + "." + m.getName() + "()");
                for (Object io : ios) {
                    group.add((BatchableStatement)StatementBuilder.insert(io).intoAll());
                }
            }
            if (group.isEmpty()) {
                System.out.println(Tool.class.getSimpleName() + ": no objects to insert");
                continue;
            }
            Tool.executeCQL(group);
        }
    }

    private static void insertObjects(CommandLine line) throws Exception {
        Object[] opts = line.getOptionValues(objects.getLongOpt());
        Properties kkeys = line.getOptionProperties(keyspaceKeys.getOpt());
        boolean no_dependents = line.hasOption(Tool.no_dependents.getLongOpt());
        System.out.print(Tool.class.getSimpleName() + ": searching for object creators in " + Arrays.toString(opts));
        if (!kkeys.isEmpty()) {
            System.out.print(" with keyspace keys " + kkeys);
        }
        if (no_dependents) {
            System.out.print(" not including dependent creators");
        }
        System.out.println();
        ConcurrentHashDirectedGraph classes = new ConcurrentHashDirectedGraph();
        Tool.findCreatorsFromPackagesOrClasses(classes, (String[])opts, no_dependents);
        try {
            List cs = GraphUtils.sort((DirectedGraph)classes);
            Collections.reverse(cs);
            Tool.insertObjectsFromClasses(cs, kkeys);
        }
        catch (IllegalCycleException e) {
            System.out.println(Tool.class.getSimpleName() + ": circular creator dependency detected: " + e.getCycle());
            throw e;
        }
    }

    private static void setRootLogLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        String pkg = Tool.class.getPackage().getName();
        for (String name : new String[]{"", pkg.subSequence(0, pkg.lastIndexOf(46, pkg.lastIndexOf(46) - 1)).toString(), "com.datastax"}) {
            LoggerConfig loggerConfig = config.getLoggerConfig(name);
            loggerConfig.setLevel(level);
        }
        ctx.updateLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Tool.setRootLogLevel(Level.OFF);
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(verbose.getOpt())) {
                verbose.run(line);
            }
            if (line.hasOption(trace.getLongOpt())) {
                trace.run(line);
            }
            for (Option option : line.getOptions()) {
                if (!(option instanceof RunnableFirstOption)) continue;
                ((RunnableFirstOption)option).run(line);
            }
            String server = line.getOptionValue(Tool.server.getLongOpt(), "127.0.0.1");
            int port = Integer.parseInt(line.getOptionValue(Tool.port.getLongOpt(), "9042"));
            boolean connect = line.hasOption(objects.getLongOpt()) || line.hasOption(schemas.getLongOpt()) || line.hasOption(truncate.getLongOpt());
            mgr = new StatementManagerImpl((Cluster.Initializer)Cluster.builder().withPort(port).addContactPoint(server).withQueryOptions(null), connect, line.getOptionValues(filters.getLongOpt()));
            if (fvflag) {
                mgr.enableFullTraces();
            }
            if (line.hasOption(replicationFactor.getLongOpt())) {
                mgr.setDefaultReplicationFactor(Integer.parseInt(line.getOptionValue(replicationFactor.getLongOpt())));
            }
            if (line.hasOption(dataCenters.getOpt())) {
                Properties dcss = line.getOptionProperties(dataCenters.getOpt());
                LinkedHashMap<String, Integer> dcs = new LinkedHashMap<String, Integer>(dcss.size() * 3 / 2);
                for (Map.Entry e : dcss.entrySet()) {
                    dcs.put((String)e.getKey(), Integer.parseInt((String)e.getValue()));
                }
                mgr.setDefaultDataCenters(dcs);
            }
            try {
                if (connect && vflag) {
                    System.out.println(Tool.class.getSimpleName() + ": connected to Cassandra on: " + server);
                }
                for (Option option : line.getOptions()) {
                    if (!(option instanceof RunnableOption)) continue;
                    ((RunnableOption)option).run(line);
                }
            }
            finally {
                mgr.close();
            }
        }
        catch (Exception e) {
            System.err.print(Tool.class.getSimpleName() + ": unexpected exception: ");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static {
        vflag = false;
        fvflag = false;
        schemas = new RunnableOption("s", "schemas", false, "to define schemas for the specified pojo classes and/or packages (separated with :)"){
            {
                this.setArgs(-2);
                this.setArgName("classes-packages");
                this.setValueSeparator(':');
            }

            public void run(CommandLine line) throws Exception {
                Tool.createSchemas(line);
            }
        };
        objects = new RunnableOption("o", "objects", false, "to insert objects using the specified creator classes and/or packages (separated with :)"){
            {
                this.setArgs(-2);
                this.setArgName("classes-packages");
                this.setValueSeparator(':');
            }

            public void run(CommandLine line) throws Exception {
                Tool.insertObjects(line);
            }
        };
        truncate = new RunnableOption("t", "truncate", false, "to truncate schema tables for the specified pojo classes and/or packages (separated with :)"){
            {
                this.setArgs(-2);
                this.setArgName("classes-packages");
                this.setValueSeparator(':');
            }

            public void run(CommandLine line) throws Exception {
                Tool.truncateSchemas(line);
            }
        };
        jsons = new RunnableOption("j", "jsons", false, "to write json schemas to disk for the specified pojo classes and/or packages (separated with :)"){
            {
                this.setArgs(-2);
                this.setArgName("classes-packages");
                this.setValueSeparator(':');
            }

            public void run(CommandLine line) throws Exception {
                Tool.createJsonSchemas(line);
            }
        };
        jsonview = Option.builder().longOpt("view").desc("to specify the Json view to use when generating the schemas (defaults to none)").hasArg().argName("class").build();
        deserialize = new RunnableFirstOption("d", "deserialize", true, "to deserialize a blob"){
            {
                this.setArgName("blob");
            }

            public void run(CommandLine line) throws Exception {
                block34: {
                    byte[] blob;
                    String s = line.getOptionValue(this.getLongOpt());
                    if (s.startsWith("0x") || s.startsWith("0X")) {
                        s = s.substring(2);
                    }
                    if ((blob = Hex.decodeHex((char[])s.toCharArray())).length >= 2 && blob[0] == -84 && blob[1] == -19) {
                        Object obj = SerializationUtils.deserialize((byte[])blob);
                        System.out.println(">> " + obj.getClass());
                        System.out.println(">> " + obj);
                    } else {
                        if (blob.length >= 4 && blob[0] == -54 && blob[1] == -2 && blob[2] == -70 && blob[3] == -66) {
                            try (ByteArrayInputStream bais = new ByteArrayInputStream(blob);
                                 DataInputStream dis = new DataInputStream(bais);){
                                dis.readLong();
                                int cpcnt = (dis.readShort() & 0xFFFF) - 1;
                                int[] classes = new int[cpcnt];
                                String[] strings = new String[cpcnt];
                                for (int i = 0; i < cpcnt; ++i) {
                                    int t = dis.read();
                                    if (t == 7) {
                                        classes[i] = dis.readShort() & 0xFFFF;
                                        continue;
                                    }
                                    if (t == 1) {
                                        strings[i] = dis.readUTF();
                                        continue;
                                    }
                                    if (t == 5 || t == 6) {
                                        dis.readLong();
                                        continue;
                                    }
                                    if (t == 8 || t == 16) {
                                        dis.readShort();
                                        continue;
                                    }
                                    if (t == 15) {
                                        dis.read();
                                        dis.readShort();
                                        continue;
                                    }
                                    dis.readInt();
                                }
                                dis.readShort();
                                System.out.println(">> compiled class " + strings[classes[(dis.readShort() & 0xFFFF) - 1] - 1].replace('/', '.'));
                                break block34;
                            }
                        }
                        Object obj = org.helenus.commons.lang3.SerializationUtils.decompressAndDeserialize((byte[])blob);
                        System.out.println(">> " + obj.getClass());
                        System.out.println(">> " + obj);
                    }
                }
                System.exit(0);
            }
        };
        help = new RunnableOption("?", "help", false, "to print this message"){

            public void run(CommandLine line) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(120, Tool.class.getSimpleName(), "Cassandra Client Tool", options, null, true);
            }
        };
        verbose = new RunnableOption("v", "verbose", false, "to enable verbose output"){

            public void run(CommandLine line) {
                vflag = true;
            }
        };
        full_verbose = new RunnableOption(null, "full", false, "to enable full verbose output"){

            public void run(CommandLine line) {
                vflag = true;
                fvflag = true;
            }
        };
        trace = new RunnableOption(null, "trace", false, "to enable trace output"){

            public void run(CommandLine line) {
                Tool.setRootLogLevel(Level.TRACE);
            }
        };
        filters = Option.builder((String)"f").longOpt("filters").desc("to specify entity filter classes to register with the driver (separated with :)").valueSeparator(':').hasArgs().argName("classes").build();
        server = Option.builder().longOpt("server").desc("to specify the server address for Cassandra (defaults to localhost)").hasArg().argName("host").build();
        port = Option.builder().longOpt("port").desc("to specify the port number for Cassandra (defaults to 9042)").hasArg().argName("number").build();
        matches_only = Option.builder().longOpt("matches-only").desc("to specify that only keyspace that matches the specified keyspace keys should be created").build();
        alter = Option.builder().longOpt("alter").desc("to alter the existing schemas instead of creating it if it doesn't exist").build();
        no_dependents = Option.builder().longOpt("no-dependents").desc("to specify that dependent creators should not be considered when creating objects").build();
        replicationFactor = Option.builder().longOpt("replication-factor").desc("to specify the default replication factor to use with the simple placement strategy when creating keyspaces (defaults to 2)").hasArg().argName("value").build();
        dataCenters = Option.builder((String)"D").desc("to specify the default data centers and number of replicas to use with the network topology strategy when creating keyspaces (e.g. -Ddatacenter1=2)").numberOfArgs(2).argName("datacenter=replicas").valueSeparator().build();
        keyspaceKeys = Option.builder((String)"K").desc("to specify value(s) for keyspace key types (e.g. -Kcustomer=acme, -Kregion=emea)").numberOfArgs(2).argName("type=value").valueSeparator().build();
        output = Option.builder().longOpt("output").desc("to specify the output directory (defaults to current directory)").hasArg().argName("output").build();
        options = new Options().addOption((Option)truncate).addOption((Option)schemas).addOption((Option)objects).addOption((Option)jsons).addOption(jsonview).addOption(keyspaceKeys).addOption(server).addOption(port).addOption(filters).addOption((Option)deserialize).addOption(matches_only).addOption(alter).addOption(no_dependents).addOption(replicationFactor).addOption(dataCenters).addOption(output).addOption((Option)verbose).addOption((Option)full_verbose).addOption((Option)trace).addOption((Option)help);
    }
}

