/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.TypeCodec;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.WithOptions;
import org.helenus.driver.codecs.provider.VarCharCodecProvider;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.StrategyClass;

public class WithOptionsImpl
extends Utils.Appendeable
implements WithOptions {
    private final String name;
    private final Object value;

    public WithOptionsImpl(String name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null name", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"invalid null value", (Object[])new Object[0]);
        this.name = name;
        this.value = value;
    }

    @Override
    void appendTo(TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        sb.append(this.name).append('=');
        if (codec == null && this.value instanceof JsonObject) {
            StringBuilder vsb = new StringBuilder(80);
            Utils.appendValue(null, VarCharCodecProvider.JSON_CODEC, codecRegistry, vsb, this.value, variables);
            sb.append(ParseUtils.unquote((String)vsb.toString()).replaceAll("'", "'QUOTE'").replaceAll("\"", "'").replaceAll("\\\\'", "\"").replaceAll("'QUOTE'", "\\\\'"));
        } else {
            Utils.appendValue(null, codec, codecRegistry, sb, this.value, variables);
        }
    }

    @Override
    boolean containsBindMarker() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public static class ReplicationWithImpl
    extends WithOptionsImpl {
        private static JsonObject getReplicationProperties(ClassInfoImpl<?> cinfo, StatementManagerImpl mgr) {
            Keyspace keyspace = cinfo.getKeyspace();
            JsonObjectBuilder jbuild = Json.createObjectBuilder();
            StrategyClass strategy = keyspace.strategy();
            switch (strategy) {
                case NETWORK_TOPOLOGY: {
                    Map<String, Integer> dcs;
                    if (ArrayUtils.isEmpty((Object[])keyspace.dataCenter())) {
                        dcs = mgr.getDefaultDataCenters();
                        if (MapUtils.isEmpty(dcs)) {
                            strategy = StrategyClass.SIMPLE;
                        }
                    } else {
                        int[] factors = keyspace.replicationFactor();
                        String[] names = keyspace.dataCenter();
                        Validate.isTrue((names.length == factors.length ? 1 : 0) != 0, (String)"mismatch number of data centers and replication factors for network topology in %s", (Object[])new Object[]{cinfo.getObjectClass().getName()});
                        dcs = new LinkedHashMap<String, Integer>(names.length * 3 / 2);
                        for (int i = 0; i < names.length; ++i) {
                            dcs.put(names[i], factors[i]);
                        }
                    }
                    if (strategy == StrategyClass.NETWORK_TOPOLOGY) {
                        dcs.entrySet().forEach(e -> jbuild.add((String)e.getKey(), ((Integer)e.getValue()).intValue()));
                        break;
                    }
                }
                case SIMPLE: {
                    int replicationFactor;
                    if (ArrayUtils.isEmpty((int[])keyspace.replicationFactor())) {
                        replicationFactor = 0;
                    } else {
                        Validate.isTrue((keyspace.replicationFactor().length == 1 ? 1 : 0) != 0, (String)"too many replication factors speecified for simple strategy in %s", (Object[])new Object[]{cinfo.getObjectClass().getName()});
                        replicationFactor = keyspace.replicationFactor()[0];
                    }
                    if (replicationFactor == 0) {
                        replicationFactor = mgr.getDefaultReplicationFactor();
                    }
                    if (replicationFactor == 0) {
                        replicationFactor = 2;
                    }
                    jbuild.add("replication_factor", replicationFactor);
                }
            }
            jbuild.add("class", strategy.NAME);
            return jbuild.build();
        }

        public ReplicationWithImpl(Object value) {
            super("REPLICATION", value);
        }

        public ReplicationWithImpl(ClassInfoImpl<?> cinfo, StatementManagerImpl mgr) {
            this(ReplicationWithImpl.getReplicationProperties(cinfo, mgr));
        }
    }
}

