/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.commons.collections.iterators.CombinationIterator;
import org.helenus.driver.Assignment;
import org.helenus.driver.Clause;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.Update;
import org.helenus.driver.UpdateNotAppliedException;
import org.helenus.driver.Using;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.impl.AssignmentImpl;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.DeleteImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.InsertImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UsingImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Table;

public class UpdateImpl<T>
extends StatementImpl<Void, VoidFuture, T>
implements Update<T> {
    private final List<TableInfoImpl<T>> tables = new ArrayList<TableInfoImpl<T>>(8);
    private final AssignmentsImpl<T> assignments;
    private final WhereImpl<T> where;
    private final OptionsImpl<T> usings;
    private final ConditionsImpl<T> conditions;
    private final ConditionsImpl<T> previousConditions;
    private volatile boolean ifExists;

    public UpdateImpl(ClassInfoImpl.POJOContext context, StatementManagerImpl mgr, StatementBridge bridge) {
        this(context, null, mgr, bridge);
    }

    public UpdateImpl(ClassInfoImpl.POJOContext context, String[] tables, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        if (tables != null) {
            for (String table : tables) {
                if (table == null) continue;
                this.tables.add((TableInfoImpl)context.getClassInfo().getTable(table));
            }
        } else {
            this.tables.addAll(context.getClassInfo().getTablesImpl());
        }
        this.assignments = new AssignmentsImpl(this);
        this.where = new WhereImpl(this);
        this.usings = new OptionsImpl(this);
        this.conditions = new ConditionsImpl(this);
        this.previousConditions = new ConditionsImpl(this);
    }

    private void andAssignment(TableInfoImpl<T> table, List<AssignmentImpl> assignments, AssignmentImpl assignment) {
        if (assignment instanceof AssignmentImpl.DelayedWithObject) {
            for (AssignmentImpl a : ((AssignmentImpl.DelayedWithObject)((Object)assignment)).processWith(table, this.getPOJOContext())) {
                this.andAssignment(table, assignments, a);
            }
        } else if (table.hasColumn(assignment.getColumnName())) {
            block6: {
                try {
                    assignment.validate(table);
                }
                catch (EmptyOptionalPrimaryKeyException e) {
                    if (assignment instanceof AssignmentImpl.ReplaceAssignmentImpl) break block6;
                    throw e;
                }
            }
            assignments.add(assignment);
        }
    }

    private void andClause(TableInfoImpl<T> table, List<ClauseImpl> clauses, ClauseImpl clause) {
        if (clause instanceof ClauseImpl.Delayed) {
            ((ClauseImpl.Delayed)((Object)clause)).processWith(table).forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
        } else if (clause instanceof ClauseImpl.DelayedWithObject) {
            ClassInfoImpl.POJOContext pctx = this.getPOJOContext();
            ((ClauseImpl.DelayedWithObject)((Object)clause)).processWith(table, pctx).forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
        } else {
            List<ClauseImpl> eclauses;
            if (clause instanceof ClauseImpl.Compound && (eclauses = ((ClauseImpl.Compound)((Object)clause)).extractSpecialColumns(table)) != null) {
                eclauses.forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
                return;
            }
            CharSequence name = clause.getColumnName();
            if (table.hasPrimaryKey(name)) {
                clause.validate(table);
                clauses.add(clause);
            }
        }
    }

    private void buildQueryStrings(TableInfoImpl<T> table, List<StringBuilder> builders) {
        Collection[] asets;
        ArrayList<Object> sets;
        ArrayList<AssignmentImpl> as;
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        if (this.getKeyspace() != null) {
            Utils.appendName(builder, this.getKeyspace()).append(".");
        }
        Utils.appendName(builder, table.getName());
        if (!((OptionsImpl)this.usings).usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(table, null, this.mgr.getCodecRegistry(), builder, " AND ", ((OptionsImpl)this.usings).usings, null);
        }
        Collection<FieldInfoImpl<T>> multiKeys = table.getMultiKeys();
        Collection<FieldInfoImpl<T>> caseInsensitiveKeys = table.getCaseInsensitiveKeys();
        AssignmentsImpl assignments = this.assignments;
        if (assignments.isEmpty()) {
            Object old;
            CharSequence cname;
            assignments = (AssignmentsImpl)new AssignmentsImpl(this).and(new AssignmentImpl.DelayedSetAllAssignmentImpl());
            if (!caseInsensitiveKeys.isEmpty()) {
                assignments.hasAllFromObject = false;
                for (FieldInfoImpl<Object> fieldInfoImpl : caseInsensitiveKeys) {
                    if (fieldInfoImpl.isMultiKey()) continue;
                    cname = fieldInfoImpl.getColumnName();
                    old = (AssignmentImpl.WithOldValue)((AssignmentsImpl)this.assignments).previous.get(cname);
                    if (old != null) {
                        assignments.assignments.add(new AssignmentImpl.DelayedReplaceAssignmentImpl(cname, old.getOldValue()));
                        continue;
                    }
                    assignments.assignments.add(new AssignmentImpl.DelayedSetAssignmentImpl(cname));
                }
            }
            if (!multiKeys.isEmpty()) {
                assignments.hasAllFromObject = false;
                for (FieldInfoImpl<Object> fieldInfoImpl : multiKeys) {
                    cname = fieldInfoImpl.getColumnName();
                    old = (AssignmentImpl.WithOldValue)((AssignmentsImpl)this.assignments).previous.get(cname);
                    if (old != null) {
                        assignments.assignments.add(new AssignmentImpl.DelayedReplaceAssignmentImpl(cname, old.getOldValue()));
                        continue;
                    }
                    assignments.assignments.add(new AssignmentImpl.DelayedSetAssignmentImpl(cname));
                }
            }
            for (AssignmentImpl.WithOldValue withOldValue : ((AssignmentsImpl)this.assignments).previous.values()) {
                cname = ((AssignmentImpl)((Object)withOldValue)).getColumnName();
                if (table.getPrimaryKey(cname) == null || !multiKeys.isEmpty() && table.isMultiKey(cname) || !caseInsensitiveKeys.isEmpty() && table.isCaseInsensitiveKey(cname)) continue;
                assignments.hasAllFromObject = false;
                assignments.assignments.add(new AssignmentImpl.DelayedReplaceAssignmentImpl(cname, withOldValue.getOldValue()));
            }
        }
        if (!assignments.assignments.isEmpty()) {
            boolean bl;
            as = new ArrayList<AssignmentImpl>(assignments.assignments.size());
            for (Object a : assignments.assignments) {
                if (assignments.hasAllFromObject() && a instanceof AssignmentImpl.DelayedSetAssignmentImpl && ((AssignmentImpl.DelayedSetAssignmentImpl)a).object == null) continue;
                this.andAssignment(table, as, (AssignmentImpl)a);
            }
            if (as.isEmpty()) {
                return;
            }
            for (Object a : ((AssignmentsImpl)this.assignments).previous.values()) {
                try {
                    ((AssignmentImpl)a).validate(table);
                }
                catch (EmptyOptionalPrimaryKeyException old) {}
            }
            boolean bl2 = false;
            Object old_values = null;
            for (AssignmentImpl assignmentImpl : as) {
                FieldInfoImpl<T> f;
                if (table.getPrimaryKey(assignmentImpl.getColumnName()) == null) continue;
                bl = true;
                AssignmentImpl.WithOldValue oa = (AssignmentImpl.WithOldValue)((AssignmentsImpl)this.assignments).previous.get(assignmentImpl.getColumnName().toString());
                if (oa == null) continue;
                if (old_values == null) {
                    old_values = new LinkedHashMap(table.getPrimaryKeys().size());
                }
                HashSet oldval = oa.getOldValue();
                if (!caseInsensitiveKeys.isEmpty() && assignmentImpl instanceof AssignmentImpl.SetAssignmentImpl && oldval != null && (f = table.getColumnImpl(assignmentImpl.getColumnName())).isCaseInsensitiveKey() && !f.isMultiKey()) {
                    oldval = StringUtils.lowerCase((String)((Object)oldval).toString());
                }
                if (!multiKeys.isEmpty() && assignmentImpl instanceof AssignmentImpl.SetAssignmentImpl) {
                    Collection newset;
                    AssignmentImpl.SetAssignmentImpl sa = (AssignmentImpl.SetAssignmentImpl)assignmentImpl;
                    FieldInfoImpl<T> f2 = table.getColumnImpl(assignmentImpl.getColumnName());
                    if (f2.isMultiKey() && oldval != null && !(newset = (Collection)sa.getValue()).isEmpty()) {
                        HashSet oldset;
                        if (f2.isCaseInsensitiveKey()) {
                            oldset = ((Collection)oldval).stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new));
                            newset.forEach(v -> oldset.remove(v != null ? StringUtils.lowerCase((String)v.toString()) : null));
                            oldval = oldset;
                        } else {
                            oldset = new HashSet(oldval);
                            oldset.removeAll(newset);
                            oldval = oldset;
                        }
                    }
                }
                old_values.put(assignmentImpl.getColumnName().toString(), oldval);
            }
            if (bl) {
                if (old_values != null) {
                    this.init(new DeleteImpl<T>(this.getPOJOContext(), table, ((OptionsImpl)this.usings).usings, this.ifExists, ((ConditionsImpl)this.previousConditions).conditions, (Map<String, Object>)old_values, this.mgr, this.bridge)).buildQueryString(table, builders);
                }
                this.init(new InsertImpl<T>(this.getPOJOContext(), table, ((OptionsImpl)this.usings).usings, this.mgr, this.bridge)).buildQueryStrings(table, builders);
                return;
            }
        } else {
            return;
        }
        builder.append(" SET ");
        Utils.joinAndAppendWithNoDuplicates(table, null, this.mgr.getCodecRegistry(), builder, ",", as, null);
        if (!((WhereImpl)this.where).clauses.isEmpty()) {
            List whereClauses = ((WhereImpl)this.where).getClauses(table);
            ArrayList<ClauseImpl> arrayList = new ArrayList<ClauseImpl>(whereClauses.size());
            for (ClauseImpl c : whereClauses) {
                this.andClause(table, arrayList, c);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            builder.append(" WHERE ");
            if (!caseInsensitiveKeys.isEmpty() || !multiKeys.isEmpty()) {
                sets = new ArrayList(multiKeys.size());
                ListIterator<ClauseImpl> i2 = arrayList.listIterator();
                while (i2.hasNext()) {
                    FieldInfoImpl<T> finfo;
                    String name;
                    ClauseImpl clauseImpl = (ClauseImpl)i2.next();
                    if (clauseImpl instanceof ClauseImpl.SimpleClauseImpl) {
                        name = clauseImpl.getColumnName().toString();
                        finfo = table.getColumnImpl(name);
                        if (finfo == null) continue;
                        boolean ci = finfo.isCaseInsensitiveKey();
                        if (finfo.isMultiKey()) {
                            i2.remove();
                            ArrayList<ClauseImpl.EqClauseImpl> set = new ArrayList<ClauseImpl.EqClauseImpl>();
                            String mkname = "mk_" + name;
                            for (Object v2 : clauseImpl.values()) {
                                if (v2 instanceof Collection) {
                                    for (Object sv : (Collection)v2) {
                                        if (ci && sv != null) {
                                            set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, StringUtils.lowerCase((String)sv.toString())));
                                            continue;
                                        }
                                        set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, sv));
                                    }
                                    continue;
                                }
                                if (ci && v2 != null) {
                                    set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, StringUtils.lowerCase((String)v2.toString())));
                                    continue;
                                }
                                set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, v2));
                            }
                            if (set.isEmpty()) continue;
                            sets.add(set);
                            continue;
                        }
                        if (!ci) continue;
                        Object v3 = clauseImpl.firstValue();
                        i2.set(new ClauseImpl.SimpleClauseImpl((CharSequence)("ci_" + name), clauseImpl.getOperation(), v3 != null ? StringUtils.lowerCase((String)v3.toString()) : null));
                        continue;
                    }
                    if (!(clauseImpl instanceof ClauseImpl.InClauseImpl) || (finfo = table.getColumnImpl(name = clauseImpl.getColumnName().toString())) == null || !finfo.isCaseInsensitiveKey()) continue;
                    i2.set(new ClauseImpl.InClauseImpl("ci_" + name, clauseImpl.values().stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new))));
                }
                if (!sets.isEmpty()) {
                    asets = new Collection[sets.size()];
                    CombinationIterator combinationIterator = new CombinationIterator(ClauseImpl.EqClauseImpl.class, sets.toArray(asets));
                    while (combinationIterator.hasNext()) {
                        StringBuilder sb = new StringBuilder(builder);
                        Utils.joinAndAppend(table, null, this.mgr.getCodecRegistry(), sb, " AND ", (Collection)combinationIterator.next(), arrayList, null);
                        builders.add(this.finishBuildingQueryString(table, sb));
                    }
                    return;
                }
            }
            Utils.joinAndAppend(table, null, this.mgr.getCodecRegistry(), builder, " AND ", arrayList, null);
        } else {
            try {
                Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> pkeys = this.getPOJOContext().getPrimaryKeyColumnValues(table.getName());
                if (!pkeys.isEmpty()) {
                    builder.append(" WHERE ");
                    if (!caseInsensitiveKeys.isEmpty()) {
                        for (FieldInfoImpl<T> finfo : caseInsensitiveKeys) {
                            Object name;
                            Triple<Object, CQLDataType, TypeCodec<?>> triple;
                            if (finfo.isMultiKey() || (triple = pkeys.remove(name = finfo.getColumnName())) == null) continue;
                            Object v4 = triple.getLeft();
                            pkeys.put("ci_" + (String)name, Triple.of((Object)(v4 != null ? StringUtils.lowerCase((String)v4.toString()) : null), (Object)triple.getMiddle(), (Object)triple.getRight()));
                        }
                    }
                    if (!multiKeys.isEmpty()) {
                        ArrayList<FieldInfoImpl> arrayList = new ArrayList<FieldInfoImpl>(multiKeys.size());
                        sets = new ArrayList<Object>(multiKeys.size());
                        for (FieldInfoImpl fieldInfoImpl : multiKeys) {
                            Object set;
                            Triple<Object, CQLDataType, TypeCodec<?>> pset = pkeys.remove(fieldInfoImpl.getColumnName());
                            if (pset == null || (set = (Set)pset.getLeft()) == null) continue;
                            arrayList.add(fieldInfoImpl);
                            if (fieldInfoImpl.isCaseInsensitiveKey()) {
                                sets.add(set.stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new)));
                                continue;
                            }
                            sets.add(set);
                        }
                        if (!sets.isEmpty()) {
                            asets = new Collection[sets.size()];
                            CombinationIterator combinationIterator = new CombinationIterator(Object.class, sets.toArray(asets));
                            while (combinationIterator.hasNext()) {
                                int j = -1;
                                for (Object k : (List)combinationIterator.next()) {
                                    FieldInfoImpl finfo = (FieldInfoImpl)arrayList.get(++j);
                                    pkeys.put("mk_" + finfo.getColumnName(), Triple.of(k, (Object)finfo.getDataType().getElementType(), (Object)((ArgumentsCodec)finfo.getCodec()).codec(0)));
                                }
                                StringBuilder sb = new StringBuilder(builder);
                                Utils.joinAndAppendNamesAndValues(null, this.mgr.getCodecRegistry(), sb, " AND ", "=", pkeys, null);
                                builders.add(this.finishBuildingQueryString(table, sb));
                            }
                            return;
                        }
                    }
                    Utils.joinAndAppendNamesAndValues(null, this.mgr.getCodecRegistry(), builder, " AND ", "=", pkeys, null);
                }
            }
            catch (EmptyOptionalPrimaryKeyException e) {
                return;
            }
        }
        builders.add(this.finishBuildingQueryString(table, builder));
    }

    private StringBuilder finishBuildingQueryString(TableInfoImpl<T> table, StringBuilder builder) {
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        } else if (!((ConditionsImpl)this.conditions).conditions.isEmpty()) {
            for (ClauseImpl c : ((ConditionsImpl)this.conditions).conditions) {
                c.validate(table);
            }
            builder.append(" IF ");
            Utils.joinAndAppend(table, null, this.mgr.getCodecRegistry(), builder, " AND ", ((ConditionsImpl)this.conditions).conditions, null);
        }
        return builder;
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : this.tables.size();
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>(this.tables.size());
        InsertImpl<T> insert = null;
        for (TableInfoImpl<T> table : this.tables) {
            if (table.getTable().type() == Table.Type.AUDIT && this.assignments.hasAllFromObject() && ((WhereImpl)this.where).clauses.isEmpty()) {
                if (insert == null) {
                    insert = this.init(new InsertImpl<T>(this.getPOJOContext(), table, ((OptionsImpl)this.usings).usings, this.mgr, this.bridge));
                    continue;
                }
                insert.into(table);
                continue;
            }
            this.buildQueryStrings(table, builders);
        }
        if (insert != null) {
            insert.buildQueryStrings(builders);
        }
        if (builders.isEmpty()) {
            return null;
        }
        return builders.toArray(new StringBuilder[builders.size()]);
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("BATCH");
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        if (this.isCounterOp()) {
            builder.append(" COUNTER");
        }
    }

    public Stream<TableInfo<T>> tables() {
        return this.tables.stream().map(t -> t);
    }

    public Update.Assignments<T> with(Assignment ... assignments) {
        return this.assignments.and(assignments);
    }

    public Update.Assignments<T> with() {
        return this.assignments;
    }

    public Update.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public Update.Where<T> where() {
        return this.where;
    }

    public Update<T> ifExists() {
        Validate.isTrue((boolean)((ConditionsImpl)this.conditions).conditions.isEmpty(), (String)"cannot combined additional conditions with IF EXISTS", (Object[])new Object[0]);
        Validate.isTrue((boolean)((ConditionsImpl)this.previousConditions).conditions.isEmpty(), (String)"cannot combined additional previous conditions with IF EXISTS", (Object[])new Object[0]);
        this.ifExists = true;
        this.setDirty();
        return this;
    }

    public Update.Conditions<T> onlyIf(Clause condition) {
        return this.conditions.and(condition);
    }

    public Update.Conditions<T> onlyIf() {
        Validate.isTrue((!this.ifExists ? 1 : 0) != 0, (String)"cannot combined additional conditions with IF EXISTS", (Object[])new Object[0]);
        return this.conditions;
    }

    public Update.Conditions<T> previouslyIf(Clause condition) {
        return this.previousConditions.and(condition);
    }

    public Update.Conditions<T> previouslyIf() {
        Validate.isTrue((!this.ifExists ? 1 : 0) != 0, (String)"cannot combined additional previous conditions with IF EXISTS", (Object[])new Object[0]);
        return this.previousConditions;
    }

    public Update.Options<T> using(Using<?> using) {
        return this.usings.and(using);
    }

    public Stream<Using<?>> usings() {
        return ((OptionsImpl)this.usings).usings.stream();
    }

    public <U> Optional<Using<U>> getUsing(String name) {
        return this.usings().filter(u -> u.getName().equals(name)).findAny();
    }

    @Override
    public VoidFuture executeAsync0() {
        if (((ConditionsImpl)this.conditions).conditions.isEmpty()) {
            return (VoidFuture)super.executeAsync0();
        }
        return this.bridge.newVoidFuture(this.executeAsyncRaw0(), new VoidFuture.PostProcessor(){

            public void postProcess(ResultSet result) {
                Row row = result.one();
                if (row == null) {
                    throw new UpdateNotAppliedException("no result row returned");
                }
                if (!row.getBool("[applied]")) {
                    throw new UpdateNotAppliedException(row, "update not applied");
                }
            }
        });
    }

    public static class ConditionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, UpdateImpl<T>>
    implements Update.Conditions<T> {
        private final List<ClauseImpl> conditions = new ArrayList<ClauseImpl>(10);

        ConditionsImpl(UpdateImpl<T> statement) {
            super(statement);
        }

        public Update.Conditions<T> and(Clause condition) {
            Validate.notNull((Object)condition, (String)"invalid null condition", (Object[])new Object[0]);
            Validate.isTrue((!((UpdateImpl)this.statement).ifExists ? 1 : 0) != 0, (String)"cannot combined additional conditions with IF EXISTS", (Object[])new Object[0]);
            Validate.isTrue((boolean)(condition instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{condition.getClass().getName()});
            ClauseImpl c = (ClauseImpl)condition;
            Validate.isTrue((boolean)"=".equals(c.getOperation()), (String)"unsupported condition: %s", (Object[])new Object[]{c});
            ClassInfoImpl cinfo = this.getPOJOContext().getClassInfo();
            if (c instanceof ClauseImpl.Compound) {
                ((ClauseImpl.Compound)((Object)c)).getColumnNames().forEach(name -> cinfo.validateColumn(name));
            } else {
                cinfo.validateColumn(c.getColumnName().toString());
            }
            this.conditions.add(c);
            this.setDirty();
            return this;
        }

        public Update.Assignments<T> with(Assignment ... assignments) {
            return ((UpdateImpl)this.statement).with(assignments);
        }

        public Update.Where<T> where(Clause clause) {
            return ((UpdateImpl)this.statement).where(clause);
        }

        public Update.Options<T> using(Using<?> using) {
            return ((UpdateImpl)this.statement).using(using);
        }
    }

    public static class OptionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, UpdateImpl<T>>
    implements Update.Options<T> {
        private final List<UsingImpl<?>> usings = new ArrayList(5);

        OptionsImpl(UpdateImpl<T> statement) {
            super(statement);
        }

        public Update.Options<T> and(Using<?> using) {
            Validate.notNull(using, (String)"invalid null using", (Object[])new Object[0]);
            Validate.isTrue((boolean)(using instanceof UsingImpl), (String)"unsupported class of usings: %s", (Object[])new Object[]{using.getClass().getName()});
            this.usings.add(((UsingImpl)using).setStatement(this.statement));
            this.setDirty();
            return this;
        }

        public Update.Assignments<T> with(Assignment ... assignments) {
            return ((UpdateImpl)this.statement).with(assignments);
        }

        public Update<T> ifExists() {
            return ((UpdateImpl)this.statement).ifExists();
        }

        public Update.Conditions<T> onlyIf(Clause condition) {
            return ((UpdateImpl)this.statement).onlyIf(condition);
        }

        public Update.Conditions<T> previouslyIf(Clause condition) {
            return ((UpdateImpl)this.statement).previouslyIf(condition);
        }
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, UpdateImpl<T>>
    implements Update.Where<T> {
        private final List<ClauseImpl> clauses = new ArrayList<ClauseImpl>(10);

        WhereImpl(UpdateImpl<T> statement) {
            super(statement);
        }

        private List<ClauseImpl> getClauses(TableInfoImpl<T> table) {
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(this.clauses);
            for (Map.Entry<String, Object> e : table.getFinalPrimaryKeyValues().entrySet()) {
                String name = e.getKey();
                if (this.clauses.stream().anyMatch(c -> c.containsColumn(name))) continue;
                clauses.add(new ClauseImpl.EqClauseImpl((CharSequence)name, e.getValue()));
            }
            return clauses;
        }

        public Update.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            ClauseImpl c = (ClauseImpl)clause;
            if (!(c instanceof ClauseImpl.Delayed) && !(c instanceof ClauseImpl.DelayedWithObject)) {
                ClassInfoImpl.Context context = this.getContext();
                ClassInfoImpl cinfo = context.getClassInfo();
                if (c instanceof ClauseImpl.Compound) {
                    ClauseImpl.Compound cc = (ClauseImpl.Compound)((Object)c);
                    List<String> names = cc.getColumnNames();
                    List<?> values = cc.getColumnValues();
                    if (c instanceof ClauseImpl.CompoundEqClauseImpl) {
                        for (int i = 0; i < names.size(); ++i) {
                            String name = names.get(i);
                            cinfo.validateColumnOrKeyspaceKey(name);
                            if (!cinfo.isKeyspaceKey(name)) continue;
                            context.addKeyspaceKey(name, values.get(i));
                        }
                    } else {
                        for (String name : names) {
                            cinfo.validateColumn(name);
                        }
                    }
                } else {
                    String name = c.getColumnName().toString();
                    if (c instanceof ClauseImpl.EqClauseImpl) {
                        cinfo.validateColumnOrKeyspaceKey(name);
                        if (cinfo.isKeyspaceKey(name)) {
                            context.addKeyspaceKey(name, c.firstValue());
                        }
                    } else {
                        cinfo.validateColumn(name);
                    }
                }
            }
            this.clauses.add(c);
            this.setDirty();
            return this;
        }

        public Update.Assignments<T> with(Assignment ... assignments) {
            return ((UpdateImpl)this.statement).with(assignments);
        }

        public Update.Options<T> using(Using<?> using) {
            return ((UpdateImpl)this.statement).using(using);
        }

        public Update<T> ifExists() {
            return ((UpdateImpl)this.statement).ifExists();
        }

        public Update.Conditions<T> onlyIf(Clause condition) {
            return ((UpdateImpl)this.statement).onlyIf(condition);
        }

        public Update.Conditions<T> previouslyIf(Clause condition) {
            return ((UpdateImpl)this.statement).previouslyIf(condition);
        }
    }

    public static class AssignmentsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, UpdateImpl<T>>
    implements Update.Assignments<T> {
        private final List<AssignmentImpl> assignments = new ArrayList<AssignmentImpl>(8);
        private final Map<String, AssignmentImpl.WithOldValue> previous = new HashMap<String, AssignmentImpl.WithOldValue>(8);
        private boolean hasAllFromObject = false;

        AssignmentsImpl(UpdateImpl<T> statement) {
            super(statement);
        }

        public Update.Assignments<T> and(Assignment ... assignments) {
            Validate.notNull((Object)assignments, (String)"invalid null assignments", (Object[])new Object[0]);
            for (Assignment assignment : assignments) {
                Validate.notNull((Object)assignment, (String)"invalid null assignment", (Object[])new Object[0]);
                Validate.isTrue((boolean)(assignment instanceof AssignmentImpl), (String)"unsupported class of assignments: %s", (Object[])new Object[]{assignment.getClass().getName()});
                AssignmentImpl a = (AssignmentImpl)assignment;
                ((UpdateImpl)this.statement).setCounterOp(a instanceof AssignmentImpl.CounterAssignmentImpl);
                if (a instanceof AssignmentImpl.DelayedSetAllAssignmentImpl && ((AssignmentImpl.DelayedSetAllAssignmentImpl)a).object == null) {
                    this.hasAllFromObject = true;
                }
                if (!(a instanceof AssignmentImpl.DelayedWithObject)) {
                    this.getPOJOContext().getClassInfo().validateColumn(a.getColumnName().toString());
                }
                if (a instanceof AssignmentImpl.PreviousAssignmentImpl) {
                    AssignmentImpl.PreviousAssignmentImpl pa = (AssignmentImpl.PreviousAssignmentImpl)a;
                    this.previous.put(pa.getColumnName().toString(), pa);
                } else if (a instanceof AssignmentImpl.ReplaceAssignmentImpl) {
                    AssignmentImpl.ReplaceAssignmentImpl ra = (AssignmentImpl.ReplaceAssignmentImpl)a;
                    this.previous.put(ra.getColumnName().toString(), ra);
                    this.assignments.add(a);
                } else {
                    this.assignments.add(a);
                }
                this.setDirty();
            }
            return this;
        }

        public boolean isEmpty() {
            return this.assignments.isEmpty();
        }

        public boolean hasAllFromObject() {
            return this.assignments.isEmpty() || this.hasAllFromObject;
        }

        public Update.Where<T> where(Clause clause) {
            return ((UpdateImpl)this.statement).where(clause);
        }

        public Update.Options<T> using(Using<?> using) {
            return ((UpdateImpl)this.statement).using(using);
        }

        public Update<T> ifExists() {
            return ((UpdateImpl)this.statement).ifExists();
        }

        public Update.Conditions<T> onlyIf(Clause condition) {
            return ((UpdateImpl)this.statement).onlyIf(condition);
        }

        public Update.Conditions<T> previouslyIf(Clause condition) {
            return ((UpdateImpl)this.statement).previouslyIf(condition);
        }
    }
}

