/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.UDTValue;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.info.UDTTypeClassInfo;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.UDTRootEntity;

public class UDTTypeClassInfoImpl<T>
extends UDTClassInfoImpl<T>
implements UDTTypeClassInfo<T> {
    private final UDTRootClassInfoImpl<? super T> rinfo;
    private final boolean dynamic;

    UDTTypeClassInfoImpl(StatementManagerImpl mgr, UDTRootClassInfoImpl<? super T> rinfo, Class<T> clazz, boolean dynamic) {
        super(mgr, clazz, UDTRootEntity.class);
        Validate.isTrue((!Modifier.isAbstract(clazz.getModifiers()) ? 1 : 0) != 0, (String)"UDT type entity class '%s', cannot be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.rinfo = rinfo;
        this.dynamic = dynamic;
        this.validate(rinfo.getObjectClass());
    }

    private void validate(Class<? super T> rclazz) {
        this.tablesImpl().forEach(t -> {
            Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Keyspace.class).isAssignableFrom(rclazz), (String)"@Keyspace annotation is not defined in UDT root element class '%s' for type class: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
            t.getTypeKey().ifPresent(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@TypeKey annotation with name '%s' is not defined in UDT root element class '%s' for type class: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
        });
    }

    public UDTRootClassInfoImpl<? super T> getRoot() {
        return this.rinfo;
    }

    public String getType() {
        return this.getName();
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public UDTClassInfoImpl.POJOContext newContextFromRoot(Object object) {
        try {
            return this.newContext(this.clazz.cast(object));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public T getObject(UDTValue uval, String type) {
        if (uval != null) {
            if (this.getType().equals(type)) {
                Object t = super.getObject(uval);
                this.getTableImpl().getTypeKey().ifPresent(f -> f.setValue(t, this.getType()));
                return t;
            }
            UDTTypeClassInfo tinfo = this.rinfo.getType(type);
            if (this.clazz.isAssignableFrom(tinfo.getObjectClass())) {
                return tinfo.getObject(uval, type);
            }
        }
        return null;
    }

    @Override
    public T getObject(UDTValue uval) {
        if (uval == null) {
            return null;
        }
        Object t = super.getObject(uval);
        this.getTableImpl().getTypeKey().ifPresent(f -> f.setValue(t, this.getType()));
        return t;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ",dynamic=" + this.dynamic + ",clazz=" + this.clazz + ",keyspace=" + this.getKeyspace() + ",columns=" + this.getColumns() + ",table=" + this.getTableImpl() + "]";
    }
}

