/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.UserTypeBridge;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;
import org.helenus.driver.persistence.UDTTypeEntity;

public abstract class UDTClassInfoImpl<T>
extends ClassInfoImpl<T>
implements CQLDataType {
    private static final String[] RESERVED_UDT_NAMES = new String[]{"byte", "smallint", "tinyint", "complex", "enum", "date", "time", "interval", "macaddr", "bitstring"};
    private final String name;
    private final TableInfoImpl<T> table;
    private volatile UserType dtype = null;

    protected UDTClassInfoImpl(StatementManagerImpl mgr, Class<T> clazz, Class<? extends Annotation> entityAnnotationClass) {
        super(mgr, clazz, entityAnnotationClass);
        this.name = this.findName();
        this.table = this.tablesImpl().findFirst().get();
        if (List.class.isAssignableFrom(clazz)) {
            this.table.addNonPrimaryColumn(new FieldInfoImpl(mgr, this, DataType.LIST, (obj, val) -> {
                List l = (List)obj;
                l.clear();
                l.addAll((Collection)val);
            }));
        } else if (Set.class.isAssignableFrom(clazz)) {
            this.table.addNonPrimaryColumn(new FieldInfoImpl(mgr, this, LinkedHashSet.class.isAssignableFrom(clazz) ? DataType.ORDERED_SET : (SortedSet.class.isAssignableFrom(clazz) ? DataType.SORTED_SET : DataType.SET), (obj, val) -> {
                Set s = (Set)obj;
                s.clear();
                s.addAll((Collection)val);
            }));
        } else if (Map.class.isAssignableFrom(clazz)) {
            this.table.addNonPrimaryColumn(new FieldInfoImpl(mgr, this, SortedMap.class.isAssignableFrom(clazz) ? DataType.SORTED_MAP : DataType.MAP, (obj, val) -> {
                Map m = (Map)obj;
                m.clear();
                m.putAll((Map)val);
            }));
        }
    }

    protected UDTClassInfoImpl(UDTClassInfoImpl<T> cinfo, Class<T> clazz) {
        super(cinfo, clazz);
        this.name = cinfo.name;
        this.table = cinfo.table;
    }

    private String findName() {
        UDTRootEntity ure;
        UDTTypeEntity ute;
        UDTEntity ue = this.clazz.getAnnotation(UDTEntity.class);
        String name = ue != null ? ue.name() : ((ute = this.clazz.getAnnotation(UDTTypeEntity.class)) != null ? ute.name() : ((ure = (UDTRootEntity)ReflectionUtils.findFirstAnnotation((Class)this.clazz, UDTRootEntity.class)) != null ? ure.name() : null));
        Validate.isTrue((name != null ? 1 : 0) != 0, (String)"class '%s' is not annotated with @UDTEntity or @UDTRootEntity", (Object[])new Object[]{this.clazz.getSimpleName()});
        Validate.isTrue((!ArrayUtils.contains((Object[])RESERVED_UDT_NAMES, (Object)name) ? 1 : 0) != 0, (String)"user-defined type name cannot be a reserved type name: %s", (Object[])new Object[]{name});
        return name;
    }

    private void decodeAndSetColumnFields(T object, UDTValue uval) {
        TableInfoImpl<T> table = this.getTableImpl();
        if (table != null) {
            for (UserType.Field coldef : uval.getType()) {
                FieldInfoImpl<T> field = table.getColumnImpl(coldef.getName());
                if (field == null) continue;
                field.decodeAndSetValue(object, uval);
            }
        }
    }

    @Override
    protected Collection<TableInfoImpl<T>> getTablesImpl() {
        return Collections.emptyList();
    }

    protected TypeCodec<T> getCodec(TypeToken<T> token, final CodecRegistry codecRegistry) {
        final TypeCodec ucodec = TypeCodec.userType((UserType)this.dtype);
        return new TypeCodec((com.datastax.driver.core.DataType)this.dtype, token){

            public T parse(String value) throws InvalidTypeException {
                return UDTClassInfoImpl.this.getObject((UDTValue)ucodec.parse(value));
            }

            public String format(Object value) throws InvalidTypeException {
                return ucodec.format((Object)UDTClassInfoImpl.this.getUDTValue(value, codecRegistry));
            }

            public ByteBuffer serialize(Object value, ProtocolVersion protocolVersion) throws InvalidTypeException {
                return ucodec.serialize((Object)UDTClassInfoImpl.this.getUDTValue(value, codecRegistry), protocolVersion);
            }

            public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
                return UDTClassInfoImpl.this.getObject((UDTValue)ucodec.deserialize(bytes, protocolVersion));
            }
        };
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFrozen() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isUserDefined() {
        return true;
    }

    public com.datastax.driver.core.DataType getDataType() {
        UserType dtype = this.dtype;
        if (dtype == null) {
            this.dtype = dtype = UserTypeBridge.instantiate(this.mgr, this);
        }
        return dtype;
    }

    public CQLDataType getMainType() {
        return this;
    }

    public CQLDataType getElementType() {
        return null;
    }

    public List<CQLDataType> getArgumentTypes() {
        return null;
    }

    public CQLDataType getFirstArgumentType() {
        return null;
    }

    public boolean isAlterableTo(CQLDataType to) {
        return false;
    }

    public String toCQL() {
        return "frozen<" + this.name + '>';
    }

    @Override
    public boolean supportsTablesAndIndexes() {
        return false;
    }

    public TableInfoImpl<T> getTableImpl() {
        return this.table;
    }

    @Override
    public Stream<TableInfo<T>> tables() {
        return Stream.empty();
    }

    @Override
    public TableInfoImpl<T> getTableImpl(String name) {
        throw new IllegalArgumentException("user-defined types do not define tables");
    }

    @Override
    public int getNumTables() {
        return 0;
    }

    @Override
    public Collection<TableInfo<T>> getTables() {
        return Collections.emptyList();
    }

    @Override
    public POJOContext newContext(T object) {
        return new POJOContext(object);
    }

    @Override
    public T getObject(Row row, Map<String, Object> kkeys) {
        throw new ObjectConversionException(this.clazz, row, this.getEntityAnnotationClass().getSimpleName() + " POJOs cannot be retrieved from result rows");
    }

    @Override
    public T getObject(UDTValue uval) {
        if (uval == null) {
            return null;
        }
        try {
            Object object = this.constructor.newInstance(new Object[0]);
            this.finalFields.forEach((field, value) -> {
                try {
                    field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            });
            this.decodeAndSetColumnFields(object, uval);
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ObjectConversionException(this.clazz, uval, "failed to instantiate blank POJO", t);
        }
    }

    public UDTValue getUDTValue(T object, CodecRegistry codecRegistry) {
        if (object == null) {
            return null;
        }
        TableInfoImpl<T> table = this.getTableImpl();
        if (table == null) {
            return null;
        }
        UDTValue uval = this.dtype.newValue();
        int i = -1;
        for (UserType.Field coldef : uval.getType()) {
            ++i;
            String cname = coldef.getName();
            FieldInfoImpl<T> field = table.getColumnImpl(cname);
            if (field == null) continue;
            uval.set(i, field.getValue(object), field.getCodec());
        }
        return uval;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ",clazz=" + this.clazz + ",keyspace=" + this.getKeyspace() + ",columns=" + this.getColumns() + ",table=" + this.table + "]";
    }

    public class POJOContext
    extends ClassInfoImpl.POJOContext {
        public POJOContext(T object) {
            super(object);
        }

        @Override
        protected final void populateKeyspaceKeys(Map<String, FieldInfoImpl<T>> kkeysFields) {
        }

        public Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getColumnValues() {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getColumnValues(this.object);
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getPartitionKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getKeyspaceAndPartitionKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getPrimaryKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getKeyspaceAndPrimaryKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getMandatoryColumnValues() {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getMandatoryAndPrimaryKeyColumnValues(this.object);
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getMandatoryAndPrimaryKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Triple<Object, CQLDataType, TypeCodec<?>> getColumnValue(CharSequence name) {
            if (UDTClassInfoImpl.this.table == null) {
                return Triple.of(null, null, null);
            }
            return UDTClassInfoImpl.this.table.getColumnValue(this.object, name);
        }

        @Override
        public final Triple<Object, CQLDataType, TypeCodec<?>> getColumnValue(String tname, CharSequence name) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getColumnValues(Iterable<CharSequence> names) {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getColumnValues(this.object, names);
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getColumnValues(String tname, Iterable<CharSequence> names) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getColumnValues(CharSequence ... names) {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getColumnValues(this.object, names);
        }

        @Override
        public final Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getColumnValues(String tname, CharSequence ... names) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }
    }
}

