/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.RegularStatement;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.helenus.driver.BatchableStatement;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.Group;
import org.helenus.driver.ObjectStatement;
import org.helenus.driver.ParentStatement;
import org.helenus.driver.Recorder;
import org.helenus.driver.Sequence;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ParentStatementImpl;
import org.helenus.driver.impl.SequenceStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.util.Inhibit;
import org.helenus.util.function.ERunnable;

public class SequenceImpl
extends SequenceStatementImpl<Void, VoidFuture, Void>
implements Sequence,
ParentStatementImpl {
    private static final Logger logger = LogManager.getFormatterLogger(SequenceImpl.class);
    private final List<StatementImpl<?, ?, ?>> statements;
    private volatile ParentStatementImpl parent = null;
    private final Optional<Recorder> recorder;
    private final LinkedList<ERunnable<?>> errorHandlers;

    public SequenceImpl(Optional<Recorder> recorder, SequenceableStatement<?, ?>[] statements, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, (String)null, mgr, bridge);
        this.statements = new ArrayList(Math.max(statements.length, 8));
        this.recorder = recorder;
        this.errorHandlers = new LinkedList();
        for (SequenceableStatement<?, ?> statement : statements) {
            this.add(statement);
        }
    }

    public SequenceImpl(Optional<Recorder> recorder, Iterable<SequenceableStatement<?, ?>> statements, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, (String)null, mgr, bridge);
        this.statements = new ArrayList(32);
        this.recorder = recorder;
        this.errorHandlers = new LinkedList();
        for (SequenceableStatement<?, ?> statement : statements) {
            this.add(statement);
        }
    }

    private Sequence addInternal(StatementImpl<?, ?, ?> s) {
        if (s instanceof SimpleStatementImpl) {
            SimpleStatementImpl ss = (SimpleStatementImpl)s;
            Validate.isTrue((!ss.isSelect() ? 1 : 0) != 0, (String)"select statements are not supported in sequence statements", (Object[])new Object[0]);
        }
        this.statements.add(s);
        if (s instanceof ParentStatementImpl) {
            ParentStatementImpl ps = (ParentStatementImpl)((Object)s);
            ps.setParent(this);
            ps.objectStatements().forEach(cs -> this.recorded((ObjectStatement<?>)cs, ps));
        } else if (s instanceof ObjectStatement) {
            this.recorded((ObjectStatement)s, this);
        }
        this.setDirty();
        return this;
    }

    @Override
    protected List<StatementImpl<?, ?, ?>> buildSequencedStatements() {
        return this.statements.stream().flatMap(s -> s instanceof SequenceStatementImpl ? ((SequenceStatementImpl)s).buildSequencedStatements().stream() : Stream.of(s)).collect(Collectors.toList());
    }

    @Override
    protected void setDirty(boolean recurse) {
        super.setDirty(recurse);
        if (recurse) {
            this.statements.forEach(s -> s.setDirty(recurse));
        }
    }

    @Override
    public void setParent(ParentStatementImpl parent) {
        this.parent = parent;
    }

    @Override
    public void recorded(ObjectStatement<?> statement, ParentStatement pstatement) {
        if (statement.getObject() == null) {
            return;
        }
        this.recorder.ifPresent(r -> r.recorded(statement, pstatement));
        ParentStatementImpl p = this.parent;
        if (p != null) {
            p.recorded(statement, pstatement);
        }
    }

    @Override
    public Stream<ObjectStatement<?>> objectStatements() {
        return this.statements.stream().flatMap(s -> {
            StatementImpl si = s;
            if (si instanceof ParentStatementImpl) {
                return ((ParentStatementImpl)((Object)si)).objectStatements();
            }
            if (s instanceof ObjectStatement) {
                return Stream.of((ObjectStatement)s);
            }
            return Stream.empty();
        });
    }

    @Override
    public Stream<GenericStatement<?, ?>> statements() {
        return Stream.concat(Stream.of(this), this.statements.stream().flatMap(s -> {
            StatementImpl si = s;
            if (si instanceof ParentStatementImpl) {
                return ((ParentStatementImpl)((Object)si)).statements();
            }
            return Stream.of(s);
        }));
    }

    @Override
    public String getKeyspace() {
        return this.statements.isEmpty() ? null : this.statements.get(0).getKeyspace();
    }

    @Override
    public Optional<Recorder> getRecorder() {
        ParentStatementImpl p = this.parent;
        return Optional.ofNullable(this.recorder.orElseGet(() -> p != null ? (Recorder)p.getRecorder().orElse(null) : null));
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public int size() {
        return this.statements.size();
    }

    public void clear() {
        this.statements.clear();
        this.setDirty();
    }

    public <R, F extends ListenableFuture<R>> Sequence add(SequenceableStatement<R, F> statement) {
        Validate.notNull(statement, (String)"invalid null statement", (Object[])new Object[0]);
        Validate.isTrue((boolean)(statement instanceof StatementImpl), (String)"unsupported class of statements: %s", (Object[])new Object[]{statement.getClass().getName()});
        return this.addInternal((StatementImpl)statement);
    }

    public <R, F extends ListenableFuture<R>> Sequence add(BatchableStatement<R, F> statement) {
        Validate.notNull(statement, (String)"invalid null statement", (Object[])new Object[0]);
        Validate.isTrue((boolean)(statement instanceof StatementImpl), (String)"unsupported class of statements: %s", (Object[])new Object[]{statement.getClass().getName()});
        return this.addInternal((StatementImpl)statement);
    }

    public Sequence add(RegularStatement statement) {
        Validate.notNull((Object)statement, (String)"invalid null statement", (Object[])new Object[0]);
        return this.addInternal(new SimpleStatementImpl(statement, this.mgr, this.bridge));
    }

    public Sequence addErrorHandler(ERunnable<?> run) {
        Validate.notNull(run, (String)"invalid null error handler", (Object[])new Object[0]);
        this.errorHandlers.addFirst(run);
        return this;
    }

    public void runErrorHandlers() {
        for (ERunnable eRunnable : this.errorHandlers) {
            Inhibit.throwables((ERunnable)eRunnable, t -> logger.catching(t));
        }
        for (StatementImpl statementImpl : this.statements) {
            if (!(statementImpl instanceof Group)) continue;
            ((Group)statementImpl).runErrorHandlers();
        }
    }

    @Override
    public Boolean isIdempotent() {
        Boolean idem = this.idempotent;
        if (idem != null) {
            return idem;
        }
        boolean nullFound = false;
        for (StatementImpl<?, ?, ?> s : this.statements) {
            Boolean iidem = s.isIdempotent();
            if (iidem == null) {
                nullFound = true;
                continue;
            }
            if (iidem.booleanValue()) continue;
            return false;
        }
        return nullFound ? null : Boolean.valueOf(true);
    }
}

