/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CompoundResultSetFuture;
import com.datastax.driver.core.EmptyResultSetFuture;
import com.datastax.driver.core.ResultSetFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.collections.iterators.CombinationIterator;
import org.helenus.driver.Clause;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.ObjectSetFuture;
import org.helenus.driver.Ordering;
import org.helenus.driver.Select;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.CompoundObjectSetFuture;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.OrderingImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.DataType;

public class SelectImpl<T>
extends StatementImpl<ObjectSet<T>, ObjectSetFuture<T>, T>
implements Select<T> {
    static final List<Object> COUNT_ALL = Collections.singletonList(new Utils.FCall("count", new Utils.RawString("*")));
    final TableInfoImpl<T> table;
    private final WhereImpl<T> where;
    private List<OrderingImpl> orderings;
    private int limit = -1;
    private boolean allowFiltering;
    private String keyspace = null;
    private List<SelectImpl<T>> statements = null;
    private Map<String, Collection<?>> keyspaceKeys = null;
    protected List<Object> columnNames;
    protected boolean countOrAllSelected = false;

    SelectImpl(ClassInfoImpl.Context context, String table, List<Object> columnNames, boolean countOrAllSelected, StatementManagerImpl mgr, StatementBridge bridge) {
        super(ObjectSet.class, context, mgr, bridge);
        this.table = (TableInfoImpl)context.getClassInfo().getTable(table);
        this.columnNames = columnNames;
        this.countOrAllSelected = countOrAllSelected;
        this.where = new WhereImpl(this);
        Validate.isTrue((countOrAllSelected || !CollectionUtils.isEmpty(columnNames) ? 1 : 0) != 0, (String)"must select at least one column", (Object[])new Object[0]);
        if (columnNames != null) {
            this.table.validateColumns(columnNames);
        }
    }

    SelectImpl(SelectImpl<T> statement) {
        super(statement, statement.getContext().getClassInfo().newContext());
        this.setDirty();
        this.clearKeyspace();
        this.table = statement.table;
        this.columnNames = statement.columnNames;
        this.countOrAllSelected = statement.countOrAllSelected;
        this.where = new WhereImpl<T>(statement.where, this);
        this.limit = statement.limit;
        this.allowFiltering = statement.allowFiltering;
        this.orderings = statement.orderings;
    }

    private Stream<SelectImpl<T>> statements() {
        if (this.statements == null) {
            ArrayList<String> snames = new ArrayList<String>(this.keyspaceKeys.keySet());
            CombinationIterator ci = new CombinationIterator(Object.class, this.keyspaceKeys.values());
            ArrayList<SelectImpl<T>> statements = new ArrayList<SelectImpl<T>>(ci.size());
            block2: while (ci.hasNext()) {
                List svalues = ci.next();
                SelectImpl<T> s = new SelectImpl<T>(this);
                for (int j = 0; j < snames.size(); ++j) {
                    try {
                        s.getContext().addKeyspaceKey((String)snames.get(j), svalues.get(j));
                        continue;
                    }
                    catch (ExcludedKeyspaceKeyException e) {
                        continue block2;
                    }
                }
                statements.add(s);
            }
            this.statements = statements;
        }
        return this.statements.stream();
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        return new StringBuilder[]{this.buildQueryString()};
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : (this.statements != null ? this.statements.size() : new CombinationIterator(Object.class, this.keyspaceKeys.values()).size());
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder buildQueryString() {
        if (!this.isEnabled()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (this.columnNames == null) {
            builder.append("*");
        } else if (this.countOrAllSelected) {
            Utils.joinAndAppendNames(this.table, null, this.mgr.getCodecRegistry(), builder, ",", this.columnNames);
        } else {
            HashSet<String> set = new HashSet<String>(25);
            for (Object name : this.columnNames) {
                if (name instanceof String) {
                    set.add((String)name);
                    continue;
                }
                if (!(name instanceof Utils.CName)) continue;
                set.add(((Utils.CName)name).getName());
            }
            ArrayList<Object> names = new ArrayList<Object>();
            for (String name : this.table.getMandatoryAndPrimaryKeyColumns()) {
                if (set.contains(name)) continue;
                names.add(name);
            }
            names.addAll(this.columnNames);
            Utils.joinAndAppendNames(this.table, null, this.mgr.getCodecRegistry(), builder, ",", names);
        }
        builder.append(" FROM ");
        try {
            if (this.getKeyspace() != null) {
                Utils.appendName(builder, this.getKeyspace()).append(".");
            }
        }
        catch (ExcludedKeyspaceKeyException e) {
            return null;
        }
        Utils.appendName(builder, this.table.getName());
        if (!((WhereImpl)this.where).clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(this.table, null, this.mgr.getCodecRegistry(), builder, " AND ", ((WhereImpl)this.where).getClauses(this.table), null);
        }
        if (this.orderings != null) {
            builder.append(" ORDER BY ");
            Utils.joinAndAppend(this.table, null, this.mgr.getCodecRegistry(), builder, ",", this.orderings, null);
        }
        if (this.limit > 0) {
            builder.append(" LIMIT ").append(this.limit);
        }
        if (this.allowFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        return builder;
    }

    @Override
    protected void clearKeyspace() {
        super.clearKeyspace();
        this.keyspace = null;
    }

    @Override
    protected void setDirty() {
        super.setDirty();
        this.keyspace = null;
        this.statements = null;
    }

    @Override
    protected ResultSetFuture executeAsyncRaw0() {
        if (!this.isEnabled() || this.keyspaceKeys == null) {
            return super.executeAsyncRaw0();
        }
        return new CompoundResultSetFuture(this.statements().map(s -> s.executeAsyncRaw0()).filter(s -> !(s instanceof EmptyResultSetFuture)).collect(Collectors.toList()), this.mgr);
    }

    @Override
    public ObjectSetFuture<T> executeAsync0() {
        if (!this.isEnabled() || this.keyspaceKeys == null) {
            return (ObjectSetFuture)super.executeAsync0();
        }
        return new CompoundObjectSetFuture(this.getContext(), this.statements().map(s -> s.executeAsync0()).collect(Collectors.toList()), this.mgr);
    }

    @Override
    public String getKeyspace() {
        if (this.keyspaceKeys == null) {
            return super.getKeyspace();
        }
        if (this.keyspace == null) {
            ArrayList<String> snames = new ArrayList<String>(this.keyspaceKeys.keySet());
            CombinationIterator ci = new CombinationIterator(Object.class, this.keyspaceKeys.values());
            ArrayList<String> keyspaces = new ArrayList<String>(ci.size());
            block2: while (ci.hasNext()) {
                List svalues = ci.next();
                SelectImpl<T> s = this.init(new SelectImpl<T>(this));
                for (int j = 0; j < snames.size(); ++j) {
                    try {
                        s.getContext().addKeyspaceKey((String)snames.get(j), svalues.get(j));
                        continue;
                    }
                    catch (ExcludedKeyspaceKeyException e) {
                        continue block2;
                    }
                }
                keyspaces.add(s.getKeyspace());
            }
            this.keyspace = "(" + String.join((CharSequence)"|", keyspaces) + ")";
        }
        return this.keyspace;
    }

    public Select.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public Select.Where<T> where() {
        return this.where;
    }

    public Select<T> orderBy(Ordering ... orderings) {
        Validate.validState((this.orderings == null ? 1 : 0) != 0, (String)"an ORDER BY clause has already been provided", (Object[])new Object[0]);
        this.orderings = new ArrayList<OrderingImpl>(orderings.length);
        for (Ordering o : orderings) {
            Validate.isTrue((boolean)(o instanceof OrderingImpl), (String)"unsupported class of orderings: %s", (Object[])new Object[]{o.getClass().getName()});
            OrderingImpl oi = (OrderingImpl)o;
            oi.validate(this.table);
            if (this.table.isMultiKey(oi.getColumnName())) {
                this.orderings.add(new OrderingImpl("mk_" + oi.getColumnName(), oi.isDescending()));
                continue;
            }
            if (this.table.isCaseInsensitiveKey(oi.getColumnName())) {
                this.orderings.add(new OrderingImpl("ci_" + oi.getColumnName(), oi.isDescending()));
                continue;
            }
            this.orderings.add(oi);
        }
        this.setDirty();
        return this;
    }

    public Select<T> limit(int limit) {
        Validate.validState((this.limit <= 0 ? 1 : 0) != 0, (String)"a LIMIT value has already been provided", (Object[])new Object[0]);
        Validate.isTrue((limit > 0 ? 1 : 0) != 0, (String)"invalid negative LIMIT: %s", (long)limit);
        this.limit = limit;
        this.setDirty();
        return this;
    }

    public Select<T> allowFiltering() {
        this.allowFiltering = true;
        return this;
    }

    public static class TableSelectionImpl<T>
    extends BuilderImpl<T>
    implements Select.TableSelection<T> {
        private final TableInfo<T> table;

        TableSelectionImpl(TableInfo<T> table, ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            super(context, mgr, bridge);
            this.table = table;
        }

        private Select.TableSelection<T> addName(Object name) {
            this.context.getClassInfo().validateColumn(name);
            if (this.columnNames == null) {
                this.columnNames = new ArrayList<Object>(25);
            }
            this.columnNames.add(name);
            return this;
        }

        public Select<T> all() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.countOrAllSelected = true;
            return this.from(this.table);
        }

        public Select<T> countAll() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.columnNames = COUNT_ALL;
            this.countOrAllSelected = true;
            return this.from(this.table);
        }

        public Select.TableSelection<T> column(Object name) {
            return this.addName(name);
        }

        public Select.TableSelection<T> writeTime(String name) {
            return this.addName(new Utils.FCall("writetime", new Utils.CName(name)));
        }

        public Select.TableSelection<T> ttl(String name) {
            return this.addName(new Utils.FCall("ttl", new Utils.CName(name)));
        }

        public Select.TableSelection<T> fcall(String name, Object ... parameters) {
            return this.addName(new Utils.FCall(name, parameters));
        }
    }

    public static class SelectionImpl<T>
    extends BuilderImpl<T>
    implements Select.SelectionOrAlias<T> {
        private Object previous;

        SelectionImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            super(context, mgr, bridge);
        }

        private Select.Selection<T> addName(Object name) {
            this.context.getClassInfo().validateColumn(name);
            if (this.columnNames == null) {
                this.columnNames = new ArrayList<Object>(25);
            }
            this.columnNames.add(name);
            return this;
        }

        private Select.SelectionOrAlias<T> queueName(Object name) {
            this.context.getClassInfo().validateColumn(name);
            if (this.previous != null) {
                this.addName(this.previous);
            }
            this.previous = name;
            return this;
        }

        public Select.Selection<T> as(String alias) {
            assert (this.previous != null);
            Utils.Alias a = new Utils.Alias(this.previous, alias);
            this.previous = null;
            return this.addName(a);
        }

        public Select.Builder<T> all() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            Validate.validState((this.previous == null ? 1 : 0) != 0, (String)"some columns ([%s]) have already been selected", (Object[])new Object[]{this.previous});
            this.countOrAllSelected = true;
            return this;
        }

        public Select.Builder<T> countAll() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            Validate.validState((this.previous == null ? 1 : 0) != 0, (String)"some columns ([%s]) have already been selected", (Object[])new Object[]{this.previous});
            this.columnNames = COUNT_ALL;
            this.countOrAllSelected = true;
            return this;
        }

        public Select.SelectionOrAlias<T> column(Object name) {
            return this.queueName(name);
        }

        public Select.SelectionOrAlias<T> writeTime(String name) {
            return this.queueName(new Utils.FCall("writetime", new Utils.CName(name)));
        }

        public Select.SelectionOrAlias<T> ttl(String name) {
            return this.queueName(new Utils.FCall("ttl", new Utils.CName(name)));
        }

        public Select.SelectionOrAlias<T> fcall(String name, Object ... parameters) {
            return this.queueName(new Utils.FCall(name, parameters));
        }

        public Select.SelectionOrAlias<T> cast(Object column, DataType targetType) {
            return this.queueName(new Utils.Cast(column, targetType));
        }

        public Select.SelectionOrAlias<T> raw(String rawString) {
            return this.queueName(StatementBuilder.raw((String)rawString));
        }

        public Select.SelectionOrAlias<T> toJson(String name) {
            return null;
        }

        @Override
        public Select<T> from(String table) {
            if (this.previous != null) {
                this.addName(this.previous);
            }
            return super.from(table);
        }

        @Override
        public Select<T> from(TableInfo<T> table) {
            if (this.previous != null) {
                this.addName(this.previous);
            }
            return super.from(table);
        }
    }

    public static class BuilderImpl<T>
    implements Select.Builder<T> {
        protected final StatementManagerImpl mgr;
        protected final StatementBridge bridge;
        protected final ClassInfoImpl.Context context;
        protected List<Object> columnNames;
        protected boolean countOrAllSelected = false;

        BuilderImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            this.mgr = mgr;
            this.bridge = bridge;
            this.context = context;
        }

        BuilderImpl(ClassInfoImpl.Context context, List<Object> columnNames, StatementManagerImpl mgr, StatementBridge bridge) {
            this(context, mgr, bridge);
            context.getClassInfo().validateColumns(columnNames);
            this.columnNames = columnNames;
        }

        public Class<T> getObjectClass() {
            return this.context.getObjectClass();
        }

        public ClassInfo<T> getClassInfo() {
            return this.context.getClassInfo();
        }

        public Select<T> from(String table) {
            return new SelectImpl(this.context, table, this.columnNames, this.countOrAllSelected, this.mgr, this.bridge);
        }

        public Select<T> from(TableInfo<T> table) {
            return new SelectImpl(this.context, table.getName(), this.columnNames, this.countOrAllSelected, this.mgr, this.bridge);
        }
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<ObjectSet<T>, ObjectSetFuture<T>, T, SelectImpl<T>>
    implements Select.Where<T> {
        private final List<ClauseImpl> clauses = new ArrayList<ClauseImpl>(10);

        WhereImpl(SelectImpl<T> statement) {
            super(statement);
        }

        WhereImpl(WhereImpl<T> w, SelectImpl<T> statement) {
            super(statement);
            this.clauses.addAll(w.clauses);
        }

        private void andClause(TableInfoImpl<T> table, List<ClauseImpl> clauses, ClauseImpl clause) {
            List<ClauseImpl> eclauses;
            if (clause instanceof ClauseImpl.Compound && (eclauses = ((ClauseImpl.Compound)((Object)clause)).extractSpecialColumns(table)) != null) {
                eclauses.forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
                return;
            }
            clauses.add(clause);
        }

        private List<ClauseImpl> getClauses(TableInfoImpl<T> table) {
            String name;
            ArrayList<Object> clauses;
            if (table.hasMultiKeys() || table.hasCaseInsensitiveKeys()) {
                clauses = new ArrayList(this.clauses.size());
                for (ClauseImpl clauseImpl : this.clauses) {
                    this.andClause(table, clauses, clauseImpl);
                }
                ListIterator<ClauseImpl> i = clauses.listIterator();
                while (i.hasNext()) {
                    FieldInfoImpl<T> finfo;
                    ClauseImpl clauseImpl = (ClauseImpl)i.next();
                    if (clauseImpl instanceof ClauseImpl.SimpleClauseImpl) {
                        name = clauseImpl.getColumnName().toString();
                        finfo = table.getColumnImpl(name);
                        if (finfo == null) continue;
                        boolean ci = finfo.isCaseInsensitiveKey();
                        if (finfo.isMultiKey()) {
                            LinkedHashSet<String> in = new LinkedHashSet<String>(8);
                            String mkname = "mk_" + name;
                            for (Object v2 : clauseImpl.values()) {
                                if (v2 instanceof Collection) {
                                    if (ci) {
                                        ((Collection)v2).forEach(iv -> in.add(iv != null ? StringUtils.lowerCase((String)iv.toString()) : null));
                                        continue;
                                    }
                                    in.addAll((Collection)v2);
                                    continue;
                                }
                                if (ci && v2 != null) {
                                    in.add(StringUtils.lowerCase((String)v2.toString()));
                                    continue;
                                }
                                in.add((String)v2);
                            }
                            if (in.size() == 1) {
                                i.set(new ClauseImpl.SimpleClauseImpl((CharSequence)mkname, clauseImpl.getOperation(), in.iterator().next()));
                                continue;
                            }
                            if (finfo.isClusteringKey()) {
                                throw new IllegalArgumentException("unsupported selection of multiple values for clustering multi-key column '" + name + "'");
                            }
                            i.set(new ClauseImpl.InClauseImpl(mkname, in));
                            continue;
                        }
                        if (!ci) continue;
                        Object v3 = clauseImpl.firstValue();
                        i.set(new ClauseImpl.SimpleClauseImpl((CharSequence)("ci_" + name), clauseImpl.getOperation(), v3 != null ? StringUtils.lowerCase((String)v3.toString()) : null));
                        continue;
                    }
                    if (!(clauseImpl instanceof ClauseImpl.InClauseImpl) || (finfo = table.getColumnImpl(name = clauseImpl.getColumnName().toString())) == null || !finfo.isCaseInsensitiveKey()) continue;
                    i.set(new ClauseImpl.InClauseImpl("ci_" + name, clauseImpl.values().stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new))));
                }
            } else {
                clauses = new ArrayList<ClauseImpl>(this.clauses);
            }
            for (Map.Entry entry : table.getFinalPrimaryKeyValues().entrySet()) {
                name = (String)entry.getKey();
                boolean found = false;
                for (ClauseImpl c : this.clauses) {
                    if (!c.containsColumn(name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                clauses.add(new ClauseImpl.EqClauseImpl((CharSequence)name, entry.getValue()));
            }
            return clauses;
        }

        public Select.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a SELECT statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((SelectImpl)this.statement).table)) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                ClassInfoImpl.Context context = this.getContext();
                ClassInfoImpl cinfo = context.getClassInfo();
                boolean add = true;
                if (c instanceof ClauseImpl.Compound) {
                    ClauseImpl.Compound cc = (ClauseImpl.Compound)((Object)c);
                    List<String> names = cc.getColumnNames();
                    List<?> values = cc.getColumnValues();
                    if (c instanceof ClauseImpl.CompoundEqClauseImpl) {
                        for (int i = 0; i < names.size(); ++i) {
                            String name2 = names.get(i);
                            ((SelectImpl)this.statement).table.validateKeyspaceKeyOrPrimaryKeyOrIndexColumn(name2);
                            if (!cinfo.isKeyspaceKey(name2)) continue;
                            try {
                                context.addKeyspaceKey(name2, values.get(i));
                                this.setDirty();
                                if (((SelectImpl)this.statement).table.hasColumn(name2)) continue;
                                names.remove(i);
                                values.remove(i);
                                --i;
                                continue;
                            }
                            catch (ExcludedKeyspaceKeyException e) {
                                names.remove(i);
                                values.remove(i);
                                --i;
                            }
                        }
                        if (names.isEmpty()) {
                            return this;
                        }
                        c.validate(((SelectImpl)this.statement).table);
                    } else if (c instanceof ClauseImpl.CompoundInClauseImpl) {
                        for (int i = 0; i < names.size(); ++i) {
                            String name3 = names.get(i);
                            ((SelectImpl)this.statement).table.validateKeyspaceKeyOrPrimaryKeyOrIndexColumn(name3);
                            if (!cinfo.isKeyspaceKey(name3)) continue;
                            ArrayList cvalues = new ArrayList((Collection)values.get(i));
                            Iterator ci = cvalues.iterator();
                            while (ci.hasNext()) {
                                Object v = ci.next();
                                try {
                                    cinfo.validateKeyspaceKey(name3, v);
                                }
                                catch (ExcludedKeyspaceKeyException e) {
                                    ci.remove();
                                }
                            }
                            if (cvalues.isEmpty()) {
                                names.remove(i);
                                values.remove(i);
                                --i;
                                continue;
                            }
                            if (((SelectImpl)this.statement).keyspaceKeys == null) {
                                ((SelectImpl)this.statement).keyspaceKeys = new LinkedHashMap(6);
                            }
                            ((SelectImpl)this.statement).keyspaceKeys.put(name3, cvalues);
                            this.setDirty();
                            if (((SelectImpl)this.statement).table.hasColumn(name3)) continue;
                            names.remove(i);
                            values.remove(i);
                            --i;
                        }
                        if (names.isEmpty()) {
                            return this;
                        }
                        c.validate(((SelectImpl)this.statement).table);
                    } else {
                        names.forEach(name -> ((SelectImpl)this.statement).table.validatePrimaryKeyOrIndexColumn(name));
                        c.validate(((SelectImpl)this.statement).table);
                    }
                    add = !names.isEmpty();
                } else {
                    String name4 = c.getColumnName().toString();
                    if (c instanceof Clause.Equality) {
                        ((SelectImpl)this.statement).table.validateKeyspaceKeyOrPrimaryKeyOrIndexColumn(name4);
                        if (cinfo.isKeyspaceKey(name4)) {
                            try {
                                context.addKeyspaceKey(name4, c.firstValue());
                                this.setDirty();
                                add = ((SelectImpl)this.statement).table.hasColumn(name4);
                            }
                            catch (ExcludedKeyspaceKeyException e) {
                                return this;
                            }
                        }
                        c.validate(((SelectImpl)this.statement).table);
                    } else if (c instanceof Clause.In) {
                        ((SelectImpl)this.statement).table.validateKeyspaceKeyOrPrimaryKeyOrIndexColumn(name4);
                        if (cinfo.isKeyspaceKey(name4)) {
                            ArrayList values = new ArrayList(c.values());
                            Iterator i = values.iterator();
                            while (i.hasNext()) {
                                Object v = i.next();
                                try {
                                    cinfo.validateKeyspaceKey(name4, v);
                                }
                                catch (ExcludedKeyspaceKeyException e) {
                                    i.remove();
                                }
                            }
                            if (((SelectImpl)this.statement).keyspaceKeys == null) {
                                ((SelectImpl)this.statement).keyspaceKeys = new LinkedHashMap(6);
                            }
                            ((SelectImpl)this.statement).keyspaceKeys.put(name4, values);
                            this.setDirty();
                            add = ((SelectImpl)this.statement).table.hasColumn(name4);
                            if (add) {
                                c.validate(((SelectImpl)this.statement).table);
                            }
                        } else {
                            c.validate(((SelectImpl)this.statement).table);
                        }
                    } else {
                        ((SelectImpl)this.statement).table.validatePrimaryKeyOrIndexColumn(name4);
                        c.validate(((SelectImpl)this.statement).table);
                    }
                }
                if (add) {
                    this.clauses.add(c);
                    this.setDirty();
                }
            }
            return this;
        }

        public Select<T> orderBy(Ordering ... orderings) {
            return ((SelectImpl)this.statement).orderBy(orderings);
        }

        public Select<T> limit(int limit) {
            return ((SelectImpl)this.statement).limit(limit);
        }
    }
}

