/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Ordering;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;

public class OrderingImpl
extends Utils.Appendeable
implements Ordering {
    private final CharSequence name;
    private final boolean isDesc;

    OrderingImpl(CharSequence name, boolean isDesc) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        this.name = name;
        this.isDesc = isDesc;
    }

    @Override
    void appendTo(TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        Utils.appendName(tinfo, null, codecRegistry, sb, this.name);
        sb.append(this.isDesc ? " DESC" : " ASC");
    }

    @Override
    boolean containsBindMarker() {
        return false;
    }

    CharSequence getColumnName() {
        return this.name;
    }

    boolean isDescending() {
        return this.isDesc;
    }

    <T> void validate(TableInfoImpl<T> table) {
        table.validateColumn(this.name);
    }
}

