/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.helenus.driver.ObjectNotFoundException;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.ObjectSetFuture;
import org.helenus.driver.StatementManager;
import org.helenus.driver.impl.ListenableFutureImpl;
import org.helenus.driver.impl.ObjectSetImpl;

public class ObjectSetFutureImpl<T>
extends ListenableFutureImpl<T>
implements ObjectSetFuture<T> {
    private final ResultSetFuture future;

    ObjectSetFutureImpl(StatementManager.Context<T> context, ResultSetFuture future) {
        super(context, (ListenableFuture<ResultSet>)future);
        this.future = future;
    }

    public ObjectSet<T> getUninterruptibly() {
        try {
            ResultSet result = this.future.getUninterruptibly();
            this.postProcess(result);
            return new ObjectSetImpl(this.context, result);
        }
        catch (InvalidQueryException e) {
            ObjectNotFoundException.handleKeyspaceNotFound((Class)this.context.getObjectClass(), (InvalidQueryException)e);
            throw e;
        }
    }

    public ObjectSet<T> getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            ResultSet result = this.future.getUninterruptibly(timeout, unit);
            this.postProcess(result);
            return new ObjectSetImpl(this.context, result);
        }
        catch (InvalidQueryException e) {
            ObjectNotFoundException.handleKeyspaceNotFound((Class)this.context.getObjectClass(), (InvalidQueryException)e);
            throw e;
        }
    }
}

