/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.commons.collections.iterators.CombinationIterator;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.Insert;
import org.helenus.driver.ObjectExistException;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.Using;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UsingImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;

public class InsertImpl<T>
extends StatementImpl<Void, VoidFuture, T>
implements Insert<T> {
    private final List<TableInfoImpl<T>> tables = new ArrayList<TableInfoImpl<T>>(8);
    private final Set<String> columns = new LinkedHashSet<String>(32);
    private final Map<String, Object> values = new LinkedHashMap<String, Object>(32);
    private final OptionsImpl<T> usings;
    private volatile boolean ifNotExists;
    private volatile boolean allValuesAdded;

    InsertImpl(ClassInfoImpl.POJOContext context, String[] tables, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        if (tables != null) {
            for (String table : tables) {
                if (table == null) continue;
                this.tables.add((TableInfoImpl)context.getClassInfo().getTable(table));
            }
        } else {
            this.tables.addAll(context.getClassInfo().getTablesImpl());
        }
        this.usings = new OptionsImpl(this);
    }

    InsertImpl(ClassInfoImpl.POJOContext context, TableInfoImpl<T> table, List<UsingImpl<?>> usings, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        this.tables.add(table);
        this.usings = new OptionsImpl(this, usings);
    }

    void into(TableInfoImpl<T> table) {
        this.tables.add(table);
    }

    void buildQueryStrings(TableInfoImpl<T> table, List<StringBuilder> builders) {
        Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> columns;
        try {
            if (this.allValuesAdded || this.columns.isEmpty()) {
                columns = this.getPOJOContext().getColumnValues(table.getName());
            } else {
                Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> mpkcolumns = this.getPOJOContext().getMandatoryAndPrimaryKeyColumnValues(table.getName());
                columns = new LinkedHashMap(mpkcolumns.size() + this.columns.size());
                columns.putAll(mpkcolumns);
                columns.putAll(this.getPOJOContext().getColumnValues(table.getName(), this.columns));
                this.values.forEach((n, v) -> {
                    FieldInfoImpl finfo = table.getColumnImpl((CharSequence)n);
                    if (finfo != null) {
                        columns.put((String)n, (Triple<Object, CQLDataType, TypeCodec<?>>)Triple.of((Object)v, (Object)finfo.getDataType(), finfo.getCodec()));
                    } else {
                        columns.put((String)n, (Triple<Object, CQLDataType, TypeCodec<?>>)Triple.of((Object)v, null, null));
                    }
                });
            }
        }
        catch (EmptyOptionalPrimaryKeyException e) {
            return;
        }
        Collection<FieldInfoImpl<T>> multiKeys = table.getMultiKeys();
        Collection<FieldInfoImpl<T>> caseInsensitiveKeys = table.getCaseInsensitiveKeys();
        if (!caseInsensitiveKeys.isEmpty()) {
            for (FieldInfoImpl<T> finfo : caseInsensitiveKeys) {
                Iterator<FieldInfoImpl<T>> pset;
                if (finfo.isMultiKey() || (pset = columns.get(finfo.getColumnName())) == null) continue;
                Object v2 = pset.getLeft();
                columns.put("ci_" + finfo.getColumnName(), Triple.of((Object)(v2 != null ? StringUtils.lowerCase((String)v2.toString()) : null), (Object)pset.getMiddle(), (Object)pset.getRight()));
            }
        }
        if (!multiKeys.isEmpty()) {
            Collection[] sets = new Collection[multiKeys.size()];
            int j = -1;
            for (FieldInfoImpl<T> finfo : multiKeys) {
                Triple<Object, CQLDataType, TypeCodec<?>> pset = columns.get(finfo.getColumnName());
                if (pset != null) {
                    boolean ci = finfo.isCaseInsensitiveKey();
                    if (ci) {
                        sets[++j] = ((Collection)pset.getLeft()).stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new));
                        continue;
                    }
                    sets[++j] = (Collection)pset.getLeft();
                    continue;
                }
                sets[++j] = null;
            }
            CombinationIterator i = new CombinationIterator(Object.class, sets);
            while (i.hasNext()) {
                List ckeys = (List)i.next();
                j = -1;
                for (FieldInfoImpl<T> finfo : multiKeys) {
                    columns.put("mk_" + finfo.getColumnName(), Triple.of(ckeys.get(++j), (Object)finfo.getDataType().getElementType(), (Object)((ArgumentsCodec)finfo.getCodec()).codec(0)));
                }
                this.buildQueryString(table, columns, builders);
            }
        } else {
            this.buildQueryString(table, columns, builders);
        }
    }

    void buildQueryStrings(List<StringBuilder> builders) {
        for (TableInfoImpl<T> table : this.tables) {
            this.buildQueryStrings(table, builders);
        }
    }

    private void buildQueryString(TableInfoImpl<T> table, Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> columns, List<StringBuilder> builders) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        if (this.getKeyspace() != null) {
            Utils.appendName(builder, this.getKeyspace()).append(".");
        }
        Utils.appendName(builder, table.getName());
        builder.append("(");
        Utils.joinAndAppendNames(table, null, this.mgr.getCodecRegistry(), builder, ",", columns.keySet());
        builder.append(") VALUES (");
        Utils.joinAndAppendValues(null, this.mgr.getCodecRegistry(), builder, ",", columns.values(), null);
        builder.append(")");
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (!((OptionsImpl)this.usings).usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(table, null, this.mgr.getCodecRegistry(), builder, " AND ", ((OptionsImpl)this.usings).usings, null);
        }
        builders.add(builder);
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : this.tables.size();
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>(this.tables.size());
        this.buildQueryStrings(builders);
        if (builders.isEmpty()) {
            return null;
        }
        return builders.toArray(new StringBuilder[builders.size()]);
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("BATCH");
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        if (this.isCounterOp()) {
            builder.append(" COUNTER");
        }
    }

    @Override
    protected VoidFuture executeAsync0() {
        if (!this.isEnabled() || !this.ifNotExists) {
            return (VoidFuture)super.executeAsync0();
        }
        return this.bridge.newVoidFuture(this.executeAsyncRaw0(), new VoidFuture.PostProcessor(){

            public void postProcess(ResultSet result) {
                Row row = result.one();
                if (row == null) {
                    throw new ObjectExistException("no result row returned");
                }
                if (!row.getBool("[applied]")) {
                    throw new ObjectExistException(row, "insert not applied");
                }
            }
        });
    }

    public boolean isEmpty() {
        return this.allValuesAdded || this.columns.isEmpty();
    }

    public Stream<TableInfo<T>> tables() {
        return this.tables.stream().map(t -> t);
    }

    public Insert<T> valuesFromObject() {
        Validate.validState((boolean)this.values.isEmpty(), (String)"separate values have already been added to this statement", (Object[])new Object[0]);
        Map kkeys = this.getPOJOContext().getClassInfo().keyspaceKeysByName;
        if (!kkeys.isEmpty()) {
            this.getPOJOContext().populateKeyspaceKeys(kkeys);
            this.setDirty();
        }
        if (!this.allValuesAdded) {
            this.columns.clear();
            this.allValuesAdded = true;
            this.setDirty();
        }
        return this;
    }

    public Insert<T> value(String name) {
        boolean isKeyspaceKey = this.getPOJOContext().getClassInfo().isKeyspaceKey(name);
        if (isKeyspaceKey) {
            try {
                this.getPOJOContext().addKeyspaceKey(name);
                this.setDirty();
            }
            catch (ExcludedKeyspaceKeyException excludedKeyspaceKeyException) {
                // empty catch block
            }
            if (this.allValuesAdded || !this.getPOJOContext().getClassInfo().isColumn(name)) {
                return this;
            }
        }
        this.getPOJOContext().getClassInfo().validateColumn(name);
        if (!this.allValuesAdded) {
            int size = this.columns.size();
            this.columns.add(name);
            if (size != this.columns.size()) {
                this.setDirty();
            }
        }
        return this;
    }

    public Insert<T> values(String ... names) {
        ArrayList<Object> ns = new ArrayList<Object>(names.length);
        for (String n : names) {
            boolean isKeyspaceKey = this.getPOJOContext().getClassInfo().isKeyspaceKey(n);
            if (isKeyspaceKey) {
                try {
                    this.getPOJOContext().addKeyspaceKey(n);
                    this.setDirty();
                }
                catch (ExcludedKeyspaceKeyException excludedKeyspaceKeyException) {
                    // empty catch block
                }
                if (!this.allValuesAdded || !this.getPOJOContext().getClassInfo().isColumn(n)) continue;
            }
            ns.add(n);
        }
        this.getPOJOContext().getClassInfo().validateColumns(ns);
        if (!this.allValuesAdded) {
            int size = this.columns.size();
            this.columns.addAll(ns);
            if (size != this.columns.size()) {
                this.setDirty();
            }
        }
        return this;
    }

    public Insert<T> value(String name, Object value) {
        boolean isKeyspaceKey = this.getPOJOContext().getClassInfo().isKeyspaceKey(name);
        if (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (isKeyspaceKey) {
            try {
                this.getPOJOContext().addKeyspaceKey(name, value);
                this.setDirty();
            }
            catch (ExcludedKeyspaceKeyException excludedKeyspaceKeyException) {
                // empty catch block
            }
            if (this.allValuesAdded || !this.getPOJOContext().getClassInfo().isColumn(name)) {
                return this;
            }
        }
        Validate.validState((!this.allValuesAdded ? 1 : 0) != 0, (String)"all columns from the object have already been added to this statement", (Object[])new Object[0]);
        this.getPOJOContext().getClassInfo().validateColumnAndValue(name, value);
        this.columns.remove(name);
        this.values.put(name, value);
        return this;
    }

    public Insert.Options<T> using(Using<?> using) {
        return this.usings.and(using);
    }

    public Stream<Using<?>> usings() {
        return ((OptionsImpl)this.usings).usings.stream();
    }

    public <U> Optional<Using<U>> getUsing(String name) {
        return this.usings().filter(u -> u.getName().equals(name)).findAny();
    }

    public Insert<T> ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public static class OptionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, InsertImpl<T>>
    implements Insert.Options<T> {
        private final List<UsingImpl<?>> usings;

        OptionsImpl(InsertImpl<T> statement) {
            this(statement, new ArrayList(5));
        }

        OptionsImpl(InsertImpl<T> statement, List<UsingImpl<?>> usings) {
            super(statement);
            this.usings = usings;
        }

        public Insert.Options<T> and(Using<?> using) {
            Validate.notNull(using, (String)"invalid null using", (Object[])new Object[0]);
            Validate.isTrue((boolean)(using instanceof UsingImpl), (String)"unsupported class of usings: %s", (Object[])new Object[]{using.getClass().getName()});
            this.usings.add(((UsingImpl)using).setStatement(this.statement));
            this.setDirty();
            return this;
        }

        public Insert<T> value(String name) {
            return ((InsertImpl)this.statement).value(name);
        }

        public Insert<T> values(String ... names) {
            return ((InsertImpl)this.statement).values(names);
        }

        public Insert<T> value(String name, Object value) {
            return ((InsertImpl)this.statement).value(name, value);
        }
    }

    public static class BuilderImpl<T>
    extends StatementImpl<Void, VoidFuture, T>
    implements Insert.Builder<T> {
        BuilderImpl(ClassInfoImpl.POJOContext context, StatementManagerImpl mgr, StatementBridge bridge) {
            super(Void.class, context, mgr, bridge);
        }

        @Override
        protected int simpleSize() {
            return this.getContext().getClassInfo().getNumTables();
        }

        @Override
        protected StringBuilder[] buildQueryStrings() {
            return ((InsertImpl)this.intoAll()).buildQueryStrings();
        }

        public Insert<T> into(String ... tables) {
            return this.init(new InsertImpl(this.getPOJOContext(), tables, this.mgr, this.bridge));
        }

        public Insert<T> into(Stream<String> tables) {
            return this.init(new InsertImpl(this.getPOJOContext(), (String[])tables.toArray(String[]::new), this.mgr, this.bridge));
        }

        public Insert<T> intoAll() {
            return this.init(new InsertImpl(this.getPOJOContext(), (String[])null, this.mgr, this.bridge));
        }

        @Override
        public String getQueryString() {
            return this.intoAll().getQueryString();
        }

        @Override
        public Void execute() {
            return (Void)this.intoAll().execute();
        }

        @Override
        public VoidFuture executeAsync() {
            return (VoidFuture)this.intoAll().executeAsync();
        }

        @Override
        public ResultSet executeRaw() {
            return this.intoAll().executeRaw();
        }

        @Override
        public ResultSetFuture executeAsyncRaw() {
            return this.intoAll().executeAsyncRaw();
        }
    }
}

