/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.ErrorResultSetFuture;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.google.common.util.concurrent.ExecutionList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.impl.CreateIndexImpl;
import org.helenus.driver.impl.CreateKeyspaceImpl;
import org.helenus.driver.impl.CreateTableImpl;
import org.helenus.driver.impl.CreateTypeImpl;
import org.helenus.driver.impl.GroupStatementImpl;
import org.helenus.driver.impl.SequenceStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.util.stream.Collectors;

public class LastResultParallelSetFuture
extends DefaultResultSetFuture {
    private final Iterator<List<StatementImpl<?, ?, ?>>> statements;
    private final ExecutionList executionList = new ExecutionList();
    private final StatementManagerImpl mgr;
    private Map<ResultSetFuture, StatementImpl<?, ?, ?>> futures = null;
    private ResultSetFuture error = null;
    private ResultSetFuture success = null;
    private boolean cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LastResultParallelSetFuture(GroupStatementImpl<?, ?, ?> group, List<StatementImpl<?, ?, ?>> statements, StatementManagerImpl mgr) {
        super(null, mgr.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion(), null);
        Validate.notNull(statements, (String)"invalid null statements", (Object[])new Object[0]);
        this.mgr = mgr;
        LinkedList slist = new LinkedList();
        int factor = group.getParallelFactor();
        int cmax_rfactor = 1;
        int cfactor = factor;
        ArrayList cslist = new ArrayList(factor);
        boolean foundSchema = false;
        for (StatementImpl<?, ?, ?> s2 : statements) {
            Validate.notNull(s2, (String)"invalid null statement", (Object[])new Object[0]);
            if (!foundSchema && s2 instanceof CreateIndexImpl && s2 instanceof CreateKeyspaceImpl && s2 instanceof CreateTableImpl && s2 instanceof CreateTypeImpl) {
                foundSchema = true;
                cfactor = Math.min(cfactor, 32);
            } else {
                int max_rfactor;
                String keyspace = s2.getKeyspace();
                if (keyspace != null && cmax_rfactor < (max_rfactor = mgr.getMaximumKeyspaceReplicationFactor(keyspace))) {
                    cmax_rfactor = max_rfactor;
                    cfactor = factor / max_rfactor;
                }
            }
            if (s2 instanceof SequenceStatementImpl) {
                cslist.add(s2);
                slist.add(cslist);
                cslist = new ArrayList(factor);
                foundSchema = false;
                cfactor = factor;
                cmax_rfactor = 1;
                continue;
            }
            if (cslist.size() >= cfactor) {
                slist.add(cslist);
                cslist = new ArrayList(factor);
                foundSchema = false;
                cfactor = factor;
                cmax_rfactor = 1;
                cslist.add(s2);
                continue;
            }
            cslist.add(s2);
        }
        if (!cslist.isEmpty()) {
            slist.add(cslist);
        }
        this.statements = slist.iterator();
        Iterator<Object> iterator = this.statements;
        synchronized (iterator) {
            this.futures = (Map)this.statements.next().stream().collect(Collectors.toIdentityMap(s -> {
                ResultSetFuture f = s.executeAsyncRaw();
                f.addListener((Runnable)new Listener(f), (Executor)mgr.getPoolExecutor());
                return f;
            }, s -> s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Iterator<List<StatementImpl<?, ?, ?>>> iterator = this.statements;
        synchronized (iterator) {
            return this.error != null || this.success != null && !this.statements.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Iterator<List<StatementImpl<?, ?, ?>>> iterator = this.statements;
        synchronized (iterator) {
            return this.cancelled || this.error != null && this.error.isCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean bl;
        boolean execute;
        block13: {
            execute = false;
            Iterator<List<StatementImpl<?, ?, ?>>> iterator = this.statements;
            // MONITORENTER : iterator
            if (!this.cancelled) break block13;
            boolean bl2 = false;
            // MONITOREXIT : iterator
            if (!execute) return bl2;
            this.executionList.execute();
            return bl2;
        }
        execute = true;
        this.cancelled = true;
        this.statements.notifyAll();
        boolean did = false;
        try {
            for (ResultSetFuture f : this.futures.keySet()) {
                if (!f.cancel(mayInterruptIfRunning)) continue;
                did = true;
            }
            boolean bl3 = bl = did || this.statements.hasNext();
        }
        catch (Throwable throwable) {
            try {
                while (this.statements.hasNext()) {
                    this.statements.next();
                }
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (!execute) throw throwable2;
                this.executionList.execute();
                throw throwable2;
            }
        }
        while (true) {
            if (!this.statements.hasNext()) {
                // MONITOREXIT : iterator
                if (!execute) return bl;
                this.executionList.execute();
                return bl;
            }
            this.statements.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        ResultSetFuture future;
        long end = System.nanoTime() + unit.toNanos(timeout);
        Iterator<List<StatementImpl<?, ?, ?>>> iterator = this.statements;
        synchronized (iterator) {
            while (true) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                if (this.error != null) {
                    future = this.error;
                    break;
                }
                if (this.futures.isEmpty() && !this.statements.hasNext()) {
                    future = this.success;
                    break;
                }
                long duration = end - System.nanoTime();
                if (duration <= 0L) {
                    throw new TimeoutException("timeout waiting for last result");
                }
                TimeUnit.NANOSECONDS.timedWait(this.statements, duration);
            }
        }
        return (ResultSet)future.get(end - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet get() throws InterruptedException, ExecutionException {
        ResultSetFuture future;
        Iterator<List<StatementImpl<?, ?, ?>>> iterator = this.statements;
        synchronized (iterator) {
            while (true) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                if (this.error != null) {
                    future = this.error;
                    break;
                }
                if (this.futures.isEmpty() && !this.statements.hasNext()) {
                    future = this.success;
                    break;
                }
                this.statements.wait();
            }
        }
        return (ResultSet)future.get();
    }

    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    private class Listener
    implements Runnable {
        private final ResultSetFuture future;

        public Listener(ResultSetFuture future) {
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            StatementImpl statement;
            boolean execute;
            block21: {
                execute = false;
                Iterator iterator = LastResultParallelSetFuture.this.statements;
                // MONITORENTER : iterator
                statement = (StatementImpl)LastResultParallelSetFuture.this.futures.remove(this.future);
                if (LastResultParallelSetFuture.this.error == null) break block21;
                LastResultParallelSetFuture.this.statements.notifyAll();
                // MONITOREXIT : iterator
                if (!execute) return;
                LastResultParallelSetFuture.this.executionList.execute();
                return;
            }
            if (this.future.isCancelled()) {
                LastResultParallelSetFuture.this.error = this.future;
                LastResultParallelSetFuture.this.success = null;
                execute = true;
                LastResultParallelSetFuture.this.statements.notifyAll();
                // MONITOREXIT : iterator
                if (!execute) return;
                LastResultParallelSetFuture.this.executionList.execute();
                return;
            }
            if (!this.future.isDone()) {
                LastResultParallelSetFuture.this.futures.put(this.future, statement);
                // MONITOREXIT : iterator
                if (!execute) return;
                LastResultParallelSetFuture.this.executionList.execute();
                return;
            }
            try {
                try {
                    this.future.get();
                }
                catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                    LastResultParallelSetFuture.this.error = this.future;
                    LastResultParallelSetFuture.this.success = null;
                    execute = true;
                    LastResultParallelSetFuture.this.statements.notifyAll();
                    throw e;
                }
                catch (Error | Exception e) {
                    LastResultParallelSetFuture.this.error = this.future;
                    LastResultParallelSetFuture.this.success = null;
                    execute = true;
                    LastResultParallelSetFuture.this.statements.notifyAll();
                }
                LastResultParallelSetFuture.this.success = this.future;
                if (LastResultParallelSetFuture.this.futures.isEmpty()) {
                    if (LastResultParallelSetFuture.this.statements.hasNext()) {
                        try {
                            LastResultParallelSetFuture.this.futures = (Map)((List)LastResultParallelSetFuture.this.statements.next()).stream().collect(Collectors.toIdentityMap(s -> {
                                ResultSetFuture f = s.executeAsyncRaw();
                                f.addListener((Runnable)new Listener(f), (Executor)LastResultParallelSetFuture.this.mgr.getPoolExecutor());
                                return f;
                            }, s -> s));
                            return;
                        }
                        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                            LastResultParallelSetFuture.this.error = (ResultSetFuture)new ErrorResultSetFuture(LastResultParallelSetFuture.this.mgr, (Throwable)e);
                            LastResultParallelSetFuture.this.success = null;
                            execute = true;
                            LastResultParallelSetFuture.this.statements.notifyAll();
                            throw e;
                        }
                        catch (Error e) {
                            LastResultParallelSetFuture.this.error = (ResultSetFuture)new ErrorResultSetFuture(LastResultParallelSetFuture.this.mgr, e);
                            LastResultParallelSetFuture.this.success = null;
                            execute = true;
                            LastResultParallelSetFuture.this.statements.notifyAll();
                            return;
                        }
                        catch (Exception e) {
                            LastResultParallelSetFuture.this.error = (ResultSetFuture)new ErrorResultSetFuture(LastResultParallelSetFuture.this.mgr, new ExecutionException(e));
                            LastResultParallelSetFuture.this.success = null;
                            execute = true;
                            LastResultParallelSetFuture.this.statements.notifyAll();
                            return;
                        }
                    }
                    execute = true;
                    LastResultParallelSetFuture.this.statements.notifyAll();
                }
                // MONITOREXIT : iterator
                return;
            }
            finally {
                if (execute) {
                    LastResultParallelSetFuture.this.executionList.execute();
                }
            }
        }
    }
}

