/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;

public class UDTValueWrapper<T>
implements PersistedObject<T, T> {
    private final UDTClassInfoImpl<T> cinfo;
    private final T val;

    UDTValueWrapper(UDTClassInfoImpl<T> cinfo, Object val) {
        Validate.notNull((Object)val, (String)"invalid null value", (Object[])new Object[0]);
        this.cinfo = cinfo;
        this.val = this.cinfo.getObjectClass().cast(val);
    }

    public int hashCode() {
        return Objects.hashCode(this.val);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UDTValueWrapper) {
            UDTValueWrapper pval = (UDTValueWrapper)obj;
            return this.cinfo == pval.cinfo && Objects.equals(this.val, pval.val);
        }
        return false;
    }

    public String toString() {
        Map<String, Pair<Object, CQLDataType>> columns = ((UDTClassInfoImpl.POJOContext)this.cinfo.newContext((Object)this.val)).getColumnValues();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Utils.joinAndAppendNamesAndValues(sb, ",", ":", columns).append("}");
        return sb.toString();
    }
}

