/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.info.TypeClassInfo;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.Table;

public class SubClassInfoImpl<T>
extends RootClassInfoImpl<T> {
    private final RootClassInfoImpl<? super T> rinfo;

    SubClassInfoImpl(RootClassInfoImpl<? super T> rinfo, Class<T> clazz) {
        super(rinfo, clazz);
        Validate.isTrue((boolean)Modifier.isAbstract(clazz.getModifiers()), (String)"root entity subclass '%s', must be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.rinfo = rinfo;
        this.validate(rinfo.getObjectClass());
    }

    private void validate(Class<? super T> rclazz) {
        this.getKeyspaceKeys().forEach((n, f) -> Validate.isTrue((boolean)rclazz.equals(f.getDeclaringClass()), (String)"@KeyspaceKey annotation with name '%s' is not defined in root element class '%s' for subclass: ", (Object[])new Object[]{n, rclazz.getSimpleName(), this.clazz.getSimpleName()}));
        this.tablesImpl().forEach(t -> {
            Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Keyspace.class).isAssignableFrom(rclazz), (String)"@Keyspace annotation is not defined in root element class '%s' for subclass: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
            Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Table.class).isAssignableFrom(rclazz), (String)"@Table annotation is not defined in root element class '%s' for subclass: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
            t.getPartitionKeys().forEach(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@PartitionKey annotation with name '%s' is not defined in root element class '%s' for subclass: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
            t.getClusteringKeys().forEach(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@ClusteringKey annotation with name '%s' is not defined in root element class '%s' for subclass: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
            t.getTypeKey().ifPresent(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@TypeKey annotation with name '%s' is not defined in root element class '%s' for subclass: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
            t.getIndexes().forEach(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@Index annotation with name '%s' is not defined in root element class '%s' for subclass: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
        });
    }

    public RootClassInfoImpl<? super T> getRoot() {
        return this.rinfo;
    }

    public RootClassInfoImpl.POJOContext newContextFromRoot(Object object) {
        try {
            return this.newContext(this.clazz.cast(object));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public T getObject(Row row, String type, Map<String, Object> kkeys) {
        if (row == null || !this.clazz.isAssignableFrom(super.getType(type).getObjectClass())) {
            return null;
        }
        return super.getObject(row, kkeys);
    }

    @Override
    public T getObject(Row row, Map<String, Object> kkeys) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions cdefs = row.getColumnDefinitions();
        for (TableInfoImpl table : this.getTablesImpl()) {
            int i;
            FieldInfoImpl type = table.getTypeKey().orElse(null);
            if (type == null || (i = cdefs.getIndexOf(type.getColumnName())) == -1 || !table.getName().equals(cdefs.getTable(i))) continue;
            return this.getObject(row, Objects.toString(type.decodeValue(row), null), kkeys);
        }
        throw new ObjectConversionException(this.clazz, row, "missing POJO type column");
    }

    @Override
    public <S extends T> TypeClassInfoImpl<S> getType(Class<S> clazz) {
        if (this.clazz.isAssignableFrom(clazz)) {
            return super.getType((Class)clazz);
        }
        return null;
    }

    @Override
    public TypeClassInfoImpl<? extends T> getType(String name) {
        TypeClassInfo tinfo = super.getType(name);
        if (this.clazz.isAssignableFrom(tinfo.getObjectClass())) {
            return tinfo;
        }
        return null;
    }

    @Override
    public Stream<TypeClassInfo<? extends T>> types() {
        return super.types().filter(t -> this.clazz.isAssignableFrom(t.getObjectClass()));
    }

    @Override
    public Stream<TypeClassInfoImpl<? extends T>> typeImpls() {
        return super.typeImpls().filter(t -> this.clazz.isAssignableFrom(t.getObjectClass()));
    }

    @Override
    public int getNumTypes() {
        return (int)this.types().count();
    }

    @Override
    public String toString() {
        return "SubClassInfoImpl(super=" + super.toString() + ", rinfo=" + this.rinfo + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubClassInfoImpl)) {
            return false;
        }
        SubClassInfoImpl other = (SubClassInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubClassInfoImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

