/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.EmptyResultSetFuture;
import com.datastax.driver.core.LastResultSequentialSetFuture;
import com.datastax.driver.core.ResultSetFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;

public abstract class SequenceStatementImpl<R, F extends ListenableFuture<R>, T>
extends StatementImpl<R, F, T> {
    private volatile List<StatementImpl<?, ?, ?>> cacheList = null;
    private volatile StringBuilder[] cacheSB = null;

    protected SequenceStatementImpl(Class<R> resultClass, ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(resultClass, context, mgr, bridge);
    }

    protected SequenceStatementImpl(Class<R> resultClass, String keyspace, StatementManagerImpl mgr, StatementBridge bridge) {
        super(resultClass, keyspace, mgr, bridge);
    }

    protected SequenceStatementImpl(SequenceStatementImpl<R, F, T> sequence) {
        super(sequence);
        this.cacheList = sequence.cacheList;
        this.cacheSB = sequence.cacheSB;
    }

    protected abstract List<StatementImpl<?, ?, ?>> buildSequencedStatements();

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("SEQUENCE");
    }

    @Override
    protected final List<StatementImpl<?, ?, ?>> buildStatements() {
        if (!this.isEnabled()) {
            this.cacheList = null;
            this.cacheSB = null;
            this.simpleSize = 0;
        } else if (this.isDirty() || this.cacheList == null) {
            this.cacheList = this.buildSequencedStatements();
            this.cacheSB = null;
            this.simpleSize = this.cacheList.stream().mapToInt(StatementImpl::simpleSize).sum();
        }
        return this.cacheList != null ? this.cacheList : Collections.emptyList();
    }

    @Override
    protected final int simpleSize() {
        this.buildStatements();
        return this.simpleSize;
    }

    @Override
    protected final StringBuilder[] buildQueryStrings() {
        if (this.isDirty() || this.cacheSB == null) {
            List<StatementImpl<?, ?, ?>> slist = this.buildStatements();
            this.cacheSB = this.cacheList == null ? null : (StringBuilder[])slist.stream().map(StatementImpl::getQueryString).filter(s -> s != null).map(s -> {
                int l;
                StringBuilder sb = new StringBuilder((String)s);
                for (l = sb.length(); l > 0 && sb.charAt(l - 1) <= ' '; --l) {
                }
                if (l != sb.length()) {
                    sb.setLength(l);
                }
                if (l == 0 || sb.charAt(l - 1) != ';') {
                    sb.append(';');
                }
                return sb;
            }).toArray(StringBuilder[]::new);
        }
        return this.cacheSB;
    }

    @Override
    protected void setDirty() {
        super.setDirty();
        this.cacheList = null;
        this.cacheSB = null;
    }

    @Override
    protected ResultSetFuture executeAsyncRaw0() {
        if (!this.isEnabled()) {
            return new EmptyResultSetFuture(this.mgr);
        }
        try {
            List<StatementImpl<?, ?, ?>> slist = this.buildStatements();
            if (slist.isEmpty()) {
                ResultSetFuture resultSetFuture = this.mgr.sent(this, (ResultSetFuture)new EmptyResultSetFuture(this.mgr));
                return resultSetFuture;
            }
            if (slist.size() == 1) {
                ResultSetFuture resultSetFuture = this.mgr.sent(this, slist.get(0).executeAsyncRaw());
                return resultSetFuture;
            }
            ResultSetFuture resultSetFuture = this.mgr.sent(this, (ResultSetFuture)new LastResultSequentialSetFuture(slist, this.mgr));
            return resultSetFuture;
        }
        finally {
            this.setDirty(true);
        }
    }
}

