/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.io.IOException;
import java.util.Objects;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;

public class PersistedValue<T, PT>
implements PersistedObject<T, PT> {
    private final Persisted persisted;
    private final Persister<T, PT> persister;
    private final String fname;
    private T decodedVal;
    private boolean decodedDirty;
    private PT encodedVal;
    private boolean encodedDirty;

    PersistedValue(Persisted persisted, Persister<T, PT> persister, String fname) {
        this.persisted = persisted;
        this.persister = persister;
        this.fname = fname;
        this.encodedVal = null;
        this.encodedDirty = false;
        this.decodedVal = null;
        this.decodedDirty = false;
    }

    public T getDecodedValue() {
        if (this.decodedDirty) {
            try {
                this.decodedVal = this.persister.decode(this.encodedVal);
                this.decodedDirty = false;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to decode field '" + this.fname + "' to " + this.persister.getDecodedClass().getName() + "' with persister: " + this.persister.getClass().getName(), e);
            }
        }
        return this.decodedVal;
    }

    public PT getEncodedValue() {
        if (this.encodedDirty) {
            try {
                this.encodedVal = this.persister.getPersistedClass().cast(this.persisted.as().CLASS.cast(this.persister.encode(this.decodedVal)));
                this.encodedDirty = false;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to encode field '" + this.fname + "' to " + this.persisted.as().CQL + "' with persister: " + this.persister.getClass().getName(), e);
            }
        }
        return this.encodedVal;
    }

    public PersistedValue<T, PT> setDecodedValue(T val) {
        this.decodedVal = val;
        this.decodedDirty = false;
        this.encodedVal = null;
        this.encodedDirty = true;
        return this;
    }

    public PersistedValue<T, PT> setEncodedValue(PT val) {
        this.encodedVal = val;
        this.encodedDirty = false;
        this.decodedVal = null;
        this.decodedDirty = true;
        return this;
    }

    public int hashCode() {
        return this.getEncodedValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PersistedValue) {
            PersistedValue pval = (PersistedValue)obj;
            if (!this.encodedDirty && !pval.encodedDirty) {
                return Objects.equals(pval.encodedVal, this.encodedVal);
            }
            if (!this.decodedDirty && !pval.decodedDirty) {
                return Objects.equals(pval.decodedVal, this.decodedVal);
            }
            if (!this.encodedDirty) {
                return Objects.equals(pval.getEncodedValue(), this.encodedVal);
            }
            if (!pval.encodedDirty) {
                return Objects.equals(pval.encodedVal, this.getEncodedValue());
            }
            if (!this.decodedDirty) {
                return Objects.equals(pval.getDecodedValue(), this.decodedVal);
            }
            if (!pval.decodedDirty) {
                return Objects.equals(pval.decodedVal, this.getDecodedValue());
            }
            return Objects.equals(pval.getEncodedValue(), this.getEncodedValue());
        }
        if (this.persister.getPersistedClass().isInstance(obj)) {
            Object ptval = this.persister.getPersistedClass().cast(obj);
            return Objects.equals(ptval, this.getEncodedValue());
        }
        if (this.persister.getDecodedClass().isInstance(obj)) {
            Object tval = this.persister.getDecodedClass().cast(obj);
            return Objects.equals(tval, this.getDecodedValue());
        }
        return false;
    }

    public String toString() {
        return (this.decodedDirty ? "?" : String.valueOf(this.decodedVal)) + "\u2248" + (this.encodedDirty ? "?" : String.valueOf(this.encodedVal));
    }
}

