/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;
import org.helenus.util.stream.Collectors;

public class PersistedSortedSet<T, PT>
extends TreeSet<T>
implements PersistedObject<T, PT> {
    private static final long serialVersionUID = -8520854665439809920L;
    private final Persisted persisted;
    private final Persister<T, PT> persister;
    private final String fname;
    private final TreeMap<T, PersistedValue<T, PT>> map;

    PersistedSortedSet(PersistedSortedSet<T, PT> set) {
        this.persisted = set.persisted;
        this.persister = set.persister;
        this.fname = set.fname;
        this.map = (TreeMap)set.map.clone();
    }

    PersistedSortedSet(Persisted persisted, Persister<T, PT> persister, String fname, Set<?> set, boolean encoded) {
        this.persisted = persisted;
        this.persister = persister;
        this.fname = fname;
        this.map = encoded ? (TreeMap)set.stream().map(pt -> new PersistedValue(persisted, persister, fname).setEncodedValue(pt)).collect(Collectors.toTreeMap(PersistedValue::getDecodedValue, pt -> pt)) : (TreeMap)set.stream().map(t -> {
            PersistedValue pval = new PersistedValue(persisted, persister, fname).setDecodedValue(t);
            pval.getEncodedValue();
            return pval;
        }).collect(Collectors.toTreeMap(PersistedValue::getDecodedValue, pval -> pval));
    }

    public Collection<PersistedValue<T, PT>> getPersistedSet() {
        return this.map.values();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.map.comparator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.map.keySet().spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.map.keySet().stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.map.keySet().parallelStream();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(T e) {
        return this.map.put(e, new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(e)) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String toString() {
        return this.map.values().toString();
    }

    @Override
    public Object clone() {
        return new PersistedSortedSet<T, PT>(this);
    }
}

