/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.helenus.commons.collections.iterators.TransformSpliterator;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;

public class PersistedMap<K, T, PT>
extends AbstractMap<K, T>
implements PersistedObject<T, PT> {
    final Persisted persisted;
    final Persister<T, PT> persister;
    final String fname;
    final Map<K, PersistedValue<T, PT>> map;
    private Set<Map.Entry<K, T>> eset = null;
    private Collection<T> vcol = null;

    private static <NK, NV> Map<NK, NV> newMap(Map<?, ?> map) {
        if (map instanceof SortedMap) {
            return new TreeMap();
        }
        if (map instanceof LinkedHashMap) {
            return new LinkedHashMap(map.size() * 3 / 2);
        }
        return new HashMap(map.size() * 3 / 2);
    }

    PersistedMap(PersistedMap<K, T, PT> pmap, Map<K, PersistedValue<T, PT>> map) {
        this.persisted = pmap.persisted;
        this.persister = pmap.persister;
        this.fname = pmap.fname;
        this.map = map;
    }

    PersistedMap(Persisted persisted, Persister<T, PT> persister, String fname, Map<K, PersistedValue<T, PT>> pmap, Map<K, ?> map, boolean encoded) {
        this.persisted = persisted;
        this.persister = persister;
        this.fname = fname;
        this.map = pmap;
        if (encoded) {
            for (Map.Entry<K, ?> e : map.entrySet()) {
                this.map.put(e.getKey(), new PersistedValue(persisted, persister, fname).setEncodedValue(e.getValue()));
            }
        } else {
            for (Map.Entry<K, ?> e : map.entrySet()) {
                PersistedValue<T, PT> pval = new PersistedValue(persisted, persister, fname).setDecodedValue(e.getValue());
                pval.getEncodedValue();
                this.map.put(e.getKey(), pval);
            }
        }
    }

    PersistedMap(Persisted persisted, Persister<T, PT> persister, String fname, Map<K, ?> map, boolean encoded) {
        this(persisted, persister, fname, PersistedMap.newMap(map), map, encoded);
    }

    public Map<K, PersistedValue<T, PT>> getPersistedMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public T get(Object key) {
        PersistedValue<T, PT> pval = this.map.get(key);
        return pval != null ? (T)pval.getDecodedValue() : null;
    }

    @Override
    public T put(K key, T value) {
        PersistedValue<T, PT> pval = this.map.put(key, new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(value));
        return pval != null ? (T)pval.getDecodedValue() : null;
    }

    @Override
    public T remove(Object key) {
        PersistedValue<T, PT> pval = this.map.remove(key);
        return pval != null ? (T)pval.getDecodedValue() : null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<T> values() {
        if (this.vcol == null) {
            final Collection<PersistedValue<T, PT>> vcol = this.map.values();
            this.vcol = new AbstractCollection<T>(){

                @Override
                public int size() {
                    return vcol.size();
                }

                @Override
                public boolean isEmpty() {
                    return vcol.isEmpty();
                }

                @Override
                public Iterator<T> iterator() {
                    return new TransformIterator<PersistedValue<T, PT>, T>(vcol.iterator()){

                        protected T transform(PersistedValue<T, PT> pv) {
                            return pv.getDecodedValue();
                        }
                    };
                }

                @Override
                public Spliterator<T> spliterator() {
                    return new TransformSpliterator<PersistedValue<T, PT>, T>(vcol.spliterator()){

                        protected T transform(PersistedValue<T, PT> pv) {
                            return pv.getDecodedValue();
                        }
                    };
                }

                @Override
                public Stream<T> stream() {
                    return vcol.stream().map(pv -> pv.getDecodedValue());
                }

                @Override
                public Stream<T> parallelStream() {
                    return vcol.parallelStream().map(pv -> pv.getDecodedValue());
                }

                @Override
                public void clear() {
                    vcol.clear();
                }

                @Override
                public String toString() {
                    return vcol.toString();
                }
            };
        }
        return this.vcol;
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        if (this.eset == null) {
            final Set<Map.Entry<K, PersistedValue<T, PT>>> eset = this.map.entrySet();
            this.eset = new AbstractSet<Map.Entry<K, T>>(){

                @Override
                public int size() {
                    return eset.size();
                }

                @Override
                public boolean isEmpty() {
                    return eset.isEmpty();
                }

                @Override
                public Iterator<Map.Entry<K, T>> iterator() {
                    return new TransformIterator<Map.Entry<K, PersistedValue<T, PT>>, Map.Entry<K, T>>(eset.iterator()){

                        protected Map.Entry<K, T> transform(Map.Entry<K, PersistedValue<T, PT>> me) {
                            return new PersistedEntry(me);
                        }
                    };
                }

                @Override
                public Spliterator<Map.Entry<K, T>> spliterator() {
                    TransformSpliterator si = new TransformSpliterator<Map.Entry<K, PersistedValue<T, PT>>, Map.Entry<K, T>>(eset.spliterator()){

                        protected Map.Entry<K, T> transform(Map.Entry<K, PersistedValue<T, PT>> me) {
                            return new PersistedEntry(me);
                        }
                    };
                    si.setReverseTransformer(pe -> ((PersistedEntry)pe).me);
                    return si;
                }

                @Override
                public Stream<Map.Entry<K, T>> stream() {
                    return eset.stream().map(me -> new PersistedEntry(me));
                }

                @Override
                public Stream<Map.Entry<K, T>> parallelStream() {
                    return eset.parallelStream().map(me -> new PersistedEntry(me));
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    return PersistedMap.this.map.remove(me.getKey()) != null;
                }

                @Override
                public void clear() {
                    eset.clear();
                }

                @Override
                public String toString() {
                    return eset.toString();
                }
            };
        }
        return this.eset;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    class PersistedEntry
    implements Map.Entry<K, T> {
        final Map.Entry<K, PersistedValue<T, PT>> me;

        PersistedEntry(Map.Entry<K, PersistedValue<T, PT>> me) {
            this.me = me;
        }

        @Override
        public K getKey() {
            return this.me.getKey();
        }

        @Override
        public T getValue() {
            return this.me.getValue().getDecodedValue();
        }

        @Override
        public T setValue(T value) {
            return this.me.setValue(new PersistedValue(PersistedMap.this.persisted, PersistedMap.this.persister, PersistedMap.this.fname).setDecodedValue(value)).getDecodedValue();
        }
    }
}

