/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.helenus.driver.ObjectNotFoundException;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.StatementManager;

public class ObjectSetImpl<T>
implements ObjectSet<T> {
    private final StatementManager.Context<T> context;
    private final ResultSet result;
    private volatile T next = null;

    ObjectSetImpl(StatementManager.Context<T> context, ResultSet result) {
        this.context = context;
        this.result = result;
    }

    public ColumnDefinitions getColumnDefinitions() {
        return this.result.getColumnDefinitions();
    }

    public boolean isExhausted() {
        while (this.next == null && !this.result.isExhausted()) {
            this.next = this.context.getObject(this.result.one());
        }
        return this.next == null;
    }

    public T one() {
        if (this.isExhausted()) {
            return null;
        }
        T next = this.next;
        this.next = null;
        return next;
    }

    public T oneRequired() {
        T next = this.one();
        if (next == null) {
            throw new ObjectNotFoundException(this.context.getObjectClass(), "one object was required; none found");
        }
        return next;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1296), false);
    }

    public List<T> all() {
        List rows = this.result.all();
        ArrayList<Object> ts = new ArrayList<Object>(rows.size() + 1);
        T next = this.next;
        if (next != null) {
            this.next = null;
            ts.add(next);
        }
        for (Row row : rows) {
            Object obj = this.context.getObject(row);
            if (obj == null) continue;
            ts.add(obj);
        }
        return ts;
    }

    public Iterator<T> iterator() {
        final Iterator i = this.result.iterator();
        return new Iterator<T>(){
            private T next = null;

            @Override
            public boolean hasNext() {
                Object next = ObjectSetImpl.this.next;
                if (next != null) {
                    ObjectSetImpl.this.next = null;
                    this.next = next;
                } else {
                    while (this.next == null && i.hasNext()) {
                        this.next = ObjectSetImpl.this.context.getObject((Row)i.next());
                    }
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("ObjectSet Iterator");
                }
                Object next = this.next;
                this.next = null;
                return next;
            }
        };
    }

    public int getAvailableWithoutFetching() {
        return this.result.getAvailableWithoutFetching() + (this.next != null ? 1 : 0);
    }

    public boolean isFullyFetched() {
        return this.next == null && this.result.isFullyFetched();
    }

    public ListenableFuture<Void> fetchMoreObjects() {
        return this.result.fetchMoreResults();
    }

    public ExecutionInfo getExecutionInfo() {
        return this.result.getExecutionInfo();
    }

    public List<ExecutionInfo> getAllExecutionInfo() {
        return this.result.getAllExecutionInfo();
    }

    public String toString() {
        return this.result.toString();
    }
}

