/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.LocaleUtils;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.impl.DataDecoder;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.info.ClassInfo;

abstract class ElementConverter {
    ElementConverter() {
    }

    public abstract Object convert(Object var1);

    static ElementConverter getConverter(final Class eclass, Class reclass) {
        if (UDTValue.class.isAssignableFrom(reclass)) {
            ClassInfo cinfo = StatementBuilder.getClassInfo((Class)eclass);
            Validate.isTrue((boolean)(cinfo instanceof UDTClassInfoImpl), (String)"unsupported element conversion from: %s to: %s; unknown user-defined type", (Object[])new Object[]{reclass.getName(), eclass.getName()});
            final UDTClassInfoImpl udtinfo = (UDTClassInfoImpl)cinfo;
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return udtinfo.getObject((UDTValue)re);
                }
            };
        }
        if (Enum.class.isAssignableFrom(eclass) && String.class == reclass) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return Enum.valueOf(eclass, (String)re);
                }
            };
        }
        if (Class.class.isAssignableFrom(eclass) && String.class == reclass) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    try {
                        return DataDecoder.findClass((String)re);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            };
        }
        if (Locale.class.isAssignableFrom(eclass) && String.class == reclass) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return LocaleUtils.toLocale((String)((String)re));
                }
            };
        }
        if (ZoneId.class.isAssignableFrom(eclass) && String.class == reclass) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    try {
                        return ZoneId.of((String)re);
                    }
                    catch (DateTimeException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            };
        }
        if (eclass.isArray() && Byte.TYPE == eclass.getComponentType() && ByteBuffer.class.isAssignableFrom(reclass)) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return Bytes.getArray((ByteBuffer)((ByteBuffer)re));
                }
            };
        }
        if (Long.class == eclass && Date.class.isAssignableFrom(reclass)) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return ((Date)re).getTime();
                }
            };
        }
        if (Instant.class == eclass && Date.class.isAssignableFrom(reclass)) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return ((Date)re).toInstant();
                }
            };
        }
        if (eclass == reclass) {
            return new ElementConverter(){

                @Override
                public Object convert(Object re) {
                    return re;
                }
            };
        }
        throw new IllegalArgumentException("unsupported element conversion from: " + reclass.getName() + " to: " + eclass.getName());
    }
}

