/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateKeyspace;
import org.helenus.driver.KeyspaceWith;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.KeyspaceWithImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.Utils;

public class CreateKeyspaceImpl<T>
extends StatementImpl<Void, VoidFuture, T>
implements CreateKeyspace<T> {
    protected final OptionsImpl<T> with = new OptionsImpl(this);
    private volatile boolean ifNotExists;
    private final WhereImpl<T> where = new WhereImpl(this);

    public CreateKeyspaceImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : 1;
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        return new StringBuilder[]{this.buildQueryString()};
    }

    @Override
    protected StringBuilder buildQueryString() {
        if (!this.isEnabled()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE KEYSPACE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        Utils.appendName(this.getKeyspace(), builder);
        KeyspaceWithImpl.ReplicationWithImpl replication = this.with.replication;
        if (replication == null) {
            replication = new KeyspaceWithImpl.ReplicationWithImpl(this.getContext().getClassInfo(), this.mgr);
        }
        ArrayList<KeyspaceWithImpl> options = new ArrayList<KeyspaceWithImpl>(this.with.options.size() + 1);
        options.add(replication);
        options.addAll(this.with.options);
        builder.append(" WITH ");
        Utils.joinAndAppend(null, builder, " AND ", options);
        builder.append(" AND DURABLE_WRITES = ").append(this.getContext().getClassInfo().getKeyspace().durableWrites());
        return builder;
    }

    public CreateKeyspace<T> ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public CreateKeyspace.Options<T> with(KeyspaceWith option) {
        return this.with.and(option);
    }

    public CreateKeyspace.Options<T> with() {
        return this.with;
    }

    public CreateKeyspace.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public CreateKeyspace.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateKeyspaceImpl<T>>
    implements CreateKeyspace.Where<T> {
        WhereImpl(CreateKeyspaceImpl<T> statement) {
            super(statement);
        }

        public CreateKeyspace.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE KEYSPACE statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((CreateKeyspaceImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ((CreateKeyspaceImpl)this.statement).getContext().addKeyspaceKey(c.getColumnName().toString(), c.firstValue());
                this.setDirty();
            }
            return this;
        }
    }

    public static class OptionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateKeyspaceImpl<T>>
    implements CreateKeyspace.Options<T> {
        protected KeyspaceWithImpl.ReplicationWithImpl replication;
        protected final List<KeyspaceWithImpl> options = new ArrayList<KeyspaceWithImpl>(2);

        OptionsImpl(CreateKeyspaceImpl<T> statement) {
            super(statement);
        }

        public CreateKeyspace.Options<T> and(KeyspaceWith option) {
            Validate.notNull((Object)option, (String)"invalid null with", (Object[])new Object[0]);
            Validate.isTrue((boolean)(option instanceof KeyspaceWithImpl), (String)"unsupported class of withs: %s", (Object[])new Object[]{option.getClass().getName()});
            if (option instanceof KeyspaceWithImpl.ReplicationWithImpl) {
                this.replication = (KeyspaceWithImpl.ReplicationWithImpl)option;
            } else {
                this.options.add((KeyspaceWithImpl)option);
            }
            this.setDirty();
            return this;
        }

        public CreateKeyspace.Where<T> where(Clause clause) {
            return ((CreateKeyspaceImpl)this.statement).where.and(clause);
        }

        public CreateKeyspace.Where<T> where() {
            return ((CreateKeyspaceImpl)this.statement).where;
        }
    }
}

