/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.RegularStatement;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.helenus.driver.Batch;
import org.helenus.driver.BatchableStatement;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.Group;
import org.helenus.driver.ObjectStatement;
import org.helenus.driver.ParentStatement;
import org.helenus.driver.Recorder;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.Using;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.ParentStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.UsingImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.util.Inhibit;
import org.helenus.util.function.ERunnable;

public class BatchImpl
extends StatementImpl<Void, VoidFuture, Void>
implements Batch,
ParentStatementImpl {
    private static final Logger logger = LogManager.getFormatterLogger(BatchImpl.class);
    private final List<StatementImpl<?, ?, ?>> statements;
    private volatile ParentStatementImpl parent = null;
    private final Optional<Recorder> recorder;
    private final LinkedList<ERunnable<?>> errorHandlers;
    private volatile boolean includesBatches = false;
    private final boolean logged;
    private final OptionsImpl usings;
    private volatile List<StatementImpl<?, ?, ?>> cacheList = null;
    private volatile StringBuilder[] cacheSB = null;

    public BatchImpl(Optional<Recorder> recorder, BatchableStatement<?, ?>[] statements, boolean logged, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, (String)null, mgr, bridge);
        this.statements = new ArrayList(Math.max(statements.length, 8));
        this.logged = logged;
        this.usings = new OptionsImpl(this);
        this.recorder = recorder;
        this.errorHandlers = new LinkedList();
        for (BatchableStatement<?, ?> statement : statements) {
            this.add((BatchableStatement<R, F>)((BatchableStatement)statement));
        }
    }

    public BatchImpl(Optional<Recorder> recorder, Iterable<BatchableStatement<?, ?>> statements, boolean logged, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, (String)null, mgr, bridge);
        this.statements = new ArrayList(32);
        this.logged = logged;
        this.usings = new OptionsImpl(this);
        this.recorder = recorder;
        this.errorHandlers = new LinkedList();
        for (BatchableStatement<?, ?> statement : statements) {
            this.add((BatchableStatement<R, F>)((BatchableStatement)statement));
        }
    }

    private BatchImpl(BatchImpl b, Optional<Recorder> recorder) {
        super(b);
        this.statements = new ArrayList(b.statements);
        this.logged = b.logged;
        this.recorder = recorder;
        this.errorHandlers = new LinkedList(b.errorHandlers);
        this.usings = new OptionsImpl(this, b.usings);
        this.cacheList = b.cacheList;
        this.cacheSB = b.cacheSB;
    }

    private List<StatementImpl<?, ?, ?>> buildBatchedStatements() {
        return this.statements.stream().flatMap(s -> s instanceof BatchImpl ? ((BatchImpl)s).buildBatchedStatements().stream() : Stream.of(s)).collect(Collectors.toList());
    }

    private Batch addInternal(StatementImpl<?, ?, ?> s) {
        if (s instanceof SimpleStatementImpl) {
            SimpleStatementImpl ss = (SimpleStatementImpl)s;
            Validate.isTrue((!ss.isSelect() ? 1 : 0) != 0, (String)"select statements are not supported in batch statements", (Object[])new Object[0]);
            Validate.isTrue((!ss.isBatch() ? 1 : 0) != 0, (String)"batch raw statements are not supported in batch statements", (Object[])new Object[0]);
        }
        boolean isCounterOp = s.isCounterOp();
        if (this.isCounterOp == null) {
            this.setCounterOp(isCounterOp);
        } else if (this.isCounterOp() != isCounterOp) {
            throw new IllegalArgumentException("cannot mix counter operations and non-counter operations in a batch statement");
        }
        this.statements.add(s);
        if (s instanceof ParentStatementImpl) {
            ParentStatementImpl ps = (ParentStatementImpl)((Object)s);
            ps.setParent(this);
            ps.objectStatements().forEach(cs -> this.recorded((ObjectStatement<?>)cs, ps));
        } else if (s instanceof ObjectStatement) {
            this.recorded((ObjectStatement)s, this);
        }
        this.setDirty();
        return this;
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("BATCH");
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        if (this.isCounterOp()) {
            builder.append(" COUNTER");
        } else if (!this.logged) {
            builder.append(" UNLOGGED");
        }
    }

    @Override
    protected final List<StatementImpl<?, ?, ?>> buildStatements() {
        if (!this.isEnabled()) {
            this.cacheList = null;
            this.cacheSB = null;
            this.simpleSize = 0;
        } else if (this.isDirty() || this.cacheList == null) {
            this.cacheList = this.buildBatchedStatements();
            this.cacheSB = null;
            this.simpleSize = this.cacheList.stream().mapToInt(StatementImpl::simpleSize).sum();
        }
        return this.cacheList != null ? this.cacheList : Collections.emptyList();
    }

    @Override
    protected int simpleSize() {
        this.buildStatements();
        return this.simpleSize;
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (this.isDirty() || this.cacheSB == null) {
            List<StatementImpl<?, ?, ?>> slist = this.buildStatements();
            if (this.cacheList == null) {
                this.cacheSB = null;
            } else {
                ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>(slist.size());
                for (StatementImpl<?, ?, ?> statement : slist) {
                    StringBuilder[] sbs = statement.buildQueryStrings();
                    if (sbs == null) continue;
                    for (StringBuilder sb : sbs) {
                        if (sb == null) continue;
                        builders.add(sb);
                    }
                }
                this.cacheSB = builders.toArray(new StringBuilder[builders.size()]);
            }
        }
        return this.cacheSB != null && this.cacheSB.length > 0 ? this.cacheSB : null;
    }

    @Override
    protected void setDirty() {
        super.setDirty();
        this.cacheList = null;
        this.cacheSB = null;
    }

    @Override
    protected void setDirty(boolean recurse) {
        super.setDirty(recurse);
        if (recurse) {
            this.statements.forEach(s -> s.setDirty(recurse));
        }
    }

    @Override
    protected void appendOptions(StringBuilder builder) {
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(null, builder, " AND ", this.usings.usings);
        }
    }

    @Override
    public void setParent(ParentStatementImpl parent) {
        this.parent = parent;
    }

    @Override
    public void recorded(ObjectStatement<?> statement, ParentStatement pstatement) {
        if (statement.getObject() == null) {
            return;
        }
        this.recorder.ifPresent(r -> r.recorded(statement, pstatement));
        ParentStatementImpl p = this.parent;
        if (p != null) {
            p.recorded(statement, pstatement);
        }
    }

    @Override
    public Stream<ObjectStatement<?>> objectStatements() {
        return this.statements.stream().flatMap(s -> {
            StatementImpl si = s;
            if (si instanceof ParentStatementImpl) {
                return ((ParentStatementImpl)((Object)si)).objectStatements();
            }
            if (s instanceof ObjectStatement) {
                return Stream.of((ObjectStatement)s);
            }
            return Stream.empty();
        });
    }

    @Override
    public Stream<GenericStatement<?, ?>> statements() {
        return Stream.concat(Stream.of(this), this.statements.stream().flatMap(s -> {
            StatementImpl si = s;
            if (si instanceof ParentStatementImpl) {
                return ((ParentStatementImpl)((Object)si)).statements();
            }
            return Stream.of(s);
        }));
    }

    @Override
    public String getKeyspace() {
        return this.statements.isEmpty() ? null : this.statements.get(0).getKeyspace();
    }

    @Override
    public Optional<Recorder> getRecorder() {
        ParentStatementImpl p = this.parent;
        return Optional.ofNullable(this.recorder.orElseGet(() -> p != null ? (Recorder)p.getRecorder().orElse(null) : null));
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public boolean hasReachedRecommendedSize() {
        return this.simpleSize() >= 5;
    }

    public boolean hasReachedRecommendedSizeFor(Class<?> clazz) {
        if (clazz == null) {
            return this.hasReachedRecommendedSize();
        }
        try {
            return this.hasReachedRecommendedSizeFor(this.mgr.getClassInfo(clazz));
        }
        catch (IllegalArgumentException e) {
            return this.hasReachedRecommendedSize();
        }
    }

    public boolean hasReachedRecommendedSizeFor(ClassInfo<?> cinfo) {
        if (cinfo == null) {
            return this.hasReachedRecommendedSize();
        }
        int free = 5 - this.simpleSize();
        int num_tables = cinfo.getNumTables();
        return free < (num_tables == 0 ? 1 : num_tables);
    }

    public int size() {
        if (!this.includesBatches) {
            return this.statements.size();
        }
        int size = 0;
        for (StatementImpl<?, ?, ?> s : this.statements) {
            if (s instanceof BatchImpl) {
                size += ((BatchImpl)s).size();
                continue;
            }
            ++size;
        }
        return size;
    }

    public void clear() {
        this.statements.clear();
        this.includesBatches = false;
        this.setDirty();
    }

    public <R, F extends ListenableFuture<R>> Batch add(BatchableStatement<R, F> statement) {
        Validate.notNull(statement, (String)"invalid null statement", (Object[])new Object[0]);
        Validate.isTrue((boolean)(statement instanceof StatementImpl), (String)"unsupported class of statements: %s", (Object[])new Object[]{statement.getClass().getName()});
        return this.addInternal((StatementImpl)statement);
    }

    public Batch add(RegularStatement statement) {
        Validate.notNull((Object)statement, (String)"invalid null statement", (Object[])new Object[0]);
        return this.addInternal(new SimpleStatementImpl(statement, this.mgr, this.bridge));
    }

    public Batch addErrorHandler(ERunnable<?> run) {
        Validate.notNull(run, (String)"invalid null error handler", (Object[])new Object[0]);
        this.errorHandlers.addFirst(run);
        return this;
    }

    public void runErrorHandlers() {
        for (ERunnable eRunnable : this.errorHandlers) {
            Inhibit.throwables((ERunnable)eRunnable, t -> logger.catching(t));
        }
        for (StatementImpl statementImpl : this.statements) {
            if (!(statementImpl instanceof Group)) continue;
            ((Group)statementImpl).runErrorHandlers();
        }
    }

    public Batch.Options using(Using<?> using) {
        return this.usings.and(using);
    }

    public Stream<Using<?>> usings() {
        return this.usings.usings.stream();
    }

    public <U> Optional<Using<U>> getUsing(String name) {
        return this.usings().filter(u -> u.getName().equals(name)).findAny();
    }

    public Batch duplicate() {
        return this.init(new BatchImpl(this, Optional.empty()));
    }

    public Batch duplicate(Recorder recorder) {
        return this.init(new BatchImpl(this, Optional.of(recorder)));
    }

    public static class OptionsImpl
    extends ForwardingStatementImpl<Void, VoidFuture, Void, BatchImpl>
    implements Batch.Options {
        private final List<UsingImpl<?>> usings = new ArrayList(5);

        OptionsImpl(BatchImpl statement) {
            super(statement);
        }

        OptionsImpl(BatchImpl statement, OptionsImpl os) {
            super(statement);
            os.usings.forEach(o -> this.usings.add(new UsingImpl(o, statement)));
        }

        public Batch.Options and(Using<?> using) {
            Validate.notNull(using, (String)"invalid null using", (Object[])new Object[0]);
            Validate.isTrue((boolean)(using instanceof UsingImpl), (String)"unsupported class of usings: %s", (Object[])new Object[]{using.getClass().getName()});
            this.usings.add(((UsingImpl)using).setStatement(this.statement));
            this.setDirty();
            return this;
        }

        public <R, F extends ListenableFuture<R>> Batch add(BatchableStatement<R, F> statement) {
            return ((BatchImpl)this.statement).add(statement);
        }

        public Batch add(RegularStatement statement) {
            return ((BatchImpl)this.statement).add(statement);
        }

        public Batch addErrorHandler(ERunnable<?> run) {
            return ((BatchImpl)this.statement).addErrorHandler(run);
        }
    }
}

