/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.impl.StatementManagerImpl;

public class CompoundResultSetFuture
extends DefaultResultSetFuture {
    private final ExecutionList executionList = new ExecutionList();
    private final List<ResultSetFuture> futures;
    private final BitSet called;

    public CompoundResultSetFuture(List<ResultSetFuture> futures, StatementManagerImpl mgr) {
        super(null, mgr.getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum(), null);
        ResultSetFuture rset;
        int i;
        Validate.notNull((Object)((Object)mgr), (String)"invalid null mgr", (Object[])new Object[0]);
        Validate.notNull(futures, (String)"invalid null result set futures", (Object[])new Object[0]);
        ArrayList<ResultSetFuture> rsets = new ArrayList<ResultSetFuture>(futures.size());
        this.called = new BitSet(futures.size());
        for (i = 0; i < futures.size(); ++i) {
            rset = futures.get(i);
            Validate.notNull((Object)rset, (String)"invalid null result set future", (Object[])new Object[0]);
            rsets.add(rset);
            this.called.set(i);
        }
        this.futures = rsets;
        i = 0;
        while (i < rsets.size()) {
            rset = (ResultSetFuture)rsets.get(i);
            final int index = i++;
            rset.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean execute = false;
                    try {
                        BitSet bitSet = CompoundResultSetFuture.this.called;
                        synchronized (bitSet) {
                            CompoundResultSetFuture.this.called.clear(index);
                            if (CompoundResultSetFuture.this.called.isEmpty()) {
                                execute = true;
                            }
                        }
                    }
                    finally {
                        if (execute) {
                            CompoundResultSetFuture.this.executionList.execute();
                        }
                    }
                }
            }, (Executor)mgr.getDirectExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        List<ResultSetFuture> list = this.futures;
        synchronized (list) {
            for (ResultSetFuture future : this.futures) {
                if (future.isDone()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        List<ResultSetFuture> list = this.futures;
        synchronized (list) {
            for (ResultSetFuture future : this.futures) {
                if (future.isCancelled()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = true;
        List<ResultSetFuture> list = this.futures;
        synchronized (list) {
            for (ResultSetFuture future : this.futures) {
                if (future.cancel(mayInterruptIfRunning)) continue;
                cancelled = false;
            }
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        long end = System.nanoTime() + unit.toNanos(timeout);
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(this.futures.size());
        List<ResultSetFuture> list = this.futures;
        synchronized (list) {
            for (ResultSetFuture future : this.futures) {
                ResultSet result = (ResultSet)future.get(end - System.nanoTime(), TimeUnit.NANOSECONDS);
                results.add(result);
            }
        }
        return new CompoundResultSet(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet get() throws InterruptedException, ExecutionException {
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(this.futures.size());
        List<ResultSetFuture> list = this.futures;
        synchronized (list) {
            for (ResultSetFuture future : this.futures) {
                results.add((ResultSet)future.get());
            }
        }
        return new CompoundResultSet(results);
    }

    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    private static class CompoundResultSet
    implements ResultSet {
        private final List<ResultSet> results;
        private int i = 0;

        CompoundResultSet(List<ResultSet> results) {
            this.results = results;
        }

        public ColumnDefinitions getColumnDefinitions() {
            return this.results.get(0).getColumnDefinitions();
        }

        public boolean isExhausted() {
            if (this.i >= this.results.size()) {
                return true;
            }
            ResultSet current = this.results.get(this.i);
            while (current.isExhausted()) {
                if (++this.i >= this.results.size()) {
                    return true;
                }
                current = this.results.get(this.i);
            }
            return false;
        }

        public Row one() {
            if (this.isExhausted()) {
                return null;
            }
            return this.results.get(this.i).one();
        }

        public List<Row> all() {
            if (this.isExhausted()) {
                return Collections.emptyList();
            }
            ArrayList<Row> rows = new ArrayList<Row>(this.results.get(this.i).all());
            while (!this.isExhausted()) {
                rows.addAll(this.results.get(this.i).all());
            }
            return rows;
        }

        public Iterator<Row> iterator() {
            return new Iterator<Row>(){

                @Override
                public boolean hasNext() {
                    return !this.isExhausted();
                }

                @Override
                public Row next() {
                    if (this.isExhausted()) {
                        throw new NoSuchElementException();
                    }
                    return ((ResultSet)results.get(i)).one();
                }
            };
        }

        public int getAvailableWithoutFetching() {
            ResultSet current;
            if (this.isExhausted()) {
                return 0;
            }
            int num = 0;
            int j = this.i;
            do {
                current = this.results.get(j);
                num += current.getAvailableWithoutFetching();
            } while (current.isFullyFetched() && ++j < this.results.size());
            return num;
        }

        public boolean isFullyFetched() {
            if (!this.isExhausted()) {
                int j = this.i;
                do {
                    if (this.results.get(j).isFullyFetched()) continue;
                    return false;
                } while (++j < this.results.size());
            }
            return true;
        }

        public ListenableFuture<Void> fetchMoreResults() {
            if (!this.isExhausted()) {
                int j = this.i;
                do {
                    ResultSet current;
                    if ((current = this.results.get(j)).isFullyFetched()) continue;
                    return current.fetchMoreResults();
                } while (++j < this.results.size());
            }
            return this.results.get(0).fetchMoreResults();
        }

        public ExecutionInfo getExecutionInfo() {
            if (this.isExhausted()) {
                return this.results.get(this.results.size() - 1).getExecutionInfo();
            }
            return this.results.get(this.i).getExecutionInfo();
        }

        public List<ExecutionInfo> getAllExecutionInfo() {
            return this.results.stream().flatMap(r -> r.getAllExecutionInfo().stream()).collect(Collectors.toList());
        }

        public boolean wasApplied() {
            return true;
        }
    }
}

