/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Clause;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.Truncate;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;

public class TruncateImpl<T>
extends GroupStatementImpl<Void, VoidFuture, T>
implements Truncate<T> {
    private final List<TableInfoImpl<T>> tables = new ArrayList<TableInfoImpl<T>>(8);
    private final WhereImpl<T> where;

    public TruncateImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        this(context, null, mgr, bridge);
    }

    public TruncateImpl(ClassInfoImpl.Context context, String[] tables, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        if (tables != null) {
            for (String table : tables) {
                if (table == null) continue;
                this.tables.add((TableInfoImpl)context.getClassInfo().getTable(table));
            }
        } else {
            this.tables.addAll(context.getClassInfo().getTablesImpl());
        }
        this.where = new WhereImpl(this);
    }

    private StringBuilder buildQueryString(TableInfoImpl<T> table) {
        StringBuilder builder = new StringBuilder();
        builder.append("TRUNCATE ");
        try {
            if (this.getKeyspace() != null) {
                Utils.appendName(this.getKeyspace(), builder).append(".");
            }
        }
        catch (ExcludedKeyspaceKeyException e) {
            return null;
        }
        Utils.appendName(table.getName(), builder);
        builder.append(';');
        return builder;
    }

    @Override
    protected final List<StatementImpl<?, ?, ?>> buildGroupedStatements() {
        return this.tables.stream().map(t -> this.buildQueryString((TableInfoImpl<T>)t)).filter(b -> b != null && b.length() != 0).map(b -> this.init(new SimpleStatementImpl(b.toString(), this.mgr, this.bridge))).collect(Collectors.toList());
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" TRUNCATE");
    }

    public Truncate.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public Truncate.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, TruncateImpl<T>>
    implements Truncate.Where<T> {
        WhereImpl(TruncateImpl<T> statement) {
            super(statement);
        }

        public Truncate.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a TRUCNATE statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((TruncateImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ((TruncateImpl)this.statement).getContext().addKeyspaceKey(c.getColumnName().toString(), c.firstValue());
                this.setDirty();
            }
            return this;
        }
    }
}

