/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.querybuilder.QueryBuilderBridge;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.RegularStatement;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;

public class SimpleStatementImpl
extends StatementImpl<ResultSet, ResultSetFuture, Void>
implements RegularStatement {
    private final String query;

    public SimpleStatementImpl(String query, StatementManagerImpl mgr, StatementBridge bridge) {
        super(ResultSet.class, (String)null, mgr, bridge);
        Validate.notNull((Object)query, (String)"invalid null query", (Object[])new Object[0]);
        this.query = query.trim();
    }

    public SimpleStatementImpl(com.datastax.driver.core.RegularStatement statement, StatementManagerImpl mgr, StatementBridge bridge) {
        super(ResultSet.class, statement instanceof SimpleStatement ? ((SimpleStatement)statement).getKeyspace() : QueryBuilderBridge.getKeyspace(statement), mgr, bridge);
        Validate.notNull((Object)statement, (String)"invalid null statement", (Object[])new Object[0]);
        this.query = statement.getQueryString().trim();
        this.setCounterOp(QueryBuilderBridge.isCounterOp(statement));
        this.init(statement);
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : (this.isBatch() ? StringUtils.countMatches((CharSequence)this.query, (char)';') : 1);
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        return new StringBuilder[]{new StringBuilder(this.query)};
    }

    @Override
    public String getQueryString() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.query;
    }

    public boolean isSelect() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.query, (CharSequence)"select");
    }

    public boolean isBatch() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.query, (CharSequence)"begin batch");
    }
}

