/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.ObjectNotFoundException;
import org.helenus.driver.StatementManager;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.FieldInfo;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Column;
import org.helenus.driver.persistence.Entity;
import org.helenus.driver.persistence.InitialObjects;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.KeyspaceKey;
import org.helenus.driver.persistence.Table;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;

public class ClassInfoImpl<T>
implements ClassInfo<T> {
    protected final Class<? extends Annotation> entityAnnotationClass;
    protected final Class<T> clazz;
    protected final Constructor<T> constructor;
    protected final Map<Field, Object> finalFields;
    private final Set<Method> initials;
    private final Keyspace keyspace;
    private final Map<String, TableInfoImpl<T>> tables;
    private final TableInfoImpl<T> primary;
    private final Set<String> columns;
    protected final Map<String, FieldInfoImpl<T>> keyspaceKeysByName;
    protected final Map<String, FieldInfoImpl<T>> keyspaceKeysByType;

    ClassInfoImpl(StatementManagerImpl mgr, Class<T> clazz, Class<? extends Annotation> entityAnnotationClass) {
        Validate.notNull(clazz, (String)"invalid null POJO class", (Object[])new Object[0]);
        this.columns = new LinkedHashSet<String>(25);
        this.tables = new LinkedHashMap<String, TableInfoImpl<T>>(12);
        this.keyspaceKeysByName = new LinkedHashMap<String, FieldInfoImpl<T>>(8);
        this.keyspaceKeysByType = new LinkedHashMap<String, FieldInfoImpl<T>>(8);
        this.entityAnnotationClass = entityAnnotationClass;
        this.clazz = clazz;
        this.constructor = this.findDefaultCtor(entityAnnotationClass);
        this.finalFields = this.findFinalFields();
        this.keyspace = this.findKeyspace();
        this.primary = this.findTables(mgr);
        this.findColumns();
        this.findKeyspaceKeys();
        this.initials = this.findInitials();
    }

    ClassInfoImpl(StatementManagerImpl mgr, Class<T> clazz) {
        this(mgr, clazz, Entity.class);
        Validate.isTrue((!Modifier.isAbstract(clazz.getModifiers()) ? 1 : 0) != 0, (String)"entity class '%s', cannot be abstract", (Object[])new Object[]{clazz.getSimpleName()});
    }

    ClassInfoImpl(ClassInfoImpl<T> cinfo, Class<T> clazz) {
        this.entityAnnotationClass = cinfo.entityAnnotationClass;
        this.clazz = clazz;
        this.constructor = cinfo.constructor;
        this.finalFields = cinfo.finalFields;
        this.keyspace = cinfo.keyspace;
        this.primary = cinfo.primary;
        this.columns = cinfo.columns;
        this.initials = cinfo.initials;
        this.tables = cinfo.tables;
        this.keyspaceKeysByName = cinfo.keyspaceKeysByName;
        this.keyspaceKeysByType = cinfo.keyspaceKeysByType;
    }

    private Constructor<T> findDefaultCtor(Class<? extends Annotation> entityAnnotationClass) {
        try {
            return ReflectionUtils.getSerializationConstructorFromAnnotation(this.clazz, entityAnnotationClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to access serialization constructor: " + this.clazz.getName() + "()", e);
        }
    }

    private Map<Field, Object> findFinalFields() {
        HashMap<Field, Object> ffields = new HashMap<Field, Object>(8);
        if (Modifier.isAbstract(this.clazz.getModifiers())) {
            return ffields;
        }
        MutableObject obj = null;
        for (Class<T> clazz = this.clazz; clazz != this.constructor.getDeclaringClass(); clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                int mods = field.getModifiers();
                if (!Modifier.isFinal(mods) || Modifier.isStatic(mods)) continue;
                field.setAccessible(true);
                if (obj == null) {
                    Throwable t;
                    try {
                        Constructor<T> ctor = this.clazz.getDeclaredConstructor(new Class[0]);
                        ctor.setAccessible(true);
                        t = ctor.newInstance(new Object[0]);
                        obj = new MutableObject((Object)t);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                        throw new IllegalArgumentException("unable to instantiate object: " + this.clazz.getName(), e);
                    }
                    catch (InvocationTargetException e) {
                        t = e.getTargetException();
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new IllegalArgumentException("unable to instantiate object: " + this.clazz.getName(), t);
                    }
                }
                try {
                    ffields.put(field, field.get(obj.getValue()));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("unable to access final value for field: " + field.getDeclaringClass().getName() + "." + field.getName(), e);
                }
            }
        }
        return ffields;
    }

    private Set<Method> findInitials() {
        Set<Method> initials = ReflectionUtils.getAllAnnotationsForMethodsAnnotatedWith(this.clazz, InitialObjects.class, (boolean)true).keySet();
        initials.forEach(m -> {
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new IllegalArgumentException("initial objects method '" + m.getName() + "' is not static in class: " + this.clazz.getSimpleName());
            }
            Class<?> type = m.getReturnType();
            if (type.isArray()) {
                Class<T> ctype = type.getComponentType();
                if (!ctype.isAssignableFrom(this.clazz)) {
                    throw new IllegalArgumentException("incompatible returned array of class '" + ctype.getName() + "' for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
            } else if (!this.clazz.isAssignableFrom(type)) {
                if (!(Collection.class.isAssignableFrom(type) || Stream.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type) || Enumeration.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type))) {
                    throw new IllegalArgumentException("incompatible returned class '" + type.getName() + "' for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
                Type rtype = m.getGenericReturnType();
                if (rtype instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)rtype;
                    if (ptype.getActualTypeArguments().length != 1) {
                        throw new IllegalArgumentException("incompatible returned type '" + ptype.getTypeName() + "' for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                    }
                    Class aclazz = ReflectionUtils.getRawClass((Type)ptype.getActualTypeArguments()[0]);
                    if (!this.clazz.isAssignableFrom(aclazz)) {
                        throw new IllegalArgumentException("incompatible returned type argument '" + aclazz.getName() + "' for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                    }
                } else {
                    throw new IllegalArgumentException("incompatible returned type '" + rtype.getTypeName() + "' for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
            }
            Class<?>[] cparms = m.getParameterTypes();
            if (this.keyspaceKeysByType.isEmpty()) {
                if (cparms.length != 0) {
                    throw new IllegalArgumentException("expecting no parameters for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
            } else {
                if (cparms.length != 1) {
                    throw new IllegalArgumentException("expecting one Map<String, String> parameter for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
                if (!Map.class.isAssignableFrom(cparms[0])) {
                    throw new IllegalArgumentException("expecting parameter for initial objects method '" + m.getName() + "' to be of type Map<String, String> in class: " + this.clazz.getSimpleName());
                }
                Type[] tparms = m.getGenericParameterTypes();
                if (tparms.length != 1) {
                    throw new IllegalArgumentException("expecting one Map<String, String> parameter for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
                if (tparms[0] instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)tparms[0];
                    for (Type atype : ptype.getActualTypeArguments()) {
                        Class aclazz = ReflectionUtils.getRawClass((Type)atype);
                        if (String.class == aclazz) continue;
                        throw new IllegalArgumentException("expecting a Map<String, String> parameter for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                    }
                } else {
                    throw new IllegalArgumentException("expecting a Map<String, String> parameter for initial objects method '" + m.getName() + "' in class: " + this.clazz.getSimpleName());
                }
            }
        });
        return initials;
    }

    private Keyspace findKeyspace() {
        Keyspace keyspace = this.clazz.getAnnotation(Keyspace.class);
        Validate.isTrue((keyspace != null ? 1 : 0) != 0, (String)"%s is not annotated with @Keyspace", (Object[])new Object[]{this.clazz.getSimpleName()});
        Validate.isTrue((!keyspace.name().isEmpty() || keyspace.keys().length != 0 ? 1 : 0) != 0, (String)"@Keyspace annotation for %s must defined at least one of 'name' or 'keys'", (Object[])new Object[]{this.clazz.getSimpleName()});
        return keyspace;
    }

    private TableInfoImpl<T> findTables(StatementManagerImpl mgr) {
        Map tables = ReflectionUtils.getAnnotationsByType(String.class, Table.class, this.clazz);
        TableInfoImpl primary = null;
        if (this instanceof UDTClassInfoImpl) {
            Validate.isTrue((boolean)tables.isEmpty(), (String)"%s is annotated with @Table", (Object[])new Object[]{this.clazz.getSimpleName()});
            UDTEntity ue = this.clazz.getAnnotation(UDTEntity.class);
            if (ue == null) {
                Validate.isTrue((ReflectionUtils.findFirstClassAnnotatedWith(this.clazz, UDTRootEntity.class) != null ? 1 : 0) != 0, (String)"class '%s' is not annotated with @UDTEntity or @UDTRootEntity", (Object[])new Object[]{this.clazz.getSimpleName()});
            }
            this.tables.put("udt", new TableInfoImpl(mgr, (UDTClassInfoImpl)this, "udt"));
        } else {
            Validate.isTrue((!tables.isEmpty() ? 1 : 0) != 0, (String)"%s is not annotated with @Table", (Object[])new Object[]{this.clazz.getSimpleName()});
            for (Table table : tables.values()) {
                TableInfoImpl tinfo = new TableInfoImpl(mgr, this, table);
                this.tables.put(tinfo.getName(), tinfo);
                if (!tinfo.getTable().primary()) continue;
                if (primary != null) {
                    throw new IllegalArgumentException("class '" + this.clazz.getSimpleName() + "' annotates 2 primary tables: '" + primary.getName() + "' and '" + tinfo.getName() + "'");
                }
                primary = tinfo;
            }
        }
        return primary;
    }

    private void findColumns() {
        for (Map.Entry e : ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(this.clazz, Column.class, (boolean)true).entrySet()) {
            for (Column column : (Column[])e.getValue()) {
                this.columns.add(column.name());
            }
        }
    }

    private void findKeyspaceKeys() {
        HashSet<String> kkeys = new HashSet<String>(this.keyspace.keys().length * 3 / 2);
        for (String s : this.keyspace.keys()) {
            kkeys.add(s);
        }
        KeyspaceKey[] keys = (KeyspaceKey[])this.clazz.getAnnotationsByType(KeyspaceKey.class);
        if (this instanceof UDTClassInfoImpl) {
            for (KeyspaceKey key : keys) {
                Validate.isTrue((!this.keyspaceKeysByType.containsKey(key.type()) ? 1 : 0) != 0, (String)"multiple @KeyspaceKey annotations found with type '%s' for class: %s", (Object[])new Object[]{key.type(), this.clazz.getSimpleName()});
                Validate.isTrue((!this.keyspaceKeysByName.containsKey(key.name()) ? 1 : 0) != 0, (String)"multiple @KeyspaceKey annotations found with name '%s' for class: %s", (Object[])new Object[]{key.name(), this.clazz.getSimpleName()});
                Validate.isTrue((boolean)kkeys.remove(key.type()), (String)"@Keyspace annotation does not define keyspace key type '%s' for class: %s", (Object[])new Object[]{key.type(), this.clazz.getSimpleName()});
                FieldInfoImpl field = new FieldInfoImpl(this, key);
                this.keyspaceKeysByName.put(key.name(), field);
                this.keyspaceKeysByType.put(key.type(), field);
            }
        } else {
            Validate.isTrue((keys.length == 0 ? 1 : 0) != 0, (String)"%s POJOs do not support @KeyspaceKey annotations on the type; define a field instead", (Object[])new Object[]{this.getEntityAnnotationClass().getSimpleName()});
            for (Field f : ReflectionUtils.getAllFieldsAnnotatedWith(this.clazz, KeyspaceKey.class, (boolean)true)) {
                FieldInfoImpl field = new FieldInfoImpl(this, f);
                KeyspaceKey key = field.getKeyspaceKey();
                Validate.isTrue((!this.keyspaceKeysByType.containsKey(key.type()) ? 1 : 0) != 0, (String)"multipe @KeyspaceKey annotations found with type '%s' for class: %s", (Object[])new Object[]{key.type(), this.clazz.getSimpleName()});
                Validate.isTrue((!this.keyspaceKeysByName.containsKey(key.name()) ? 1 : 0) != 0, (String)"multipe @KeyspaceKey annotations found with name '%s' for class: %s", (Object[])new Object[]{key.name(), this.clazz.getSimpleName()});
                Validate.isTrue((boolean)kkeys.remove(key.type()), (String)"@Keyspace annotation does not define keyspace key type '%s' for class: %s", (Object[])new Object[]{key.type(), this.clazz.getSimpleName()});
                this.keyspaceKeysByName.put(key.name(), field);
                this.keyspaceKeysByType.put(key.type(), field);
            }
        }
        Validate.isTrue((boolean)kkeys.isEmpty(), (String)"missing @KeyspaceKey annotations for @Keyspace defined keyspace keys: %s for class: %s", (Object[])new Object[]{StringUtils.join(kkeys, (String)", "), this.clazz.getSimpleName()});
    }

    private void setKeyspaceKeyFields(T object, Row row, Map<String, FieldInfoImpl<T>> map, Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            FieldInfoImpl<T> field = map.get(name);
            if (field == null) continue;
            try {
                field.setValue(object, value);
            }
            catch (IllegalArgumentException iae) {
                throw new ObjectConversionException(this.clazz, row, "unable to set '" + name + "' keyspace key in object", (Throwable)iae);
            }
        }
    }

    private void decodeAndSetColumnFields(T object, Row row) {
        for (ColumnDefinitions.Definition coldef : row.getColumnDefinitions()) {
            FieldInfoImpl<T> field;
            TableInfoImpl table = (TableInfoImpl)this.getTable(coldef.getTable());
            if (table == null || (field = table.getColumnImpl(coldef.getName())) == null) continue;
            field.decodeAndSetValue(object, row);
        }
    }

    private void validateColumn(Object name, boolean ignoreNonColumnNames) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                this.validateColumn(n2);
            }
            return;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                this.validateColumn(parm, true);
            }
            return;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            if (ignoreNonColumnNames) {
                return;
            }
            throw new IllegalArgumentException("unexpected column name '" + name + "'");
        }
        Validate.isTrue((boolean)this.columns.contains(n), (String)"%s doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
    }

    protected Stream<TableInfoImpl<T>> tablesImpl() {
        return this.tables.values().stream();
    }

    protected Collection<TableInfoImpl<T>> getTablesImpl() {
        return this.tables.values();
    }

    public Class<? extends Annotation> getEntityAnnotationClass() {
        return this.entityAnnotationClass;
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    public boolean supportsTablesAndIndexes() {
        return true;
    }

    public Stream<Class<? extends T>> objectClasses() {
        return Stream.of(this.clazz);
    }

    public Stream<ClassInfoImpl<? extends T>> classInfos() {
        return Stream.of(this);
    }

    public Stream<UDTClassInfoImpl<?>> udts() {
        return this.tables.values().stream().flatMap(t -> t.udts()).distinct();
    }

    public Object getDefaultValue(Field field) {
        Object dflt = this.finalFields.getOrDefault(field, this);
        Validate.isTrue((dflt != this ? 1 : 0) != 0, (String)"field '%s.%s' is not a valid final field for class '%s'", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName(), this.clazz});
        return dflt;
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public int getNumKeyspaceKeys() {
        return this.keyspaceKeysByType.size();
    }

    public FieldInfo<T> getKeyspaceKey(String name) {
        return this.keyspaceKeysByName.get(name);
    }

    public FieldInfo<T> getKeyspaceKeyByType(String type) {
        return this.keyspaceKeysByType.get(type);
    }

    public boolean isKeyspaceKey(String name) {
        FieldInfoImpl<T> field = this.keyspaceKeysByName.get(name);
        return field != null ? field.isKeyspaceKey() : false;
    }

    public Map<String, FieldInfoImpl<T>> getKeyspaceKeys() {
        return this.keyspaceKeysByName;
    }

    public Map<String, FieldInfoImpl<T>> getKeyspaceKeyTypes() {
        return this.keyspaceKeysByType;
    }

    public TableInfoImpl<T> getTableImpl(String name) {
        Validate.notNull((Object)name, (String)"invalid null table name", (Object[])new Object[0]);
        TableInfoImpl<T> tinfo = this.tables.get(name);
        if (tinfo == null) {
            tinfo = this.tables.get(TableInfoImpl.cleanName(name));
        }
        Validate.isTrue((tinfo != null ? 1 : 0) != 0, (String)"%s doesn't define table '%s'", (Object[])new Object[]{this.clazz.getName(), name});
        return tinfo;
    }

    public TableInfo<T> getTable(String name) {
        return this.getTableImpl(name);
    }

    public Optional<TableInfo<T>> getPrimaryTable() {
        return Optional.ofNullable(this.primary);
    }

    public Optional<TableInfo<T>> getAuditTable() {
        return this.tables.values().stream().filter(t -> Table.Type.AUDIT == t.getTable().type()).findAny();
    }

    public int getNumTables() {
        return this.tables.size();
    }

    public Collection<TableInfo<T>> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public Stream<TableInfo<T>> tables() {
        return this.tables.values().stream();
    }

    public Iterator<TableInfo<T>> iterator() {
        return this.getTables().iterator();
    }

    public Collection<String> getColumns() {
        return this.columns;
    }

    public Context newContext() {
        return new Context();
    }

    public POJOContext newContext(T object) {
        return new POJOContext(object);
    }

    public boolean isColumn(String name) {
        return this.columns.contains(name);
    }

    public void validateColumn(Object name) {
        this.validateColumn(name, false);
    }

    public void validateColumnOrKeyspaceKey(String name) {
        Validate.notNull((Object)name, (String)"invalid null column name or keyspace key", (Object[])new Object[0]);
        Validate.isTrue((this.columns.contains(name) || this.keyspaceKeysByName.containsKey(name) ? 1 : 0) != 0, (String)"%s doesn't define column or keyspace key '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), name});
    }

    public void validateColumns(Iterable<Object> names) {
        for (Object name : names) {
            this.validateColumn(name);
        }
    }

    public void validateColumns(String ... names) {
        for (String name : names) {
            this.validateColumn(name);
        }
    }

    public void validateColumnAndValue(String name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        FieldInfoImpl field = this.tables.values().stream().map(t -> t.getColumnImpl(name)).filter(f -> f != null).findAny().orElse(null);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"%s doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), name});
        field.validateValue(value);
    }

    public void validateKeyspaceKey(String name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null name", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"invalid null value", (Object[])new Object[0]);
        FieldInfoImpl<T> field = this.keyspaceKeysByName.get(name);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"%s doesn't define keyspace key: %s", (Object[])new Object[]{this.clazz.getSimpleName(), name});
        field.validateValue(value);
    }

    public T getObject(Row row, Map<String, Object> keyspaceKeys) {
        if (row == null) {
            return null;
        }
        Validate.notNull(keyspaceKeys, (String)"invalid null keyspace keys", (Object[])new Object[0]);
        try {
            Object object = this.constructor.newInstance(new Object[0]);
            this.finalFields.forEach((field, value) -> {
                try {
                    field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            });
            this.setKeyspaceKeyFields(object, row, this.keyspaceKeysByName, keyspaceKeys);
            this.decodeAndSetColumnFields(object, row);
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ObjectConversionException(this.clazz, row, "failed to instantiate blank POJO", t);
        }
    }

    public T getObject(UDTValue uval) {
        throw new ObjectConversionException(this.clazz, uval, this.getEntityAnnotationClass().getSimpleName() + " POJOs cannot be retrieved from UDT values");
    }

    public Collection<T> getInitialObjects(Map<String, String> keyspaceKeys) {
        if (this.initials.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<T> objs = new ArrayList<T>(16);
            for (Method initial : this.initials) {
                Object ret = this.keyspaceKeysByType.isEmpty() ? initial.invoke(null, new Object[0]) : initial.invoke(null, keyspaceKeys);
                if (ret == null) {
                    return Collections.emptyList();
                }
                Class<?> type = initial.getReturnType();
                if (type.isArray()) {
                    int l = Array.getLength(ret);
                    for (int i = 0; i < l; ++i) {
                        objs.add(this.clazz.cast(Array.get(ret, i)));
                    }
                    continue;
                }
                if (ret instanceof Collection) {
                    ((Collection)ret).forEach(o -> objs.add(this.clazz.cast(o)));
                    continue;
                }
                if (ret instanceof Stream) {
                    ((Stream)ret).forEach(o -> objs.add(this.clazz.cast(o)));
                    continue;
                }
                if (ret instanceof Iterator) {
                    Iterator i = (Iterator)ret;
                    while (i.hasNext()) {
                        objs.add(this.clazz.cast(i.next()));
                    }
                    continue;
                }
                if (ret instanceof Enumeration) {
                    Enumeration e = (Enumeration)ret;
                    while (e.hasMoreElements()) {
                        objs.add(this.clazz.cast(e.nextElement()));
                    }
                    continue;
                }
                if (ret instanceof Iterable) {
                    Iterator i = ((Iterable)ret).iterator();
                    while (i.hasNext()) {
                        objs.add(this.clazz.cast(i.next()));
                    }
                    continue;
                }
                objs.add(this.clazz.cast(ret));
            }
            return objs;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(t);
        }
    }

    public String toString() {
        return "ClassInfoImpl(clazz=" + this.clazz + ", keyspace=" + this.getKeyspace() + ", columns=" + this.getColumns() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassInfoImpl)) {
            return false;
        }
        ClassInfoImpl other = (ClassInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<T> this$clazz = this.clazz;
        Class<T> other$clazz = other.clazz;
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassInfoImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $clazz = this.clazz;
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public class POJOContext
    extends Context {
        protected final T object;

        public POJOContext(T object) {
            Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
            Validate.isTrue((boolean)ClassInfoImpl.this.clazz.isInstance(object), (String)"invalid POJO class '%s'; expecting '%s'", (Object[])new Object[]{object.getClass().getName(), ClassInfoImpl.this.clazz.getName()});
            this.object = object;
            this.populateKeyspaceKeys(ClassInfoImpl.this.keyspaceKeysByName);
        }

        protected void populateKeyspaceKeys(Map<String, FieldInfoImpl<T>> fields) {
            this.keyspaceKeys.clear();
            for (Map.Entry e : fields.entrySet()) {
                String name = e.getKey();
                FieldInfoImpl field = e.getValue();
                Object val = field.getValue(this.object);
                this.keyspaceKeys.put(name, val);
            }
        }

        public T getObject() {
            return this.object;
        }

        public Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getColumnValues(this.object);
        }

        public Map<String, Pair<Object, CQLDataType>> getPartitionKeyColumnValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getPartitionKeyColumnValues(this.object);
        }

        public Map<String, Pair<Object, CQLDataType>> getKeyspaceAndPartitionKeyColumnValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return this.getKeyspaceKeyValues();
            }
            return table.getKeyspaceAndPartitionKeyColumnValues(this.object);
        }

        public Map<String, Pair<Object, CQLDataType>> getPrimaryKeyColumnValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getPrimaryKeyColumnValues(this.object);
        }

        public Map<String, Pair<Object, CQLDataType>> getPrimaryKeyColumnValues(String tname, Map<String, Object> pkeys_override) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getPrimaryKeyColumnValues(this.object, pkeys_override);
        }

        public Map<String, Pair<Object, CQLDataType>> getKeyspaceKeyValues() {
            LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.keyspaceKeys.size());
            for (Map.Entry e : ClassInfoImpl.this.getKeyspaceKeys().entrySet()) {
                String name = e.getKey();
                FieldInfoImpl field = e.getValue();
                Object value = field.getValue(this.object);
                Validate.isTrue((value != null ? 1 : 0) != 0, (String)"missing keyspace key '%s'", (Object[])new Object[]{name});
                values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
            }
            return values;
        }

        public Map<String, Pair<Object, CQLDataType>> getKeyspaceAndPrimaryKeyColumnValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return this.getKeyspaceKeyValues();
            }
            return table.getKeyspaceAndPrimaryKeyColumnValues(this.object);
        }

        public Map<String, Pair<Object, CQLDataType>> getMandatoryAndPrimaryKeyColumnValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getMandatoryAndPrimaryKeyColumnValues(this.object);
        }

        public Map<String, Pair<Object, CQLDataType>> getNonPrimaryKeyColumnNonEncodedValues(String tname) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getNonPrimaryKeyColumnNonEncodedValues(this.object);
        }

        public Pair<Object, CQLDataType> getColumnNonEncodedValue(String tname, CharSequence name) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Pair.of(null, null);
            }
            return table.getColumnNonEncodedValue(this.object, name);
        }

        public Pair<Object, CQLDataType> getColumnValue(String tname, CharSequence name) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Pair.of(null, null);
            }
            return table.getColumnValue(this.object, name);
        }

        public Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname, Iterable<CharSequence> names) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getColumnValues(this.object, names);
        }

        public Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname, CharSequence ... names) {
            TableInfoImpl table = (TableInfoImpl)ClassInfoImpl.this.getTable(tname);
            if (table == null) {
                return Collections.emptyMap();
            }
            return table.getColumnValues(this.object, names);
        }

        public void addKeyspaceKey(String name) {
            Validate.notNull((Object)name, (String)"invalid null name", (Object[])new Object[0]);
            FieldInfoImpl field = ClassInfoImpl.this.keyspaceKeysByName.get(name);
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"%s doesn't define keyspace key: %s", (Object[])new Object[]{ClassInfoImpl.this.clazz.getSimpleName(), name});
            Object val = field.getValue(this.object);
            ClassInfoImpl.this.validateKeyspaceKey(name, val);
            this.keyspaceKeys.put(name, val);
        }
    }

    public class Context
    implements StatementManager.Context<T> {
        protected final Map<String, Object> keyspaceKeys = new LinkedHashMap<String, Object>(8);

        Context() {
        }

        public Class<T> getObjectClass() {
            return ClassInfoImpl.this.getObjectClass();
        }

        public ClassInfoImpl<T> getClassInfo() {
            return ClassInfoImpl.this;
        }

        public String getKeyspace() {
            Object[] types = ClassInfoImpl.this.keyspace.keys();
            String name = ClassInfoImpl.this.keyspace.name();
            if (!ArrayUtils.isEmpty((Object[])types)) {
                Object[] svalues = new String[types.length];
                for (int i = 0; i < types.length; ++i) {
                    FieldInfoImpl finfo = (FieldInfoImpl)ClassInfoImpl.this.getKeyspaceKeyByType((String)types[i]);
                    KeyspaceKey skey = finfo.getKeyspaceKey();
                    String key = skey.name();
                    Object value = this.keyspaceKeys.get(key);
                    if (value == null) {
                        throw new ObjectNotFoundException(this.getObjectClass(), "missing keyspace key '" + key + "'");
                    }
                    if (ArrayUtils.contains((Object[])skey.exclude(), (Object)value)) {
                        throw new ExcludedKeyspaceKeyException("excluded keyspace key '" + key + "' value '" + value + "' for object class: " + ClassInfoImpl.this.clazz.getName());
                    }
                    svalues[i] = String.valueOf(value);
                }
                String svalue = StringUtils.join((Object[])svalues, (char)'_');
                name = name.isEmpty() ? svalue : name + '_' + svalue;
            }
            if (name.isEmpty()) {
                throw new ObjectNotFoundException(this.getObjectClass(), "invalid empty keyspace name");
            }
            return name.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
        }

        public void addKeyspaceKey(String name, Object value) {
            ClassInfoImpl.this.validateKeyspaceKey(name, value);
            this.keyspaceKeys.put(name, value);
        }

        public T getObject(Row row) {
            return ClassInfoImpl.this.getObject(row, this.keyspaceKeys);
        }

        public T getObject(UDTValue uval) {
            return ClassInfoImpl.this.getObject(uval);
        }

        public Collection<T> getInitialObjects() {
            if (ClassInfoImpl.this.getKeyspaceKeys().isEmpty()) {
                return ClassInfoImpl.this.getInitialObjects(null);
            }
            LinkedHashMap<String, String> svalues = new LinkedHashMap<String, String>(ClassInfoImpl.this.getKeyspaceKeys().size());
            for (Map.Entry e : ClassInfoImpl.this.getKeyspaceKeyTypes().entrySet()) {
                String type = e.getKey();
                FieldInfoImpl finfo = e.getValue();
                String name = finfo.getKeyspaceKeyName();
                Object value = this.keyspaceKeys.get(name);
                Validate.isTrue((value != null ? 1 : 0) != 0, (String)"missing keyspace key '%s'", (Object[])new Object[]{name});
                svalues.put(type, String.valueOf(value));
            }
            return ClassInfoImpl.this.getInitialObjects(svalues);
        }
    }
}

