/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.Assignment;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.DataType;

public abstract class AssignmentImpl
extends Utils.Appendeable
implements Assignment {
    protected final CharSequence name;

    AssignmentImpl(CharSequence name) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        this.name = name;
    }

    CharSequence getColumnName() {
        return this.name;
    }

    abstract void validate(TableInfoImpl<?> var1);

    public String toString() {
        return "AssignmentImpl(name=" + this.name + ")";
    }

    static class MapPutAssignmentImpl
    extends AssignmentImpl {
        private final Object key;
        private final Object value;

        MapPutAssignmentImpl(CharSequence name, Object key, Object value) {
            super(name);
            this.key = key;
            this.value = value;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb).append("[");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendValue(this.key, finfo.getDataType().getFirstArgumentType(), sb);
            sb.append("]=");
            Utils.appendValue(finfo.encodeElementValue(this.value), finfo.getDataType().getElementType(), sb);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateMapColumnAndKeyValue(this.name, this.key, this.value);
        }

        @Override
        public String toString() {
            return "AssignmentImpl.MapPutAssignmentImpl(super=" + super.toString() + ", key=" + this.key + ", value=" + this.value + ")";
        }
    }

    static class CollectionAssignmentImpl
    extends AssignmentImpl {
        private final DataType ctype;
        private final Object collection;
        private final boolean isAdd;

        CollectionAssignmentImpl(DataType ctype, CharSequence name, Object collection, boolean isAdd) {
            super(name);
            this.ctype = ctype;
            this.collection = collection;
            this.isAdd = isAdd;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendName(this.name, sb).append(this.isAdd ? "+" : "-");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendCollection(finfo.encodeValue(this.collection), finfo.getDataType(), sb, null);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            if (this.ctype == DataType.MAP || this.ctype == DataType.SORTED_MAP) {
                table.validateMapColumnAndKeyValues(this.name, (Map)this.collection);
            } else {
                FieldInfoImpl<?> finfo = table.getColumnImpl(this.name);
                if (finfo != null && (finfo.getDataType().getMainType() == DataType.MAP || finfo.getDataType().getMainType() == DataType.SORTED_MAP)) {
                    table.validateMapColumnAndKeys(this.name, (Iterable)this.collection);
                } else if (this.ctype == DataType.SET || this.ctype == DataType.ORDERED_SET || this.ctype == DataType.SORTED_SET) {
                    table.validateSetColumnAndValues(this.name, (Iterable)this.collection);
                } else {
                    table.validateListColumnAndValues(this.name, (Iterable)this.collection);
                }
            }
        }

        @Override
        public String toString() {
            return "AssignmentImpl.CollectionAssignmentImpl(super=" + super.toString() + ", ctype=" + this.ctype + ", collection=" + this.collection + ", isAdd=" + this.isAdd + ")";
        }
    }

    static class ListSetIdxAssignmentImpl
    extends AssignmentImpl {
        private final int idx;
        private final Object value;

        ListSetIdxAssignmentImpl(CharSequence name, int idx, Object value) {
            super(name);
            this.idx = idx;
            this.value = value;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb).append("[").append(this.idx).append("]=");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendValue(finfo.encodeElementValue(this.value), finfo.getDataType(), sb);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateListColumnAndValue(this.name, this.value);
        }

        @Override
        public String toString() {
            return "AssignmentImpl.ListSetIdxAssignmentImpl(super=" + super.toString() + ", idx=" + this.idx + ", value=" + this.value + ")";
        }
    }

    static class ListPrependAssignmentImpl
    extends AssignmentImpl {
        private final List<?> value;

        ListPrependAssignmentImpl(CharSequence name, List<?> value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb).append("=");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendList((List)finfo.encodeValue(this.value), finfo.getDataType(), sb);
            sb.append("+");
            Utils.appendName(this.name, sb);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateListColumnAndValue(this.name, this.value);
        }

        @Override
        public String toString() {
            return "AssignmentImpl.ListPrependAssignmentImpl(super=" + super.toString() + ", value=" + this.value + ")";
        }
    }

    static class CounterAssignmentImpl
    extends AssignmentImpl {
        private final long value;
        private final boolean isIncr;

        CounterAssignmentImpl(CharSequence name, long value, boolean isIncr) {
            super(name);
            if (!isIncr && value < 0L) {
                this.value = -value;
                this.isIncr = true;
            } else {
                this.value = value;
                this.isIncr = isIncr;
            }
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb).append("=");
            Utils.appendName(this.name, sb).append(this.isIncr ? "+" : "-").append(this.value);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateCounterColumn(this.name);
        }

        @Override
        public String toString() {
            return "AssignmentImpl.CounterAssignmentImpl(super=" + super.toString() + ", value=" + this.value + ", isIncr=" + this.isIncr + ")";
        }
    }

    static class DelayedSetAllAssignmentImpl
    extends AssignmentImpl
    implements DelayedWithObject {
        final Object object;

        DelayedSetAllAssignmentImpl() {
            this((Object)null);
        }

        DelayedSetAllAssignmentImpl(Object object) {
            super("");
            this.object = object;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> table, ClassInfoImpl.POJOContext context) {
            ArrayList<AssignmentImpl> assignments = new ArrayList<AssignmentImpl>(25);
            if (this.object != null) {
                Validate.isTrue((boolean)context.getObjectClass().isInstance(this.object), (String)"setAll() object class '%s' is not compatible with POJO class '%s'", (Object[])new Object[]{this.object.getClass().getName(), context.getObjectClass().getName()});
                context = context.getClassInfo().newContext(this.object);
            }
            for (Map.Entry<String, Pair<Object, CQLDataType>> e : context.getNonPrimaryKeyColumnNonEncodedValues(table.getName()).entrySet()) {
                assignments.add(new SetAssignmentImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return assignments;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        public String toString() {
            return "AssignmentImpl.DelayedSetAllAssignmentImpl(super=" + super.toString() + ", object=" + this.object + ")";
        }
    }

    static class DelayedReplaceAssignmentImpl
    extends DelayedSetAssignmentImpl
    implements WithOldValue {
        protected volatile Object old;

        DelayedReplaceAssignmentImpl(CharSequence name, Object old) {
            super(name);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        DelayedReplaceAssignmentImpl(Object object, CharSequence name, Object old) {
            super(object, name);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        @Override
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> table, ClassInfoImpl.POJOContext context) {
            Pair<Object, CQLDataType> neval;
            if (this.object != null) {
                Validate.isTrue((boolean)context.getObjectClass().isInstance(this.object), (String)"setAll() object class '%s' is not compatible with POJO class '%s'", (Object[])new Object[]{this.object.getClass().getName(), context.getObjectClass().getName()});
                context = context.getClassInfo().newContext(this.object);
            }
            if (table.getColumnImpl(this.name) == null) {
                return Collections.emptyList();
            }
            try {
                neval = context.getColumnNonEncodedValue(table.getName(), this.name);
            }
            catch (EmptyOptionalPrimaryKeyException e) {
                neval = null;
            }
            return Arrays.asList(new ReplaceAssignmentImpl(this.name, neval, this.old));
        }

        @Override
        public Object getOldValue() {
            return this.old;
        }

        @Override
        public String toString() {
            return "AssignmentImpl.DelayedReplaceAssignmentImpl(super=" + super.toString() + ", old=" + this.old + ")";
        }
    }

    static class DelayedSetAssignmentImpl
    extends SetAssignmentImpl
    implements DelayedWithObject {
        final Object object;

        DelayedSetAssignmentImpl(CharSequence name) {
            this((Object)null, name);
        }

        DelayedSetAssignmentImpl(Object object, CharSequence name) {
            super(name);
            this.object = object;
        }

        @Override
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> table, ClassInfoImpl.POJOContext context) {
            if (this.object != null) {
                Validate.isTrue((boolean)context.getObjectClass().isInstance(this.object), (String)"setAll() object class '%s' is not compatible with POJO class '%s'", (Object[])new Object[]{this.object.getClass().getName(), context.getObjectClass().getName()});
                context = context.getClassInfo().newContext(this.object);
            }
            if (table.getColumnImpl(this.name) == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(new SetAssignmentImpl(this.name, context.getColumnNonEncodedValue(table.getName(), this.name)));
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        public String toString() {
            return "AssignmentImpl.DelayedSetAssignmentImpl(super=" + super.toString() + ", object=" + this.object + ")";
        }
    }

    static class PreviousAssignmentImpl
    extends AssignmentImpl
    implements WithOldValue {
        protected volatile Object old;

        PreviousAssignmentImpl(CharSequence name, Object old) {
            super(name);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateColumnAndValue(this.name, this.old, true);
        }

        @Override
        public Object getOldValue() {
            return this.old;
        }

        @Override
        public String toString() {
            return "AssignmentImpl.PreviousAssignmentImpl(super=" + super.toString() + ", old=" + this.old + ")";
        }
    }

    static class ReplaceAssignmentImpl
    extends SetAssignmentImpl
    implements WithOldValue {
        protected volatile Object old;

        ReplaceAssignmentImpl(CharSequence name, Object value, Object old) {
            super(name, value);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        ReplaceAssignmentImpl(CharSequence name, Pair<Object, CQLDataType> pvalue, Object old) {
            super(name, pvalue);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            super.validate(table);
            table.validateColumnAndValue(this.name, this.old, true);
        }

        @Override
        public Object getOldValue() {
            return this.old;
        }

        @Override
        public String toString() {
            return "AssignmentImpl.ReplaceAssignmentImpl(super=" + super.toString() + ", old=" + this.old + ")";
        }
    }

    static class SetAssignmentImpl
    extends AssignmentImpl {
        protected volatile Object value;
        private final CQLDataType definition;

        SetAssignmentImpl(CharSequence name) {
            this(name, null, null);
        }

        SetAssignmentImpl(CharSequence name, Object value) {
            this(name, value, null);
        }

        SetAssignmentImpl(CharSequence name, Pair<Object, CQLDataType> pvalue) {
            super(name);
            if (pvalue != null) {
                Object value = pvalue.getLeft();
                if (value instanceof Optional) {
                    value = ((Optional)value).orElse(null);
                }
                this.value = value;
                this.definition = (CQLDataType)pvalue.getRight();
            } else {
                this.value = null;
                this.definition = null;
            }
        }

        SetAssignmentImpl(CharSequence name, Object value, CQLDataType definition) {
            super(name);
            if (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            this.value = value;
            this.definition = definition;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb);
            sb.append("=");
            FieldInfoImpl<?> field = tinfo.getColumnImpl(this.name);
            Utils.appendValue(field.encodeValue(this.value), (CQLDataType)(this.definition != null ? this.definition : field.getDataType()), sb);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateColumnAndValue(this.name, this.value);
        }

        Object getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return "AssignmentImpl.SetAssignmentImpl(super=" + super.toString() + ", value=" + this.getValue() + ", definition=" + this.definition + ")";
        }
    }

    static interface WithOldValue {
        public Object getOldValue();
    }

    static interface DelayedWithObject {
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> var1, ClassInfoImpl.POJOContext var2);
    }
}

