/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.Row;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.AlterSchema;
import org.helenus.driver.Clause;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.GroupableStatement;
import org.helenus.driver.ParentStatement;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.AlterCreateKeyspaceImpl;
import org.helenus.driver.impl.AlterCreateTableImpl;
import org.helenus.driver.impl.AlterCreateTypeImpl;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.CreateIndexImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupImpl;
import org.helenus.driver.impl.SequenceImpl;
import org.helenus.driver.impl.SequenceStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.Table;

public class AlterSchemaImpl<T>
extends SequenceStatementImpl<Void, VoidFuture, T>
implements AlterSchema<T> {
    private final WhereImpl<T> where = new WhereImpl(this);

    public AlterSchemaImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
    }

    protected void buildSequencedStatements(Set<Pair<String, Keyspace>> keyspaces, Map<Pair<String, Keyspace>, Set<Table>> tables, GroupImpl kgroup, GroupImpl tgroup, GroupImpl igroup, SequenceImpl yseq, GroupImpl group) {
        String ks;
        if (!this.isEnabled()) {
            return;
        }
        try {
            ks = this.getKeyspace();
        }
        catch (ExcludedKeyspaceKeyException e) {
            return;
        }
        Keyspace keyspace = this.getContext().getClassInfo().getKeyspace();
        Pair pk = Pair.of((Object)ks, (Object)keyspace);
        if (keyspaces == null || !keyspaces.contains(keyspace)) {
            AlterCreateKeyspaceImpl ak = this.init(new AlterCreateKeyspaceImpl(this.getContext(), this.mgr, this.bridge));
            kgroup.add(ak);
            if (keyspaces != null) {
                keyspaces.add((Pair<String, Keyspace>)pk);
            }
        }
        if (this.getClassInfo().supportsTablesAndIndexes()) {
            boolean alterTable = true;
            if (tables != null) {
                alterTable = false;
                for (TableInfoImpl table : this.getContext().getClassInfo().getTablesImpl()) {
                    Set<Table> stables = tables.get(keyspace);
                    if (stables == null) {
                        stables = new HashSet<Table>(8);
                        tables.put((Pair<String, Keyspace>)pk, stables);
                    }
                    if (!stables.add(table.getTable())) continue;
                    alterTable = true;
                }
            }
            if (alterTable) {
                AlterCreateTableImpl at = this.init(new AlterCreateTableImpl(this.getContext(), this.mgr, this.bridge));
                at.buildGroupedStatements().forEach(s -> tgroup.addInternal((StatementImpl<?, ?, ?>)s));
                for (Map.Entry<String, List<Row>> e : at.getTableInfos().entrySet()) {
                    e.getValue().stream().map(r -> r.getString(4)).filter(i -> i != null).distinct().forEach(i -> {
                        StringBuilder builder = new StringBuilder("DROP INDEX ");
                        if (this.getKeyspace() != null) {
                            Utils.appendName(this.getKeyspace(), builder).append('.');
                        }
                        Utils.appendName(i, builder);
                        builder.append(';');
                        tgroup.add(new SimpleStatementImpl(builder.toString(), this.mgr, this.bridge));
                    });
                }
                igroup.add((GroupableStatement)this.init(new CreateIndexImpl(this.getContext(), null, null, this.mgr, this.bridge)));
            }
        } else {
            AlterCreateTypeImpl at = this.init(new AlterCreateTypeImpl(this.getContext(), this.mgr, this.bridge));
            yseq.add(at);
        }
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" ALTER");
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("SCHEMA");
    }

    @Override
    protected List<StatementImpl<?, ?, ?>> buildSequencedStatements() {
        GroupImpl kgroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        GroupImpl tgroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        GroupImpl igroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        SequenceImpl yseq = this.init(new SequenceImpl(Optional.empty(), new SequenceableStatement[0], this.mgr, this.bridge));
        GroupImpl group = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        this.buildSequencedStatements(null, null, kgroup, tgroup, igroup, yseq, group);
        return Stream.of(kgroup, yseq, tgroup, igroup, group).filter(g -> !((ParentStatement)g).isEmpty()).collect(Collectors.toList());
    }

    public Set<Class<?>> getObjectClasses() {
        return this.getContext().getClassInfo().objectClasses().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<ClassInfo<?>> getClassInfos() {
        return this.getContext().getClassInfo().classInfos().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public AlterSchema.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public AlterSchema.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, AlterSchemaImpl<T>>
    implements AlterSchema.Where<T> {
        WhereImpl(AlterSchemaImpl<T> statement) {
            super(statement);
        }

        public AlterSchema.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE SCHEMA statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((AlterSchemaImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ((AlterSchemaImpl)this.statement).getContext().addKeyspaceKey(c.getColumnName().toString(), c.firstValue());
                this.setDirty();
            }
            return this;
        }
    }
}

