/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.DataTypeParser;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.CreateTypeImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;

public class AlterCreateTypeImpl<T>
extends CreateTypeImpl<T> {
    public AlterCreateTypeImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(context, mgr, bridge);
        this.ifNotExists();
    }

    @Override
    protected StringBuilder[] buildQueryStrings(UDTClassInfoImpl<T> ucinfo) {
        TableInfoImpl<T> table = ucinfo.getTableImpl();
        Row row = this.mgr.getSession().executeAsync((Statement)new SimpleStatement("SELECT field_names,field_types FROM system.schema_usertypes WHERE keyspace_name='" + this.getKeyspace() + "' and type_name='" + ucinfo.getName() + "' LIMIT 1")).getUninterruptibly().one();
        if (row == null) {
            return super.buildQueryStrings(ucinfo);
        }
        HashMap<String, CQLDataType> columns = new HashMap<String, CQLDataType>(table.getColumns().size() * 3 / 2);
        for (FieldInfoImpl<T> field : table.getColumnsImpl()) {
            if (field.isTypeKey() && ucinfo instanceof UDTTypeClassInfoImpl) continue;
            columns.put(field.getColumnName(), field.getDataType());
        }
        List names0 = row.getList(0, String.class);
        List utypes0 = row.getList(1, String.class);
        ArrayList<String> columns0 = new ArrayList<String>(names0.size());
        for (int i = 0; i < names0.size(); ++i) {
            String name0 = (String)names0.get(i);
            String utype0 = (String)utypes0.get(i);
            CQLDataType type = (CQLDataType)columns.remove(name0);
            if (type == null) continue;
            CQLDataType type0 = DataTypeParser.typeToCQL(utype0);
            String type0_cql = type0.toCQL();
            String type_cql = type.toCQL();
            if (type_cql.equals(type0_cql)) continue;
            Validate.isTrue((boolean)type0.isAlterableTo(type), (String)"column '%s' for udt entity '%s' cannot be altered from %s to %s", (Object[])new Object[]{name0, this.getObjectClass().getName(), type0_cql, type_cql});
            columns0.add("ALTER " + name0 + " TYPE " + type_cql);
        }
        columns.forEach((n, t) -> columns0.add("ADD " + n + " " + t.toCQL()));
        if (columns.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TYPE ");
        if (this.getKeyspace() != null) {
            Utils.appendName(this.getKeyspace(), builder).append(".");
        }
        Utils.appendName(ucinfo.getName(), builder);
        builder.append(' ');
        return (StringBuilder[])columns0.stream().map(inst -> new StringBuilder(builder).append((String)inst)).toArray(StringBuilder[]::new);
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" ALTER TYPE");
    }
}

