/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.info.TypeClassInfo;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.RootEntity;
import org.helenus.driver.persistence.Table;
import org.helenus.driver.persistence.TypeEntity;

public class TypeClassInfoImpl<T>
extends ClassInfoImpl<T>
implements TypeClassInfo<T> {
    private final RootClassInfoImpl<? super T> rinfo;
    private final String type;
    private final boolean dynamic;

    TypeClassInfoImpl(StatementManagerImpl mgr, RootClassInfoImpl<? super T> rinfo, Class<T> clazz, boolean dynamic) {
        super(mgr, clazz, RootEntity.class);
        Validate.isTrue((!Modifier.isAbstract(clazz.getModifiers()) ? 1 : 0) != 0, (String)"type entity class '%s', cannot be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.type = this.findType();
        this.rinfo = rinfo;
        this.dynamic = dynamic;
        this.validate(rinfo.getObjectClass());
    }

    private String findType() {
        TypeEntity te = this.clazz.getAnnotation(TypeEntity.class);
        Validate.isTrue((te != null ? 1 : 0) != 0, (String)"class '%s' is not annotated with @TypeEntity", (Object[])new Object[]{this.clazz.getSimpleName()});
        return te.name();
    }

    private void validate(Class<? super T> rclazz) {
        this.getKeyspaceKeys().forEach((n, f) -> Validate.isTrue((boolean)rclazz.equals(f.getDeclaringClass()), (String)"@PartitionKey annotation with name '%s' is not defined in root element class '%s' for type class: %s; found in class: %s", (Object[])new Object[]{n, rclazz.getSimpleName(), this.clazz.getSimpleName(), f.getDeclaringClass().getSimpleName()}));
        this.tablesImpl().forEach(t -> {
            Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Keyspace.class).isAssignableFrom(rclazz), (String)"@Keyspace annotation is not defined in root element class '%s' for type class: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
            Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Table.class).isAssignableFrom(rclazz), (String)"@Table annotation is not defined in root element class '%s' for type class: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
            t.getPartitionKeys().forEach(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@PartitionKey annotation with name '%s' is not defined in root element class '%s' for type class: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
            t.getClusteringKeys().forEach(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@ClusteringKey annotation with name '%s' is not defined in root element class '%s' for type class: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
            t.getTypeKey().ifPresent(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@TypeKey annotation with name '%s' is not defined in root element class '%s' for type class: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
            t.getIndexes().forEach(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@Index annotation with name '%s' is not defined in root element class '%s' for type class: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
        });
    }

    public RootClassInfoImpl<? super T> getRoot() {
        return this.rinfo;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public ClassInfoImpl.POJOContext newContextFromRoot(Object object) {
        try {
            return this.newContext(this.clazz.cast(object));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public T getObject(Row row, String type, Map<String, Object> kkeys) {
        if (row != null) {
            if (this.type.equals(type)) {
                return super.getObject(row, kkeys);
            }
            TypeClassInfo tinfo = this.rinfo.getType(type);
            if (this.clazz.isAssignableFrom(tinfo.getObjectClass())) {
                return tinfo.getObject(row, type, kkeys);
            }
        }
        return null;
    }

    @Override
    public T getObject(Row row, Map<String, Object> kkeys) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions cdefs = row.getColumnDefinitions();
        for (TableInfoImpl table : this.getTablesImpl()) {
            int i;
            FieldInfoImpl field = table.getTypeKey().orElse(null);
            if (field == null || (i = cdefs.getIndexOf(field.getColumnName())) == -1 || !table.getName().equals(cdefs.getTable(i))) continue;
            String type = Objects.toString(field.decodeValue(row), null);
            if (type == null) break;
            return this.getObject(row, type, kkeys);
        }
        throw new ObjectConversionException(this.clazz, row, "missing POJO type column");
    }

    @Override
    public String toString() {
        return "TypeClassInfoImpl(super=" + super.toString() + ", type=" + this.getType() + ", dynamic=" + this.isDynamic() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeClassInfoImpl)) {
            return false;
        }
        TypeClassInfoImpl other = (TypeClassInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return this.isDynamic() == other.isDynamic();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TypeClassInfoImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + (this.isDynamic() ? 79 : 97);
        return result;
    }
}

