/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.DataDecoder;
import org.helenus.driver.impl.PersistedList;
import org.helenus.driver.impl.PersistedMap;
import org.helenus.driver.impl.PersistedNavigableMap;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.PersistedOrderedSet;
import org.helenus.driver.impl.PersistedSet;
import org.helenus.driver.impl.PersistedSortedSet;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Column;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;

public class DataTypeImpl {
    private static final Map<DataType, DataDecoder<?>[]> decoders = new EnumMap<DataType, DataDecoder<?>[]>(DataType.class);

    private static void init(DataType type, DataDecoder<?> ... decoders) {
        DataTypeImpl.decoders.put(type, decoders);
    }

    public static Class<?> unwrapOptionalIfPresent(Class<?> clazz, Type type) {
        if (Optional.class.isAssignableFrom(clazz) && type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type atype = ptype.getActualTypeArguments()[0];
            return ReflectionUtils.getRawClass((Type)atype);
        }
        return clazz;
    }

    private static DataDecoder<?> getDecoder(DataType type, Class<?> clazz) {
        DataDecoder<?>[] decoders = DataTypeImpl.decoders.get(type);
        if (decoders.length == 1) {
            return decoders[0];
        }
        for (DataDecoder<?> decoder : decoders) {
            if (!decoder.canDecodeTo(clazz)) continue;
            return decoder;
        }
        return null;
    }

    private static void inferDataTypeFrom(Field field, Class<?> clazz, List<CQLDataType> types) {
        DataTypeImpl.inferDataTypeFrom("field: " + field.getDeclaringClass().getName() + "." + field.getName(), field.getGenericType(), clazz, types, field.getAnnotation(Persisted.class));
    }

    private static void inferDataTypeFrom(Class<?> clazz, List<CQLDataType> types) {
        DataTypeImpl.inferDataTypeFrom("class: " + clazz.getName(), clazz.getGenericSuperclass(), clazz.getSuperclass(), types, clazz.getAnnotation(Persisted.class));
    }

    private static void inferDataTypeFrom(String trace, Type type, Class<?> clazz, List<CQLDataType> types, Persisted persisted) {
        boolean isUDT;
        boolean bl = isUDT = clazz.getAnnotation(UDTEntity.class) != null || ReflectionUtils.findFirstClassAnnotatedWith(clazz, UDTRootEntity.class) != null;
        if (Optional.class.isAssignableFrom(clazz)) {
            Validate.isTrue((!isUDT && types.isEmpty() ? 1 : 0) != 0, (String)"collection of optionals is not supported in %s", (Object[])new Object[]{trace});
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type atype = ptype.getActualTypeArguments()[0];
                if (persisted != null) {
                    types.add((CQLDataType)persisted.as());
                } else {
                    DataTypeImpl.inferBasicDataTypeFrom(trace, ReflectionUtils.getRawClass((Type)atype), types, persisted);
                }
                return;
            }
        } else if (List.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types, persisted);
                return;
            }
            Validate.isTrue((boolean)types.isEmpty(), (String)"collection of collections is not supported in %s", (Object[])new Object[]{trace});
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type atype = ptype.getActualTypeArguments()[0];
                types.add((CQLDataType)DataType.LIST);
                if (persisted != null) {
                    types.add((CQLDataType)persisted.as());
                } else {
                    DataTypeImpl.inferDataTypeFrom(trace, type, ReflectionUtils.getRawClass((Type)atype), types, persisted);
                }
                return;
            }
        } else if (Set.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types, persisted);
                return;
            }
            Validate.isTrue((boolean)types.isEmpty(), (String)"collection of collections is not supported in %s", (Object[])new Object[]{trace});
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type atype = ptype.getActualTypeArguments()[0];
                types.add((CQLDataType)(LinkedHashSet.class.isAssignableFrom(clazz) ? DataType.ORDERED_SET : DataType.SET));
                if (persisted != null) {
                    types.add((CQLDataType)persisted.as());
                } else {
                    DataTypeImpl.inferDataTypeFrom(trace, type, ReflectionUtils.getRawClass((Type)atype), types, persisted);
                }
                return;
            }
        } else if (SortedMap.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types, persisted);
                return;
            }
            Validate.isTrue((boolean)types.isEmpty(), (String)"collection of collections is not supported in %s", (Object[])new Object[]{trace});
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type ktype = ptype.getActualTypeArguments()[0];
                Type vtype = ptype.getActualTypeArguments()[1];
                types.add((CQLDataType)DataType.SORTED_MAP);
                DataTypeImpl.inferDataTypeFrom(trace, type, ReflectionUtils.getRawClass((Type)ktype), types, null);
                if (persisted != null) {
                    types.add((CQLDataType)persisted.as());
                } else {
                    DataTypeImpl.inferDataTypeFrom(trace, type, ReflectionUtils.getRawClass((Type)vtype), types, persisted);
                }
                return;
            }
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (isUDT) {
                DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types, persisted);
                return;
            }
            Validate.isTrue((boolean)types.isEmpty(), (String)"collection of collections is not supported in %s", (Object[])new Object[]{trace});
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type ktype = ptype.getActualTypeArguments()[0];
                Type vtype = ptype.getActualTypeArguments()[1];
                types.add((CQLDataType)DataType.MAP);
                DataTypeImpl.inferDataTypeFrom(trace, type, ReflectionUtils.getRawClass((Type)ktype), types, null);
                if (persisted != null) {
                    types.add((CQLDataType)persisted.as());
                } else {
                    DataTypeImpl.inferDataTypeFrom(trace, type, ReflectionUtils.getRawClass((Type)vtype), types, persisted);
                }
                return;
            }
        }
        DataTypeImpl.inferBasicDataTypeFrom(trace, clazz, types, persisted);
    }

    private static void inferBasicDataTypeFrom(String trace, Class<?> clazz, List<CQLDataType> types, Persisted persisted) {
        clazz = ClassUtils.primitiveToWrapper(clazz);
        if (persisted != null) {
            types.add((CQLDataType)persisted.as());
        } else if (String.class == clazz) {
            types.add((CQLDataType)DataType.TEXT);
        } else if (Integer.class == clazz) {
            types.add((CQLDataType)DataType.INT);
        } else if (Long.class == clazz) {
            types.add((CQLDataType)DataType.BIGINT);
        } else if (Boolean.class == clazz) {
            types.add((CQLDataType)DataType.BOOLEAN);
        } else if (Date.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.TIMESTAMP);
        } else if (Double.class == clazz) {
            types.add((CQLDataType)DataType.DOUBLE);
        } else if (Float.class == clazz) {
            types.add((CQLDataType)DataType.FLOAT);
        } else if (UUID.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.UUID);
        } else if (clazz.isArray() && Byte.TYPE == clazz.getComponentType() || ByteBuffer.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.BLOB);
        } else if (BigDecimal.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.DECIMAL);
        } else if (BigInteger.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.VARINT);
        } else if (InetAddress.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.INET);
        } else if (AtomicLong.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.COUNTER);
        } else if (clazz.isEnum()) {
            types.add((CQLDataType)DataType.ASCII);
        } else if (Class.class == clazz) {
            types.add((CQLDataType)DataType.ASCII);
        } else if (Locale.class == clazz) {
            types.add((CQLDataType)DataType.ASCII);
        } else if (ZoneId.class.isAssignableFrom(clazz)) {
            types.add((CQLDataType)DataType.ASCII);
        } else if (Instant.class == clazz) {
            types.add((CQLDataType)DataType.TIMESTAMP);
        } else {
            try {
                ClassInfoImpl cinfo = (ClassInfoImpl)StatementBuilder.getClassInfo((Class)clazz);
                Validate.isTrue((boolean)(cinfo instanceof UDTClassInfoImpl), (String)"unable to infer data type in %s", (Object[])new Object[]{trace});
                types.add((UDTClassInfoImpl)cinfo);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("unable to infer data type in " + trace, e);
            }
        }
    }

    public static Definition inferDataTypeFrom(Field field) {
        Column.Data cdata;
        Validate.notNull((Object)field, (String)"invalid null field", (Object[])new Object[0]);
        Persisted persisted = field.getAnnotation(Persisted.class);
        if (persisted == null && (cdata = field.getAnnotation(Column.Data.class)) != null) {
            ArrayList<CQLDataType> itypes = new ArrayList<CQLDataType>(3);
            DataType type = cdata.type();
            ArrayList<DataType> atypes = new ArrayList<DataType>(Arrays.asList(cdata.arguments()));
            if (!atypes.isEmpty() && type == DataType.INFERRED) {
                DataTypeImpl.inferDataTypeFrom(field, field.getType(), itypes);
                Validate.isTrue((boolean)(itypes.get(0) instanceof DataType), (String)"missing data type value in field: %s.%s", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
                type = (DataType)itypes.get(0);
            }
            if (type != DataType.INFERRED) {
                Validate.isTrue((atypes.size() >= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"missing argument data type(s) for '%s' in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                Validate.isTrue((type.NUM_ARGUMENTS != 0 || atypes.size() == 0 ? 1 : 0) != 0, (String)"data type '%s' is not a collection in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                Validate.isTrue((atypes.size() <= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"too many argument data type(s) for '%s' in field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
                if (type.NUM_ARGUMENTS != 0) {
                    Validate.isTrue((((DataType)atypes.get((int)0)).NUM_ARGUMENTS == 0 ? 1 : 0) != 0, (String)"collection of collection is not supported in field: %s.%s", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
                    Validate.isTrue((type.NUM_ARGUMENTS <= 1 || ((DataType)atypes.get((int)1)).NUM_ARGUMENTS == 0 ? 1 : 0) != 0, (String)"map of collection is not supported in field: %s.%s", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
                    if ((DataType)atypes.get(0) == DataType.INFERRED || type.NUM_ARGUMENTS > 1 && (DataType)atypes.get(1) == DataType.INFERRED) {
                        if (itypes.isEmpty()) {
                            DataTypeImpl.inferDataTypeFrom(field, field.getType(), itypes);
                        }
                        for (int i = 0; i < atypes.size(); ++i) {
                            if (atypes.get(i) != DataType.INFERRED) continue;
                            atypes.set(i, (DataType)itypes.get(i + 1));
                        }
                    }
                }
                return new Definition(type, atypes);
            }
        }
        if ((cdata = field.getAnnotation(Column.Data.class)) != null) {
            DataType type = cdata.type();
            if (type == DataType.BLOB) {
                return new Definition(DataType.BLOB, new DataType[0]);
            }
            Validate.isTrue((type == DataType.INFERRED ? 1 : 0) != 0, (String)"unsupported data type '%s' in @Persisted annotated field: %s.%s", (Object[])new Object[]{type.CQL, field.getDeclaringClass().getName(), field.getName()});
        }
        ArrayList<CQLDataType> types = new ArrayList<CQLDataType>(3);
        DataTypeImpl.inferDataTypeFrom(field, field.getType(), types);
        return new Definition(types);
    }

    public static Definition inferDataTypeFrom(DataType type, Class<?> clazz) {
        UDTEntity.Data cdata;
        Validate.notNull((Object)type, (String)"invalid null type", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.isTrue((type.NUM_ARGUMENTS != 0 ? 1 : 0) != 0, (String)"data type '%s' is not a collection in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
        Persisted persisted = clazz.getAnnotation(Persisted.class);
        if (persisted == null && (cdata = clazz.getAnnotation(UDTEntity.Data.class)) != null) {
            ArrayList<DataType> atypes = new ArrayList<DataType>(Arrays.asList(cdata.arguments()));
            Validate.isTrue((atypes.size() >= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"missing argument data type(s) for '%s' in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
            Validate.isTrue((atypes.size() <= type.NUM_ARGUMENTS ? 1 : 0) != 0, (String)"too many argument data type(s) for '%s' in class: %s", (Object[])new Object[]{type.CQL, clazz.getName()});
            if (type.NUM_ARGUMENTS != 0) {
                Validate.isTrue((((DataType)atypes.get((int)0)).NUM_ARGUMENTS == 0 ? 1 : 0) != 0, (String)"collection of collection is not supported in class: %s", (Object[])new Object[]{clazz.getName()});
                Validate.isTrue((type.NUM_ARGUMENTS <= 1 || ((DataType)atypes.get((int)1)).NUM_ARGUMENTS == 0 ? 1 : 0) != 0, (String)"map of collection is not supported in class: %s", (Object[])new Object[]{clazz.getName()});
                if ((DataType)atypes.get(0) == DataType.INFERRED || type.NUM_ARGUMENTS > 1 && (DataType)atypes.get(1) == DataType.INFERRED) {
                    ArrayList<CQLDataType> types = new ArrayList<CQLDataType>(3);
                    DataTypeImpl.inferDataTypeFrom(clazz, types);
                    for (int i = 0; i < atypes.size(); ++i) {
                        if (atypes.get(i) != DataType.INFERRED) continue;
                        atypes.set(i, (DataType)types.get(i + 1));
                    }
                }
            }
            return new Definition(type, atypes);
        }
        ArrayList<CQLDataType> types = new ArrayList<CQLDataType>(3);
        DataTypeImpl.inferDataTypeFrom(clazz, types);
        return new Definition(types);
    }

    public static boolean isAssignableFrom(CQLDataType type, Class<?> clazz) {
        if (type.isUserDefined()) {
            return ((UDTClassInfoImpl)type).getObjectClass().isAssignableFrom(clazz);
        }
        for (DataDecoder<?> decoder : decoders.get(type)) {
            if (!decoder.canDecodeTo(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(CQLDataType type, Object object) {
        return object != null ? DataTypeImpl.isAssignableFrom(type, object.getClass()) : true;
    }

    static {
        DataTypeImpl.init(DataType.ASCII, DataDecoder.asciiToEnum, DataDecoder.asciiToClass, DataDecoder.asciiToLocale, DataDecoder.asciiToZoneId, DataDecoder.asciiToString);
        DataTypeImpl.init(DataType.BIGINT, DataDecoder.bigintToLong);
        DataTypeImpl.init(DataType.BLOB, DataDecoder.blobToByteArray, DataDecoder.blobToByteBuffer);
        DataTypeImpl.init(DataType.BOOLEAN, DataDecoder.booleanToBoolean);
        DataTypeImpl.init(DataType.COUNTER, DataDecoder.counterToLong, DataDecoder.counterToAtomicLong);
        DataTypeImpl.init(DataType.DECIMAL, DataDecoder.decimalToBigDecimal);
        DataTypeImpl.init(DataType.DOUBLE, DataDecoder.doubleToDouble);
        DataTypeImpl.init(DataType.FLOAT, DataDecoder.floatToFloat);
        DataTypeImpl.init(DataType.INET, DataDecoder.inetToInetAddress);
        DataTypeImpl.init(DataType.INT, DataDecoder.intToInteger);
        DataTypeImpl.init(DataType.TEXT, DataDecoder.textToString);
        DataTypeImpl.init(DataType.TIMESTAMP, DataDecoder.timestampToLong, DataDecoder.timestampToDate, DataDecoder.timestampToInstant);
        DataTypeImpl.init(DataType.UUID, DataDecoder.uuidToUUID);
        DataTypeImpl.init(DataType.VARCHAR, DataDecoder.varcharToString);
        DataTypeImpl.init(DataType.VARINT, DataDecoder.varintToBigInteger);
        DataTypeImpl.init(DataType.TIMEUUID, DataDecoder.timeuuidToUUID);
    }

    public static class Definition
    implements CQLDataType {
        private final CQLDataType type;
        private final List<CQLDataType> arguments;

        public Definition(DataType type, DataType ... arguments) {
            this.type = type;
            this.arguments = Arrays.asList((CQLDataType[])arguments);
        }

        public Definition(DataType type, List<CQLDataType> arguments) {
            this.type = type;
            this.arguments = arguments;
        }

        public Definition(List<CQLDataType> types) {
            this.type = types.remove(0);
            this.arguments = Collections.unmodifiableList(types);
        }

        public String name() {
            return this.type.name();
        }

        public boolean isCollection() {
            return !this.arguments.isEmpty();
        }

        public boolean isUserDefined() {
            return this.type instanceof UDTClassInfoImpl;
        }

        public CQLDataType getMainType() {
            return this.type;
        }

        public CQLDataType getElementType() {
            if (this.arguments.size() == 0) {
                return null;
            }
            return this.arguments.get(this.arguments.size() - 1);
        }

        public List<CQLDataType> getArgumentTypes() {
            return this.arguments;
        }

        public CQLDataType getFirstArgumentType() {
            return this.arguments.isEmpty() ? null : this.arguments.get(0);
        }

        public boolean isAlterableTo(CQLDataType to) {
            if (to instanceof Definition) {
                Definition tod = (Definition)to;
                if (!this.type.isAlterableTo(tod.type)) {
                    return false;
                }
                if (this.isCollection()) {
                    if (this.arguments.size() != tod.arguments.size()) {
                        return false;
                    }
                    for (int i = 0; i < this.arguments.size(); ++i) {
                        if (this.arguments.get(i).isAlterableTo(tod.arguments.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
            if (this.isCollection() || this.isUserDefined()) {
                return false;
            }
            return this.type.isAlterableTo(to);
        }

        public DataDecoder<?> getDecoder(Field field, boolean mandatory) {
            DataDecoder decoder;
            Validate.notNull((Object)field, (String)"invalid null field", (Object[])new Object[0]);
            Persisted persisted = field.getAnnotation(Persisted.class);
            Class clazz = ClassUtils.primitiveToWrapper(DataTypeImpl.unwrapOptionalIfPresent(field.getType(), field.getGenericType()));
            if (this.isCollection()) {
                if (List.class.isAssignableFrom(clazz)) {
                    if (persisted != null) {
                        return DataDecoder.list(persisted.as().CLASS, mandatory);
                    }
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        return DataDecoder.list(ReflectionUtils.getRawClass((Type)atype), mandatory);
                    }
                    throw new IllegalArgumentException("unable to determine element type for field: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
                if (LinkedHashSet.class.isAssignableFrom(clazz) || Set.class.equals((Object)clazz) && this.type instanceof DataType && ((DataType)this.type).getMainType() == DataType.ORDERED_SET) {
                    if (persisted != null) {
                        return DataDecoder.orderedSet(persisted.as().CLASS, mandatory);
                    }
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        return DataDecoder.orderedSet(ReflectionUtils.getRawClass((Type)atype), mandatory);
                    }
                    throw new IllegalArgumentException("unable to determine element type for field: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
                if (SortedSet.class.isAssignableFrom(clazz) || Set.class.equals((Object)clazz) && this.type instanceof DataType && ((DataType)this.type).getMainType() == DataType.SORTED_SET) {
                    if (persisted != null) {
                        return DataDecoder.sortedSet(persisted.as().CLASS, mandatory);
                    }
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        return DataDecoder.sortedSet(ReflectionUtils.getRawClass((Type)atype), mandatory);
                    }
                    throw new IllegalArgumentException("unable to determine element type for field: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
                if (Set.class.isAssignableFrom(clazz)) {
                    if (persisted != null) {
                        return DataDecoder.set(persisted.as().CLASS, mandatory);
                    }
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type atype = ptype.getActualTypeArguments()[0];
                        return DataDecoder.set(ReflectionUtils.getRawClass((Type)atype), mandatory);
                    }
                    throw new IllegalArgumentException("unable to determine element type for field: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
                if (SortedMap.class.isAssignableFrom(clazz) || Map.class.equals((Object)clazz) && this.type instanceof DataType && ((DataType)this.type).getMainType() == DataType.SORTED_MAP) {
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type ktype = ptype.getActualTypeArguments()[0];
                        if (persisted != null) {
                            return DataDecoder.sortedMap(ReflectionUtils.getRawClass((Type)ktype), persisted.as().CLASS, mandatory);
                        }
                        Type vtype = ptype.getActualTypeArguments()[1];
                        return DataDecoder.sortedMap(ReflectionUtils.getRawClass((Type)ktype), ReflectionUtils.getRawClass((Type)vtype), mandatory);
                    }
                    throw new IllegalArgumentException("unable to determine elements type for field: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType ptype = (ParameterizedType)type;
                        Type ktype = ptype.getActualTypeArguments()[0];
                        if (persisted != null) {
                            return DataDecoder.map(ReflectionUtils.getRawClass((Type)ktype), persisted.as().CLASS, mandatory);
                        }
                        Type vtype = ptype.getActualTypeArguments()[1];
                        return DataDecoder.map(ReflectionUtils.getRawClass((Type)ktype), ReflectionUtils.getRawClass((Type)vtype), mandatory);
                    }
                    throw new IllegalArgumentException("unable to determine elements type for field: " + field.getDeclaringClass().getName() + "." + field.getName());
                }
            } else if (this.isUserDefined()) {
                return DataDecoder.udt((UDTClassInfoImpl)this.type);
            }
            if ((decoder = persisted != null ? DataTypeImpl.getDecoder((DataType)this.type, persisted.as().CLASS) : DataTypeImpl.getDecoder((DataType)this.type, clazz)) != null) {
                return decoder;
            }
            throw new IllegalArgumentException("unsupported type to convert to: " + clazz.getName() + " for field: " + field.getDeclaringClass().getName() + "." + field.getName());
        }

        public DataDecoder<?> getDecoder(Class<?> clazz) {
            Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
            Validate.validState((boolean)this.isCollection(), (String)"not a collection definition", (Object[])new Object[0]);
            if (List.class.isAssignableFrom(clazz)) {
                Type type = clazz.getGenericSuperclass();
                if (type instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)type;
                    Type atype = ptype.getActualTypeArguments()[0];
                    return DataDecoder.list(ReflectionUtils.getRawClass((Type)atype), true);
                }
                throw new IllegalArgumentException("unable to determine element type for class: " + clazz.getName());
            }
            if (LinkedHashSet.class.isAssignableFrom(clazz) || Set.class.equals(clazz) && this.type instanceof DataType && ((DataType)this.type).getMainType() == DataType.ORDERED_SET) {
                Type type = clazz.getGenericSuperclass();
                if (type instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)type;
                    Type atype = ptype.getActualTypeArguments()[0];
                    return DataDecoder.orderedSet(ReflectionUtils.getRawClass((Type)atype), true);
                }
                throw new IllegalArgumentException("unable to determine element type for class: " + clazz.getName());
            }
            if (Set.class.isAssignableFrom(clazz)) {
                Type type = clazz.getGenericSuperclass();
                if (type instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)type;
                    Type atype = ptype.getActualTypeArguments()[0];
                    return DataDecoder.set(ReflectionUtils.getRawClass((Type)atype), true);
                }
                throw new IllegalArgumentException("unable to determine element type for class: " + clazz.getName());
            }
            if (SortedMap.class.isAssignableFrom(clazz) || Map.class.equals(clazz) && this.type instanceof DataType && ((DataType)this.type).getMainType() == DataType.SORTED_MAP) {
                Type type = clazz.getGenericSuperclass();
                if (type instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)type;
                    Type ktype = ptype.getActualTypeArguments()[0];
                    Type vtype = ptype.getActualTypeArguments()[1];
                    return DataDecoder.sortedMap(ReflectionUtils.getRawClass((Type)ktype), ReflectionUtils.getRawClass((Type)vtype), true);
                }
                throw new IllegalArgumentException("unable to determine elements type for class: " + clazz.getName());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Type type = clazz.getGenericSuperclass();
                if (type instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)type;
                    Type ktype = ptype.getActualTypeArguments()[0];
                    Type vtype = ptype.getActualTypeArguments()[1];
                    return DataDecoder.map(ReflectionUtils.getRawClass((Type)ktype), ReflectionUtils.getRawClass((Type)vtype), true);
                }
                throw new IllegalArgumentException("unable to determine elements type for class: " + clazz.getName());
            }
            throw new IllegalArgumentException("unsupported collection type to convert to: " + clazz.getSuperclass().getName() + " for class: " + clazz.getName());
        }

        public <T, PT> Object encode(Object val, Persisted persisted, Persister<T, PT> persister, String fname) throws IOException {
            if (val == null || persisted == null || persister == null || val instanceof PersistedObject) {
                return val;
            }
            if (this.type == DataType.LIST) {
                return new PersistedList<T, PT>(persisted, persister, fname, (List)val, false);
            }
            if (this.type == DataType.SET) {
                return new PersistedSet<T, PT>(persisted, persister, fname, (Set)val, false);
            }
            if (this.type == DataType.ORDERED_SET) {
                return new PersistedOrderedSet<T, PT>(persisted, persister, fname, (Set)val, false);
            }
            if (this.type == DataType.SORTED_SET) {
                return new PersistedSortedSet<T, PT>(persisted, persister, fname, (Set)val, false);
            }
            if (this.type == DataType.MAP) {
                return new PersistedMap(persisted, persister, fname, (Map)val, false);
            }
            if (this.type == DataType.SORTED_MAP) {
                return new PersistedNavigableMap(persisted, persister, fname, (Map)val, false);
            }
            PersistedValue<Object, PT> pval = new PersistedValue<Object, PT>(persisted, persister, fname).setDecodedValue(val);
            pval.getEncodedValue();
            return pval;
        }

        public <T, PT> Object encodeElement(Object val, Persisted persisted, Persister<T, PT> persister, String fname) throws IOException {
            if (val == null || persisted == null || persister == null || val instanceof PersistedObject) {
                return val;
            }
            if (this.type == DataType.LIST || this.type == DataType.SET || this.type == DataType.ORDERED_SET || this.type == DataType.MAP || this.type == DataType.SORTED_MAP) {
                PersistedValue<Object, PT> pval = new PersistedValue<Object, PT>(persisted, persister, fname).setDecodedValue(val);
                pval.getEncodedValue();
                return pval;
            }
            throw new IOException("field is not a list, a set, or a map");
        }

        public <T, PT> Object decode(Object val, Persisted persisted, Persister<T, PT> persister, String fname) throws IOException {
            if (val == null || persisted == null || persister == null || val instanceof PersistedObject) {
                return val;
            }
            if (this.type == DataType.LIST) {
                return new PersistedList<T, PT>(persisted, persister, fname, (List)val, true);
            }
            if (this.type == DataType.SET) {
                return new PersistedSet<T, PT>(persisted, persister, fname, (Set)val, true);
            }
            if (this.type == DataType.ORDERED_SET) {
                return new PersistedOrderedSet<T, PT>(persisted, persister, fname, (Set)val, true);
            }
            if (this.type == DataType.SORTED_SET) {
                return new PersistedSortedSet<T, PT>(persisted, persister, fname, (Set)val, true);
            }
            if (this.type == DataType.MAP) {
                return new PersistedMap(persisted, persister, fname, (Map)val, true);
            }
            if (this.type == DataType.SORTED_MAP) {
                return new PersistedNavigableMap(persisted, persister, fname, (Map)val, true);
            }
            return persister.decode(persister.getPersistedClass().cast(persisted.as().CLASS.cast(val)));
        }

        public String toCQL() {
            if (!this.isCollection()) {
                return this.type.toCQL();
            }
            ArrayList<String> cqls = new ArrayList<String>(this.arguments.size());
            StringBuilder sb = new StringBuilder();
            for (CQLDataType atype : this.arguments) {
                cqls.add(atype.toCQL());
            }
            sb.append(this.type.toCQL()).append('<').append(StringUtils.join(cqls, (char)',')).append('>');
            return sb.toString();
        }

        public Stream<UDTClassInfoImpl<?>> udts() {
            if (this.type instanceof UDTClassInfoImpl) {
                return Stream.of((UDTClassInfoImpl)this.type);
            }
            return this.arguments.stream().filter(t -> t instanceof UDTClassInfoImpl).map(t -> (UDTClassInfoImpl)t);
        }

        public String toString() {
            return this.toCQL();
        }
    }
}

