/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.utils.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.LocaleUtils;
import org.helenus.driver.impl.ElementConverter;
import org.helenus.driver.impl.UDTClassInfoImpl;

public abstract class DataDecoder<V> {
    public static final DataDecoder<String> asciiToString = new DataDecoder<String>(String.class){

        @Override
        protected String decodeImpl(Row row, String name, Class<String> clazz) {
            Validate.isTrue((String.class == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getString(name);
        }

        @Override
        protected String decodeImpl(UDTValue uval, String name, Class<String> clazz) {
            Validate.isTrue((String.class == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getString(name);
        }
    };
    public static final DataDecoder<Enum> asciiToEnum = new DataDecoder<Enum>(Enum.class){

        @Override
        protected Enum decodeImpl(Row row, String name, Class<Enum> clazz) {
            Validate.isTrue((boolean)Enum.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            String eval = row.getString(name);
            return eval != null ? Enum.valueOf(clazz, eval) : null;
        }

        @Override
        protected Enum decodeImpl(UDTValue uval, String name, Class<Enum> clazz) {
            Validate.isTrue((boolean)Enum.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            String eval = uval.getString(name);
            return eval != null ? Enum.valueOf(clazz, eval) : null;
        }
    };
    public static final DataDecoder<Class> asciiToClass = new DataDecoder<Class>(Class.class){

        @Override
        protected Class decodeImpl(Row row, String name, Class<Class> clazz) {
            Validate.isTrue((boolean)Class.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            String cname = row.getString(name);
            if (cname == null) {
                return null;
            }
            try {
                return DataDecoder.findClass(cname);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        protected Class decodeImpl(UDTValue uval, String name, Class<Class> clazz) {
            Validate.isTrue((boolean)Class.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            String cname = uval.getString(name);
            if (cname == null) {
                return null;
            }
            try {
                return DataDecoder.findClass(cname);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    };
    public static final DataDecoder<Locale> asciiToLocale = new DataDecoder<Locale>(Locale.class){

        @Override
        protected Locale decodeImpl(Row row, String name, Class<Locale> clazz) {
            Validate.isTrue((boolean)Locale.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return LocaleUtils.toLocale((String)row.getString(name));
        }

        @Override
        protected Locale decodeImpl(UDTValue uval, String name, Class<Locale> clazz) {
            Validate.isTrue((boolean)Locale.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return LocaleUtils.toLocale((String)uval.getString(name));
        }
    };
    public static final DataDecoder<ZoneId> asciiToZoneId = new DataDecoder<ZoneId>(ZoneId.class){

        @Override
        protected ZoneId decodeImpl(Row row, String name, Class<ZoneId> clazz) {
            Validate.isTrue((boolean)ZoneId.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            String zid = row.getString(name);
            try {
                return zid != null ? ZoneId.of(zid) : null;
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        protected ZoneId decodeImpl(UDTValue uval, String name, Class<ZoneId> clazz) {
            Validate.isTrue((boolean)ZoneId.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            String zid = uval.getString(name);
            try {
                return zid != null ? ZoneId.of(zid) : null;
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    };
    public static final DataDecoder<Long> bigintToLong = new DataDecoder<Long>(Long.class){

        @Override
        protected Long decodeImpl(Row row, String name, Class<Long> clazz) {
            Validate.isTrue((Long.class == clazz || Long.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.isNull(name) ? null : Long.valueOf(row.getLong(name));
        }

        @Override
        protected Long decodeImpl(UDTValue uval, String name, Class<Long> clazz) {
            Validate.isTrue((Long.class == clazz || Long.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.isNull(name) ? null : Long.valueOf(uval.getLong(name));
        }
    };
    public static final DataDecoder<byte[]> blobToByteArray = new DataDecoder<byte[]>(byte[].class){

        @Override
        protected byte[] decodeImpl(Row row, String name, Class<byte[]> clazz) {
            Validate.isTrue((boolean)clazz.isArray(), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            Validate.isTrue((Byte.TYPE == clazz.getComponentType() ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            ByteBuffer buf = row.getBytes(name);
            return buf != null ? Bytes.getArray((ByteBuffer)buf) : null;
        }

        @Override
        protected byte[] decodeImpl(UDTValue uval, String name, Class<byte[]> clazz) {
            Validate.isTrue((boolean)clazz.isArray(), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            Validate.isTrue((Byte.TYPE == clazz.getComponentType() ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            ByteBuffer buf = uval.getBytes(name);
            return buf != null ? Bytes.getArray((ByteBuffer)buf) : null;
        }
    };
    public static final DataDecoder<ByteBuffer> blobToByteBuffer = new DataDecoder<ByteBuffer>(ByteBuffer.class){

        @Override
        protected ByteBuffer decodeImpl(Row row, String name, Class<ByteBuffer> clazz) {
            Validate.isTrue((boolean)ByteBuffer.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getBytes(name);
        }

        @Override
        protected ByteBuffer decodeImpl(UDTValue uval, String name, Class<ByteBuffer> clazz) {
            Validate.isTrue((boolean)ByteBuffer.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getBytes(name);
        }
    };
    public static final DataDecoder<Boolean> booleanToBoolean = new DataDecoder<Boolean>(Boolean.class){

        @Override
        protected Boolean decodeImpl(Row row, String name, Class<Boolean> clazz) {
            Validate.isTrue((Boolean.class == clazz || Boolean.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.isNull(name) ? null : Boolean.valueOf(row.getBool(name));
        }

        @Override
        protected Boolean decodeImpl(UDTValue uval, String name, Class<Boolean> clazz) {
            Validate.isTrue((Boolean.class == clazz || Boolean.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.isNull(name) ? null : Boolean.valueOf(uval.getBool(name));
        }
    };
    public static final DataDecoder<Long> counterToLong = bigintToLong;
    public static final DataDecoder<AtomicLong> counterToAtomicLong = new DataDecoder<AtomicLong>(AtomicLong.class){

        @Override
        protected AtomicLong decodeImpl(Row row, String name, Class<AtomicLong> clazz) {
            Validate.isTrue((boolean)AtomicLong.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.isNull(name) ? null : new AtomicLong(row.getLong(name));
        }

        @Override
        protected AtomicLong decodeImpl(UDTValue uval, String name, Class<AtomicLong> clazz) {
            Validate.isTrue((boolean)AtomicLong.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.isNull(name) ? null : new AtomicLong(uval.getLong(name));
        }
    };
    public static final DataDecoder<BigDecimal> decimalToBigDecimal = new DataDecoder<BigDecimal>(BigDecimal.class){

        @Override
        protected BigDecimal decodeImpl(Row row, String name, Class<BigDecimal> clazz) {
            Validate.isTrue((boolean)BigDecimal.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getDecimal(name);
        }

        @Override
        protected BigDecimal decodeImpl(UDTValue uval, String name, Class<BigDecimal> clazz) {
            Validate.isTrue((boolean)BigDecimal.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getDecimal(name);
        }
    };
    public static final DataDecoder<Double> doubleToDouble = new DataDecoder<Double>(Double.class){

        @Override
        protected Double decodeImpl(Row row, String name, Class<Double> clazz) {
            Validate.isTrue((Double.class == clazz || Double.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.isNull(name) ? null : Double.valueOf(row.getDouble(name));
        }

        @Override
        protected Double decodeImpl(UDTValue uval, String name, Class<Double> clazz) {
            Validate.isTrue((Double.class == clazz || Double.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.isNull(name) ? null : Double.valueOf(uval.getDouble(name));
        }
    };
    public static final DataDecoder<Float> floatToFloat = new DataDecoder<Float>(Float.class){

        @Override
        protected Float decodeImpl(Row row, String name, Class<Float> clazz) {
            Validate.isTrue((Float.class == clazz || Float.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.isNull(name) ? null : Float.valueOf(row.getFloat(name));
        }

        @Override
        protected Float decodeImpl(UDTValue uval, String name, Class<Float> clazz) {
            Validate.isTrue((Float.class == clazz || Float.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.isNull(name) ? null : Float.valueOf(uval.getFloat(name));
        }
    };
    public static final DataDecoder<InetAddress> inetToInetAddress = new DataDecoder<InetAddress>(InetAddress.class){

        @Override
        protected InetAddress decodeImpl(Row row, String name, Class<InetAddress> clazz) {
            Validate.isTrue((boolean)InetAddress.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getInet(name);
        }

        @Override
        protected InetAddress decodeImpl(UDTValue uval, String name, Class<InetAddress> clazz) {
            Validate.isTrue((boolean)InetAddress.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getInet(name);
        }
    };
    public static final DataDecoder<Integer> intToInteger = new DataDecoder<Integer>(Integer.class){

        @Override
        protected Integer decodeImpl(Row row, String name, Class<Integer> clazz) {
            Validate.isTrue((Integer.class == clazz || Integer.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.isNull(name) ? null : Integer.valueOf(row.getInt(name));
        }

        @Override
        protected Integer decodeImpl(UDTValue uval, String name, Class<Integer> clazz) {
            Validate.isTrue((Integer.class == clazz || Integer.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.isNull(name) ? null : Integer.valueOf(uval.getInt(name));
        }
    };
    public static final DataDecoder<String> textToString = asciiToString;
    public static final DataDecoder<Date> timestampToDate = new DataDecoder<Date>(Date.class){

        @Override
        protected Date decodeImpl(Row row, String name, Class<Date> clazz) {
            Validate.isTrue((boolean)Date.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getDate(name);
        }

        @Override
        protected Date decodeImpl(UDTValue uval, String name, Class<Date> clazz) {
            Validate.isTrue((boolean)Date.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getDate(name);
        }
    };
    public static final DataDecoder<Instant> timestampToInstant = new DataDecoder<Instant>(Instant.class){

        @Override
        protected Instant decodeImpl(Row row, String name, Class<Instant> clazz) {
            Validate.isTrue((boolean)Instant.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            Date date = row.getDate(name);
            return date != null ? date.toInstant() : null;
        }

        @Override
        protected Instant decodeImpl(UDTValue uval, String name, Class<Instant> clazz) {
            Validate.isTrue((boolean)Instant.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            Date date = uval.getDate(name);
            return date != null ? date.toInstant() : null;
        }
    };
    public static final DataDecoder<Long> timestampToLong = new DataDecoder<Long>(Long.class){

        @Override
        protected Long decodeImpl(Row row, String name, Class<Long> clazz) {
            Validate.isTrue((Long.class == clazz || Long.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            Date date = row.getDate(name);
            return date != null ? Long.valueOf(date.getTime()) : null;
        }

        @Override
        protected Long decodeImpl(UDTValue uval, String name, Class<Long> clazz) {
            Validate.isTrue((Long.class == clazz || Long.TYPE == clazz ? 1 : 0) != 0, (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            Date date = uval.getDate(name);
            return date != null ? Long.valueOf(date.getTime()) : null;
        }
    };
    public static final DataDecoder<UUID> uuidToUUID = new DataDecoder<UUID>(UUID.class){

        @Override
        protected UUID decodeImpl(Row row, String name, Class<UUID> clazz) {
            Validate.isTrue((boolean)UUID.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getUUID(name);
        }

        @Override
        protected UUID decodeImpl(UDTValue uval, String name, Class<UUID> clazz) {
            Validate.isTrue((boolean)UUID.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getUUID(name);
        }
    };
    public static final DataDecoder<String> varcharToString = asciiToString;
    public static final DataDecoder<BigInteger> varintToBigInteger = new DataDecoder<BigInteger>(BigInteger.class){

        @Override
        protected BigInteger decodeImpl(Row row, String name, Class<BigInteger> clazz) {
            Validate.isTrue((boolean)BigInteger.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return row.getVarint(name);
        }

        @Override
        protected BigInteger decodeImpl(UDTValue uval, String name, Class<BigInteger> clazz) {
            Validate.isTrue((boolean)BigInteger.class.isAssignableFrom(clazz), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
            return uval.getVarint(name);
        }
    };
    public static final DataDecoder<UUID> timeuuidToUUID = uuidToUUID;
    private final Class<V> clazz;

    public static Class<?> findClass(String name) throws ClassNotFoundException {
        ClassLoader otccl = Thread.currentThread().getContextClassLoader();
        return otccl != null ? Class.forName(name, true, otccl) : Class.forName(name);
    }

    public static final DataDecoder<List> list(final Class<?> eclazz, final boolean mandatory) {
        return new DataDecoder<List>(List.class){

            private List decodeImpl(Class<?> etype, List<Object> list) {
                if (list == null) {
                    if (mandatory) {
                        return new ArrayList(8);
                    }
                    return list;
                }
                ArrayList<Object> nlist = new ArrayList<Object>(list.size());
                if (eclazz.isAssignableFrom(etype)) {
                    nlist.addAll(list);
                } else {
                    ElementConverter converter = ElementConverter.getConverter(eclazz, etype);
                    for (Object o : list) {
                        nlist.add(o != null ? converter.convert(o) : null);
                    }
                }
                return nlist;
            }

            @Override
            protected List decodeImpl(Row row, String name, Class clazz) {
                return this.decodeImpl(((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getName().asJavaClass(), row.isNull(name) ? null : row.getList(name, Object.class));
            }

            @Override
            protected List decodeImpl(UDTValue uval, String name, Class clazz) {
                return this.decodeImpl(((DataType)uval.getType().getFieldType(name).getTypeArguments().get(0)).getName().asJavaClass(), uval.isNull(name) ? null : uval.getList(name, Object.class));
            }
        };
    }

    public static final DataDecoder<Set> set(final Class<?> eclazz, final boolean mandatory) {
        return new DataDecoder<Set>(Set.class){

            private Set decodeImpl(Class<?> etype, Set<Object> set) {
                if (set == null) {
                    if (mandatory) {
                        if (eclazz.isEnum()) {
                            return EnumSet.noneOf(eclazz);
                        }
                        return new HashSet(8);
                    }
                    return set;
                }
                AbstractSet nset = eclazz.isEnum() ? EnumSet.noneOf(eclazz) : new HashSet(set.size() * 3 / 2);
                if (eclazz.isAssignableFrom(etype)) {
                    nset.addAll(set);
                } else {
                    ElementConverter converter = ElementConverter.getConverter(eclazz, etype);
                    for (Object o : set) {
                        nset.add(o != null ? converter.convert(o) : null);
                    }
                }
                return nset;
            }

            @Override
            protected Set decodeImpl(Row row, String name, Class clazz) {
                return this.decodeImpl(((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getName().asJavaClass(), row.isNull(name) ? null : row.getSet(name, Object.class));
            }

            @Override
            protected Set decodeImpl(UDTValue uval, String name, Class clazz) {
                return this.decodeImpl(((DataType)uval.getType().getFieldType(name).getTypeArguments().get(0)).getName().asJavaClass(), uval.isNull(name) ? null : uval.getSet(name, Object.class));
            }
        };
    }

    public static final DataDecoder<LinkedHashSet> orderedSet(final Class<?> eclazz, final boolean mandatory) {
        return new DataDecoder<LinkedHashSet>(LinkedHashSet.class){

            private LinkedHashSet decodeImpl(Class<?> etype, List<Object> set) {
                if (set == null) {
                    if (mandatory) {
                        return new LinkedHashSet(8);
                    }
                    return null;
                }
                LinkedHashSet<Object> nset = new LinkedHashSet<Object>(set.size() * 3 / 2);
                if (eclazz.isAssignableFrom(etype)) {
                    nset.addAll(set);
                } else {
                    ElementConverter converter = ElementConverter.getConverter(eclazz, etype);
                    for (Object o : set) {
                        nset.add(o != null ? converter.convert(o) : null);
                    }
                }
                return nset;
            }

            @Override
            protected LinkedHashSet decodeImpl(Row row, String name, Class clazz) {
                return this.decodeImpl(((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getName().asJavaClass(), row.isNull(name) ? null : row.getList(name, Object.class));
            }

            @Override
            protected LinkedHashSet decodeImpl(UDTValue uval, String name, Class clazz) {
                return this.decodeImpl(((DataType)uval.getType().getFieldType(name).getTypeArguments().get(0)).getName().asJavaClass(), uval.isNull(name) ? null : uval.getList(name, Object.class));
            }
        };
    }

    public static final DataDecoder<SortedSet> sortedSet(final Class<?> eclazz, final boolean mandatory) {
        return new DataDecoder<SortedSet>(SortedSet.class){

            private SortedSet decodeImpl(Class<?> etype, Set<Object> set) {
                if (set == null) {
                    if (mandatory) {
                        return new TreeSet();
                    }
                    return null;
                }
                TreeSet<Object> nset = new TreeSet<Object>();
                if (eclazz.isAssignableFrom(etype)) {
                    nset.addAll(set);
                } else {
                    ElementConverter converter = ElementConverter.getConverter(eclazz, etype);
                    for (Object o : set) {
                        nset.add(o != null ? converter.convert(o) : null);
                    }
                }
                return nset;
            }

            @Override
            protected SortedSet decodeImpl(Row row, String name, Class clazz) {
                return this.decodeImpl(((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getName().asJavaClass(), row.isNull(name) ? null : row.getSet(name, Object.class));
            }

            @Override
            protected SortedSet decodeImpl(UDTValue uval, String name, Class clazz) {
                return this.decodeImpl(((DataType)uval.getType().getFieldType(name).getTypeArguments().get(0)).getName().asJavaClass(), uval.isNull(name) ? null : uval.getSet(name, Object.class));
            }
        };
    }

    public static final DataDecoder<Map> map(final Class<?> ekclazz, final Class<?> evclazz, final boolean mandatory) {
        return new DataDecoder<Map>(Map.class){

            private Map decodeImpl(Class<?> ektype, Class<?> evtype, Map<Object, Object> map) {
                if (map == null) {
                    if (mandatory) {
                        if (ekclazz.isEnum()) {
                            return new EnumMap(ekclazz);
                        }
                        return new HashMap(8);
                    }
                    return map;
                }
                AbstractMap nmap = ekclazz.isEnum() ? new EnumMap(ekclazz) : new HashMap(map.size() * 3 / 2);
                if (ekclazz.isAssignableFrom(ektype) && evclazz.isAssignableFrom(evtype)) {
                    nmap.putAll(map);
                } else {
                    ElementConverter kconverter = ElementConverter.getConverter(ekclazz, ektype);
                    ElementConverter vconverter = ElementConverter.getConverter(evclazz, evtype);
                    for (Map.Entry<Object, Object> e : map.entrySet()) {
                        Object k = e.getKey();
                        Object v = e.getValue();
                        nmap.put(k != null ? kconverter.convert(k) : null, v != null ? vconverter.convert(v) : null);
                    }
                }
                return nmap;
            }

            @Override
            protected Map decodeImpl(Row row, String name, Class clazz) {
                return this.decodeImpl(((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getName().asJavaClass(), ((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(1)).getName().asJavaClass(), row.isNull(name) ? null : row.getMap(name, Object.class, Object.class));
            }

            @Override
            protected Map decodeImpl(UDTValue uval, String name, Class clazz) {
                return this.decodeImpl(((DataType)uval.getType().getFieldType(name).getTypeArguments().get(0)).getName().asJavaClass(), ((DataType)uval.getType().getFieldType(name).getTypeArguments().get(1)).getName().asJavaClass(), uval.isNull(name) ? null : uval.getMap(name, Object.class, Object.class));
            }
        };
    }

    public static final DataDecoder<SortedMap> sortedMap(final Class<?> ekclazz, final Class<?> evclazz, final boolean mandatory) {
        return new DataDecoder<SortedMap>(SortedMap.class){

            private SortedMap decodeImpl(Class<?> ektype, Class<?> evtype, Map<Object, Object> map) {
                if (map == null) {
                    if (mandatory) {
                        return new TreeMap();
                    }
                    return null;
                }
                TreeMap<Object, Object> nmap = new TreeMap<Object, Object>();
                if (ekclazz.isAssignableFrom(ektype) && evclazz.isAssignableFrom(evtype)) {
                    nmap.putAll(map);
                } else {
                    ElementConverter kconverter = ElementConverter.getConverter(ekclazz, ektype);
                    ElementConverter vconverter = ElementConverter.getConverter(evclazz, evtype);
                    for (Map.Entry<Object, Object> e : map.entrySet()) {
                        Object k = e.getKey();
                        Object v = e.getValue();
                        nmap.put(k != null ? kconverter.convert(k) : null, v != null ? vconverter.convert(v) : null);
                    }
                }
                return nmap;
            }

            @Override
            protected SortedMap decodeImpl(Row row, String name, Class clazz) {
                return this.decodeImpl(((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getName().asJavaClass(), ((DataType)row.getColumnDefinitions().getType(name).getTypeArguments().get(1)).getName().asJavaClass(), row.isNull(name) ? null : row.getMap(name, Object.class, Object.class));
            }

            @Override
            protected SortedMap decodeImpl(UDTValue uval, String name, Class clazz) {
                return this.decodeImpl(((DataType)uval.getType().getFieldType(name).getTypeArguments().get(0)).getName().asJavaClass(), ((DataType)uval.getType().getFieldType(name).getTypeArguments().get(1)).getName().asJavaClass(), uval.isNull(name) ? null : uval.getMap(name, Object.class, Object.class));
            }
        };
    }

    public static final DataDecoder<Object> udt(final UDTClassInfoImpl<?> cinfo) {
        return new DataDecoder<Object>(Object.class){

            @Override
            protected Object decodeImpl(Row row, String name, Class clazz) {
                Validate.isTrue((boolean)clazz.isAssignableFrom(cinfo.getObjectClass()), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
                UDTValue uval = row.getUDTValue(name);
                if (uval == null) {
                    return null;
                }
                return cinfo.getObject(uval);
            }

            @Override
            protected Object decodeImpl(UDTValue uval, String name, Class clazz) {
                Validate.isTrue((boolean)clazz.isAssignableFrom(cinfo.getObjectClass()), (String)"unsupported class '%s' to decode to", (Object[])new Object[]{clazz.getName()});
                UDTValue fuval = uval.getUDTValue(name);
                if (fuval == null) {
                    return null;
                }
                return cinfo.getObject(fuval);
            }
        };
    }

    DataDecoder(Class<V> clazz) {
        this.clazz = clazz;
    }

    protected abstract V decodeImpl(Row var1, String var2, Class<V> var3);

    protected abstract V decodeImpl(UDTValue var1, String var2, Class<V> var3);

    public boolean canDecodeTo(Class<?> clazz) {
        return this.clazz.isAssignableFrom(clazz);
    }

    public V decode(Row row, String name, Class<V> clazz) {
        Validate.notNull((Object)row, (String)"invalid null row", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"invalid null name", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null clazz", (Object[])new Object[0]);
        return this.decodeImpl(row, name, clazz);
    }

    public V decode(UDTValue uval, String name, Class<V> clazz) {
        Validate.notNull((Object)uval, (String)"invalid null UDT value", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"invalid null name", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null clazz", (Object[])new Object[0]);
        return this.decodeImpl(uval, name, clazz);
    }
}

