/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.ExecutionList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.StatementManager;

public class ErrorResultSetFuture
extends DefaultResultSetFuture {
    private static final ExecutionList execution = new ExecutionList();
    private final Throwable error;

    public ErrorResultSetFuture(StatementManager mgr, Throwable error) {
        super(null, mgr.getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum(), null);
        Validate.notNull((Object)mgr, (String)"invalid null mgr", (Object[])new Object[0]);
        Validate.notNull((Object)error, (String)"invalid null error", (Object[])new Object[0]);
        this.error = error;
    }

    RuntimeException propagateError(boolean unwrapExecutionError) {
        Throwable t = this.error;
        if (unwrapExecutionError && t instanceof ExecutionException) {
            t = ((ExecutionException)t).getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof DriverException) {
            throw ((DriverException)t).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", t);
    }

    public ResultSet getUninterruptibly() {
        throw this.propagateError(true);
    }

    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        throw this.propagateError(true);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        throw this.propagateError(false);
    }

    public ResultSet get() throws InterruptedException, ExecutionException {
        throw this.propagateError(false);
    }

    public boolean isDone() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    public void addListener(Runnable listener, Executor exec) {
        execution.add(listener, exec);
    }

    static {
        execution.execute();
    }
}

