/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;
import org.helenus.driver.persistence.UDTTypeEntity;

public abstract class UDTClassInfoImpl<T>
extends ClassInfoImpl<T>
implements CQLDataType {
    private static final String[] RESERVED_UDT_NAMES = new String[]{"byte", "smallint", "complex", "enum", "date", "interval", "macaddr", "bitstring"};
    private final String name;
    private final TableInfoImpl<T> table;

    protected UDTClassInfoImpl(StatementManagerImpl mgr, Class<T> clazz, Class<? extends Annotation> entityAnnotationClass) {
        super(mgr, clazz, entityAnnotationClass);
        this.name = this.findName();
        this.table = this.tablesImpl().findFirst().get();
        if (List.class.isAssignableFrom(clazz)) {
            this.table.addNonPrimaryColumn(new FieldInfoImpl(this, DataType.LIST, (obj, val) -> {
                List l = (List)obj;
                l.clear();
                l.addAll((Collection)val);
            }));
        } else if (Set.class.isAssignableFrom(clazz)) {
            this.table.addNonPrimaryColumn(new FieldInfoImpl(this, LinkedHashSet.class.isAssignableFrom(clazz) ? DataType.ORDERED_SET : DataType.SET, (obj, val) -> {
                Set s = (Set)obj;
                s.clear();
                s.addAll((Collection)val);
            }));
        } else if (Map.class.isAssignableFrom(clazz)) {
            this.table.addNonPrimaryColumn(new FieldInfoImpl(this, SortedMap.class.isAssignableFrom(clazz) ? DataType.SORTED_MAP : DataType.MAP, (obj, val) -> {
                Map m = (Map)obj;
                m.clear();
                m.putAll((Map)val);
            }));
        }
    }

    protected UDTClassInfoImpl(UDTClassInfoImpl<T> cinfo, Class<T> clazz) {
        super(cinfo, clazz);
        this.name = cinfo.name;
        this.table = cinfo.table;
    }

    private String findName() {
        UDTRootEntity ure;
        UDTTypeEntity ute;
        UDTEntity ue = this.clazz.getAnnotation(UDTEntity.class);
        String name = ue != null ? ue.name() : ((ute = this.clazz.getAnnotation(UDTTypeEntity.class)) != null ? ute.name() : ((ure = (UDTRootEntity)ReflectionUtils.findFirstAnnotation((Class)this.clazz, UDTRootEntity.class)) != null ? ure.name() : null));
        Validate.isTrue((name != null ? 1 : 0) != 0, (String)"class '%s' is not annotated with @UDTEntity or @UDTRootEntity", (Object[])new Object[]{this.clazz.getSimpleName()});
        Validate.isTrue((!ArrayUtils.contains((Object[])RESERVED_UDT_NAMES, (Object)name) ? 1 : 0) != 0, (String)"user-defined type name cannot be a reserved type name: %s", (Object[])new Object[]{name});
        return name;
    }

    private void decodeAndSetColumnFields(T object, UDTValue uval) {
        TableInfoImpl<T> table = this.getTableImpl();
        if (table != null) {
            for (UserType.Field coldef : uval.getType()) {
                FieldInfoImpl<T> field = table.getColumnImpl(coldef.getName());
                if (field == null) continue;
                field.decodeAndSetValue(object, uval);
            }
        }
    }

    @Override
    protected Collection<TableInfoImpl<T>> getTablesImpl() {
        return Collections.emptyList();
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isUserDefined() {
        return true;
    }

    public CQLDataType getMainType() {
        return this;
    }

    public CQLDataType getElementType() {
        return null;
    }

    public List<CQLDataType> getArgumentTypes() {
        return null;
    }

    public CQLDataType getFirstArgumentType() {
        return null;
    }

    public boolean isAlterableTo(CQLDataType to) {
        return false;
    }

    public String toCQL() {
        return "frozen<" + this.name + ">";
    }

    @Override
    public boolean supportsTablesAndIndexes() {
        return false;
    }

    public TableInfoImpl<T> getTableImpl() {
        return this.table;
    }

    @Override
    public Stream<TableInfo<T>> tables() {
        return Stream.empty();
    }

    @Override
    public TableInfoImpl<T> getTableImpl(String name) {
        throw new IllegalArgumentException("user-defined types do not define tables");
    }

    @Override
    public int getNumTables() {
        return 0;
    }

    @Override
    public Collection<TableInfo<T>> getTables() {
        return Collections.emptyList();
    }

    @Override
    public POJOContext newContext(T object) {
        return new POJOContext(object);
    }

    @Override
    public T getObject(Row row, Map<String, Object> kkeys) {
        throw new ObjectConversionException(this.clazz, row, this.getEntityAnnotationClass().getSimpleName() + " POJOs cannot be retrieved from result rows");
    }

    @Override
    public T getObject(UDTValue uval) {
        if (uval == null) {
            return null;
        }
        try {
            Object object = this.constructor.newInstance(new Object[0]);
            this.finalFields.forEach((field, value) -> {
                try {
                    field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            });
            this.decodeAndSetColumnFields(object, uval);
            return object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ObjectConversionException(this.clazz, uval, "failed to instantiate blank POJO", t);
        }
    }

    @Override
    public String toString() {
        return "UDTClassInfoImpl(super=" + super.toString() + ", name=" + this.getName() + ", table=" + this.table + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UDTClassInfoImpl)) {
            return false;
        }
        UDTClassInfoImpl other = (UDTClassInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TableInfoImpl<T> this$table = this.table;
        TableInfoImpl<T> other$table = other.table;
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UDTClassInfoImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TableInfoImpl<T> $table = this.table;
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    public class POJOContext
    extends ClassInfoImpl.POJOContext {
        public POJOContext(T object) {
            super(object);
        }

        @Override
        protected final void populateKeyspaceKeys(Map<String, FieldInfoImpl<T>> kkeysFields) {
        }

        public Map<String, Pair<Object, CQLDataType>> getColumnValues() {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getColumnValues(this.object);
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getPartitionKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getKeyspaceAndPartitionKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getPrimaryKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getKeyspaceAndPrimaryKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Map<String, Pair<Object, CQLDataType>> getMandatoryColumnValues() {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getMandatoryAndPrimaryKeyColumnValues(this.object);
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getMandatoryAndPrimaryKeyColumnValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getNonPrimaryKeyColumnNonEncodedValues(String tname) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Pair<Object, CQLDataType> getColumnValue(CharSequence name) {
            if (UDTClassInfoImpl.this.table == null) {
                return Pair.of(null, null);
            }
            return UDTClassInfoImpl.this.table.getColumnValue(this.object, name);
        }

        @Override
        public final Pair<Object, CQLDataType> getColumnValue(String tname, CharSequence name) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Map<String, Pair<Object, CQLDataType>> getColumnValues(Iterable<CharSequence> names) {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getColumnValues(this.object, names);
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname, Iterable<CharSequence> names) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }

        public Map<String, Pair<Object, CQLDataType>> getColumnValues(CharSequence ... names) {
            if (UDTClassInfoImpl.this.table == null) {
                return Collections.emptyMap();
            }
            return UDTClassInfoImpl.this.table.getColumnValues(this.object, names);
        }

        @Override
        public final Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname, CharSequence ... names) {
            throw new IllegalArgumentException("user-defined types do not define tables");
        }
    }
}

