/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.helenus.commons.collections.iterators.TransformSpliterator;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;

public class PersistedOrderedSet<T, PT>
extends LinkedHashSet<T>
implements PersistedObject<T, PT> {
    private static final long serialVersionUID = 1444306189578940573L;
    private final Persisted persisted;
    private final Persister<T, PT> persister;
    private final String fname;
    private final LinkedHashSet<PersistedValue<T, PT>> set;

    PersistedOrderedSet(PersistedOrderedSet<T, PT> set) {
        super(6);
        this.persisted = set.persisted;
        this.persister = set.persister;
        this.fname = set.fname;
        this.set = (LinkedHashSet)set.set.clone();
    }

    PersistedOrderedSet(Persisted persisted, Persister<T, PT> persister, String fname, Set<?> set, boolean encoded) {
        super(6);
        this.persisted = persisted;
        this.persister = persister;
        this.fname = fname;
        this.set = encoded ? set.stream().map(pt -> new PersistedValue(persisted, persister, fname).setEncodedValue(pt)).collect(Collectors.toCollection(LinkedHashSet::new)) : set.stream().map(t -> {
            PersistedValue pval = new PersistedValue(persisted, persister, fname).setDecodedValue(t);
            pval.getEncodedValue();
            return pval;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public LinkedHashSet<PersistedValue<T, PT>> getPersistedSet() {
        return this.set;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new TransformIterator<PersistedValue<T, PT>, T>(this.set.iterator()){

            protected T transform(PersistedValue<T, PT> pv) {
                return pv.getDecodedValue();
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return new TransformSpliterator<PersistedValue<T, PT>, T>(this.set.spliterator()){

            protected T transform(PersistedValue<T, PT> pv) {
                return pv.getDecodedValue();
            }
        };
    }

    @Override
    public Stream<T> stream() {
        return this.set.stream().map(pv -> pv.getDecodedValue());
    }

    @Override
    public Stream<T> parallelStream() {
        return this.set.parallelStream().map(pv -> pv.getDecodedValue());
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(new PersistedValue(this.persisted, this.persister, this.fname).setDecodedValue(this.persister.getDecodedClass().cast(o)));
    }

    @Override
    public boolean add(T e) {
        return this.set.add(new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(new PersistedValue(this.persisted, this.persister, this.fname).setDecodedValue(this.persister.getDecodedClass().cast(o)));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public String toString() {
        return this.set.toString();
    }

    @Override
    public Object clone() {
        return new PersistedOrderedSet<T, PT>(this);
    }
}

