/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.utils.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.Keywords;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.impl.PersistedList;
import org.helenus.driver.impl.PersistedMap;
import org.helenus.driver.impl.PersistedSet;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTValueWrapper;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTTypeEntity;

public abstract class Utils {
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?");

    public static StringBuilder joinAndAppendNamesAndValues(StringBuilder sb, String separator, String keySeparator, Map<String, Pair<Object, CQLDataType>> mappings) {
        boolean first = true;
        for (Map.Entry<String, Pair<Object, CQLDataType>> e : mappings.entrySet()) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendName(e.getKey(), sb).append(keySeparator);
            Utils.appendValue(e.getValue().getLeft(), (CQLDataType)e.getValue().getRight(), sb);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendWithNoDuplicates(TableInfoImpl<?> tinfo, StringBuilder sb, String separator, Collection<? extends Appendeable> values) {
        HashSet<String> done = new HashSet<String>(values.size() * 3 / 2);
        boolean first = true;
        for (Appendeable appendeable : values) {
            StringBuilder vsb = new StringBuilder(10);
            appendeable.appendTo(tinfo, vsb);
            String vs = vsb.toString();
            if (!done.add(vs)) continue;
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(vs);
        }
        return sb;
    }

    public static StringBuilder joinAndAppend(TableInfoImpl<?> tinfo, StringBuilder sb, String separator, Collection<? extends Appendeable> values) {
        boolean first = true;
        for (Appendeable appendeable : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            appendeable.appendTo(tinfo, sb);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendNames(StringBuilder sb, String separator, Iterable<?> values) {
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendName(value, sb);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendValues(StringBuilder sb, String separator, Iterable<Pair<Object, CQLDataType>> values) {
        boolean first = true;
        for (Pair<Object, CQLDataType> value : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendValue(value.getLeft(), (CQLDataType)value.getRight(), sb);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendValues(StringBuilder sb, String separator, Iterable<?> values, CQLDataType definition) {
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendValue(value, definition, sb);
        }
        return sb;
    }

    public static boolean isSerializable(Object value) {
        if (value instanceof BindMarker || value instanceof BindMarker || value instanceof FCName) {
            return false;
        }
        return !(value instanceof Number) || value instanceof BigInteger || value instanceof BigDecimal;
    }

    static StringBuilder appendValue(Object value, CQLDataType definition, StringBuilder sb, List<Object> variables) {
        if (variables == null || !Utils.isSerializable(value)) {
            return Utils.appendValue(value, definition, sb);
        }
        sb.append('?');
        variables.add(value);
        return sb;
    }

    public static StringBuilder appendValue(Object value, CQLDataType definition, StringBuilder sb) {
        if (value instanceof PersistedValue) {
            value = ((PersistedValue)value).getEncodedValue();
        }
        if (Utils.appendValueIfLiteral(value, sb)) {
            return sb;
        }
        if (Utils.appendValueIfCollection(value, definition, sb)) {
            return sb;
        }
        if (Utils.appendValueIfUdt(value, definition, sb)) {
            return sb;
        }
        if (Utils.appendValueIfTuple(value, definition, sb)) {
            return sb;
        }
        Utils.appendStringIfValid(value, sb);
        return sb;
    }

    public static StringBuilder appendFlatValue(Object value, CQLDataType definition, StringBuilder sb) {
        if (value instanceof PersistedValue) {
            value = ((PersistedValue)value).getEncodedValue();
        }
        if (Utils.appendValueIfLiteral(value, sb)) {
            return sb;
        }
        if (Utils.appendValueIfUdt(value, definition, sb)) {
            return sb;
        }
        if (Utils.appendValueIfTuple(value, definition, sb)) {
            return sb;
        }
        Utils.appendStringIfValid(value, sb);
        return sb;
    }

    private static void appendStringIfValid(Object value, StringBuilder sb) {
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        } else if (value instanceof Locale) {
            value = ((Locale)value).toString();
        } else if (value instanceof ZoneId) {
            value = ((ZoneId)value).getId();
        } else if (value instanceof Instant) {
            value = String.valueOf(((Instant)value).toEpochMilli());
        } else if (value instanceof Class) {
            value = ((Class)value).getName();
        }
        if (value instanceof RawString) {
            sb.append(value.toString());
        } else {
            Validate.isTrue((boolean)(value instanceof String), (String)"invalid value %s of type unknown to the statement builder: %s", (Object[])new Object[]{value, !(value instanceof byte[]) ? "" : " (for blob values, make sure to use a ByteBuffer)"});
            Utils.appendValueString((String)value, sb);
        }
    }

    private static boolean appendValueIfLiteral(Object value, StringBuilder sb) {
        if (value instanceof Number || value instanceof UUID || value instanceof Boolean) {
            sb.append(value);
            return true;
        }
        if (value instanceof InetAddress) {
            sb.append("'").append(((InetAddress)value).getHostAddress()).append("'");
            return true;
        }
        if (value instanceof Date) {
            sb.append(((Date)value).getTime());
            return true;
        }
        if (value instanceof ByteBuffer) {
            sb.append(Bytes.toHexString((ByteBuffer)((ByteBuffer)value)));
            return true;
        }
        if (value instanceof byte[]) {
            sb.append(Bytes.toHexString((byte[])((byte[])value)));
            return true;
        }
        if (value instanceof BindMarker) {
            sb.append(value);
            return true;
        }
        if (value instanceof BindMarker) {
            sb.append(value);
            return true;
        }
        if (value instanceof FCall) {
            FCall fcall = (FCall)value;
            sb.append(fcall.getName()).append("(");
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Utils.appendValue(fcall.parameters[i], null, sb);
            }
            sb.append(")");
            return true;
        }
        if (value instanceof CName) {
            Utils.appendName(((CName)value).getName(), sb);
            return true;
        }
        if (value instanceof JsonObject) {
            sb.append(value.toString().replaceAll("'", "'QUOTE'").replaceAll("\"", "'").replaceAll("\\\\'", "\"").replaceAll("'QUOTE'", "\\\\'"));
            return true;
        }
        if (value == null) {
            sb.append("null");
            return true;
        }
        return false;
    }

    private static boolean appendValueIfCollection(Object value, CQLDataType definition, StringBuilder sb) {
        if (value instanceof List) {
            Utils.appendList((List)value, definition, sb);
            return true;
        }
        if (definition != null && definition.getMainType() == DataType.ORDERED_SET && value instanceof Collection) {
            Utils.appendList((Collection)value, definition, sb);
            return true;
        }
        if (value instanceof Set) {
            Utils.appendSet((Set)value, definition, sb);
            return true;
        }
        if (value instanceof Map) {
            Utils.appendMap((Map)value, definition, sb);
            return true;
        }
        return false;
    }

    static StringBuilder appendCollection(Object value, CQLDataType definition, StringBuilder sb, List<Object> variables) {
        if (variables == null || !Utils.isSerializable(value)) {
            boolean wasCollection = Utils.appendValueIfCollection(value, definition, sb);
            assert (wasCollection);
        } else {
            sb.append('?');
            variables.add(value);
        }
        return sb;
    }

    static StringBuilder appendList(Collection<?> l, CQLDataType definition, StringBuilder sb) {
        CQLDataType vdef = definition.getElementType();
        sb.append('[');
        boolean first = true;
        if (l instanceof PersistedList) {
            l = ((PersistedList)l).getPersistedList();
        }
        for (Object elt : l) {
            Validate.isTrue((elt != null ? 1 : 0) != 0, (String)"null are not supported in %s", (Object[])new Object[]{l instanceof List ? "lists" : (l instanceof Set ? "sets" : "collections")});
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendFlatValue(elt, vdef, sb);
        }
        sb.append(']');
        return sb;
    }

    static StringBuilder appendSet(Set<?> s, CQLDataType definition, StringBuilder sb) {
        CQLDataType vdef = definition.getElementType();
        sb.append('{');
        boolean first = true;
        if (s instanceof PersistedSet) {
            s = ((PersistedSet)s).getPersistedSet();
        }
        for (Object elt : s) {
            Validate.isTrue((elt != null ? 1 : 0) != 0, (String)"null are not supported in sets", (Object[])new Object[0]);
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendFlatValue(elt, vdef, sb);
        }
        sb.append('}');
        return sb;
    }

    static StringBuilder appendMap(Map<?, ?> m, CQLDataType definition, StringBuilder sb) {
        CQLDataType kdef = definition.getFirstArgumentType();
        CQLDataType vdef = definition.getElementType();
        sb.append('{');
        boolean first = true;
        if (m instanceof PersistedMap) {
            m = ((PersistedMap)m).getPersistedMap();
        }
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object eval = entry.getValue();
            Validate.isTrue((eval != null ? 1 : 0) != 0, (String)"null are not supported in maps", (Object[])new Object[0]);
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendFlatValue(entry.getKey(), kdef, sb);
            sb.append(':');
            Utils.appendFlatValue(eval, vdef, sb);
        }
        sb.append('}');
        return sb;
    }

    private static boolean appendValueIfUdt(Object value, CQLDataType definition, StringBuilder sb) {
        if (value instanceof UDTValue) {
            sb.append(((UDTValue)value).toString());
            return true;
        }
        if (value instanceof UDTValueWrapper) {
            sb.append(((UDTValueWrapper)value).toString());
            return true;
        }
        if (value != null) {
            Class uclass = ReflectionUtils.findFirstClassAnnotatedWith(value.getClass(), UDTEntity.class);
            if (uclass != null) {
                ClassInfo cinfo = definition instanceof ClassInfo ? (ClassInfo)definition : StatementBuilder.getClassInfo((Class)uclass);
                Validate.isTrue((boolean)(cinfo instanceof UDTClassInfoImpl), (String)"unsupported element conversion from: %s to: %s; unknown user-defined type", (Object[])new Object[]{uclass.getName(), UDTValue.class.getName()});
                sb.append(new UDTValueWrapper((UDTClassInfoImpl)cinfo, value).toString());
                return true;
            }
            Class utclass = ReflectionUtils.findFirstClassAnnotatedWith(value.getClass(), UDTTypeEntity.class);
            if (utclass != null) {
                ClassInfo cinfo = definition instanceof ClassInfo ? (ClassInfo)definition : StatementBuilder.getClassInfo((Class)utclass);
                Validate.isTrue((boolean)(cinfo instanceof UDTClassInfoImpl), (String)"unsupported element conversion from: %s to: %s; unknown user-defined type", (Object[])new Object[]{utclass.getName(), UDTValue.class.getName()});
                sb.append(new UDTValueWrapper((UDTClassInfoImpl)cinfo, value).toString());
                return true;
            }
        }
        return false;
    }

    private static boolean appendValueIfTuple(Object value, CQLDataType definition, StringBuilder sb) {
        if (value instanceof TupleValue) {
            sb.append(((TupleValue)value).toString());
            return true;
        }
        return false;
    }

    private static StringBuilder appendValueString(String value, StringBuilder sb) {
        return sb.append('\'').append(Utils.replace(value, '\'', "''")).append('\'');
    }

    static boolean isRawValue(Object value) {
        return value != null && !(value instanceof FCall) && !(value instanceof CName) && !(value instanceof BindMarker) && !(value instanceof BindMarker);
    }

    public static StringBuilder appendName(String name, StringBuilder sb) {
        if (cnamePattern.matcher(name = name.trim()).matches() && !Keywords.isReserved((String)name) || name.startsWith("\"") || name.startsWith("token(") || name.contains("|")) {
            sb.append(name);
        } else {
            sb.append('\"').append(name).append('\"');
        }
        return sb;
    }

    static StringBuilder appendName(Object name, StringBuilder sb) {
        if (name instanceof String) {
            Utils.appendName((String)name, sb);
        } else if (name instanceof CName) {
            Utils.appendName(((CName)name).getName(), sb);
        } else if (name instanceof FCall) {
            FCall fcall = (FCall)name;
            sb.append(fcall.getName()).append("(");
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Utils.appendValue(fcall.parameters[i], null, sb);
            }
            sb.append(")");
        } else {
            Utils.appendName((String)name, sb);
        }
        return sb;
    }

    static String replace(String text, char search, String replacement) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(search, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return text;
        }
        int newLength = text.length() + nbMatch * (replacement.length() - 1);
        char[] result = new char[newLength];
        int newIdx = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == search) {
                for (int r = 0; r < replacement.length(); ++r) {
                    result[newIdx++] = replacement.charAt(r);
                }
                continue;
            }
            result[newIdx++] = c;
        }
        return new String(result);
    }

    public static class Alias {
        private final Object column;
        private final String alias;

        Alias(Object column, String alias) {
            this.column = column;
            this.alias = alias;
        }

        public String toString() {
            return String.format("%s AS %s", this.column, this.alias);
        }
    }

    public static class CNameSequence
    implements CharSequence {
        private final String[] names;
        private final String seq;

        CNameSequence(String seq, String ... names) {
            this.names = names;
            this.seq = seq;
        }

        public String getName() {
            return this.names[0];
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.seq.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.seq;
        }
    }

    public static class CNameKey
    extends CName {
        private final Object key;

        public CNameKey(String name, Object key) {
            super(name);
            this.key = key;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Utils.appendName(this.getColumnName(), sb);
            sb.append('[');
            Utils.appendFlatValue(this.key, null, sb);
            return sb.append(']').toString();
        }
    }

    public static class CNameIndex
    extends CName {
        private final int idx;

        public CNameIndex(String name, int idx) {
            super(name);
            if (idx < 0) {
                throw new ArrayIndexOutOfBoundsException("invalid index '" + idx + "' for column '" + name + "'");
            }
            this.idx = idx;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Utils.appendName(this.getColumnName(), sb);
            return sb.append('[').append(this.idx).append(']').toString();
        }
    }

    public static class CName
    extends FCName {
        public CName(String name) {
            super(name);
            Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        }

        public String getColumnName() {
            return this.getName();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class FCall
    extends FCName
    implements Iterable<Object> {
        private final Object[] parameters;

        public FCall(String name, Object ... parameters) {
            super(name);
            Validate.notNull((Object)name, (String)"invalid null operation name", (Object[])new Object[0]);
            this.parameters = parameters;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ObjectArrayIterator(this.parameters);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(this.parameters[i]);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static abstract class FCName {
        private final String name;

        FCName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class RawString {
        private final String str;

        public RawString(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(TableInfoImpl<?> var1, StringBuilder var2);
    }
}

