/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.info.UDTTypeClassInfo;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.Table;

public class UDTSubClassInfoImpl<T>
extends UDTRootClassInfoImpl<T> {
    private final UDTRootClassInfoImpl<? super T> rinfo;

    UDTSubClassInfoImpl(UDTRootClassInfoImpl<? super T> rinfo, Class<T> clazz) {
        super(rinfo, clazz);
        Validate.isTrue((boolean)Modifier.isAbstract(clazz.getModifiers()), (String)"UDT root entity subclass '%s', must be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.rinfo = rinfo;
        this.validate(rinfo.getObjectClass());
    }

    private void validate(Class<? super T> rclazz) {
        Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Keyspace.class).isAssignableFrom(rclazz), (String)"@Keyspace annotation is not defined on UDT root element class '%s' for subclass: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
        Validate.isTrue((boolean)ReflectionUtils.findFirstClassAnnotatedWith((Class)this.clazz, Table.class).isAssignableFrom(rclazz), (String)"@Table annotation is not defined on UDT root element class '%s' for subclass: %s", (Object[])new Object[]{rclazz.getSimpleName(), this.clazz.getSimpleName()});
        this.getTableImpl().getTypeKey().ifPresent(f -> Validate.isTrue((boolean)f.getDeclaringClass().isAssignableFrom(rclazz), (String)"@TypeKey annotation with name '%s' is not defined on UDT root element class '%s' for subclass: %s", (Object[])new Object[]{f.getColumnName(), rclazz.getSimpleName(), this.clazz.getSimpleName()}));
    }

    public UDTRootClassInfoImpl<? super T> getRoot() {
        return this.rinfo;
    }

    public UDTRootClassInfoImpl.POJOContext newContextFromRoot(Object object) {
        try {
            return this.newContext(this.clazz.cast(object));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public T getObject(Row row, String type, Map<String, Object> suffixes) {
        if (row == null || !this.clazz.isAssignableFrom(super.getType(type).getObjectClass())) {
            return null;
        }
        return super.getObject(row, suffixes);
    }

    @Override
    public T getObject(Row row, Map<String, Object> suffixes) {
        int i;
        if (row == null) {
            return null;
        }
        ColumnDefinitions cdefs = row.getColumnDefinitions();
        TableInfoImpl table = this.getTableImpl();
        FieldInfoImpl type = table.getTypeKey().orElse(null);
        if (type != null && (i = cdefs.getIndexOf(type.getColumnName())) != -1 && table.getName().equals(cdefs.getTable(i))) {
            return this.getObject(row, Objects.toString(type.decodeValue(row), null), suffixes);
        }
        throw new ObjectConversionException(this.clazz, row, "missing POJO type column");
    }

    @Override
    public <S extends T> UDTTypeClassInfoImpl<S> getType(Class<S> clazz) {
        if (this.clazz.isAssignableFrom(clazz)) {
            return super.getType((Class)clazz);
        }
        return null;
    }

    @Override
    public UDTTypeClassInfoImpl<? extends T> getType(String name) {
        UDTTypeClassInfo tinfo = super.getType(name);
        if (this.clazz.isAssignableFrom(tinfo.getObjectClass())) {
            return tinfo;
        }
        return null;
    }

    @Override
    public Stream<UDTTypeClassInfo<? extends T>> types() {
        return super.types().filter(t -> this.clazz.isAssignableFrom(t.getObjectClass()));
    }

    @Override
    public Stream<UDTTypeClassInfoImpl<? extends T>> typeImpls() {
        return super.typeImpls().filter(t -> this.clazz.isAssignableFrom(t.getObjectClass()));
    }

    @Override
    public int getNumTypes() {
        return (int)this.types().count();
    }

    @Override
    public String toString() {
        return "UDTSubClassInfoImpl(super=" + super.toString() + ", rinfo=" + this.rinfo + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UDTSubClassInfoImpl)) {
            return false;
        }
        UDTSubClassInfoImpl other = (UDTSubClassInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UDTSubClassInfoImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

