/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.helenus.commons.collections.iterators.TransformSpliterator;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;

public class PersistedSet<T, PT>
extends AbstractSet<T>
implements PersistedObject<T, PT> {
    private final Persisted persisted;
    private final Persister<T, PT> persister;
    private final String fname;
    private final Set<PersistedValue<T, PT>> set;

    private static <NV> Set<NV> newSet(Set<?> set) {
        if (set instanceof SortedSet) {
            return new TreeSet();
        }
        if (set instanceof LinkedHashSet) {
            return new LinkedHashSet(set.size() * 3 / 2);
        }
        return new HashSet(set.size() * 3 / 2);
    }

    PersistedSet(Persisted persisted, Persister<T, PT> persister, String fname, Set<PersistedValue<T, PT>> pset, Set<?> set, boolean encoded) {
        this.persisted = persisted;
        this.persister = persister;
        this.fname = fname;
        this.set = pset;
        if (encoded) {
            set.forEach(pt -> pset.add(new PersistedValue(persisted, persister, fname).setEncodedValue(pt)));
        } else {
            set.forEach(t -> {
                PersistedValue pval = new PersistedValue(persisted, persister, fname).setDecodedValue(t);
                pval.getEncodedValue();
                pset.add(pval);
            });
        }
    }

    PersistedSet(Persisted persisted, Persister<T, PT> persister, String fname, Set<?> set, boolean encoded) {
        this(persisted, persister, fname, PersistedSet.newSet(set), set, encoded);
    }

    public Set<PersistedValue<T, PT>> getPersistedSet() {
        return this.set;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new TransformIterator<PersistedValue<T, PT>, T>(this.set.iterator()){

            protected T transform(PersistedValue<T, PT> pv) {
                return pv.getDecodedValue();
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return new TransformSpliterator<PersistedValue<T, PT>, T>(this.set.spliterator()){

            protected T transform(PersistedValue<T, PT> pv) {
                return pv.getDecodedValue();
            }
        };
    }

    @Override
    public Stream<T> stream() {
        return this.set.stream().map(pv -> pv.getDecodedValue());
    }

    @Override
    public Stream<T> parallelStream() {
        return this.set.parallelStream().map(pv -> pv.getDecodedValue());
    }

    @Override
    public boolean add(T e) {
        return this.set.add(new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(new PersistedValue(this.persisted, this.persister, this.fname).setDecodedValue(this.persister.getDecodedClass().cast(o)));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public String toString() {
        return this.set.toString();
    }
}

