/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.helenus.commons.collections.iterators.TransformListIterator;
import org.helenus.driver.impl.PersistedObject;
import org.helenus.driver.impl.PersistedValue;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;

public class PersistedList<T, PT>
extends AbstractList<T>
implements PersistedObject<T, PT> {
    private final Persisted persisted;
    private final Persister<T, PT> persister;
    private final String fname;
    private final List<PersistedValue<T, PT>> list;

    private static <NV> List<NV> newList(List<?> list) {
        if (list instanceof LinkedList) {
            return new LinkedList();
        }
        return new ArrayList(list.size());
    }

    PersistedList(Persisted persisted, Persister<T, PT> persister, String fname, List<?> list, boolean encoded) {
        this.persisted = persisted;
        this.persister = persister;
        this.fname = fname;
        this.list = PersistedList.newList(list);
        if (encoded) {
            list.forEach(pt -> this.list.add(new PersistedValue(persisted, persister, fname).setEncodedValue(pt)));
        } else {
            list.forEach(t -> {
                PersistedValue pval = new PersistedValue(persisted, persister, fname).setDecodedValue(t);
                pval.getEncodedValue();
                this.list.add(pval);
            });
        }
    }

    private PersistedList(PersistedList<T, PT> plist, int fromIndex, int toIndex) {
        this.persisted = plist.persisted;
        this.persister = plist.persister;
        this.fname = plist.fname;
        this.list = plist.list.subList(fromIndex, toIndex);
    }

    public List<PersistedValue<T, PT>> getPersistedList() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new TransformIterator<PersistedValue<T, PT>, T>(this.list.iterator()){

            protected T transform(PersistedValue<T, PT> pv) {
                return pv.getDecodedValue();
            }
        };
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new TransformListIterator<PersistedValue<T, PT>, T>(this.list.listIterator()){

            protected T transform(PersistedValue<T, PT> pv) {
                return pv.getDecodedValue();
            }
        };
    }

    @Override
    public Stream<T> stream() {
        return this.list.stream().map(pv -> pv.getDecodedValue());
    }

    @Override
    public Stream<T> parallelStream() {
        return this.list.parallelStream().map(pv -> pv.getDecodedValue());
    }

    @Override
    public boolean add(T e) {
        this.list.add(new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(e));
        return true;
    }

    @Override
    public void add(int index, T e) {
        this.list.add(index, new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(e));
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return this.list.get(index).getDecodedValue();
    }

    @Override
    public T set(int index, T e) {
        return this.list.set(index, new PersistedValue<T, PT>(this.persisted, this.persister, this.fname).setDecodedValue(e)).getDecodedValue();
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index).getDecodedValue();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new PersistedList<T, PT>(this, fromIndex, toIndex);
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

