/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import org.apache.commons.lang3.Validate;
import org.helenus.driver.Ordering;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;

public class OrderingImpl
extends Utils.Appendeable
implements Ordering {
    private final CharSequence name;
    private final boolean isDesc;

    OrderingImpl(CharSequence name, boolean isDesc) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        this.name = name;
        this.isDesc = isDesc;
    }

    @Override
    void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
        Utils.appendName(this.name, sb);
        sb.append(this.isDesc ? " DESC" : " ASC");
    }

    CharSequence getColumnName() {
        return this.name;
    }

    boolean isDescending() {
        return this.isDesc;
    }

    <T> void validate(TableInfoImpl<T> table) {
        table.validateColumn(this.name);
    }
}

