/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateIndex;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.RootClassInfo;
import org.helenus.driver.persistence.Index;

public class CreateIndexImpl<T>
extends GroupStatementImpl<Void, VoidFuture, T>
implements CreateIndex<T> {
    private final String customClass;
    private final List<TableInfoImpl<T>> tables = new ArrayList<TableInfoImpl<T>>(8);
    private volatile boolean ifNotExists;
    private final WhereImpl<T> where;

    public CreateIndexImpl(ClassInfoImpl.Context context, String customClass, String[] tables, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        this.customClass = customClass;
        RootClassInfo cinfo = context.getClassInfo();
        if (cinfo instanceof TypeClassInfoImpl) {
            cinfo = ((TypeClassInfoImpl)cinfo).getRoot();
        }
        if (tables != null) {
            for (String table : tables) {
                if (table == null) continue;
                this.tables.add((TableInfoImpl)cinfo.getTable(table));
            }
        } else {
            this.tables.addAll(cinfo.getTablesImpl());
        }
        this.where = new WhereImpl(this);
    }

    private StringBuilder buildIndexQueryString(FieldInfoImpl<T> field, TableInfoImpl<T> table) {
        StringBuilder builder = new StringBuilder(80);
        Index index = field.getIndex();
        String iname = index.name();
        String customClass = this.customClass != null ? this.customClass : index.customClass();
        builder.append("CREATE ");
        if (!StringUtils.isEmpty((CharSequence)customClass)) {
            builder.append("CUSTOM ");
        }
        if (this.ifNotExists) {
            builder.append("INDEX IF NOT EXISTS");
        }
        if (!StringUtils.isEmpty((CharSequence)iname)) {
            builder.append(' ').append(iname);
        }
        builder.append(" ON ");
        if (this.getKeyspace() != null) {
            Utils.appendName(this.getKeyspace(), builder).append('.');
        }
        Utils.appendName(table.getName(), builder);
        builder.append(" (").append(field.getColumnName()).append(')');
        if (!StringUtils.isEmpty((CharSequence)customClass)) {
            builder.append(" USING ").append(customClass);
        }
        builder.append(';');
        return builder;
    }

    List<StringBuilder> buildQueryStrings(TableInfoImpl<T> table) {
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>(2);
        for (FieldInfoImpl<T> field : table.getIndexes()) {
            builders.add(this.buildIndexQueryString(field, table));
        }
        return builders;
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" CREATE INDEX");
    }

    @Override
    protected List<StatementImpl<?, ?, ?>> buildGroupedStatements() {
        return this.tables.stream().map(t -> this.buildQueryStrings((TableInfoImpl<T>)t)).filter(bs -> bs != null).flatMap(bs -> bs.stream()).filter(b -> b != null && b.length() != 0).map(b -> this.init(new SimpleStatementImpl(b.toString(), this.mgr, this.bridge))).collect(Collectors.toList());
    }

    public CreateIndex<T> ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public CreateIndex.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public CreateIndex.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateIndexImpl<T>>
    implements CreateIndex.Where<T> {
        WhereImpl(CreateIndexImpl<T> statement) {
            super(statement);
        }

        public CreateIndex.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE INDEX statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((CreateIndexImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ((CreateIndexImpl)this.statement).getContext().addSuffix(c.getColumnName().toString(), c.firstValue());
                this.setDirty();
            }
            return this;
        }
    }

    public static class BuilderImpl<T>
    implements CreateIndex.Builder<T> {
        private final StatementManagerImpl mgr;
        private final StatementBridge bridge;
        private final ClassInfoImpl.Context context;
        private volatile String customClass;

        public BuilderImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            this.mgr = mgr;
            this.bridge = bridge;
            this.context = context;
        }

        public Class<T> getObjectClass() {
            return this.context.getObjectClass();
        }

        public ClassInfo<T> getClassInfo() {
            return this.context.getClassInfo();
        }

        public CreateIndex.Builder<T> usingClass(String customClass) {
            this.customClass = customClass;
            return this;
        }

        public CreateIndex<T> on(String ... tables) {
            return new CreateIndexImpl(this.context, this.customClass, tables, this.mgr, this.bridge);
        }

        public CreateIndex<T> onAll() {
            return new CreateIndexImpl(this.context, this.customClass, null, this.mgr, this.bridge);
        }
    }
}

