/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import java.util.List;
import java.util.stream.Collectors;
import org.helenus.driver.impl.DataTypeImpl;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Ordering;

public class DataTypeParser
extends CassandraTypeParser {
    private static CQLDataType toCQL(DataType t) {
        if (t instanceof UserType) {
            final UserType ut = (UserType)t;
            return new CQLDataType(){

                public String name() {
                    return ut.getTypeName();
                }

                public boolean isCollection() {
                    return false;
                }

                public boolean isUserDefined() {
                    return true;
                }

                public CQLDataType getMainType() {
                    return this;
                }

                public CQLDataType getElementType() {
                    return null;
                }

                public List<CQLDataType> getArgumentTypes() {
                    return null;
                }

                public CQLDataType getFirstArgumentType() {
                    return null;
                }

                public boolean isAlterableTo(CQLDataType to) {
                    return false;
                }

                public String toCQL() {
                    return "frozen<" + this.name() + '>';
                }
            };
        }
        if (t instanceof TupleType) {
            final TupleType tt = (TupleType)t;
            return new CQLDataType(){

                public String name() {
                    return "tuple";
                }

                public boolean isCollection() {
                    return false;
                }

                public boolean isUserDefined() {
                    return false;
                }

                public CQLDataType getMainType() {
                    return this;
                }

                public CQLDataType getElementType() {
                    return null;
                }

                public List<CQLDataType> getArgumentTypes() {
                    return null;
                }

                public CQLDataType getFirstArgumentType() {
                    return null;
                }

                public boolean isAlterableTo(CQLDataType to) {
                    return false;
                }

                public String toCQL() {
                    return tt.getComponentTypes().stream().map(ct -> DataTypeParser.toCQL(ct).toCQL()).collect(Collectors.joining(",", "frozen<tuple<", ">>"));
                }
            };
        }
        return new DataTypeImpl.Definition(org.helenus.driver.persistence.DataType.valueOf((String)t.getName().name()), t.getTypeArguments().stream().map(ta -> DataTypeParser.toCQL(ta)).collect(Collectors.toList()));
    }

    public static CQLDataType validatorToCQL(String validator) {
        return DataTypeParser.toCQL(CassandraTypeParser.parseOne((String)validator));
    }

    public static CQLDataType typeToCQL(String type) {
        if (type.startsWith("org.apache.cassandra.db.marshal.FrozenType(")) {
            type = type.substring(43, type.length() - 1);
        }
        return DataTypeParser.toCQL(CassandraTypeParser.parseOne((String)type));
    }

    public static boolean isReversed(String validator) {
        return CassandraTypeParser.isReversed((String)validator);
    }

    public static Ordering getOrderingFrom(String validator) {
        return CassandraTypeParser.isReversed((String)validator) ? Ordering.DESCENDING : Ordering.ASCENDING;
    }

    public static boolean isUserType(String validator) {
        return CassandraTypeParser.isUserType((String)validator);
    }

    public static boolean isTupleType(String validator) {
        return CassandraTypeParser.isTupleType((String)validator);
    }

    private DataTypeParser() {
    }
}

