/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.FieldInfo;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Column;
import org.helenus.driver.persistence.Table;

public class TableInfoImpl<T>
implements TableInfo<T> {
    private final Class<T> clazz;
    private final ClassInfoImpl<T> cinfo;
    private final Table table;
    private final String name;
    private final Map<Pair<String, Class<?>>, FieldInfoImpl<T>> fields = new LinkedHashMap(25);
    private final Map<String, FieldInfoImpl<T>> columns = new LinkedHashMap<String, FieldInfoImpl<T>>(25);
    private final Map<String, FieldInfoImpl<T>> primaryKeyColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(12);
    private final Map<String, FieldInfoImpl<T>> indexColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(12);
    private final Map<String, FieldInfoImpl<T>> partitionKeyColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(12);
    private final Map<String, FieldInfoImpl<T>> clusteringKeyColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(12);
    private final MutableObject<FieldInfoImpl<T>> typeKeyColumn = new MutableObject();
    private final Map<String, Object> finalPrimaryKeyValues = new LinkedHashMap<String, Object>(12);
    private final Map<String, FieldInfoImpl<T>> mandatoryAndPrimaryKeyColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(12);
    private final Map<String, FieldInfoImpl<T>> nonPrimaryKeyColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(12);
    private final Map<String, FieldInfoImpl<T>> multiKeyColumns = new LinkedHashMap<String, FieldInfoImpl<T>>(2);
    private final List<FieldInfoImpl<T>> multiKeyColumnsList = new ArrayList<FieldInfoImpl<T>>(2);
    private volatile boolean hasCollectionColumns = false;

    static final String cleanName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
    }

    public TableInfoImpl(StatementManagerImpl mgr, ClassInfoImpl<T> cinfo, Table table) {
        this.clazz = cinfo.getObjectClass();
        this.cinfo = cinfo;
        this.table = table;
        this.name = table != null ? TableInfoImpl.cleanName(table.name()) : null;
        this.findColumnFields(mgr);
    }

    public TableInfoImpl(StatementManagerImpl mgr, UDTClassInfoImpl<T> cinfo, String name) {
        this.clazz = cinfo.getObjectClass();
        this.cinfo = cinfo;
        this.table = null;
        this.name = name;
        this.findColumnFields(mgr);
    }

    private void findColumnFields(StatementManagerImpl mgr) {
        FieldInfoImpl<T> lastPartitionKey = null;
        FieldInfoImpl<T> lastClusteringKey = null;
        for (Field f : ReflectionUtils.getAllFieldsAnnotatedWith(this.clazz, Column.class, (boolean)true)) {
            FieldInfoImpl<T> oldc;
            Pair pf = Pair.of((Object)f.getName(), f.getDeclaringClass());
            FieldInfoImpl<T> field = this.fields.get(pf);
            if (field == null) {
                field = new FieldInfoImpl(this, f);
                if (!field.isColumn()) continue;
                this.fields.put(pf, field);
            }
            if (field.isTypeKey()) {
                FieldInfoImpl oldk = (FieldInfoImpl)this.typeKeyColumn.getValue();
                if (oldk != null) {
                    throw new IllegalArgumentException(this.clazz.getSimpleName() + " cannot annotate more than one field as a type key for table '" + this.table.name() + "': found '" + oldk.getDeclaringClass().getSimpleName() + "." + oldk.getName() + "' and '" + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "'");
                }
                if (this.cinfo instanceof UDTTypeClassInfoImpl) {
                    this.fields.remove(pf);
                    continue;
                }
                this.typeKeyColumn.setValue(field);
                this.mandatoryAndPrimaryKeyColumns.put(field.getColumnName(), field);
                if (field.isIndex()) {
                    this.indexColumns.put(field.getColumnName(), field);
                }
            }
            if ((oldc = this.columns.put(field.getColumnName(), field)) != null) {
                throw new IllegalArgumentException(this.clazz.getSimpleName() + " cannot annotate more than one field with the same column name '" + field.getColumnName() + (this.table != null ? "' for table '" + this.table.name() : "") + "': found '" + oldc.getDeclaringClass().getSimpleName() + "." + oldc.getName() + "' and '" + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "'");
            }
            if (field.getDataType().isCollection()) {
                this.hasCollectionColumns = true;
            }
            if (field.isPartitionKey()) {
                lastPartitionKey = field;
                this.mandatoryAndPrimaryKeyColumns.put(field.getColumnName(), field);
                this.primaryKeyColumns.put(field.getColumnName(), field);
                this.partitionKeyColumns.put(field.getColumnName(), field);
                if (field.isFinal()) {
                    this.finalPrimaryKeyValues.put(field.getColumnName(), field.getFinalValue());
                }
                if (!field.isMultiKey()) continue;
                this.multiKeyColumns.put(field.getColumnName(), field);
                this.multiKeyColumnsList.add(field);
                continue;
            }
            if (field.isClusteringKey()) {
                lastClusteringKey = field;
                this.mandatoryAndPrimaryKeyColumns.put(field.getColumnName(), field);
                this.primaryKeyColumns.put(field.getColumnName(), field);
                this.clusteringKeyColumns.put(field.getColumnName(), field);
                if (field.isFinal()) {
                    this.finalPrimaryKeyValues.put(field.getColumnName(), field.getFinalValue());
                }
                if (!field.isMultiKey()) continue;
                this.multiKeyColumns.put(field.getColumnName(), field);
                this.multiKeyColumnsList.add(field);
                continue;
            }
            if (field.isIndex()) {
                this.indexColumns.put(field.getColumnName(), field);
            }
            if (field.isMandatory()) {
                this.mandatoryAndPrimaryKeyColumns.put(field.getColumnName(), field);
                this.nonPrimaryKeyColumns.put(field.getColumnName(), field);
                continue;
            }
            this.nonPrimaryKeyColumns.put(field.getColumnName(), field);
        }
        if (this.table != null) {
            Validate.isTrue((!this.partitionKeyColumns.isEmpty() ? 1 : 0) != 0, (String)"pojo '%s' must annotate one field as a partition primary key for table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), this.table.name()});
        }
        mgr.filter(this);
        this.reorderPrimaryKeys();
        if (lastPartitionKey != null) {
            lastPartitionKey.setLast();
        }
        if (lastClusteringKey != null) {
            lastClusteringKey.setLast();
        }
    }

    private void reorderPrimaryKeys() {
        FieldInfoImpl field;
        if (this.table == null || this.table.partition().length == 0 && this.table.clustering().length == 0) {
            return;
        }
        LinkedHashMap<String, FieldInfoImpl<T>> partition = new LinkedHashMap<String, FieldInfoImpl<T>>(this.partitionKeyColumns);
        LinkedHashMap<String, FieldInfoImpl<T>> clustering = new LinkedHashMap<String, FieldInfoImpl<T>>(this.clusteringKeyColumns);
        this.primaryKeyColumns.clear();
        this.partitionKeyColumns.clear();
        this.clusteringKeyColumns.clear();
        for (String columnName : this.table.partition()) {
            field = (FieldInfoImpl)partition.remove(columnName);
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"@Table partition key '%s' not found in pojo '%s' for table '%s'", (Object[])new Object[]{columnName, this.clazz.getSimpleName(), this.table.name()});
            this.primaryKeyColumns.put(columnName, field);
            this.partitionKeyColumns.put(columnName, field);
        }
        this.primaryKeyColumns.putAll(partition);
        this.partitionKeyColumns.putAll(partition);
        for (String columnName : this.table.clustering()) {
            field = (FieldInfoImpl)clustering.remove(columnName);
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"@Table clustering key '%s' not found in pojo '%s' for table '%s'", (Object[])new Object[]{columnName, this.clazz.getSimpleName(), this.table.name()});
            this.primaryKeyColumns.put(columnName, field);
            this.clusteringKeyColumns.put(columnName, field);
        }
        this.primaryKeyColumns.putAll(clustering);
        this.clusteringKeyColumns.putAll(clustering);
    }

    private void validateColumn(Object name, boolean ignoreNonColumnNames) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                this.validateColumn(n2);
            }
            return;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                this.validateColumn(parm, true);
            }
            return;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            if (ignoreNonColumnNames) {
                return;
            }
            if (this.table == null) {
                throw new IllegalArgumentException("unexpected column name '" + name + "' for pojo '" + this.clazz.getSimpleName() + "'");
            }
            throw new IllegalArgumentException("unexpected column name '" + name + "' in table '" + this.table.name() + "' for udt '" + this.clazz.getSimpleName() + "'");
        }
        if (this.table != null) {
            Validate.isTrue((boolean)this.columns.containsKey(n), (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((boolean)this.columns.containsKey(n), (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        }
    }

    FieldInfoImpl<T> forceNonPrimaryColumnToNotBeMandatory(FieldInfoImpl<T> col) {
        if (col.isMandatory()) {
            col = new FieldInfoImpl<T>(this.cinfo, this, col, false);
            this.fields.put(Pair.of((Object)col.getName(), col.getDeclaringClass()), col);
            this.columns.put(col.getColumnName(), col);
            if (col.isIndex()) {
                this.indexColumns.put(col.getColumnName(), col);
            }
            if (col.isMandatory()) {
                this.mandatoryAndPrimaryKeyColumns.put(col.getColumnName(), col);
                this.nonPrimaryKeyColumns.put(col.getColumnName(), col);
            } else {
                this.nonPrimaryKeyColumns.put(col.getColumnName(), col);
            }
        }
        return col;
    }

    void addNonPrimaryColumn(FieldInfoImpl<? extends T> col) {
        Validate.isTrue((this.cinfo instanceof RootClassInfoImpl || this.cinfo instanceof UDTClassInfoImpl ? 1 : 0) != 0, (String)"should not have been called for class '%s'", (Object[])new Object[]{this.cinfo.getClass().getName()});
        FieldInfoImpl<T> old = this.columns.get(col.getColumnName());
        if (old != null) {
            if (!old.getDeclaringClass().equals(col.getDeclaringClass())) {
                Validate.isTrue((old.getDataType().getMainType() == col.getDataType().getMainType() ? 1 : 0) != 0, (String)"incompatible type columns '%s.%s' of type '%s' and '%s.%s' of type '%s' in table '%s' in pojo '%s'", (Object[])new Object[]{old.getDeclaringClass().getSimpleName(), old.getName(), old.getDataType().getMainType(), col.getDeclaringClass().getSimpleName(), col.getName(), col.getDataType().getMainType(), this.name, this.clazz.getSimpleName()});
            }
            if (old.isMandatory() != col.isMandatory()) {
                if (old.isMandatory()) {
                    Validate.isTrue((!this.cinfo.getObjectClass().equals(col.getDeclaringClass()) ? 1 : 0) != 0, (String)"incompatible type columns '%s.%s' of type '%s' and '%s.%s' of type '%s' in table '%s' in pojo '%s'", (Object[])new Object[]{old.getDeclaringClass().getSimpleName(), old.getName(), old.getDataType().getMainType(), col.getDeclaringClass().getSimpleName(), col.getName(), col.getDataType().getMainType(), this.name, this.clazz.getSimpleName()});
                }
                if (this.cinfo instanceof UDTRootClassInfoImpl) {
                    old = this.forceNonPrimaryColumnToNotBeMandatory(old);
                }
            }
            old.getters.putAll(col.getters);
            old.setters.putAll(col.setters);
            return;
        }
        FieldInfoImpl<Object> rcol = this.cinfo instanceof RootClassInfoImpl || this.cinfo instanceof UDTRootClassInfoImpl ? new FieldInfoImpl<T>(this.cinfo, this, col) : col;
        if (rcol.getDataType().isCollection()) {
            this.hasCollectionColumns = true;
        }
        this.fields.put(Pair.of((Object)rcol.getName(), rcol.getDeclaringClass()), rcol);
        this.columns.put(rcol.getColumnName(), rcol);
        if (rcol.isIndex()) {
            this.indexColumns.put(rcol.getColumnName(), rcol);
        }
        if (rcol.isMandatory()) {
            this.mandatoryAndPrimaryKeyColumns.put(rcol.getColumnName(), rcol);
            this.nonPrimaryKeyColumns.put(rcol.getColumnName(), rcol);
        } else {
            this.nonPrimaryKeyColumns.put(rcol.getColumnName(), rcol);
        }
    }

    Map<String, Pair<Object, CQLDataType>> getColumnValues(T object) {
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.columns.size());
        for (Map.Entry<String, FieldInfoImpl<T>> e : this.columns.entrySet()) {
            String name = e.getKey();
            FieldInfoImpl<T> field = e.getValue();
            Object value = field.getValue(object);
            if (value == null) {
                if (this.table != null) {
                    Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' from table '%s' in pojo '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
                    if (field.isPartitionKey() || field.isClusteringKey()) {
                        if (field.isOptional()) {
                            throw new EmptyOptionalPrimaryKeyException("missing primary key column '" + name + "' in table '" + this.table.name() + "' in pojo '" + this.clazz.getSimpleName() + "'");
                        }
                        throw new IllegalArgumentException("missing primary key column '" + name + "' in table '" + this.table.name() + "' in pojo '" + this.clazz.getSimpleName() + "'");
                    }
                    Validate.isTrue((!field.isTypeKey() ? 1 : 0) != 0, (String)"missing type key column '%s' from table '%s' in pojo '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
                } else {
                    Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' in udt '%s'", (Object[])new Object[]{name, this.clazz.getSimpleName()});
                }
            }
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getPartitionKeyColumnValues(T object) {
        if (this.table == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.primaryKeyColumns.size());
        for (Map.Entry<String, FieldInfoImpl<T>> e : this.partitionKeyColumns.entrySet()) {
            String name = e.getKey();
            FieldInfoImpl<T> field = e.getValue();
            Object value = field.getValue(object);
            Validate.isTrue((value != null ? 1 : 0) != 0, (String)"missing partition key column '%s' from table '%s' for pojop '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Object> getFinalPrimaryKeyValues() {
        return this.finalPrimaryKeyValues;
    }

    Map<String, Pair<Object, CQLDataType>> getSuffixAndPartitionKeyColumnValues(T object) {
        if (this.table == null) {
            return Collections.emptyMap();
        }
        Map<String, FieldInfoImpl<T>> skeys = this.cinfo.getSuffixKeys();
        LinkedHashMap<String, FieldInfoImpl<T>> keys = new LinkedHashMap<String, FieldInfoImpl<T>>(this.primaryKeyColumns.size() + skeys.size());
        keys.putAll(skeys);
        keys.putAll(this.partitionKeyColumns);
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(keys.size());
        for (Map.Entry e : keys.entrySet()) {
            String name = (String)e.getKey();
            FieldInfoImpl field = (FieldInfoImpl)e.getValue();
            Object value = field.getValue(object);
            Validate.isTrue((value != null ? 1 : 0) != 0, (String)"missing suffix or partition key column '%s' from table '%s' for pojo '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getPrimaryKeyColumnValues(T object) {
        if (this.table == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.primaryKeyColumns.size());
        for (Map.Entry<String, FieldInfoImpl<T>> e : this.primaryKeyColumns.entrySet()) {
            String name = e.getKey();
            FieldInfoImpl<T> field = e.getValue();
            Object value = field.getValue(object);
            if (value == null) {
                if (field.isOptional()) {
                    throw new EmptyOptionalPrimaryKeyException("missing primary key column '" + name + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                }
                throw new IllegalArgumentException("missing primary key column '" + name + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
            }
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getPrimaryKeyColumnValues(T object, Map<String, Object> pkeys_override) {
        if (this.table == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.primaryKeyColumns.size());
        for (Map.Entry<String, FieldInfoImpl<T>> e : this.primaryKeyColumns.entrySet()) {
            String name = e.getKey();
            FieldInfoImpl<T> field = e.getValue();
            Object value = pkeys_override.getOrDefault(name, this);
            if (value == this) {
                value = field.getValue(object);
            }
            if (value == null) {
                if (field.isOptional()) {
                    throw new EmptyOptionalPrimaryKeyException("missing primary key column '" + name + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                }
                throw new IllegalArgumentException("missing primary key column '" + name + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
            }
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getSuffixAndPrimaryKeyColumnValues(T object) {
        if (this.table == null) {
            return Collections.emptyMap();
        }
        Map<String, FieldInfoImpl<T>> skeys = this.cinfo.getSuffixKeys();
        LinkedHashMap<String, FieldInfoImpl<T>> keys = new LinkedHashMap<String, FieldInfoImpl<T>>(this.primaryKeyColumns.size() + skeys.size());
        keys.putAll(skeys);
        keys.putAll(this.primaryKeyColumns);
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(keys.size());
        for (Map.Entry e : keys.entrySet()) {
            String name = (String)e.getKey();
            FieldInfoImpl field = (FieldInfoImpl)e.getValue();
            Object value = field.getValue(object);
            Validate.isTrue((value != null ? 1 : 0) != 0, (String)"missing suffix or primary key column '%s' from table '%s' for pojo '%s'; null value", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getMandatoryAndPrimaryKeyColumnValues(T object) {
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.mandatoryAndPrimaryKeyColumns.size());
        for (Map.Entry<String, FieldInfoImpl<T>> e : this.mandatoryAndPrimaryKeyColumns.entrySet()) {
            String name = e.getKey();
            FieldInfoImpl<T> field = e.getValue();
            Object value = field.getValue(object);
            if (value == null) {
                if (this.table != null) {
                    Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' from table '%s' for pojo '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
                    if (field.isPartitionKey() || field.isClusteringKey()) {
                        if (field.isOptional()) {
                            throw new EmptyOptionalPrimaryKeyException("missing primary key column '" + name + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                        }
                        throw new IllegalArgumentException("missing primary key column '" + name + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                    }
                    Validate.isTrue((!field.isTypeKey() ? 1 : 0) != 0, (String)"missing type key column '%s' from table '%s' for pojo '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
                } else {
                    Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' for udt '%s'", (Object[])new Object[]{name, this.clazz.getSimpleName()});
                }
            }
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getNonPrimaryKeyColumnNonEncodedValues(T object) {
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.nonPrimaryKeyColumns.size());
        for (Map.Entry<String, FieldInfoImpl<T>> e : this.nonPrimaryKeyColumns.entrySet()) {
            String name = e.getKey();
            FieldInfoImpl<T> field = e.getValue();
            Object value = field.getNonEncodedValue(object);
            if (this.table != null) {
                Validate.isTrue((!field.isMandatory() || value != null ? 1 : 0) != 0, (String)"missing mandatory column '%s' from table '%s' for pojo '%s'", (Object[])new Object[]{name, this.table.name(), this.clazz.getSimpleName()});
            } else {
                Validate.isTrue((!field.isMandatory() || value != null ? 1 : 0) != 0, (String)"missing mandatory column '%s' for udt '%s'", (Object[])new Object[]{name, this.clazz.getSimpleName()});
            }
            values.put(name, (Pair<Object, CQLDataType>)Pair.of((Object)value, (Object)field.getDataType()));
        }
        return values;
    }

    Pair<Object, CQLDataType> getColumnValue(T object, CharSequence name) {
        String n = name instanceof Utils.CNameSequence ? ((Utils.CNameSequence)name).getName() : name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        Object value = field.getValue(object);
        if (value == null) {
            if (this.table != null) {
                Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' in table '%s' for pojo '%s'", (Object[])new Object[]{n, this.table.name(), this.clazz.getSimpleName()});
                if (field.isPartitionKey() || field.isClusteringKey()) {
                    if (field.isOptional()) {
                        throw new EmptyOptionalPrimaryKeyException("missing primary key column '" + n + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                    }
                    throw new IllegalArgumentException("missing primary key column '" + n + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                }
                Validate.isTrue((!field.isTypeKey() ? 1 : 0) != 0, (String)"missing type key column '%s' in table '%s' for pojo '%s'", (Object[])new Object[]{n, this.table.name(), this.clazz.getSimpleName()});
            } else {
                Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' for udt '%s'", (Object[])new Object[]{n, this.clazz.getSimpleName()});
            }
        }
        return Pair.of((Object)value, (Object)field.getDataType());
    }

    Pair<Object, CQLDataType> getColumnNonEncodedValue(T object, CharSequence name) {
        String n = name instanceof Utils.CNameSequence ? ((Utils.CNameSequence)name).getName() : name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        Object value = field.getNonEncodedValue(object);
        if (value == null) {
            if (this.table != null) {
                Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' in table '%s' for pojo '%s'", (Object[])new Object[]{n, this.table.name(), this.clazz.getSimpleName()});
                if (field.isPartitionKey() || field.isClusteringKey()) {
                    if (field.isOptional()) {
                        throw new EmptyOptionalPrimaryKeyException("missing primary key column '" + n + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                    }
                    throw new IllegalArgumentException("missing primary key column '" + n + "' in table '" + this.table.name() + "' for pojo '" + this.clazz.getSimpleName() + "'");
                }
                Validate.isTrue((!field.isTypeKey() ? 1 : 0) != 0, (String)"missing type key column '%s' in table '%s' for pojo '%s'", (Object[])new Object[]{n, this.table.name(), this.clazz.getSimpleName()});
            } else {
                Validate.isTrue((!field.isMandatory() ? 1 : 0) != 0, (String)"missing mandatory column '%s' for udt '%s'", (Object[])new Object[]{n, this.clazz.getSimpleName()});
            }
        }
        return Pair.of((Object)value, (Object)field.getDataType());
    }

    Map<String, Pair<Object, CQLDataType>> getColumnValues(T object, Iterable<CharSequence> names) {
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.columns.size());
        for (CharSequence name : names) {
            String n = name instanceof Utils.CNameSequence ? ((Utils.CNameSequence)name).getName() : name.toString();
            values.put(n, this.getColumnValue(object, n));
        }
        return values;
    }

    Map<String, Pair<Object, CQLDataType>> getColumnValues(T object, CharSequence ... names) {
        LinkedHashMap<String, Pair<Object, CQLDataType>> values = new LinkedHashMap<String, Pair<Object, CQLDataType>>(this.columns.size());
        for (CharSequence name : names) {
            String n = name instanceof Utils.CNameSequence ? ((Utils.CNameSequence)name).getName() : name.toString();
            values.put(n, this.getColumnValue(object, n));
        }
        return values;
    }

    protected Collection<FieldInfoImpl<T>> getColumnsImpl() {
        return this.columns.values();
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    public ClassInfo<T> getClassInfo() {
        return this.cinfo;
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasCollectionColumns() {
        return this.hasCollectionColumns;
    }

    public boolean hasColumn(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                if (this.hasColumn(n2)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                if (this.hasColumn(parm)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            return false;
        }
        return this.columns.containsKey(n);
    }

    public boolean hasPrimaryKey(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (this.table == null) {
            return false;
        }
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                if (this.hasPrimaryKey(n2)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                if (this.hasPrimaryKey(parm)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            return false;
        }
        return this.primaryKeyColumns.containsKey(n);
    }

    public boolean isLastPartitionKey(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (this.table == null) {
            return false;
        }
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                if (this.isLastPartitionKey(n2)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                if (this.isLastPartitionKey(parm)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            return false;
        }
        FieldInfoImpl<T> f = this.partitionKeyColumns.get(n);
        return f != null ? f.isLast() : false;
    }

    public boolean isLastClusteringKey(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (this.table == null) {
            return false;
        }
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                if (this.isLastPartitionKey(n2)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                if (this.isLastPartitionKey(parm)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            return false;
        }
        FieldInfoImpl<T> f = this.clusteringKeyColumns.get(n);
        return f != null ? f.isLast() : false;
    }

    public boolean isMultiKey(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (this.table == null) {
            return false;
        }
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                if (this.isMultiKey(n2)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                if (this.isMultiKey(parm)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            return false;
        }
        FieldInfoImpl<T> f = this.multiKeyColumns.get(n);
        return f != null;
    }

    public boolean isNonPrimaryKeyColumn(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (this.table == null) {
            return false;
        }
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                if (this.isNonPrimaryKeyColumn(n2)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.FCall) {
            for (Object parm : (Utils.FCall)name) {
                if (this.isNonPrimaryKeyColumn(parm)) continue;
                return false;
            }
            return true;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            return false;
        }
        FieldInfoImpl<T> f = this.nonPrimaryKeyColumns.get(n);
        return f != null;
    }

    public FieldInfoImpl<T> getColumnByField(Field f) {
        return this.fields.get(Pair.of((Object)f.getName(), f.getDeclaringClass()));
    }

    public FieldInfoImpl<T> getColumnImpl(CharSequence name) {
        return name != null ? this.columns.get(name.toString()) : null;
    }

    public Iterator<FieldInfo<T>> iterator() {
        final Iterator<FieldInfoImpl<T>> iterator = this.columns.values().iterator();
        return new Iterator<FieldInfo<T>>(){
            private FieldInfoImpl<T> current = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public FieldInfo<T> next() {
                this.current = (FieldInfoImpl)iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                iterator.remove();
                String cname = this.current.getColumnName();
                if (TableInfoImpl.this.table != null) {
                    TableInfoImpl.this.primaryKeyColumns.remove(cname);
                    TableInfoImpl.this.partitionKeyColumns.remove(cname);
                    TableInfoImpl.this.finalPrimaryKeyValues.remove(cname);
                    TableInfoImpl.this.clusteringKeyColumns.remove(cname);
                    FieldInfoImpl old = (FieldInfoImpl)TableInfoImpl.this.typeKeyColumn.getValue();
                    if (old != null && old.getColumnName().equals(cname)) {
                        TableInfoImpl.this.typeKeyColumn.setValue(null);
                    }
                    TableInfoImpl.this.indexColumns.remove(cname);
                }
                TableInfoImpl.this.mandatoryAndPrimaryKeyColumns.remove(cname);
                TableInfoImpl.this.nonPrimaryKeyColumns.remove(cname);
                TableInfoImpl.this.fields.remove(Pair.of((Object)this.current.getName(), this.current.getDeclaringClass()));
                this.current = null;
            }
        };
    }

    public Collection<FieldInfo<T>> getColumns() {
        return Collections.unmodifiableCollection(this.columns.values());
    }

    public Optional<FieldInfo<T>> getColumn(String name) {
        return Optional.ofNullable(this.columns.get(name));
    }

    public Stream<FieldInfo<T>> columns() {
        return this.columns.values().stream();
    }

    public Collection<FieldInfoImpl<T>> getNonPrimaryKeys() {
        return this.nonPrimaryKeyColumns.values();
    }

    public Collection<FieldInfoImpl<T>> getPartitionKeys() {
        return this.partitionKeyColumns.values();
    }

    public Collection<FieldInfoImpl<T>> getSuffixAndPartitionKeys() {
        Map<String, FieldInfoImpl<T>> skeys = this.cinfo.getSuffixKeys();
        LinkedHashMap<String, FieldInfoImpl<T>> keys = new LinkedHashMap<String, FieldInfoImpl<T>>(this.primaryKeyColumns.size() + skeys.size());
        keys.putAll(skeys);
        keys.putAll(this.partitionKeyColumns);
        return keys.values();
    }

    public Collection<FieldInfoImpl<T>> getClusteringKeys() {
        return this.clusteringKeyColumns.values();
    }

    public Optional<FieldInfoImpl<T>> getTypeKey() {
        return Optional.ofNullable(this.typeKeyColumn.getValue());
    }

    public Collection<FieldInfoImpl<T>> getPrimaryKeys() {
        return this.primaryKeyColumns.values();
    }

    public List<FieldInfoImpl<T>> getMultiKeys() {
        return this.multiKeyColumnsList;
    }

    public Collection<FieldInfoImpl<T>> getSuffixAndPrimaryKeys() {
        Map<String, FieldInfoImpl<T>> skeys = this.cinfo.getSuffixKeys();
        LinkedHashMap<String, FieldInfoImpl<T>> keys = new LinkedHashMap<String, FieldInfoImpl<T>>(this.primaryKeyColumns.size() + skeys.size());
        keys.putAll(skeys);
        keys.putAll(this.primaryKeyColumns);
        return keys.values();
    }

    public FieldInfoImpl<T> getPrimaryKey(CharSequence name) {
        return name != null ? this.primaryKeyColumns.get(name.toString()) : null;
    }

    public Collection<FieldInfoImpl<T>> getIndexes() {
        return this.indexColumns.values();
    }

    public Collection<FieldInfoImpl<T>> getMandatoryAndPrimaryKeys() {
        return this.mandatoryAndPrimaryKeyColumns.values();
    }

    public Set<String> getMandatoryAndPrimaryKeyColumns() {
        return this.mandatoryAndPrimaryKeyColumns.keySet();
    }

    public void validateColumn(Object name) {
        this.validateColumn(name, false);
    }

    public void validateColumns(Iterable<Object> names) {
        for (Object name : names) {
            this.validateColumn(name);
        }
    }

    public void validateColumns(Object ... names) {
        for (Object name : names) {
            this.validateColumn(name);
        }
    }

    public void validateNotMandatoryOrPrimaryKeyColumn(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                this.validateNotMandatoryOrPrimaryKeyColumn(n2);
            }
            return;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            throw new IllegalArgumentException("unexpected column name: " + name);
        }
        if (this.table != null) {
            Validate.isTrue((!this.mandatoryAndPrimaryKeyColumns.containsKey(n) ? 1 : 0) != 0, (String)"pojo '%s' defines mandatory or primary key column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((!this.mandatoryAndPrimaryKeyColumns.containsKey(n) ? 1 : 0) != 0, (String)"udt '%s' defines mandatory column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
    }

    public void validatePrimaryKeyOrIndexColumn(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                this.validatePrimaryKeyOrIndexColumn(n2);
            }
            return;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            throw new IllegalArgumentException("unexpected column name: " + name);
        }
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
            Validate.isTrue((field.isPartitionKey() || field.isClusteringKey() || field.isIndex() ? 1 : 0) != 0, (String)"pojo '%s' doesn't define primary key or index column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
    }

    public void validateSuffixKeyOrPrimaryKeyOrIndexColumn(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                this.validatePrimaryKeyOrIndexColumn(n2);
            }
            return;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            throw new IllegalArgumentException("unexpected column name: " + name);
        }
        FieldInfoImpl field = this.columns.get(n);
        if (field == null) {
            field = (FieldInfoImpl)this.cinfo.getSuffixKey(n);
        }
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column or suffix key '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
            Validate.isTrue((field.isPartitionKey() || field.isClusteringKey() || field.isSuffixKey() || field.isIndex() ? 1 : 0) != 0, (String)"pojo '%s' doesn't define suffix key, primary key, or index column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
    }

    public void validateCounterColumn(Object name) {
        String n;
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n2 : ((Utils.CNameSequence)name).getNames()) {
                this.validateCounterColumn(n2);
            }
            return;
        }
        if (name instanceof Utils.CName) {
            n = ((Utils.CName)name).getColumnName();
        } else if (name instanceof CharSequence) {
            n = name.toString();
        } else {
            throw new IllegalArgumentException("unexpected column name: " + name);
        }
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
            Validate.isTrue((boolean)field.isCounter(), (String)"pojo '%s' doesn't define counter column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
    }

    public void validateColumnAndValue(CharSequence name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateColumnAndValue(n, value);
            }
            return;
        }
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        field.validateValue(value);
    }

    public void validateSuffixOrColumnAndValue(CharSequence name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null column name or suffix key", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateSuffixOrColumnAndValue(n, value);
            }
            return;
        }
        String n = name.toString();
        FieldInfoImpl field = this.columns.get(n);
        if (field == null) {
            field = (FieldInfoImpl)this.cinfo.getSuffixKey(n);
        }
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column or suffix key '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        field.validateValue(value);
    }

    public void validateColumnAndValues(CharSequence name, Collection<?> values) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateColumnAndValues(n, values);
            }
            return;
        }
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        for (Object value : values) {
            field.validateValue(value);
        }
    }

    public void validateListColumnAndValue(CharSequence name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateListColumnAndValue(n, value);
            }
            return;
        }
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        field.validateListValue(value);
    }

    public void validateListColumnAndValues(CharSequence name, Iterable<?> values) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateListColumnAndValues(n, values);
            }
            return;
        }
        Validate.notNull(values, (String)"invalid null list of values", (Object[])new Object[0]);
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        for (Object value : values) {
            field.validateListValue(value);
        }
    }

    public void validateSetColumnAndValue(CharSequence name, Object value) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateSetColumnAndValue(n, value);
            }
            return;
        }
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        field.validateSetValue(value);
    }

    public void validateSetColumnAndValues(CharSequence name, Iterable<?> values) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateSetColumnAndValues(n, values);
            }
            return;
        }
        Validate.notNull(values, (String)"invalid null list of values", (Object[])new Object[0]);
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        for (Object value : values) {
            field.validateSetValue(value);
        }
    }

    public void validateMapColumnAndKeyValue(CharSequence name, Object key, Object value) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateMapColumnAndKeyValue(n, key, value);
            }
            return;
        }
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        field.validateMapKeyValue(key, value);
    }

    public void validateMapColumnAndKeyValues(CharSequence name, Map<?, ?> mappings) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateMapColumnAndKeyValues(n, mappings);
            }
            return;
        }
        Validate.notNull(mappings, (String)"invalid null collection of mappings", (Object[])new Object[0]);
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        for (Map.Entry<?, ?> e : mappings.entrySet()) {
            field.validateMapKeyValue(e.getKey(), e.getValue());
        }
    }

    public void validateMapColumnAndKeys(CharSequence name, Iterable<?> keys) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        if (name instanceof Utils.CNameSequence) {
            for (String n : ((Utils.CNameSequence)name).getNames()) {
                this.validateMapColumnAndKeys(n, keys);
            }
            return;
        }
        Validate.notNull(keys, (String)"invalid null collection of keys", (Object[])new Object[0]);
        String n = name.toString();
        FieldInfoImpl<T> field = this.columns.get(n);
        if (this.table != null) {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"pojo '%s' doesn't define column '%s' in table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n, this.table.name()});
        } else {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"udt '%s' doesn't define column '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), n});
        }
        for (Object key : keys) {
            field.validateMapKey(key);
        }
    }

    public Stream<UDTClassInfoImpl<?>> udts() {
        return this.columns.values().stream().flatMap(f -> f.udts());
    }

    public String toString() {
        return "TableInfoImpl(clazz=" + this.clazz + ", table=" + this.getTable() + ", name=" + this.getName() + ", fields=" + this.fields + ", columns=" + this.getColumns() + ", primaryKeyColumns=" + this.primaryKeyColumns + ", indexColumns=" + this.indexColumns + ", partitionKeyColumns=" + this.partitionKeyColumns + ", clusteringKeyColumns=" + this.clusteringKeyColumns + ", typeKeyColumn=" + this.typeKeyColumn + ", finalPrimaryKeyValues=" + this.getFinalPrimaryKeyValues() + ", mandatoryAndPrimaryKeyColumns=" + this.getMandatoryAndPrimaryKeyColumns() + ", nonPrimaryKeyColumns=" + this.nonPrimaryKeyColumns + ", multiKeyColumns=" + this.multiKeyColumns + ", multiKeyColumnsList=" + this.multiKeyColumnsList + ", hasCollectionColumns=" + this.hasCollectionColumns + ")";
    }
}

