/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.EmptyResultSetFuture;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.helenus.driver.Batch;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.Group;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.ObjectSetFuture;
import org.helenus.driver.Sequence;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ObjectSetFutureImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.info.ClassInfo;

public abstract class StatementImpl<R, F extends ListenableFuture<R>, T>
implements GenericStatement<R, F> {
    private static final Logger logger = LogManager.getFormatterLogger(StatementImpl.class);
    public static final String MK_PREFIX = "mk_";
    public static final String UDT_C_PREFIX = "c_";
    protected final StatementManagerImpl mgr;
    protected final StatementBridge bridge;
    protected final Class<R> resultClass;
    private final Class<T> pojoClass;
    private final ClassInfoImpl.Context context;
    private final ClassInfoImpl.POJOContext pojoContext;
    private volatile String keyspace;
    private volatile ConsistencyLevel consistency;
    private volatile boolean enabled = true;
    private volatile ConsistencyLevel serialConsistency;
    private volatile String tracePrefix = null;
    private volatile String errorTracePrefix = null;
    private volatile int fetchSize;
    private volatile RetryPolicy retryPolicy;
    private volatile boolean dirty;
    protected volatile int simpleSize = -1;
    private volatile StringBuilder cache;
    protected volatile Boolean isCounterOp;
    private volatile Object data = null;

    static DriverException propagateCause(ExecutionException e) throws DriverException {
        if (e.getCause() instanceof DriverException) {
            throw ((DriverException)e.getCause()).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", e.getCause());
    }

    protected StatementImpl(Class<R> resultClass, ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        Validate.notNull(resultClass, (String)"invalid null result class", (Object[])new Object[0]);
        Validate.isTrue((resultClass == ObjectSet.class || resultClass == Void.class || resultClass == ResultSet.class ? 1 : 0) != 0, (String)("unsupported result class: " + resultClass.getName()), (Object[])new Object[0]);
        this.mgr = mgr;
        this.bridge = bridge;
        this.resultClass = resultClass;
        this.context = context;
        if (context != null) {
            this.pojoClass = context.getObjectClass();
            this.pojoContext = context instanceof ClassInfoImpl.POJOContext ? (ClassInfoImpl.POJOContext)context : null;
        } else {
            this.pojoClass = null;
            this.pojoContext = null;
            this.keyspace = null;
        }
        this.keyspace = null;
    }

    protected StatementImpl(Class<R> resultClass, String keyspace, StatementManagerImpl mgr, StatementBridge bridge) {
        Validate.notNull(resultClass, (String)"invalid null result class", (Object[])new Object[0]);
        Validate.isTrue((resultClass == ObjectSet.class || resultClass == Void.class || resultClass == ResultSet.class ? 1 : 0) != 0, (String)("unsupported result class: " + resultClass.getName()), (Object[])new Object[0]);
        this.mgr = mgr;
        this.bridge = bridge;
        this.resultClass = resultClass;
        this.pojoClass = null;
        this.context = null;
        this.pojoContext = null;
        this.keyspace = keyspace;
    }

    protected StatementImpl(StatementImpl<R, F, T> statement) {
        this.mgr = statement.mgr;
        this.bridge = statement.bridge;
        this.resultClass = statement.resultClass;
        this.pojoClass = statement.pojoClass;
        this.context = statement.context;
        this.pojoContext = statement.pojoContext;
        this.keyspace = statement.keyspace;
        this.enabled = statement.enabled;
        this.consistency = statement.consistency;
        this.serialConsistency = statement.serialConsistency;
        this.tracePrefix = statement.tracePrefix;
        this.errorTracePrefix = statement.errorTracePrefix;
        this.fetchSize = statement.fetchSize;
        this.retryPolicy = statement.retryPolicy;
        this.simpleSize = statement.simpleSize;
        this.dirty = statement.dirty;
        this.cache = statement.cache;
        this.isCounterOp = statement.isCounterOp;
        this.data = statement.data;
    }

    protected StatementImpl(StatementImpl<R, F, T> statement, ClassInfoImpl.Context context) {
        this.mgr = statement.mgr;
        this.bridge = statement.bridge;
        this.resultClass = statement.resultClass;
        this.pojoClass = statement.pojoClass;
        this.context = context;
        this.pojoContext = null;
        this.keyspace = statement.keyspace;
        this.enabled = statement.enabled;
        this.consistency = statement.consistency;
        this.serialConsistency = statement.serialConsistency;
        this.tracePrefix = statement.tracePrefix;
        this.errorTracePrefix = statement.errorTracePrefix;
        this.fetchSize = statement.fetchSize;
        this.retryPolicy = statement.retryPolicy;
        this.simpleSize = statement.simpleSize;
        this.dirty = statement.dirty;
        this.cache = statement.cache;
        this.isCounterOp = statement.isCounterOp;
        this.data = statement.data;
    }

    private void debugExecution(String query) {
        if (logger.isDebugEnabled() && (this.isTracing() || this.mgr.areAllStatementsTracesEnabled())) {
            String prefix = StringUtils.defaultString((String)this.tracePrefix);
            if (this.mgr.isFullTracesEnabled() || query.length() < 2048) {
                logger.log(Level.DEBUG, "%sCQL -> %s", new Object[]{prefix, query});
            } else if (this instanceof Batch) {
                logger.log(Level.DEBUG, "%sCQL -> %s ... APPLY BATCH", new Object[]{prefix, query.substring(0, 2032)});
            } else if (this instanceof Sequence) {
                logger.log(Level.DEBUG, "%sCQL -> %s ... APPLY SEQUENCE", new Object[]{prefix, query.substring(0, 2029)});
            } else if (this instanceof Group) {
                logger.log(Level.DEBUG, "%sCQL -> %s ... APPLY GROUP", new Object[]{prefix, query.substring(0, 2032)});
            } else {
                logger.log(Level.DEBUG, "%sCQL -> %s ...", new Object[]{prefix, query.substring(0, 2044)});
            }
        }
    }

    private void errorExecution(String query, Throwable e) {
        if (logger.isErrorEnabled() && (this.isErrorTracing() || this.mgr.areAllStatementsTracesEnabled())) {
            String prefix = StringUtils.defaultString((String)this.errorTracePrefix);
            if (this.mgr.isFullTracesEnabled() || query.length() < 2048) {
                logger.log(Level.ERROR, "%sCQL ERROR -> %s", new Object[]{prefix, query});
            } else if (this instanceof Batch) {
                logger.log(Level.ERROR, "%sCQL ERROR -> %s ... APPLY BATCH", new Object[]{prefix, query.substring(0, 2032)});
            } else if (this instanceof Sequence) {
                logger.log(Level.ERROR, "%sCQL ERROR -> %s ... APPLY SEQUENCE", new Object[]{prefix, query.substring(0, 2029)});
            } else if (this instanceof Group) {
                logger.log(Level.ERROR, "%sCQL ERROR -> %s ... APPLY GROUP", new Object[]{prefix, query.substring(0, 2032)});
            } else {
                logger.log(Level.ERROR, "%sCQL ERROR -> %s ...", new Object[]{prefix, query.substring(0, 2044)});
            }
            logger.log(Level.ERROR, "%sCQL ERROR -> ", new Object[]{this.errorTracePrefix, e});
        } else if (logger.isDebugEnabled() && (this.isTracing() || this.mgr.areAllStatementsTracesEnabled())) {
            String prefix = StringUtils.defaultString((String)this.tracePrefix);
            if (this.mgr.isFullTracesEnabled() || query.length() < 2048) {
                logger.log(Level.DEBUG, "%sCQL ERROR -> %s", new Object[]{prefix, query});
            } else if (this instanceof Batch) {
                logger.log(Level.DEBUG, "%sCQL ERROR -> %s ... APPLY BATCH", new Object[]{prefix, query.substring(0, 2032)});
            } else if (this instanceof Sequence) {
                logger.log(Level.DEBUG, "%sCQL ERROR -> %s ... APPLY SEQUENCE", new Object[]{prefix, query.substring(0, 2029)});
            } else if (this instanceof Group) {
                logger.log(Level.DEBUG, "%sCQL ERROR -> %s ... APPLY GROUP", new Object[]{prefix, query.substring(0, 2032)});
            } else {
                logger.log(Level.DEBUG, "%sCQL ERROR -> %s ...", new Object[]{prefix, query.substring(0, 2044)});
            }
            logger.log(Level.DEBUG, "%sCQL ERROR -> ", new Object[]{prefix, e});
        }
    }

    protected <S extends StatementImpl<?, ?, ?>> S init(S s) {
        if (this.isEnabled()) {
            s.enable();
        } else {
            s.disable();
        }
        if (this.getConsistencyLevel() != null) {
            s.setConsistencyLevel(this.getConsistencyLevel());
        }
        if (this.getSerialConsistencyLevel() != null) {
            s.setSerialConsistencyLevel(this.getSerialConsistencyLevel());
        }
        s.enableTracing(this.tracePrefix);
        s.enableErrorTracing(this.errorTracePrefix);
        if (this.getRetryPolicy() != null) {
            s.setRetryPolicy(this.getRetryPolicy());
        }
        s.setFetchSize(this.getFetchSize());
        s.setUserData((Object)this.data);
        return s;
    }

    protected <S extends Statement> S init(S s) {
        if (this.getConsistencyLevel() != null) {
            s.setConsistencyLevel(this.getConsistencyLevel());
        }
        if (this.getSerialConsistencyLevel() != null) {
            s.setSerialConsistencyLevel(this.getSerialConsistencyLevel());
        }
        if (s.isTracing()) {
            s.enableTracing();
        } else {
            s.disableTracing();
        }
        if (this.getRetryPolicy() != null) {
            s.setRetryPolicy(this.getRetryPolicy());
        }
        s.setFetchSize(this.getFetchSize());
        return s;
    }

    protected List<StatementImpl<?, ?, ?>> buildStatements() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this);
    }

    protected abstract StringBuilder[] buildQueryStrings();

    protected void appendGroupType(StringBuilder builder) {
    }

    protected void appendGroupSubType(StringBuilder builder) {
    }

    protected void appendOptions(StringBuilder builder) {
    }

    protected StringBuilder buildQueryString() {
        if (!this.enabled) {
            return null;
        }
        StringBuilder[] builders = this.buildQueryStrings();
        if (builders == null || builders.length == 0) {
            return null;
        }
        if (builders.length == 1 && !(this instanceof Batch)) {
            return builders[0];
        }
        StringBuilder builder = new StringBuilder();
        builder.append("BEGIN");
        this.appendGroupSubType(builder);
        builder.append(' ');
        this.appendGroupType(builder);
        this.appendOptions(builder);
        builder.append(' ');
        for (StringBuilder sb : builders) {
            String s = sb.toString();
            builder.append(s);
            if (!s.trim().endsWith(";")) {
                builder.append(';');
            }
            builder.append(' ');
        }
        builder.append("APPLY ");
        this.appendGroupType(builder);
        builder.append(';');
        return builder;
    }

    protected void clearKeyspace() {
        this.keyspace = null;
    }

    protected void setDirty() {
        this.dirty = true;
        this.cache = null;
        this.simpleSize = -1;
    }

    protected void setDirty(boolean recurse) {
        this.setDirty();
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected abstract int simpleSize();

    protected boolean isCounterOp() {
        return this.isCounterOp == null ? false : this.isCounterOp;
    }

    protected void setCounterOp(boolean isCounterOp) {
        this.isCounterOp = isCounterOp;
    }

    protected F executeAsync0() {
        ResultSetFuture rawFuture = this.executeAsyncRaw0();
        if (ObjectSet.class == this.resultClass) {
            return (F)((Object)new ObjectSetFutureImpl(this.context, rawFuture));
        }
        if (Void.class == this.resultClass) {
            return (F)this.bridge.newVoidFuture(rawFuture);
        }
        if (ResultSet.class == this.resultClass) {
            return (F)rawFuture;
        }
        throw new IllegalStateException("unsupported result class: " + this.resultClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetFuture executeAsyncRaw0() {
        if (!this.enabled) {
            return new EmptyResultSetFuture(this.mgr);
        }
        final String query = this.getQueryString();
        try {
            if (StringUtils.isEmpty((CharSequence)query)) {
                EmptyResultSetFuture emptyResultSetFuture = new EmptyResultSetFuture(this.mgr);
                return emptyResultSetFuture;
            }
            SimpleStatement raw = this.init(new SimpleStatement(query));
            this.debugExecution(query);
            final ResultSetFuture f = this.mgr.sent(this, this.mgr.getSession().executeAsync((Statement)raw));
            ResultSetFuture resultSetFuture = new ResultSetFuture(){

                public void addListener(Runnable listener, Executor executor) {
                    f.addListener(listener, executor);
                }

                public boolean isCancelled() {
                    return f.isCancelled();
                }

                public boolean isDone() {
                    return f.isDone();
                }

                public ResultSet get() throws InterruptedException, ExecutionException {
                    try {
                        return (ResultSet)f.get();
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Error | Exception e) {
                        StatementImpl.this.errorExecution(query, e);
                        throw e;
                    }
                }

                public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    try {
                        return (ResultSet)f.get(timeout, unit);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        throw e;
                    }
                    catch (Error | Exception e) {
                        StatementImpl.this.errorExecution(query, e);
                        throw e;
                    }
                }

                public ResultSet getUninterruptibly() {
                    try {
                        return f.getUninterruptibly();
                    }
                    catch (Error | Exception e) {
                        StatementImpl.this.errorExecution(query, e);
                        throw e;
                    }
                }

                public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
                    try {
                        return f.getUninterruptibly(timeout, unit);
                    }
                    catch (TimeoutException e) {
                        throw e;
                    }
                    catch (Error | Exception e) {
                        StatementImpl.this.errorExecution(query, e);
                        throw e;
                    }
                }

                public boolean cancel(boolean mayInterruptIfRunning) {
                    return f.cancel(mayInterruptIfRunning);
                }
            };
            return resultSetFuture;
        }
        finally {
            this.setDirty(true);
        }
    }

    public Class<T> getObjectClass() {
        return this.pojoClass;
    }

    public ClassInfo<T> getClassInfo() {
        return this.context.getClassInfo();
    }

    public ClassInfoImpl<T> getClassInfoImpl() {
        return this.context.getClassInfo();
    }

    public ClassInfoImpl.Context getContext() {
        return this.context;
    }

    public ClassInfoImpl.POJOContext getPOJOContext() {
        return this.pojoContext;
    }

    public T getObject() {
        return this.pojoContext != null ? (T)this.pojoContext.getObject() : null;
    }

    public String getKeyspace() {
        if (this.keyspace == null && this.context != null) {
            this.keyspace = this.context.getKeyspace();
        }
        return this.keyspace;
    }

    public GenericStatement<R, F> enable() {
        if (!this.enabled) {
            this.setDirty();
            this.enabled = true;
        }
        return this;
    }

    public GenericStatement<R, F> disable() {
        if (this.enabled) {
            this.setDirty();
            this.enabled = false;
        }
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GenericStatement<R, F> setConsistencyLevel(ConsistencyLevel consistency) {
        if (consistency != this.consistency) {
            this.setDirty();
            this.consistency = consistency;
        }
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public GenericStatement<R, F> setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        Validate.isTrue((serialConsistency == ConsistencyLevel.SERIAL || serialConsistency == ConsistencyLevel.LOCAL_SERIAL ? 1 : 0) != 0, (String)"invalid serial consistency level: %s", (Object[])new Object[]{serialConsistency});
        if (serialConsistency != this.serialConsistency) {
            this.setDirty();
            this.serialConsistency = serialConsistency;
        }
        return this;
    }

    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    public GenericStatement<R, F> enableTracing() {
        if (!Objects.equals("", this.tracePrefix)) {
            this.setDirty();
            this.tracePrefix = "";
        }
        return this;
    }

    public GenericStatement<R, F> enableTracing(String prefix) {
        if (!Objects.equals(prefix, this.tracePrefix)) {
            this.setDirty();
            this.tracePrefix = prefix;
        }
        return this;
    }

    public GenericStatement<R, F> disableTracing() {
        if (this.tracePrefix != null) {
            this.setDirty();
            this.tracePrefix = null;
        }
        return this;
    }

    public boolean isTracing() {
        return this.tracePrefix != null;
    }

    public GenericStatement<R, F> enableErrorTracing() {
        if (!Objects.equals("", this.errorTracePrefix)) {
            this.setDirty();
            this.errorTracePrefix = "";
        }
        return this;
    }

    public GenericStatement<R, F> enableErrorTracing(String prefix) {
        if (!Objects.equals(prefix, this.errorTracePrefix)) {
            this.setDirty();
            this.errorTracePrefix = prefix;
        }
        this.errorTracePrefix = prefix;
        return this;
    }

    public GenericStatement<R, F> disableErrorTracing() {
        if (this.errorTracePrefix != null) {
            this.setDirty();
            this.errorTracePrefix = null;
        }
        return this;
    }

    public boolean isErrorTracing() {
        return this.errorTracePrefix != null;
    }

    public GenericStatement<R, F> setRetryPolicy(RetryPolicy policy) {
        if (!Objects.equals(policy, this.retryPolicy)) {
            this.setDirty();
            this.retryPolicy = policy;
        }
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public GenericStatement<R, F> setFetchSize(int fetchSize) {
        if (fetchSize != this.fetchSize) {
            this.setDirty();
            this.fetchSize = fetchSize;
        }
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public <U> U getUserData() {
        return (U)this.data;
    }

    public <U> void setUserData(U data) {
        this.data = data;
    }

    public String getQueryString() {
        if (!this.enabled) {
            return null;
        }
        if (this.dirty || this.cache == null) {
            StringBuilder sb = this.buildQueryString();
            if (sb == null) {
                this.cache = null;
            } else {
                int l;
                for (l = sb.length(); l > 0 && sb.charAt(l - 1) <= ' '; --l) {
                }
                if (l != sb.length()) {
                    sb.setLength(l);
                }
                if (l == 0 || sb.charAt(l - 1) != ';') {
                    sb.append(';');
                }
                this.cache = sb;
            }
            this.dirty = false;
        }
        return this.cache != null ? this.cache.toString() : null;
    }

    public R execute() {
        F future = this.executeAsync();
        try {
            if (future instanceof ObjectSetFuture) {
                return (R)((ObjectSetFuture)future).getUninterruptibly();
            }
            if (future instanceof VoidFuture) {
                return (R)((VoidFuture)future).getUninterruptibly();
            }
            if (future instanceof ResultSetFuture) {
                return (R)((ResultSetFuture)future).getUninterruptibly();
            }
            return (R)Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            throw StatementImpl.propagateCause(e);
        }
    }

    public F executeAsync() {
        this.mgr.executing(this);
        return this.executeAsync0();
    }

    public ResultSet executeRaw() {
        return this.executeAsyncRaw().getUninterruptibly();
    }

    public ResultSetFuture executeAsyncRaw() {
        this.mgr.executing(this);
        return this.executeAsyncRaw0();
    }

    public final String toString() {
        return StringUtils.defaultString((String)this.getQueryString());
    }
}

