/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CompoundResultSetFuture;
import com.datastax.driver.core.EmptyResultSetFuture;
import com.datastax.driver.core.ResultSetFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.collections.iterators.CombinationIterator;
import org.helenus.driver.Clause;
import org.helenus.driver.ExcludedSuffixKeyException;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.ObjectSetFuture;
import org.helenus.driver.Ordering;
import org.helenus.driver.Select;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.CompoundObjectSetFuture;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.OrderingImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.TableInfo;

public class SelectImpl<T>
extends StatementImpl<ObjectSet<T>, ObjectSetFuture<T>, T>
implements Select<T> {
    static final List<Object> COUNT_ALL = Collections.singletonList(new Utils.FCall("count", new Utils.RawString("*")));
    final TableInfoImpl<T> table;
    private final WhereImpl<T> where;
    private List<OrderingImpl> orderings;
    private int limit = -1;
    private boolean allowFiltering;
    private String keyspace = null;
    private List<SelectImpl<T>> statements = null;
    private Map<String, Collection<?>> suffixes = null;
    protected List<Object> columnNames;
    protected boolean countOrAllSelected = false;

    SelectImpl(ClassInfoImpl.Context context, String table, List<Object> columnNames, boolean countOrAllSelected, StatementManagerImpl mgr, StatementBridge bridge) {
        super(ObjectSet.class, context, mgr, bridge);
        this.table = (TableInfoImpl)context.getClassInfo().getTable(table);
        this.columnNames = columnNames;
        this.countOrAllSelected = countOrAllSelected;
        this.where = new WhereImpl(this);
        Validate.isTrue((countOrAllSelected || !CollectionUtils.isEmpty(columnNames) ? 1 : 0) != 0, (String)"must select at least one column", (Object[])new Object[0]);
        if (columnNames != null) {
            this.table.validateColumns(columnNames);
        }
    }

    SelectImpl(SelectImpl<T> statement) {
        super(statement, statement.getContext().getClassInfo().newContext());
        this.setDirty();
        this.clearKeyspace();
        this.table = statement.table;
        this.columnNames = statement.columnNames;
        this.countOrAllSelected = statement.countOrAllSelected;
        this.where = new WhereImpl<T>(statement.where, this);
        this.limit = statement.limit;
        this.allowFiltering = statement.allowFiltering;
        this.orderings = statement.orderings;
    }

    private Stream<SelectImpl<T>> statements() {
        if (this.statements == null) {
            ArrayList<String> snames = new ArrayList<String>(this.suffixes.keySet());
            CombinationIterator ci = new CombinationIterator(Object.class, this.suffixes.values());
            ArrayList<SelectImpl<T>> statements = new ArrayList<SelectImpl<T>>(ci.size());
            block2: while (ci.hasNext()) {
                List svalues = ci.next();
                SelectImpl<T> s = new SelectImpl<T>(this);
                for (int j = 0; j < snames.size(); ++j) {
                    try {
                        s.getContext().addSuffix((String)snames.get(j), svalues.get(j));
                        continue;
                    }
                    catch (ExcludedSuffixKeyException e) {
                        continue block2;
                    }
                }
                statements.add(s);
            }
            this.statements = statements;
        }
        return this.statements.stream();
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        return new StringBuilder[]{this.buildQueryString()};
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : (this.statements != null ? this.statements.size() : new CombinationIterator(Object.class, this.suffixes.values()).size());
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder buildQueryString() {
        if (!this.isEnabled()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (this.columnNames == null) {
            builder.append("*");
        } else if (this.countOrAllSelected) {
            Utils.joinAndAppendNames(builder, ",", this.columnNames);
        } else {
            HashSet<String> set = new HashSet<String>(25);
            for (Object name : this.columnNames) {
                if (name instanceof String) {
                    set.add((String)name);
                    continue;
                }
                if (!(name instanceof Utils.CName)) continue;
                set.add(((Utils.CName)name).getName());
            }
            ArrayList<Object> names = new ArrayList<Object>();
            for (String name : this.table.getMandatoryAndPrimaryKeyColumns()) {
                if (set.contains(name)) continue;
                names.add(name);
            }
            names.addAll(this.columnNames);
            Utils.joinAndAppendNames(builder, ",", names);
        }
        builder.append(" FROM ");
        try {
            if (this.getKeyspace() != null) {
                Utils.appendName(this.getKeyspace(), builder).append(".");
            }
        }
        catch (ExcludedSuffixKeyException e) {
            return null;
        }
        Utils.appendName(this.table.getName(), builder);
        if (!((WhereImpl)this.where).clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(this.table, builder, " AND ", ((WhereImpl)this.where).getClauses(this.table));
        }
        if (this.orderings != null) {
            builder.append(" ORDER BY ");
            Utils.joinAndAppend(this.table, builder, ",", this.orderings);
        }
        if (this.limit > 0) {
            builder.append(" LIMIT ").append(this.limit);
        }
        if (this.allowFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        return builder;
    }

    @Override
    protected void clearKeyspace() {
        super.clearKeyspace();
        this.keyspace = null;
    }

    @Override
    protected void setDirty() {
        super.setDirty();
        this.keyspace = null;
        this.statements = null;
    }

    @Override
    protected ResultSetFuture executeAsyncRaw0() {
        if (!this.isEnabled() || this.suffixes == null) {
            return super.executeAsyncRaw0();
        }
        return new CompoundResultSetFuture(this.statements().map(s -> s.executeAsyncRaw0()).filter(s -> !(s instanceof EmptyResultSetFuture)).collect(Collectors.toList()), this.mgr);
    }

    @Override
    public ObjectSetFuture<T> executeAsync0() {
        if (!this.isEnabled() || this.suffixes == null) {
            return (ObjectSetFuture)super.executeAsync0();
        }
        return new CompoundObjectSetFuture(this.getContext(), this.statements().map(s -> s.executeAsync0()).collect(Collectors.toList()), this.mgr);
    }

    @Override
    public String getKeyspace() {
        if (this.suffixes == null) {
            return super.getKeyspace();
        }
        if (this.keyspace == null) {
            ArrayList<String> snames = new ArrayList<String>(this.suffixes.keySet());
            CombinationIterator ci = new CombinationIterator(Object.class, this.suffixes.values());
            ArrayList<String> keyspaces = new ArrayList<String>(ci.size());
            block2: while (ci.hasNext()) {
                List svalues = ci.next();
                SelectImpl<T> s = this.init(new SelectImpl<T>(this));
                for (int j = 0; j < snames.size(); ++j) {
                    try {
                        s.getContext().addSuffix((String)snames.get(j), svalues.get(j));
                        continue;
                    }
                    catch (ExcludedSuffixKeyException e) {
                        continue block2;
                    }
                }
                keyspaces.add(s.getKeyspace());
            }
            this.keyspace = "(" + String.join((CharSequence)"|", keyspaces) + ")";
        }
        return this.keyspace;
    }

    public Select.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public Select.Where<T> where() {
        return this.where;
    }

    public Select<T> orderBy(Ordering ... orderings) {
        Validate.validState((this.orderings == null ? 1 : 0) != 0, (String)"an ORDER BY clause has already been provided", (Object[])new Object[0]);
        this.orderings = new ArrayList<OrderingImpl>(orderings.length);
        for (Ordering o : orderings) {
            Validate.isTrue((boolean)(o instanceof OrderingImpl), (String)"unsupported class of orderings: %s", (Object[])new Object[]{o.getClass().getName()});
            OrderingImpl oi = (OrderingImpl)o;
            oi.validate(this.table);
            if (this.table.isMultiKey(oi.getColumnName())) {
                this.orderings.add(new OrderingImpl("mk_" + oi.getColumnName(), oi.isDescending()));
                continue;
            }
            this.orderings.add(oi);
        }
        this.setDirty();
        return this;
    }

    public Select<T> limit(int limit) {
        Validate.validState((this.limit <= 0 ? 1 : 0) != 0, (String)"a LIMIT value has already been provided", (Object[])new Object[0]);
        Validate.isTrue((limit > 0 ? 1 : 0) != 0, (String)"invalid negative LIMIT: %s", (long)limit);
        this.limit = limit;
        this.setDirty();
        return this;
    }

    public Select<T> allowFiltering() {
        this.allowFiltering = true;
        return this;
    }

    public static class TableSelectionImpl<T>
    extends BuilderImpl<T>
    implements Select.TableSelection<T> {
        private final TableInfo<T> table;

        TableSelectionImpl(TableInfo<T> table, ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            super(context, mgr, bridge);
            this.table = table;
        }

        private Select.TableSelection<T> addName(Object name) {
            this.context.getClassInfo().validateColumn(name);
            if (this.columnNames == null) {
                this.columnNames = new ArrayList<Object>(25);
            }
            this.columnNames.add(name);
            return this;
        }

        public Select<T> all() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.countOrAllSelected = true;
            return this.from(this.table);
        }

        public Select<T> countAll() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.columnNames = COUNT_ALL;
            this.countOrAllSelected = true;
            return this.from(this.table);
        }

        public Select.TableSelection<T> column(Object name) {
            return this.addName(name);
        }

        public Select.TableSelection<T> writeTime(String name) {
            return this.addName(new Utils.FCall("writetime", new Utils.CName(name)));
        }

        public Select.TableSelection<T> ttl(String name) {
            return this.addName(new Utils.FCall("ttl", new Utils.CName(name)));
        }

        public Select.TableSelection<T> fcall(String name, Object ... parameters) {
            return this.addName(new Utils.FCall(name, parameters));
        }
    }

    public static class SelectionImpl<T>
    extends BuilderImpl<T>
    implements Select.Selection<T> {
        SelectionImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            super(context, mgr, bridge);
        }

        private Select.Selection<T> addName(Object name) {
            this.context.getClassInfo().validateColumn(name);
            if (this.columnNames == null) {
                this.columnNames = new ArrayList<Object>(25);
            }
            this.columnNames.add(name);
            return this;
        }

        public Select.Builder<T> all() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.countOrAllSelected = true;
            return this;
        }

        public Select.Builder<T> countAll() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.columnNames = COUNT_ALL;
            this.countOrAllSelected = true;
            return this;
        }

        public Select.Selection<T> column(Object name) {
            return this.addName(name);
        }

        public Select.Selection<T> writeTime(String name) {
            return this.addName(new Utils.FCall("writetime", new Utils.CName(name)));
        }

        public Select.Selection<T> ttl(String name) {
            return this.addName(new Utils.FCall("ttl", new Utils.CName(name)));
        }

        public Select.Selection<T> fcall(String name, Object ... parameters) {
            return this.addName(new Utils.FCall(name, parameters));
        }
    }

    public static class BuilderImpl<T>
    implements Select.Builder<T> {
        protected final StatementManagerImpl mgr;
        protected final StatementBridge bridge;
        protected final ClassInfoImpl.Context context;
        protected List<Object> columnNames;
        protected boolean countOrAllSelected = false;

        BuilderImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            this.mgr = mgr;
            this.bridge = bridge;
            this.context = context;
        }

        BuilderImpl(ClassInfoImpl.Context context, List<Object> columnNames, StatementManagerImpl mgr, StatementBridge bridge) {
            this(context, mgr, bridge);
            context.getClassInfo().validateColumns(columnNames);
            this.columnNames = columnNames;
        }

        public Class<T> getObjectClass() {
            return this.context.getObjectClass();
        }

        public ClassInfo<T> getClassInfo() {
            return this.context.getClassInfo();
        }

        public Select<T> from(String table) {
            return new SelectImpl(this.context, table, this.columnNames, this.countOrAllSelected, this.mgr, this.bridge);
        }

        public Select<T> from(TableInfo<T> table) {
            return new SelectImpl(this.context, table.getName(), this.columnNames, this.countOrAllSelected, this.mgr, this.bridge);
        }
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<ObjectSet<T>, ObjectSetFuture<T>, T, SelectImpl<T>>
    implements Select.Where<T> {
        private final List<ClauseImpl> clauses = new ArrayList<ClauseImpl>(10);

        WhereImpl(SelectImpl<T> statement) {
            super(statement);
        }

        WhereImpl(WhereImpl<T> w, SelectImpl<T> statement) {
            super(statement);
            this.clauses.addAll(w.clauses);
        }

        private List<ClauseImpl> getClauses(TableInfoImpl<T> table) {
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(this.clauses);
            if (!table.getMultiKeys().isEmpty()) {
                ListIterator<ClauseImpl> i = clauses.listIterator();
                while (i.hasNext()) {
                    ClauseImpl clause = (ClauseImpl)i.next();
                    FieldInfoImpl<T> f = table.getColumnImpl(clause.getColumnName());
                    if (f == null || !f.isMultiKey()) continue;
                    LinkedHashSet<ClauseImpl> in = new LinkedHashSet<ClauseImpl>(8);
                    for (ClauseImpl v : clause.values()) {
                        if (v instanceof Collection) {
                            in.addAll((Collection)((Object)v));
                            continue;
                        }
                        in.add(v);
                    }
                    if (in.size() == 1) {
                        i.set(new ClauseImpl.EqClauseImpl((CharSequence)("mk_" + clause.getColumnName()), in.iterator().next()));
                        continue;
                    }
                    if (f.isClusteringKey()) {
                        throw new IllegalArgumentException("unsupported selection of multiple values for clustering multi-key column '" + clause.getColumnName() + "'");
                    }
                    i.set(new ClauseImpl.InClauseImpl("mk_" + clause.getColumnName(), in));
                }
            }
            for (Map.Entry<String, Object> e : table.getFinalPrimaryKeyValues().entrySet()) {
                String name = e.getKey();
                boolean found = false;
                for (ClauseImpl c : this.clauses) {
                    if (!name.equals(c.getColumnName().toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                clauses.add(new ClauseImpl.EqClauseImpl((CharSequence)name, e.getValue()));
            }
            return clauses;
        }

        /*
         * WARNING - void declaration
         */
        public Select.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a SELECT statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((SelectImpl)this.statement).table)) {
                    this.and(clause2);
                }
            } else {
                void var3_8;
                ClauseImpl c = (ClauseImpl)clause;
                boolean bl = true;
                if (c instanceof Clause.Equality) {
                    ((SelectImpl)this.statement).table.validateSuffixKeyOrPrimaryKeyOrIndexColumn(c.getColumnName());
                    if (((SelectImpl)this.statement).getContext().getClassInfo().isSuffixKey(c.getColumnName().toString())) {
                        try {
                            ((SelectImpl)this.statement).getContext().addSuffix(c.getColumnName().toString(), c.firstValue());
                            boolean bl2 = ((SelectImpl)this.statement).table.hasColumn(c.getColumnName());
                        }
                        catch (ExcludedSuffixKeyException e) {
                            return this;
                        }
                    }
                    c.validate(((SelectImpl)this.statement).table);
                } else if (c instanceof Clause.In) {
                    ((SelectImpl)this.statement).table.validateSuffixKeyOrPrimaryKeyOrIndexColumn(c.getColumnName());
                    if (((SelectImpl)this.statement).getContext().getClassInfo().isSuffixKey(c.getColumnName().toString())) {
                        ArrayList values = new ArrayList(c.values());
                        Iterator i = values.iterator();
                        while (i.hasNext()) {
                            Object v = i.next();
                            try {
                                ((SelectImpl)this.statement).getContext().getClassInfo().validateSuffix(c.getColumnName().toString(), v);
                            }
                            catch (ExcludedSuffixKeyException e) {
                                i.remove();
                            }
                        }
                        if (((SelectImpl)this.statement).suffixes == null) {
                            ((SelectImpl)this.statement).suffixes = new LinkedHashMap(6);
                        }
                        ((SelectImpl)this.statement).suffixes.put(c.getColumnName().toString(), values);
                        boolean bl3 = ((SelectImpl)this.statement).table.hasColumn(c.getColumnName());
                    } else {
                        c.validate(((SelectImpl)this.statement).table);
                    }
                } else {
                    ((SelectImpl)this.statement).table.validatePrimaryKeyOrIndexColumn(c.getColumnName());
                    c.validate(((SelectImpl)this.statement).table);
                }
                if (var3_8 != false) {
                    this.clauses.add(c);
                    this.setDirty();
                }
            }
            return this;
        }

        public Select<T> orderBy(Ordering ... orderings) {
            return ((SelectImpl)this.statement).orderBy(orderings);
        }

        public Select<T> limit(int limit) {
            return ((SelectImpl)this.statement).limit(limit);
        }
    }
}

