/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.SubClassInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.info.RootClassInfo;
import org.helenus.driver.info.TypeClassInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.RootEntity;

public class RootClassInfoImpl<T>
extends ClassInfoImpl<T>
implements RootClassInfo<T> {
    private final Map<Class<? extends T>, TypeClassInfoImpl<? extends T>> ctypes;
    private final Map<String, TypeClassInfoImpl<? extends T>> ntypes;

    RootClassInfoImpl(StatementManagerImpl mgr, Class<T> clazz) {
        super(mgr, clazz, RootEntity.class);
        Validate.isTrue((boolean)Modifier.isAbstract(clazz.getModifiers()), (String)"root entity class '%s', must be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.ctypes = this.findTypeInfos(mgr);
        this.ntypes = this.ctypes.values().stream().collect(Collectors.toMap(tcinfo -> tcinfo.getType(), tcinfo -> tcinfo));
        this.validateAndComplementSchema();
    }

    RootClassInfoImpl(RootClassInfoImpl<? super T> rinfo, Class<T> clazz) {
        super(rinfo, clazz);
        Validate.isTrue((boolean)Modifier.isAbstract(clazz.getModifiers()), (String)"root entity class '%s', must be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.ctypes = rinfo.ctypes;
        this.ntypes = rinfo.ntypes;
    }

    private Map<Class<? extends T>, TypeClassInfoImpl<? extends T>> findTypeInfos(StatementManagerImpl mgr) {
        Validate.notNull((Object)this.clazz, (String)"invalid null root POJO class", (Object[])new Object[0]);
        RootEntity re = this.clazz.getAnnotation(RootEntity.class);
        int hsize = re.types().length * 3 / 2;
        HashMap<Class<T>, TypeClassInfoImpl<T>> types = new HashMap<Class<T>, TypeClassInfoImpl<T>>(hsize);
        HashSet<String> names = new HashSet<String>(hsize);
        for (Class type : re.types()) {
            Validate.isTrue((boolean)this.clazz.isAssignableFrom(type), (String)"type class '%s' must extends root element class: %s", (Object[])new Object[]{type.getName(), this.clazz.getName()});
            TypeClassInfoImpl tcinfo = new TypeClassInfoImpl(mgr, this, type, false);
            Validate.isTrue((types.put(tcinfo.getObjectClass(), tcinfo) == null ? 1 : 0) != 0, (String)"duplicate type element class '%s' defined for root element class '%s'", (Object[])new Object[]{type.getSimpleName(), this.clazz.getSimpleName()});
            Validate.isTrue((boolean)names.add(tcinfo.getType()), (String)"duplicate type name '%s' defined by class '%s' for root element class '%s'", (Object[])new Object[]{tcinfo.getType(), type.getSimpleName(), this.clazz.getSimpleName()});
        }
        return types;
    }

    private void validateAndComplementSchema() {
        this.tablesImpl().forEach(t -> {
            Validate.isTrue((boolean)t.getTypeKey().isPresent(), (String)"%s must annotate one field as a type key for table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), t.getName()});
            this.ctypes.values().forEach(tcinfo -> tcinfo.getTableImpl(t.getName()).getNonPrimaryKeys().stream().forEach(c -> t.addNonPrimaryColumn(c)));
        });
    }

    TypeClassInfoImpl<? extends T> addType(StatementManagerImpl mgr, Class<?> type) {
        Validate.isTrue((boolean)this.clazz.isAssignableFrom(type), (String)"type class '%s' must extends root element class: %s", (Object[])new Object[]{type.getName(), this.clazz.getName()});
        TypeClassInfoImpl tcinfo = new TypeClassInfoImpl(mgr, this, type, true);
        Validate.isTrue((this.ctypes.put(tcinfo.getObjectClass(), tcinfo) == null ? 1 : 0) != 0, (String)"duplicate type element class '%s' defined for root element class '%s'", (Object[])new Object[]{type.getSimpleName(), this.clazz.getSimpleName()});
        Validate.isTrue((this.ntypes.put(tcinfo.getType(), tcinfo) == null ? 1 : 0) != 0, (String)"duplicate type name '%s' defined by class '%s' for root element class '%s'", (Object[])new Object[]{tcinfo.getType(), type.getSimpleName(), this.clazz.getSimpleName()});
        tcinfo.getTablesImpl().forEach(t -> {
            TableInfoImpl rt = this.getTableImpl(t.getName());
            t.getNonPrimaryKeys().stream().forEach(c -> {
                FieldInfoImpl rc = rt.getColumnImpl(c.getColumnName());
                Validate.isTrue((rc != null ? 1 : 0) != 0, (String)"root element '%s' doesn't define column '%s' in pojo '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), c.getColumnName(), type.getSimpleName()});
                if (rc.getDeclaringClass().equals(c.getDeclaringClass())) {
                    return;
                }
                Validate.isTrue((rc.getDataType().getMainType() == c.getDataType().getMainType() ? 1 : 0) != 0, (String)"incompatible type columns '%s.%s' of type '%s' and '%s.%s' of type '%s' in table '%s' in pojo '%s'", (Object[])new Object[]{c.getDeclaringClass().getSimpleName(), c.getName(), c.getDataType().getMainType(), rc.getDeclaringClass().getSimpleName(), rc.getName(), rc.getDataType().getMainType(), t.getName(), type.getSimpleName()});
            });
        });
        return tcinfo;
    }

    SubClassInfoImpl<? extends T> newSubClass(StatementManagerImpl mgr, Class<?> type) {
        Validate.isTrue((boolean)this.clazz.isAssignableFrom(type), (String)"subclass '%s' must extends root element class: %s", (Object[])new Object[]{type.getName(), this.clazz.getName()});
        SubClassInfoImpl tcinfo = new SubClassInfoImpl(this, type);
        Validate.isTrue((!this.ctypes.containsKey(tcinfo.getObjectClass()) ? 1 : 0) != 0, (String)"a type element class '%s' is already defined for root element class '%s'", (Object[])new Object[]{type.getSimpleName(), this.clazz.getSimpleName()});
        tcinfo.getTablesImpl().forEach(t -> {
            TableInfoImpl rt = this.getTableImpl(t.getName());
            t.getNonPrimaryKeys().stream().forEach(c -> {
                FieldInfoImpl rc = rt.getColumnImpl(c.getColumnName());
                Validate.isTrue((rc != null ? 1 : 0) != 0, (String)"root element '%s' doesn't define column '%s' in pojo '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), c.getColumnName(), type.getSimpleName()});
                if (rc.getDeclaringClass().equals(c.getDeclaringClass())) {
                    return;
                }
                Validate.isTrue((rc.getDataType().getMainType() == c.getDataType().getMainType() ? 1 : 0) != 0, (String)"incompatible type columns '%s.%s' of type '%s' and '%s.%s' of type '%s' in table '%s' in subclass '%s'", (Object[])new Object[]{c.getDeclaringClass().getSimpleName(), c.getName(), c.getDataType().getMainType(), rc.getDeclaringClass().getSimpleName(), rc.getName(), rc.getDataType().getMainType(), t.getName(), type.getSimpleName()});
            });
        });
        return tcinfo;
    }

    @Override
    public Stream<Class<? extends T>> objectClasses() {
        return (Stream)Stream.concat(Stream.of(this.clazz), ((Stream)this.ctypes.values().stream().sequential()).map(t -> t.getObjectClass())).sequential();
    }

    @Override
    public Stream<ClassInfoImpl<? extends T>> classInfos() {
        return (Stream)Stream.concat(Stream.of(this), (Stream)this.ctypes.values().stream().sequential()).sequential();
    }

    @Override
    public Context newContext() {
        return new Context();
    }

    @Override
    public POJOContext newContext(T object) {
        return new POJOContext(object);
    }

    public <S extends T> TypeClassInfoImpl<S> getType(Class<S> clazz) {
        return this.ctypes.get(clazz);
    }

    public TypeClassInfoImpl<? extends T> getType(String name) {
        return this.ntypes.get(name);
    }

    public Stream<TypeClassInfo<? extends T>> types() {
        return this.ntypes.values().stream();
    }

    public Stream<TypeClassInfoImpl<? extends T>> typeImpls() {
        return this.ntypes.values().stream();
    }

    public int getNumTypes() {
        return this.ctypes.size();
    }

    @Override
    public T getObject(Row row, Map<String, Object> suffixes) {
        if (row == null) {
            return null;
        }
        for (ColumnDefinitions.Definition coldef : row.getColumnDefinitions()) {
            FieldInfoImpl field;
            TableInfoImpl table = (TableInfoImpl)this.getTable(coldef.getTable());
            if (table == null || (field = table.getColumnImpl(coldef.getName())) == null || !field.isTypeKey()) continue;
            String type = Objects.toString(field.decodeValue(row), null);
            TypeClassInfoImpl<T> tcinfo = this.ntypes.get(type);
            if (tcinfo == null) {
                throw new ObjectConversionException(this.clazz, row, "unknown POJO type: " + type);
            }
            return tcinfo.getObject(row, type, suffixes);
        }
        throw new ObjectConversionException(this.clazz, row, "missing POJO type column");
    }

    @Override
    public String toString() {
        return "RootClassInfoImpl(super=" + super.toString() + ", ntypes=" + this.ntypes + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RootClassInfoImpl)) {
            return false;
        }
        RootClassInfoImpl other = (RootClassInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<Class<T>, TypeClassInfoImpl<T>> this$ctypes = this.ctypes;
        Map<Class<? extends T>, TypeClassInfoImpl<? extends T>> other$ctypes = other.ctypes;
        if (this$ctypes == null ? other$ctypes != null : !((Object)this$ctypes).equals(other$ctypes)) {
            return false;
        }
        Map<String, TypeClassInfoImpl<T>> this$ntypes = this.ntypes;
        Map<String, TypeClassInfoImpl<? extends T>> other$ntypes = other.ntypes;
        return !(this$ntypes == null ? other$ntypes != null : !((Object)this$ntypes).equals(other$ntypes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RootClassInfoImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Map<Class<T>, TypeClassInfoImpl<T>> $ctypes = this.ctypes;
        result = result * 59 + ($ctypes == null ? 43 : ((Object)$ctypes).hashCode());
        Map<String, TypeClassInfoImpl<T>> $ntypes = this.ntypes;
        result = result * 59 + ($ntypes == null ? 43 : ((Object)$ntypes).hashCode());
        return result;
    }

    public class POJOContext
    extends ClassInfoImpl.POJOContext {
        private final ClassInfoImpl.POJOContext tcontext;

        public POJOContext(T object) {
            super(object);
            TypeClassInfoImpl tcinfo = (TypeClassInfoImpl)RootClassInfoImpl.this.ctypes.get(object.getClass());
            Validate.isTrue((tcinfo != null ? 1 : 0) != 0, (String)"invalid POJO class '%s'; expecting one of %s", (Object[])new Object[]{object.getClass().getName(), RootClassInfoImpl.this.ctypes.keySet()});
            this.tcontext = tcinfo.newContextFromRoot(object);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname) {
            return this.tcontext.getColumnValues(tname);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getPartitionKeyColumnValues(String tname) {
            return this.tcontext.getPartitionKeyColumnValues(tname);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getSuffixAndPartitionKeyColumnValues(String tname) {
            return this.tcontext.getSuffixAndPartitionKeyColumnValues(tname);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getPrimaryKeyColumnValues(String tname) {
            return this.tcontext.getPrimaryKeyColumnValues(tname);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getSuffixKeyValues() {
            return this.tcontext.getSuffixKeyValues();
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getSuffixAndPrimaryKeyColumnValues(String tname) {
            return this.tcontext.getSuffixAndPrimaryKeyColumnValues(tname);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getMandatoryAndPrimaryKeyColumnValues(String tname) {
            return this.tcontext.getMandatoryAndPrimaryKeyColumnValues(tname);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getNonPrimaryKeyColumnNonEncodedValues(String tname) {
            return this.tcontext.getNonPrimaryKeyColumnNonEncodedValues(tname);
        }

        @Override
        public Pair<Object, CQLDataType> getColumnValue(String tname, CharSequence name) {
            return this.tcontext.getColumnValue(tname, name);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname, Iterable<CharSequence> names) {
            return this.tcontext.getColumnValues(tname, names);
        }

        @Override
        public Map<String, Pair<Object, CQLDataType>> getColumnValues(String tname, CharSequence ... names) {
            return this.tcontext.getColumnValues(tname, names);
        }

        @Override
        public String getKeyspace() {
            return this.tcontext.getKeyspace();
        }

        @Override
        public void addSuffix(String suffix, Object value) {
            this.tcontext.addSuffix(suffix, value);
        }

        @Override
        public T getObject(Row row) {
            return this.tcontext.getObject(row);
        }

        @Override
        public Collection<T> getInitialObjects() {
            return this.tcontext.getInitialObjects().stream().collect(Collectors.toList());
        }
    }

    public class Context
    extends ClassInfoImpl.Context {
        private final Map<Class<? extends T>, ClassInfoImpl.Context> contexts;

        Context() {
            this.contexts = RootClassInfoImpl.this.ctypes.values().stream().collect(Collectors.toMap(tcinfo -> tcinfo.getObjectClass(), tcinfo -> tcinfo.newContext()));
        }

        @Override
        public void addSuffix(String suffix, Object value) {
            super.addSuffix(suffix, value);
            this.contexts.values().forEach(tc -> tc.addSuffix(suffix, value));
        }
    }
}

